/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.ScriptingLibraryProperties;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryTable {
    private final Map<String, ScriptingLibraryModel> myLibraryModels;
    private final Map<String, ScriptingLibraryModel> myAliases;
    private volatile Map<String, VirtualFile> myProjectOrGlobalLibraryFileByNameMapCache;
    private final LibraryKind myLibraryKind;
    private final Project myProject;
    private volatile FileStateFinder myFileStateFinder;
    private final Object myFileStateFinderLock;

    public ScriptingLibraryTable(@NotNull LibraryKind libraryKind, @NotNull Project project) {
        if (libraryKind == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(1);
        }
        this.myLibraryModels = new ConcurrentHashMap<String, ScriptingLibraryModel>();
        this.myAliases = new ConcurrentHashMap<String, ScriptingLibraryModel>();
        this.myFileStateFinderLock = new Object();
        this.myLibraryKind = libraryKind;
        this.myProject = project;
    }

    public void readFrom(@NotNull LibraryTable libraryTable) {
        if (libraryTable == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(2);
        }
        ScriptingLibraryModel.LibraryLevel level = ScriptingLibraryManager.getLibraryLevel(libraryTable);
        for (Library library : libraryTable.getLibraries()) {
            if (!(library instanceof LibraryEx)) continue;
            this.readLibrary((LibraryEx)library, level);
        }
    }

    private void readLibrary(@NotNull LibraryEx library, @NotNull ScriptingLibraryModel.LibraryLevel level) {
        PersistentLibraryKind libType;
        if (library == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(3);
        }
        if (level == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(4);
        }
        if ((libType = library.getKind()) != null && libType == this.myLibraryKind) {
            ScriptingLibraryModel libModel = new ScriptingLibraryModel(library.getName(), level);
            libModel.setOriginalLibrary((Library)library);
            HashSet<String> sourceFileUrls = new HashSet<String>();
            HashSet<String> compactFileUrls = new HashSet<String>();
            LibraryProperties properties = library.getProperties();
            if (properties instanceof ScriptingLibraryProperties) {
                String[] libClassUrls;
                ScriptingLibraryProperties libraryProperties = (ScriptingLibraryProperties)properties;
                libModel.setFrameworkDescriptor(libraryProperties.getFrameworkType());
                HashSet<String> libPropsSourceFileUrlSet = new HashSet<String>(libraryProperties.getSourceFilesUrls());
                for (String libClassUrl : libClassUrls = library.getUrls(OrderRootType.CLASSES)) {
                    if (libPropsSourceFileUrlSet.contains(libClassUrl)) {
                        sourceFileUrls.add(libClassUrl);
                        continue;
                    }
                    compactFileUrls.add(libClassUrl);
                }
                Object[] libSourceUrls = library.getUrls(OrderRootType.SOURCES);
                if (libSourceUrls.length > 0) {
                    ContainerUtil.addAll(sourceFileUrls, (Object[])libSourceUrls);
                    ContainerUtil.addAll(libPropsSourceFileUrlSet, (Object[])libSourceUrls);
                    libraryProperties.setSourceFilesUrls(libPropsSourceFileUrlSet);
                }
            } else {
                ContainerUtil.addAll(compactFileUrls, (Object[])library.getUrls(OrderRootType.CLASSES));
            }
            libModel.setSourceFileUrls(sourceFileUrls);
            libModel.setCompactFileUrls(compactFileUrls);
            libModel.setDocUrls(library.getUrls(OrderRootType.DOCUMENTATION));
            libModel.setAssociatedModules(ModuleHelper.getAssociatedModules(this.myProject, (Library)library));
            this.myLibraryModels.put(library.getName(), libModel);
        }
    }

    @NotNull
    public Set<String> getDocUrlsFor(@NotNull VirtualFile file) {
        if (file == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(5);
        }
        THashSet urls = Collections.emptySet();
        for (ScriptingLibraryModel scriptingLibraryModel : this.myLibraryModels.values()) {
            if (!scriptingLibraryModel.containsFile(file)) continue;
            if (urls.isEmpty()) {
                urls = new THashSet();
            }
            urls.addAll(scriptingLibraryModel.getDocUrls());
        }
        THashSet tHashSet = urls;
        if (tHashSet == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(6);
        }
        return tHashSet;
    }

    @Nullable
    public ScriptingLibraryModel findLibrary(@NotNull VirtualFile file) {
        if (file == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(7);
        }
        for (ScriptingLibraryModel scriptingLibraryModel : this.myLibraryModels.values()) {
            if (!scriptingLibraryModel.containsFile(file)) continue;
            return scriptingLibraryModel;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ThreeState getFileState(VirtualFile file) {
        FileStateFinder finder = this.myFileStateFinder;
        if (finder == null) {
            Object object = this.myFileStateFinderLock;
            synchronized (object) {
                finder = this.myFileStateFinder;
                if (finder == null) {
                    this.myFileStateFinder = finder = new FileStateFinder(this.myLibraryModels.values());
                }
            }
        }
        ThreeState threeState = finder.getFileState(file);
        if (threeState == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(8);
        }
        return threeState;
    }

    @Nullable
    public VirtualFile findProjectOrGlobalLibraryFileByName(String fileName) {
        Map<String, VirtualFile> map = this.getProjectOrGlobalLibraryFileByNameMap();
        return map.get(fileName);
    }

    @NotNull
    private Map<String, VirtualFile> getProjectOrGlobalLibraryFileByNameMap() {
        Map<String, VirtualFile> map = this.myProjectOrGlobalLibraryFileByNameMapCache;
        if (map == null) {
            map = new HashMap<String, VirtualFile>();
            for (ScriptingLibraryModel libraryModel : this.myLibraryModels.values()) {
                if (libraryModel.getLibraryLevel() != ScriptingLibraryModel.LibraryLevel.PROJECT && libraryModel.getLibraryLevel() != ScriptingLibraryModel.LibraryLevel.GLOBAL) continue;
                for (VirtualFile file : libraryModel.getSourceFiles()) {
                    map.put(file.getName(), file);
                }
                for (VirtualFile file : libraryModel.getCompactFiles()) {
                    map.put(file.getName(), file);
                }
            }
            this.myProjectOrGlobalLibraryFileByNameMapCache = map;
        }
        Map<String, VirtualFile> map2 = map;
        if (map2 == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(9);
        }
        return map2;
    }

    public void invalidateCache() {
        this.myFileStateFinder = null;
        this.myProjectOrGlobalLibraryFileByNameMapCache = null;
    }

    @Nullable
    public ScriptingLibraryModel getLibraryByName(@NotNull String libName) {
        ScriptingLibraryModel model;
        if (libName == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(10);
        }
        if ((model = this.myLibraryModels.get(libName)) != null) {
            return model;
        }
        return this.myAliases.get(libName);
    }

    public void removeLibrary(ScriptingLibraryModel scriptingLibraryModel) {
        this.myLibraryModels.remove(scriptingLibraryModel.getName());
        this.invalidateCache();
    }

    public void addPredefinedLibrary(@NotNull ScriptingLibraryModel predefinedLibraryModel) {
        if (predefinedLibraryModel == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(11);
        }
        assert (predefinedLibraryModel.getLibraryLevel() == ScriptingLibraryModel.LibraryLevel.PREDEFINED);
        this.addLibrary(predefinedLibraryModel);
    }

    @NotNull
    ScriptingLibraryModel createLibrary(String libName, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls, ScriptingLibraryModel.LibraryLevel libraryLevel, boolean isOnByDefault) {
        ScriptingLibraryModel libModel = new ScriptingLibraryModel(libName, sourceFiles, compactFiles, docUrls, libraryLevel, isOnByDefault);
        this.addLibrary(libModel);
        ScriptingLibraryModel scriptingLibraryModel = libModel;
        if (scriptingLibraryModel == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(12);
        }
        return scriptingLibraryModel;
    }

    protected void addLibrary(@NotNull ScriptingLibraryModel libraryModel) {
        if (libraryModel == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(13);
        }
        this.myLibraryModels.put(libraryModel.getName(), libraryModel);
        this.invalidateCache();
    }

    public ScriptingLibraryModel @NotNull [] getLibraries(ScriptingLibraryModel.LibraryLevel libraryLevel) {
        ArrayList<ScriptingLibraryModel> result = new ArrayList<ScriptingLibraryModel>();
        for (ScriptingLibraryModel model : this.myLibraryModels.values()) {
            assert (model.getLibraryLevel() != null) : "NULL level for " + model.getName();
            if (!model.getLibraryLevel().equals((Object)libraryLevel)) continue;
            result.add(model);
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = result.toArray(ScriptingLibraryModel.EMPTY_ARRAY);
        if (scriptingLibraryModelArray == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(14);
        }
        return scriptingLibraryModelArray;
    }

    public ScriptingLibraryModel[] getAllLibraries() {
        return this.myLibraryModels.values().toArray(ScriptingLibraryModel.EMPTY_ARRAY);
    }

    public void renameLibrary(String oldName, String newName) {
        ScriptingLibraryModel libraryModel = this.myLibraryModels.get(oldName);
        if (libraryModel != null) {
            this.myLibraryModels.remove(oldName);
            this.myLibraryModels.put(newName, libraryModel);
            this.myAliases.put(oldName, libraryModel);
        }
    }

    @Nullable
    public ScriptingLibraryModel getModel(@NotNull Library original) {
        if (original == null) {
            ScriptingLibraryTable.$$$reportNull$$$0(15);
        }
        for (ScriptingLibraryModel model : this.myLibraryModels.values()) {
            if (model.getOriginalLibrary() != original) continue;
            return model;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ScriptingLibraryTable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedLibraryModel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryModel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ScriptingLibraryTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocUrlsFor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOrGlobalLibraryFileByNameMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readFrom";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readLibrary";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDocUrlsFor";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryByName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPredefinedLibrary";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileStateFinder {
        private final Map<VirtualFile, Boolean> myStateByFileMap;
        private final Set<VirtualFile> mySourceDirs;

        private FileStateFinder(@NotNull Collection<ScriptingLibraryModel> models) {
            if (models == null) {
                FileStateFinder.$$$reportNull$$$0(0);
            }
            HashMap<VirtualFile, Boolean> stateByFileMap = new HashMap<VirtualFile, Boolean>();
            ArrayList<VirtualFile> sourceDirs = new ArrayList<VirtualFile>();
            for (ScriptingLibraryModel model : models) {
                for (VirtualFile f : model.getCompactFiles()) {
                    stateByFileMap.put(f, true);
                }
                for (VirtualFile f : model.getSourceFiles()) {
                    stateByFileMap.put(f, false);
                    if (!f.isDirectory()) continue;
                    sourceDirs.add(f);
                }
            }
            this.myStateByFileMap = ImmutableMap.copyOf(stateByFileMap);
            this.mySourceDirs = ImmutableSet.copyOf(sourceDirs);
        }

        @NotNull
        public ThreeState getFileState(@NotNull VirtualFile file) {
            Boolean flag;
            if (file == null) {
                FileStateFinder.$$$reportNull$$$0(1);
            }
            if ((flag = this.myStateByFileMap.get(file)) != null) {
                ThreeState threeState = flag != false ? ThreeState.YES : ThreeState.NO;
                if (threeState == null) {
                    FileStateFinder.$$$reportNull$$$0(2);
                }
                return threeState;
            }
            if (VfsUtilCore.isUnder((VirtualFile)file, this.mySourceDirs)) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    FileStateFinder.$$$reportNull$$$0(3);
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                FileStateFinder.$$$reportNull$$$0(4);
            }
            return threeState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "models";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/libraries/ScriptingLibraryTable$FileStateFinder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/libraries/ScriptingLibraryTable$FileStateFinder";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileState";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

