/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.ExtensionInstantiationException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import gnu.trove.THashSet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public abstract class KeyedExtensionFactory<T, KeyT> {
    private final Class<T> myInterfaceClass;
    private final ExtensionPointName<KeyedFactoryEPBean> myEpName;
    private final PicoContainer myPicoContainer;

    public KeyedExtensionFactory(@NotNull Class<T> interfaceClass, @NonNls @NotNull ExtensionPointName<KeyedFactoryEPBean> epName, @NotNull PicoContainer picoContainer) {
        if (interfaceClass == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(0);
        }
        if (epName == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(1);
        }
        if (picoContainer == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(2);
        }
        this.myInterfaceClass = interfaceClass;
        this.myEpName = epName;
        this.myPicoContainer = picoContainer;
    }

    @NotNull
    public T get() {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                Object keyArg;
                String key;
                List epBeans = KeyedExtensionFactory.this.myEpName.getExtensionList();
                Object result = KeyedExtensionFactory.this.getByKey(epBeans, key = KeyedExtensionFactory.this.getKey(keyArg = args[0]), method, args);
                if (result == null) {
                    result = KeyedExtensionFactory.this.getByKey(epBeans, null, method, args);
                }
                return result;
            }
        };
        Object object = Proxy.newProxyInstance(this.myInterfaceClass.getClassLoader(), new Class[]{this.myInterfaceClass}, handler);
        if (object == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(3);
        }
        return (T)object;
    }

    public T getByKey(@NotNull KeyT key) {
        if (key == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(4);
        }
        return KeyedExtensionFactory.findByKey(this.getKey(key), this.myEpName, this.myPicoContainer);
    }

    @Nullable
    public static <T> T findByKey(@NotNull String key, @NotNull ExtensionPointName<KeyedFactoryEPBean> point, @NotNull PicoContainer picoContainer) {
        if (key == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(5);
        }
        if (point == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(6);
        }
        if (picoContainer == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(7);
        }
        for (KeyedFactoryEPBean epBean : point.getExtensionList()) {
            if (!key.equals(epBean.key) || epBean.implementationClass == null) continue;
            try {
                return epBean.instantiateClass(epBean.implementationClass, picoContainer);
            }
            catch (ExtensionInstantiationException | ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExtensionInstantiationException(e, epBean.getPluginDescriptor());
            }
        }
        return null;
    }

    @NotNull
    public Set<String> getAllKeys() {
        List<KeyedFactoryEPBean> list = this.myEpName.getExtensionList();
        THashSet set = new THashSet();
        for (KeyedFactoryEPBean epBean : list) {
            set.add(epBean.key);
        }
        THashSet tHashSet = set;
        if (tHashSet == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(8);
        }
        return tHashSet;
    }

    private T getByKey(List<? extends KeyedFactoryEPBean> epBeans, String key, Method method, Object[] args) {
        Object result = null;
        for (KeyedFactoryEPBean keyedFactoryEPBean : epBeans) {
            if (!Comparing.strEqual((String)keyedFactoryEPBean.key, (String)key, (boolean)true)) continue;
            try {
                if (keyedFactoryEPBean.implementationClass != null) {
                    result = keyedFactoryEPBean.instantiateClass(keyedFactoryEPBean.implementationClass, this.myPicoContainer);
                } else {
                    Object factory = keyedFactoryEPBean.instantiateClass(keyedFactoryEPBean.factoryClass, this.myPicoContainer);
                    result = method.invoke(factory, args);
                }
                if (result == null) continue;
                break;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof ControlFlowException && t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new ExtensionInstantiationException(e, keyedFactoryEPBean.getPluginDescriptor());
            }
            catch (ExtensionInstantiationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                throw new ExtensionInstantiationException(e, keyedFactoryEPBean.getPluginDescriptor());
            }
            catch (Exception e) {
                throw new ExtensionInstantiationException(e, keyedFactoryEPBean.getPluginDescriptor());
            }
        }
        return (T)result;
    }

    @NotNull
    public abstract String getKey(@NotNull KeyT var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picoContainer";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/KeyedExtensionFactory";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getByKey";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findByKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

