/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeDeploymentRuntime;
import com.intellij.docker.runtimes.ComposeExternalRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeploymentRuntime;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRuntimesCache {
    private static final Logger LOG = Logger.getInstance(DockerRuntimesCache.class);
    private final DockerRuntimesManagerService.DockerRuntimesManager myManager;
    private final DockerRuntimeContext myRuntimeContext;
    private final DockerGroupRuntime myContainersGroup;
    private final DockerGroupRuntime myImagesGroup;
    private final Map<String, ComposeDeploymentRuntime> myComposeDeployments;
    private final Map<String, ComposeExternalRuntime> myExternalComposeApps;
    private final Map<String, DockerApplicationRuntime> myApplicationId2Runtime;

    DockerRuntimesCache(@NotNull DockerRuntimesManagerService.DockerRuntimesManager manager, @NotNull DockerRuntimeContext context) {
        if (manager == null) {
            DockerRuntimesCache.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DockerRuntimesCache.$$$reportNull$$$0(1);
        }
        this.myComposeDeployments = ContainerUtil.newConcurrentMap();
        this.myExternalComposeApps = ContainerUtil.newConcurrentMap();
        this.myApplicationId2Runtime = new HashMap<String, DockerApplicationRuntime>();
        this.myManager = manager;
        this.myRuntimeContext = context;
        this.myContainersGroup = new DockerGroupRuntime.ContainersGroup(this.myRuntimeContext);
        this.myImagesGroup = new DockerGroupRuntime.ImagesGroup(this.myRuntimeContext);
    }

    @NotNull
    public DockerDeploymentRuntime createDeploymentRuntime(@NotNull DeploymentTask<DockerDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager) throws ServerRuntimeException {
        if (task == null) {
            DockerRuntimesCache.$$$reportNull$$$0(2);
        }
        if (logManager == null) {
            DockerRuntimesCache.$$$reportNull$$$0(3);
        }
        boolean imageNotContainer = task.getSource().getType() instanceof DockerFileDeploymentSourceType && ((DockerDeploymentConfiguration)task.getConfiguration()).isBuildOnly();
        DockerGroupRuntime parentGroup = imageNotContainer ? this.myImagesGroup : this.myContainersGroup;
        return new DockerDeploymentRuntime(this.myRuntimeContext, task, logManager, parentGroup);
    }

    @NotNull
    public ComposeDeploymentRuntime createComposeRuntime(@NotNull DeploymentTask<DockerDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager) throws ServerRuntimeException {
        ComposeDeploymentRuntime newRuntime;
        String projectName;
        ComposeDeploymentRuntime existingRuntime;
        if (task == null) {
            DockerRuntimesCache.$$$reportNull$$$0(4);
        }
        if (logManager == null) {
            DockerRuntimesCache.$$$reportNull$$$0(5);
        }
        if ((existingRuntime = this.myComposeDeployments.get(projectName = (newRuntime = new ComposeDeploymentRuntime(this, task, logManager)).getComposeProjectName())) != null) {
            existingRuntime.appendDeploymentTask(task);
            ComposeDeploymentRuntime composeDeploymentRuntime = existingRuntime;
            if (composeDeploymentRuntime == null) {
                DockerRuntimesCache.$$$reportNull$$$0(6);
            }
            return composeDeploymentRuntime;
        }
        this.myComposeDeployments.put(projectName, newRuntime);
        ComposeDeploymentRuntime composeDeploymentRuntime = newRuntime;
        if (composeDeploymentRuntime == null) {
            DockerRuntimesCache.$$$reportNull$$$0(7);
        }
        return composeDeploymentRuntime;
    }

    public DockerApplicationRuntime createRuntimeForExternalUse(@NotNull DockerAgentApplication agentApp) {
        if (agentApp == null) {
            DockerRuntimesCache.$$$reportNull$$$0(8);
        }
        String id = agentApp.getUniqueName();
        DockerApplicationRuntime result = this.newApplicationRuntime(id);
        result.setApplication(agentApp);
        return result;
    }

    @NotNull
    public List<CloudApplicationRuntime> refreshStructure(DockerAgentApplication @NotNull [] agentApps) {
        if (agentApps == null) {
            DockerRuntimesCache.$$$reportNull$$$0(9);
        }
        DeltaImpl delta = new DeltaImpl();
        HashSet<String> deletedIds = new HashSet<String>(this.myApplicationId2Runtime.keySet());
        ArrayList<DockerApplicationRuntime> newLeafs = new ArrayList<DockerApplicationRuntime>(agentApps.length);
        for (DockerAgentApplication nextAgentApp : agentApps) {
            DeploymentStatus nextStatusBefore;
            String nextId = nextAgentApp.getUniqueName();
            deletedIds.remove(nextId);
            DockerApplicationRuntime nextRuntime = this.myApplicationId2Runtime.get(nextId);
            if (nextRuntime == null) {
                nextRuntime = this.newApplicationRuntime(nextId);
                this.myApplicationId2Runtime.put(nextId, nextRuntime);
                delta.markAdded(nextRuntime);
                nextStatusBefore = null;
            } else {
                nextStatusBefore = nextRuntime.getStatus();
            }
            boolean changedStatus = nextRuntime.checkAndClearInternalChangeStatus();
            this.mapAgentApplication(nextRuntime, nextAgentApp);
            if (nextStatusBefore != null && !changedStatus) {
                DeploymentStatus statusAfter = nextRuntime.getStatus();
                boolean bl = changedStatus = statusAfter != null && !nextStatusBefore.equals(statusAfter);
            }
            if (changedStatus) {
                delta.markChanged(nextRuntime);
            }
            newLeafs.add(nextRuntime);
        }
        LinkedHashSet<DockerApplicationRuntime> parents = new LinkedHashSet<DockerApplicationRuntime>();
        parents.add(this.myContainersGroup);
        parents.add(this.myImagesGroup);
        for (DockerApplicationRuntime nextLeaf : newLeafs) {
            boolean unknownParent;
            CloudApplicationRuntime parent = nextLeaf.getParent();
            while (parent instanceof DockerApplicationRuntime && (unknownParent = parents.add((DockerApplicationRuntime)parent))) {
                parent = parent.getParent();
            }
        }
        ArrayList<CloudApplicationRuntime> result = new ArrayList<CloudApplicationRuntime>(newLeafs.size() + parents.size());
        result.addAll(parents);
        result.addAll(newLeafs);
        for (String next : deletedIds) {
            DockerApplicationRuntime nextRuntime = this.myApplicationId2Runtime.remove(next);
            assert (nextRuntime != null) : "for removed id: " + next;
            nextRuntime.setParent(null);
            delta.markDeleted(nextRuntime);
        }
        if (!delta.isEmpty()) {
            this.fireRuntimesRefreshed(delta);
        }
        ArrayList<CloudApplicationRuntime> arrayList = result;
        if (arrayList == null) {
            DockerRuntimesCache.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    DockerRuntimeContext getRuntimeContext() {
        DockerRuntimeContext dockerRuntimeContext = this.myRuntimeContext;
        if (dockerRuntimeContext == null) {
            DockerRuntimesCache.$$$reportNull$$$0(11);
        }
        return dockerRuntimeContext;
    }

    private void mapAgentApplication(@NotNull DockerApplicationRuntime runtime, @NotNull DockerAgentApplication agentApp) {
        if (runtime == null) {
            DockerRuntimesCache.$$$reportNull$$$0(12);
        }
        if (agentApp == null) {
            DockerRuntimesCache.$$$reportNull$$$0(13);
        }
        runtime.setApplication(agentApp);
        String containerId = agentApp.getContainerId();
        if (containerId == null) {
            runtime.setParent(this.myImagesGroup);
        } else {
            ComposeServiceRuntime composeService = this.findComposeService(agentApp);
            if (composeService != null) {
                composeService.addContainer(runtime);
            } else {
                runtime.setParent(this.myContainersGroup);
            }
        }
    }

    void composeApplicationUndeployed(@NotNull ComposeDeploymentRuntime undeployed) {
        if (undeployed == null) {
            DockerRuntimesCache.$$$reportNull$$$0(14);
        }
        this.myComposeDeployments.remove(undeployed.getComposeProjectName());
    }

    @Nullable
    private ComposeServiceRuntime findComposeService(@NotNull DockerAgentApplication agentApp) {
        Map containerLabels;
        if (agentApp == null) {
            DockerRuntimesCache.$$$reportNull$$$0(15);
        }
        if ((containerLabels = agentApp.getContainerLabels()) == null) {
            return null;
        }
        String composeService = (String)containerLabels.get("com.docker.compose.service");
        String composeProject = (String)containerLabels.get("com.docker.compose.project");
        if (composeProject == null || composeService == null) {
            return null;
        }
        ComposeApplicationRuntime composeRuntime = this.findComposeApplicationRuntime(composeProject);
        if (composeRuntime == null) {
            composeRuntime = this.myExternalComposeApps.computeIfAbsent(composeProject, this::newComposeExternalApplicationRuntime);
        }
        return composeRuntime.findOrCreateService(composeService);
    }

    @Nullable
    ComposeApplicationRuntime findComposeApplicationRuntime(@NotNull String composeProject) {
        if (composeProject == null) {
            DockerRuntimesCache.$$$reportNull$$$0(16);
        }
        return Optional.ofNullable(this.myComposeDeployments.get(composeProject)).orElseGet(() -> this.myExternalComposeApps.get(composeProject));
    }

    @NotNull
    private DockerApplicationRuntime newApplicationRuntime(String uniqueName) {
        return new DockerApplicationRuntime(this.myRuntimeContext, uniqueName, null);
    }

    @NotNull
    private ComposeExternalRuntime newComposeExternalApplicationRuntime(String composeProject) {
        return new ComposeExternalRuntime(this.myRuntimeContext, composeProject);
    }

    private void fireRuntimesRefreshed(@NotNull DeltaImpl delta) {
        if (delta == null) {
            DockerRuntimesCache.$$$reportNull$$$0(17);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("refreshed: " + this + ": " + delta.toLogString());
        }
        DockerRuntimesCache.syncPublisher().runtimesRefreshed(this.myManager, delta);
    }

    private static DockerRuntimesManagerService.DockerRuntimesListener syncPublisher() {
        return (DockerRuntimesManagerService.DockerRuntimesListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DockerRuntimesManagerService.DOCKER_RUNTIMES_MANAGER_TOPIC);
    }

    public String toString() {
        return "DockerRuntimeCache@" + Integer.toHexString(System.identityHashCode(this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/DockerRuntimesCache";
                break;
            }
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentApp";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentApps";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undeployed";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composeProject";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/DockerRuntimesCache";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createComposeRuntime";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshStructure";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDeploymentRuntime";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createComposeRuntime";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRuntimeForExternalUse";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refreshStructure";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mapAgentApplication";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "composeApplicationUndeployed";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findComposeService";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findComposeApplicationRuntime";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fireRuntimesRefreshed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeltaImpl
    implements DockerRuntimesManagerService.DockerRuntimesListener.Delta {
        private final List<DockerApplicationRuntime> myNew = new LinkedList<DockerApplicationRuntime>();
        private final List<DockerApplicationRuntime> myDeleted = new LinkedList<DockerApplicationRuntime>();
        private final List<DockerApplicationRuntime> myStatusChanged = new LinkedList<DockerApplicationRuntime>();

        private DeltaImpl() {
        }

        public boolean isEmpty() {
            return this.myDeleted.isEmpty() && this.myNew.isEmpty() && this.myStatusChanged.isEmpty();
        }

        @Override
        @NotNull
        public List<DockerApplicationRuntime> getNewRuntimes() {
            List<DockerApplicationRuntime> list = Collections.unmodifiableList(this.myNew);
            if (list == null) {
                DeltaImpl.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        @NotNull
        public List<DockerApplicationRuntime> getDeleted() {
            List<DockerApplicationRuntime> list = Collections.unmodifiableList(this.myDeleted);
            if (list == null) {
                DeltaImpl.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public List<DockerApplicationRuntime> getStatusChanged() {
            List<DockerApplicationRuntime> list = Collections.unmodifiableList(this.myStatusChanged);
            if (list == null) {
                DeltaImpl.$$$reportNull$$$0(2);
            }
            return list;
        }

        void markAdded(@NotNull DockerApplicationRuntime newRuntime) {
            if (newRuntime == null) {
                DeltaImpl.$$$reportNull$$$0(3);
            }
            this.myNew.add(newRuntime);
        }

        void markDeleted(@NotNull DockerApplicationRuntime deletedRuntime) {
            if (deletedRuntime == null) {
                DeltaImpl.$$$reportNull$$$0(4);
            }
            this.myDeleted.add(deletedRuntime);
        }

        void markChanged(@NotNull DockerApplicationRuntime startedOrStopped) {
            if (startedOrStopped == null) {
                DeltaImpl.$$$reportNull$$$0(5);
            }
            this.myStatusChanged.add(startedOrStopped);
        }

        String toLogString() {
            return "\n deleted [" + this.myDeleted.size() + "]: " + this.myDeleted + ", \n added [" + this.myNew.size() + "]: " + this.myNew + ", \n changed [" + this.myStatusChanged.size() + "]: " + this.myStatusChanged;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/runtimes/DockerRuntimesCache$DeltaImpl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRuntime";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deletedRuntime";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startedOrStopped";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNewRuntimes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeleted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatusChanged";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/runtimes/DockerRuntimesCache$DeltaImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "markAdded";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "markDeleted";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "markChanged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

