/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.actions.ImportDataSourceAction;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import org.jetbrains.annotations.NotNull;

public class DatabaseConfigFileWatcher
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            DatabaseConfigFileWatcher.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (DataSourceDetector.EP_NAME.getExtensionList().isEmpty()) {
            return;
        }
        final MergingUpdateQueue queue = new MergingUpdateQueue(this.getClass().getSimpleName(), 3000, true, null, (Disposable)project, null, Alarm.ThreadToUse.POOLED_THREAD);
        queue.setRestartTimerOnAdd(true);
        project.getMessageBus().connect((Disposable)queue).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                queue.suspend();
            }

            public void exitDumbMode() {
                queue.resume();
            }
        });
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (DumbService.isDumb((Project)project)) {
                queue.suspend();
            }
            this.queueUpdate(project, queue);
        });
    }

    public void queueUpdate(final @NotNull Project project, final @NotNull MergingUpdateQueue queue) {
        if (project == null) {
            DatabaseConfigFileWatcher.$$$reportNull$$$0(1);
        }
        if (queue == null) {
            DatabaseConfigFileWatcher.$$$reportNull$$$0(2);
        }
        queue.queue(new Update(project){

            public void run() {
                DataSourceRegistry registry = new DataSourceRegistry(project);
                boolean done = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                    if (DumbService.isDumb((Project)project)) {
                        throw new ProcessCanceledException();
                    }
                    DatabaseConfigFileWatcher.this.scanForNewConfigurations(project, registry);
                });
                if (!project.isOpen()) {
                    return;
                }
                if (!done) {
                    queue.queue((Update)this);
                    return;
                }
                Disposer.dispose((Disposable)queue);
                if (registry.getNewDataSources().isEmpty()) {
                    return;
                }
                ApplicationManager.getApplication().invokeAndWait(() -> DatabaseConfigFileWatcher.notifyNewDataSourcesDetected(project), ModalityState.NON_MODAL);
            }

            public boolean canEat(Update update2) {
                return this.equals(update2);
            }
        });
    }

    protected void scanForNewConfigurations(@NotNull Project project, @NotNull DataSourceRegistry registry) {
        Module[] modules;
        if (project == null) {
            DatabaseConfigFileWatcher.$$$reportNull$$$0(3);
        }
        if (registry == null) {
            DatabaseConfigFileWatcher.$$$reportNull$$$0(4);
        }
        Module[] moduleArray = modules = project.isDisposed() ? Module.EMPTY_ARRAY : ModuleManager.getInstance((Project)project).getModules();
        if (modules.length == 0) {
            return;
        }
        for (DataSourceDetector detector : DataSourceDetector.EP_NAME.getExtensionList()) {
            for (Module module : modules) {
                detector.collectDataSources(module, registry.getBuilder(), false);
            }
        }
    }

    private static void notifyNewDataSourcesDetected(final @NotNull Project project) {
        if (project == null) {
            DatabaseConfigFileWatcher.$$$reportNull$$$0(5);
        }
        if (!project.isOpen()) {
            return;
        }
        DatabaseNotifications.DATABASE_DETECTION_GROUP.createNotification(DatabaseBundle.message((String)"data.sources.detected", (Object[])new Object[0]), DatabaseBundle.message((String)"data.sources.detected.content", (Object[])new Object[0]), NotificationType.INFORMATION, null).addAction((AnAction)new NotificationAction(DatabaseBundle.message((String)"data.sources.detected.configure", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (ImportDataSourceAction.doImportAction(project, true)) {
                    notification.expire();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/autoconfig/DatabaseConfigFileWatcher$3";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/autoconfig/DatabaseConfigFileWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "queueUpdate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "scanForNewConfigurations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyNewDataSourcesDetected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

