/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.argument;

import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.CliArgumentImpl;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.psi.DbElement;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringCliArgumentImpl
extends CliArgumentImpl
implements StringCliArgument {
    public StringCliArgumentImpl(@NotNull String uiName, String ... options) {
        if (uiName == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(0);
        }
        if (options == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(1);
        }
        super(uiName, options);
    }

    @Override
    @NotNull
    public String getPrefix() {
        String string = DbCliUtil.extractParameterizable(this.getArguments());
        if (string == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public Function<String, String> getQuoter() {
        Function<String, String> function2 = s -> s;
        if (function2 == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(3);
        }
        return function2;
    }

    @Override
    @NotNull
    public Function<String, String> getUnquoter() {
        Function<String, String> function2 = s -> s;
        if (function2 == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(4);
        }
        return function2;
    }

    @Override
    @Nullable
    public String getComponentValue(@NotNull String text2, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        if (text2 == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(5);
        }
        if (current == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(6);
        }
        if (next == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(7);
        }
        if (cd == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(8);
        }
        return DbCliUtil.cutParameter(text2, current, next);
    }

    @Override
    @Nullable
    public TextRange getComponentValueRange(@NotNull String text2, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        if (text2 == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(9);
        }
        if (current == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(10);
        }
        if (next == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(11);
        }
        if (cd == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(12);
        }
        return DbCliUtil.asParameterRange(current, next);
    }

    @Override
    @NotNull
    public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
        if (elements == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(13);
        }
        if (cd == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(14);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            StringCliArgumentImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/argument/StringCliArgumentImpl";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cd";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/argument/StringCliArgumentImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuoter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnquoter";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringsFromElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getComponentValue";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getComponentValueRange";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStringsFromElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MaybeUnnamedArgument
    extends ElementsStringArgument {
        public MaybeUnnamedArgument(@NotNull String uiName, @NotNull Condition<DbElement> condition, @NotNull String[] options) {
            if (uiName == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(0);
            }
            if (condition == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(1);
            }
            if (options == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(2);
            }
            super(uiName, condition, options);
        }

        @Override
        public boolean isMyLexeme(@NotNull String text2, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
            if (text2 == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(3);
            }
            if (current == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(4);
            }
            if (next == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(5);
            }
            if (cd == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(6);
            }
            return cd.contains(this.getArguments()) ? super.isMyLexeme(text2, current, next, cd) : current.isParameter() && !cd.checkedOut(this);
        }

        @Override
        @Nullable
        public String getComponentValue(@NotNull String text2, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
            if (text2 == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(7);
            }
            if (current == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(8);
            }
            if (next == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(9);
            }
            if (cd == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(10);
            }
            return cd.contains(this.getArguments()) ? (current.isArgument() ? DbCliUtil.cutParameter(text2, current, next) : null) : current.getText();
        }

        @Override
        @Nullable
        public TextRange getComponentValueRange(@NotNull String text2, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
            if (text2 == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(11);
            }
            if (current == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(12);
            }
            if (next == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(13);
            }
            if (cd == null) {
                MaybeUnnamedArgument.$$$reportNull$$$0(14);
            }
            return cd.contains(this.getArguments()) ? (current.isArgument() ? DbCliUtil.asParameterRange(current, next) : null) : current.asRange();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 3: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: 
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 5: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "next";
                    break;
                }
                case 6: 
                case 10: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cd";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/cli/argument/StringCliArgumentImpl$MaybeUnnamedArgument";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMyLexeme";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getComponentValue";
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getComponentValueRange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ElementsStringArgument
    extends QuotedStringArgument {
        private final Condition<DbElement> myCondition;

        public ElementsStringArgument(@NotNull String uiName, @NotNull Condition<DbElement> condition, String ... options) {
            if (uiName == null) {
                ElementsStringArgument.$$$reportNull$$$0(0);
            }
            if (condition == null) {
                ElementsStringArgument.$$$reportNull$$$0(1);
            }
            if (options == null) {
                ElementsStringArgument.$$$reportNull$$$0(2);
            }
            super(uiName, options);
            this.myCondition = condition;
        }

        @Override
        @NotNull
        public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
            if (elements == null) {
                ElementsStringArgument.$$$reportNull$$$0(3);
            }
            if (cd == null) {
                ElementsStringArgument.$$$reportNull$$$0(4);
            }
            List<String> list = DbCliUtil.fromElementsToSeparated(elements, this.myCondition);
            if (list == null) {
                ElementsStringArgument.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cd";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/argument/StringCliArgumentImpl$ElementsStringArgument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/argument/StringCliArgumentImpl$ElementsStringArgument";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStringsFromElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getStringsFromElements";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class QuotedStringArgument
    extends StringCliArgumentImpl {
        public QuotedStringArgument(@NotNull String uiName, String ... options) {
            if (uiName == null) {
                QuotedStringArgument.$$$reportNull$$$0(0);
            }
            if (options == null) {
                QuotedStringArgument.$$$reportNull$$$0(1);
            }
            super(uiName, options);
        }

        @Override
        @NotNull
        public Function<String, String> getQuoter() {
            Function<String, String> function2 = DbCliUtil::quote;
            if (function2 == null) {
                QuotedStringArgument.$$$reportNull$$$0(2);
            }
            return function2;
        }

        @Override
        @NotNull
        public Function<String, String> getUnquoter() {
            Function<String, String> function2 = StringUtil::unquoteString;
            if (function2 == null) {
                QuotedStringArgument.$$$reportNull$$$0(3);
            }
            return function2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/argument/StringCliArgumentImpl$QuotedStringArgument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/argument/StringCliArgumentImpl$QuotedStringArgument";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuoter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnquoter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

