/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.client.DatabaseScriptingSessionClient;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/console/session/DatabaseConsoleHistoryController;", "Lcom/intellij/execution/console/ConsoleHistoryController;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleView;", "client", "Lcom/intellij/database/console/client/DatabaseScriptingSessionClient;", "(Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/execution/console/LanguageConsoleView;Lcom/intellij/database/console/client/DatabaseScriptingSessionClient;)V", "insertTextMultiline", "", "text", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "document", "Lcom/intellij/openapi/editor/Document;", "install", "", "intellij.database.impl"})
public final class DatabaseConsoleHistoryController
extends ConsoleHistoryController {
    private final DatabaseScriptingSessionClient client;

    protected int insertTextMultiline(@NotNull CharSequence text2, @NotNull Editor editor, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        TextRange textRange = ScriptModelUtil.getSelectedStatementsRange(this.client, editor, DatabaseSettings.getDefaultExecOption());
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"ScriptModelUtil.getSelec\u2026s.getDefaultExecOption())");
        TextRange range = textRange;
        document.replaceString(range.getStartOffset(), range.getEndOffset(), text2);
        editor.getSelectionModel().setSelection(range.getStartOffset(), range.getStartOffset() + text2.length());
        return range.getStartOffset();
    }

    public void install() {
        this.setMultiline(true);
        super.install();
    }

    public DatabaseConsoleHistoryController(@NotNull LocalDataSource dataSource2, @NotNull LanguageConsoleView consoleView, @NotNull DatabaseScriptingSessionClient client) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)consoleView, (String)"consoleView");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        super((ConsoleRootType)DbConsoleRootType.getInstance(), dataSource2.getUniqueId(), consoleView);
        this.client = client;
    }
}

