/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSyncManager {
    private static final Logger LOG = Logger.getInstance(DataSourceSyncManager.class);
    private static final DataSourceSyncManager INSTANCE = new DataSourceSyncManager();
    private static final DatabaseExecutor NEW_CONNECTION_EXECUTOR;
    private static DatabaseExecutor ourDefaultExecutor;
    private final MultiMap<Object, SyncProcessor> myActive = MultiMap.create();

    public static DataSourceSyncManager getInstance() {
        return INSTANCE;
    }

    public static <E extends Throwable> void withDefaultExecutor(@Nullable DatabaseExecutor e, @NotNull ThrowableRunnable<E> r) throws E {
        if (r == null) {
            DataSourceSyncManager.$$$reportNull$$$0(0);
        }
        DatabaseExecutor prev = ourDefaultExecutor;
        ourDefaultExecutor = e;
        try {
            r.run();
        }
        finally {
            ourDefaultExecutor = prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAbleToPerform(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(1);
        }
        if (dataSource2.isLoading()) {
            return false;
        }
        MultiMap<Object, SyncProcessor> multiMap = this.myActive;
        synchronized (multiMap) {
            return !this.myActive.containsKey(DataSourceSyncManager.getKey(dataSource2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Throwable getAsyncTrace(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(2);
        }
        MultiMap<Object, SyncProcessor> multiMap = this.myActive;
        synchronized (multiMap) {
            Object key = DataSourceSyncManager.getKey(dataSource2);
            Collection queue = this.myActive.get(key);
            SyncProcessor item = (SyncProcessor)ContainerUtil.getFirstItem((Collection)queue);
            return item == null ? null : item.getAsyncTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveTaskCount(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(3);
        }
        MultiMap<Object, SyncProcessor> multiMap = this.myActive;
        synchronized (multiMap) {
            Object key = DataSourceSyncManager.getKey(dataSource2);
            Collection queue = this.myActive.get(key);
            return queue.size();
        }
    }

    @Nullable
    public AsyncTask<SyncResult> tryPerform(@NotNull LoaderContext context, boolean stopRunning, boolean merge, @Nullable DatabaseExecutor executor) {
        if (context == null) {
            DataSourceSyncManager.$$$reportNull$$$0(4);
        }
        return this.tryPerform(new SyncTask(context), stopRunning, merge, executor);
    }

    @Nullable
    public AsyncTask<SyncResult> tryPerform(@NotNull LoaderContext context, boolean stopRunning, boolean merge) {
        if (context == null) {
            DataSourceSyncManager.$$$reportNull$$$0(5);
        }
        return this.tryPerform(context, stopRunning, merge, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AsyncTask<SyncResult> tryPerform(@NotNull SyncTask task, boolean stopRunning, boolean merge, @Nullable DatabaseExecutor executor) {
        LocalDataSource dataSource2;
        if (task == null) {
            DataSourceSyncManager.$$$reportNull$$$0(6);
        }
        if ((dataSource2 = task.context.getDataSource()).isLoading()) {
            return null;
        }
        MultiMap<Object, SyncProcessor> multiMap = this.myActive;
        synchronized (multiMap) {
            Object key = DataSourceSyncManager.getKey(dataSource2);
            Collection queue = this.myActive.getModifiable(key);
            SmartList dropped = new SmartList();
            SyncProcessor current = DataSourceSyncManager.shrinkQueueRunning(queue, (Consumer<SyncProcessor>)((Consumer)arg_0 -> DataSourceSyncManager.lambda$tryPerform$2((List)dropped, arg_0)));
            if (merge) {
                if (current != null && stopRunning) {
                    task = SyncTask.merge(task, current.myTask);
                }
                for (SyncTask droppedTask : dropped) {
                    task = SyncTask.merge(task, droppedTask);
                }
            }
            SyncProcessor processor = new SyncProcessor(task, executor);
            queue.add(processor);
            return current == null ? this.startProcessor(key, processor) : DataSourceSyncManager.queuedProcessor(current, processor, stopRunning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public AsyncTask<SyncResult> stopSynchronization(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(7);
        }
        MultiMap<Object, SyncProcessor> multiMap = this.myActive;
        // MONITORENTER : multiMap
        Object key = DataSourceSyncManager.getKey(dataSource2);
        Collection queue = this.myActive.getModifiable(key);
        SyncProcessor current = DataSourceSyncManager.shrinkQueueRunning(queue, null);
        if (current == null) {
            AsyncTask<Object> asyncTask = AsyncTask.completed(null);
            // MONITOREXIT : multiMap
            if (asyncTask != null) return asyncTask;
            DataSourceSyncManager.$$$reportNull$$$0(8);
            return asyncTask;
        }
        current.cancel();
        AsyncTask<SyncResult> asyncTask = current.myResult.getTask();
        // MONITOREXIT : multiMap
        if (asyncTask != null) return asyncTask;
        DataSourceSyncManager.$$$reportNull$$$0(9);
        return asyncTask;
    }

    @NotNull
    private static Object getKey(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(10);
        }
        String string = dataSource2.getUniqueId();
        if (string == null) {
            DataSourceSyncManager.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    private static SyncProcessor shrinkQueueRunning(@NotNull Collection<SyncProcessor> queue, @Nullable Consumer<SyncProcessor> droppedConsumer) {
        if (queue == null) {
            DataSourceSyncManager.$$$reportNull$$$0(12);
        }
        SyncProcessor first2 = null;
        if (queue.size() < 2) {
            return (SyncProcessor)ContainerUtil.getFirstItem(queue);
        }
        ArrayList<SyncProcessor> toStop = new ArrayList<SyncProcessor>();
        Iterator<SyncProcessor> it2 = queue.iterator();
        while (it2.hasNext()) {
            SyncProcessor cur = it2.next();
            if (first2 == null) {
                first2 = cur;
                continue;
            }
            toStop.add(cur);
            if (droppedConsumer != null) {
                droppedConsumer.consume((Object)cur);
            }
            it2.remove();
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (SyncProcessor processor : toStop) {
                try {
                    processor.cancel();
                }
                catch (Throwable e) {
                    LOG.warn(e);
                }
            }
        });
        return first2;
    }

    @NotNull
    private static AsyncTask<SyncResult> queuedProcessor(@NotNull SyncProcessor current, @NotNull SyncProcessor processor, boolean stopExisting) {
        ProgressIndicator indicator;
        if (current == null) {
            DataSourceSyncManager.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            DataSourceSyncManager.$$$reportNull$$$0(14);
        }
        if ((indicator = AsyncUtil.getAsyncFriendlyIndicator()) != null) {
            indicator.setText(DatabaseBundle.message((String)"waiting.for.previous.introspection.to.finish", (Object[])new Object[0]));
        }
        if (stopExisting) {
            current.cancel();
        }
        AsyncTask<SyncResult> asyncTask = processor.myResult.getTask();
        if (asyncTask == null) {
            DataSourceSyncManager.$$$reportNull$$$0(15);
        }
        return asyncTask;
    }

    @NotNull
    private AsyncTask<SyncResult> startProcessor(@NotNull Object key, @NotNull SyncProcessor processor) {
        if (key == null) {
            DataSourceSyncManager.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            DataSourceSyncManager.$$$reportNull$$$0(17);
        }
        AsyncTask<SyncResult> asyncTask = processor.run().whenComplete(null, (r, e) -> {
            MultiMap<Object, SyncProcessor> multiMap = this.myActive;
            synchronized (multiMap) {
                Collection queue = this.myActive.getModifiable(key);
                if (ContainerUtil.getFirstItem((Collection)queue) != processor) {
                    LOG.warn("Unexpected sync queue corruption");
                }
                queue.remove(processor);
                if (queue.isEmpty()) {
                    this.myActive.remove(key);
                } else {
                    SyncProcessor first2 = (SyncProcessor)queue.iterator().next();
                    ApplicationManager.getApplication().executeOnPooledThread(() -> this.startProcessor(key, first2));
                }
            }
        });
        if (asyncTask == null) {
            DataSourceSyncManager.$$$reportNull$$$0(18);
        }
        return asyncTask;
    }

    private static /* synthetic */ void lambda$tryPerform$2(List dropped, SyncProcessor p2) {
        dropped.add(p2.myTask);
    }

    static {
        ourDefaultExecutor = NEW_CONNECTION_EXECUTOR = (t, path, op) -> {
            Project project = t.context.getProject();
            LocalDataSource ds = t.context.getDataSource();
            SearchPath searchPath = SearchPath.of((ObjectPath)path);
            DatabaseSessionManager.facade(project, ds, t.context.getCredentialsStore(), searchPath, t.context.getErrorHandler(), DGDepartment.INTROSPECTION).runSync(SessionsUtil.function(c2 -> {
                op.consume(c2);
                return null;
            }));
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSyncManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSyncManager";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "stopSynchronization";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "queuedProcessor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withDefaultExecutor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAbleToPerform";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAsyncTrace";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActiveTaskCount";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryPerform";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stopSynchronization";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shrinkQueueRunning";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "queuedProcessor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "startProcessor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SyncProcessor {
        private final SyncTask myTask;
        private final AsyncTask.DelayedTask<SyncResult> myResult;
        private final long myStartTime;
        private final MyProgress myProgress;
        private final ModalityState myModality;
        private final DatabaseExecutor myDbExecutor;

        SyncProcessor(@NotNull SyncTask task, @Nullable DatabaseExecutor executor) {
            if (task == null) {
                SyncProcessor.$$$reportNull$$$0(0);
            }
            this.myProgress = new MyProgress();
            this.myTask = task;
            this.myResult = new AsyncTask.DelayedTask(AsyncTask.currentFrame());
            this.myStartTime = System.currentTimeMillis();
            this.myModality = ModalityState.defaultModalityState();
            this.myDbExecutor = executor != null ? executor : ourDefaultExecutor;
        }

        public void cancel() {
            this.myProgress.cancel();
            this.myResult.cancelIfNotStarted();
        }

        @Nullable
        public Throwable getAsyncTrace() {
            return this.myProgress.getAsyncTrace();
        }

        @NotNull
        public AsyncTask<SyncResult> run() {
            AsyncTask<SyncResult> asyncTask = this.myResult.start(AsyncUtil.transactionExecutor((Disposable)this.myTask.context.getProject(), this.myModality), () -> this.prepareAndRefresh());
            if (asyncTask == null) {
                SyncProcessor.$$$reportNull$$$0(1);
            }
            return asyncTask;
        }

        private AsyncTask<SyncResult> prepareAndRefresh() {
            ProgressIndicator indicator;
            if (this.myTask.context.getProject().isOpen() && (indicator = this.myProgress.start()) != null) {
                try {
                    return ((AsyncTask)AsyncUtil.underProgress(() -> {
                        WriteAction.runAndWait(() -> ((FileDocumentManager)FileDocumentManager.getInstance()).saveAllDocuments());
                        return AsyncTask.currentFrame().compute(AsyncUtil.getPoolExecutor(), this::performSync);
                    }, indicator)).whenComplete(null, (r, e) -> this.myProgress.stop());
                }
                catch (Throwable e2) {
                    this.myProgress.stop();
                    return AsyncTask.exceptional(e2);
                }
            }
            return AsyncTask.cancelled();
        }

        @NotNull
        private SyncResult performSync() {
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            if (indicator == null) {
                indicator = new EmptyProgressIndicator();
            }
            LocalDataSource dataSource2 = this.myTask.context.getDataSource();
            try {
                new DatabaseModelLoader.IntrospectionSession(this.myTask.context, indicator, this.myModality){

                    @Override
                    public void perform(@Nullable ObjectPath path, @NotNull ThrowableConsumer<DatabaseConnection, Exception> consumer2) {
                        if (consumer2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        myDbExecutor.perform(myTask, path, consumer2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dataSource/DataSourceSyncManager$SyncProcessor$1", "perform"));
                    }
                }.run();
            }
            catch (SQLException e) {
                AsyncUtil.addUnhandledError(this.myTask.context.getErrorHandler(), e, dataSource2);
                throw new ProcessCanceledException();
            }
            finally {
                DbSrcUtils.refresh();
            }
            DataSourceSnapshotManager.INSTANCE.apply(this.myTask.context.getProject(), dataSource2);
            return new SyncResult(this.myTask, System.currentTimeMillis() - this.myStartTime);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSyncManager$SyncProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSyncManager$SyncProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "run";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyProgress {
            private volatile boolean myCanceled = false;
            private volatile boolean myCreated = false;
            private volatile ProgressIndicator myIndicator = AsyncUtil.getAsyncFriendlyIndicator();

            private MyProgress() {
            }

            public synchronized void cancel() {
                if (this.myIndicator != null) {
                    this.myIndicator.cancel();
                }
                this.myCanceled = true;
            }

            @Nullable
            public synchronized ProgressIndicator start() {
                if (this.myCanceled) {
                    return null;
                }
                boolean bl = this.myCreated = this.myIndicator == null;
                if (this.myCreated) {
                    this.myIndicator = this.createIndicator();
                    this.myIndicator.start();
                }
                this.myIndicator.setText(DatabaseBundle.message((String)"message.starting", (Object[])new Object[0]));
                return this.myIndicator;
            }

            public synchronized void stop() {
                if (this.myIndicator == null || !this.myCreated) {
                    return;
                }
                this.myIndicator.stop();
                if (this.myIndicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)this.myIndicator).processFinish();
                }
            }

            @Nullable
            public synchronized Throwable getAsyncTrace() {
                return AsyncUtil.getAsyncCallTrace(this.myIndicator);
            }

            private ProgressIndicator createIndicator() {
                return AsyncUtil.createBackgroundIndicator(((SyncProcessor)SyncProcessor.this).myTask.context.getProject(), ((SyncProcessor)SyncProcessor.this).myTask.context.getDataSource().getName());
            }
        }
    }

    public static class SyncTask {
        public final LoaderContext context;

        private SyncTask(@NotNull LoaderContext context) {
            if (context == null) {
                SyncTask.$$$reportNull$$$0(0);
            }
            this.context = context;
        }

        @NotNull
        public static SyncTask merge(@NotNull SyncTask task1, @NotNull SyncTask task2) {
            if (task1 == null) {
                SyncTask.$$$reportNull$$$0(1);
            }
            if (task2 == null) {
                SyncTask.$$$reportNull$$$0(2);
            }
            LoaderContext context = task1.context.merge(task2.context);
            context.setErrorHandler(task1.context.getErrorHandler());
            return new SyncTask(context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task2";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceSyncManager$SyncTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "merge";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SyncResult {
        public final long elapsedTime;
        public final SyncTask task;

        public SyncResult(SyncTask task, long elapsedTime) {
            this.task = task;
            this.elapsedTime = elapsedTime;
        }
    }

    public static interface DatabaseExecutor {
        public void perform(@NotNull SyncTask var1, @Nullable ObjectPath var2, @NotNull ThrowableConsumer<DatabaseConnection, Exception> var3);
    }
}

