/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceTestConnectionPanel;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.template.UrlEditorModelBase;
import com.intellij.database.dataSource.url.ui.DatabaseAuthPanel;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.UniformLookSettingsProvider;
import com.intellij.database.dataSource.url.ui.UrlEditorInspector;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicJdbcUrlEditor
implements UrlEditorModelBase.StateChangeListener {
    private final JComponent myPanel;
    private final DataSourceTestConnectionPanel myTestConnectionPanel;
    private DatabaseDriver myDriver;
    private DatabaseDriver myActualDriver;
    private final List<UrlPropertiesPanel> myUrlPropertiesPanels;
    private final EditorTextField myUrlField;
    private final Runnable myChangedCallback;
    private final MyLink myPanelsSwitcher;
    private final DataSourceConfigurable myConfigurable;
    private final MyInspectionConsumer myInspectionsPane;
    private final DatabaseAuthPanel myAuthPanel;
    private final MyLink myDriverLink;
    private final Map<String, String> myInterchangeProperties;
    private boolean myEditUrl;
    private int myCurrentPropPanel;
    private boolean myPersistentPropertyChanged;
    private final JComponent myConstructorPanel;
    private UrlEditorModel myModel;
    private boolean myUpdating;
    private Collection<UrlEditorInspector> myInspectors;
    private final JBLabel myUnderLabel;

    public DynamicJdbcUrlEditor(@NotNull DataSourceConfigurable configurable, @NotNull Runnable changedCallback) {
        if (configurable == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(0);
        }
        if (changedCallback == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(1);
        }
        this.myUrlPropertiesPanels = new ArrayList<UrlPropertiesPanel>();
        this.myInterchangeProperties = new LinkedHashMap<String, String>();
        this.myEditUrl = true;
        this.myConfigurable = configurable;
        this.myTestConnectionPanel = new DataSourceTestConnectionPanel(this.myConfigurable);
        GridLayoutManager tcLayout = (GridLayoutManager)this.myTestConnectionPanel.getComponent().getLayout();
        this.myPanel = new JPanel((LayoutManager)new GridLayoutManager(3 + tcLayout.getRowCount(), 6));
        this.myChangedCallback = changedCallback;
        this.myDriver = null;
        this.myActualDriver = null;
        this.myModel = this.createModelForDriver(null);
        this.myAuthPanel = new DatabaseAuthPanel(this.myConfigurable.getProject(), (LocalDataSource)this.myConfigurable.getDataSource(), this.myConfigurable.getSecretService());
        this.myAuthPanel.addListeners(this.delayed((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DynamicJdbcUrlEditor.this.myUpdating) {
                    return;
                }
                DynamicJdbcUrlEditor.this.removeCredentialsFromActiveParser();
                DynamicJdbcUrlEditor.this.myModel.commit(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$1", "textChanged"));
            }
        }), this);
        this.myDriverLink = new MyLink(() -> this.onDriverLinkClicked());
        this.myPanelsSwitcher = new MyLink(() -> {
            final UrlEditorModel model = this.myModel;
            List items = JBIterable.generate((Object)0, i2 -> i2 + 1).take(model.getGroupsCount()).toList();
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Integer>(null, items){

                @NotNull
                public String getTextFor(Integer value2) {
                    String string = model.getGroupName(value2);
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @Nullable
                public PopupStep onChosen(Integer selectedValue, boolean finalChoice) {
                    if (selectedValue != null) {
                        model.selectGroup(Math.max(0, selectedValue));
                        model.commit(true);
                    }
                    return FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$2", "getTextFor"));
                }
            }).showUnderneathOf((Component)this.getPanelSwitcher());
        });
        this.myConstructorPanel = new JPanel();
        this.myConstructorPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)DynamicJdbcUrlEditor.getVSpacing()));
        this.myPanel.add((Component)this.createConstructorPreface(), UrlPropertiesPanel.createSimpleConstraints(0, 0, 6));
        this.myPanel.add((Component)this.myConstructorPanel, UrlPropertiesPanel.createRowConstraints(1));
        this.myUrlField = new EditorTextField("", this.myConfigurable.getProject(), (FileType)FileTypes.PLAIN_TEXT);
        this.myUrlField.addSettingsProvider((EditorSettingsProvider)new UniformLookSettingsProvider());
        this.myUrlField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                DynamicJdbcUrlEditor.this.setUrlFieldActive(true);
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                DynamicJdbcUrlEditor.this.setUrlFieldActive(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myUrlField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (DynamicJdbcUrlEditor.this.myUpdating) {
                    return;
                }
                DynamicJdbcUrlEditor.this.myModel.setUrl(DynamicJdbcUrlEditor.this.myUrlField.getText());
                DynamicJdbcUrlEditor.this.myModel.commit(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$4", "documentChanged"));
            }
        });
        TextComponentEditorAction trimPaster = new TextComponentEditorAction((EditorActionHandler)new BasePasteHandler(){

            protected Transferable getContentsToPaste(Editor editor, DataContext dataContext) {
                Transferable contents = super.getContentsToPaste(editor, dataContext);
                SelectionModel sel = editor.getSelectionModel();
                if (sel.getSelectionStart() != 0 || sel.getSelectionEnd() != editor.getDocument().getTextLength()) {
                    return contents;
                }
                if (contents == null || !contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    return contents;
                }
                try {
                    String data = (String)contents.getTransferData(DataFlavor.stringFlavor);
                    return new TextTransferable(data.trim());
                }
                catch (Exception e) {
                    return contents;
                }
            }
        }){};
        ActionUtil.copyFrom((AnAction)trimPaster, (String)"EditorPaste");
        trimPaster.registerCustomShortcutSet((JComponent)this.myUrlField, null);
        trimPaster.registerCustomShortcutSet(this.myUrlField.getComponent(), null);
        this.myInspectionsPane = new MyInspectionConsumer();
        this.myTestConnectionPanel.setWidget(this.myInspectionsPane);
        GridLayoutManager urlLayout = new GridLayoutManager(2, 6);
        urlLayout.setVGap(0);
        JPanel urlPanel = new JPanel((LayoutManager)urlLayout);
        JBLabel urlLabel = new JBLabel(DatabaseBundle.message((String)"data.source.editor.url.label", (Object[])new Object[0]));
        urlPanel.add((Component)urlLabel, UrlPropertiesPanel.createLabelConstraints(0, 0, urlLabel.getPreferredSize().getWidth()));
        urlPanel.add((Component)this.myUrlField, UrlPropertiesPanel.createSimpleConstraints(0, 1, 5));
        Box underUrl = new Box(1);
        this.myUnderLabel = new JBLabel(" " + DatabaseBundle.message((String)"data.source.editor.url.ad", (Object[])new Object[0]), UIUtil.ComponentStyle.MINI);
        underUrl.add((Component)this.myUnderLabel);
        underUrl.add(Box.createVerticalStrut(4));
        this.myUnderLabel.setAlignmentX(0.0f);
        urlPanel.add((Component)underUrl, UrlPropertiesPanel.createConstraints(1, 1, 5, 9, 1, -1, false));
        this.myPanel.add((Component)urlPanel, UrlPropertiesPanel.createRowConstraints(2));
        GridConstraints c2 = UrlPropertiesPanel.vRubber(UrlPropertiesPanel.createRowConstraints(3), true);
        c2.setRowSpan(tcLayout.getRowCount());
        c2.setFill(3);
        this.myPanel.add((Component)this.myTestConnectionPanel.getComponent(), c2);
        UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        this.myInspectionsPane.updateVisibility(panel2 == null ? null : panel2.getDataInterchange());
    }

    @NotNull
    public DataSourceTestConnectionPanel getTestConnectionPanel() {
        DataSourceTestConnectionPanel dataSourceTestConnectionPanel = this.myTestConnectionPanel;
        if (dataSourceTestConnectionPanel == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(2);
        }
        return dataSourceTestConnectionPanel;
    }

    @NotNull
    public JComponent createConstructorPreface() {
        JBLabel typeLbl = new JBLabel(DatabaseBundle.message((String)"data.source.editor.connection.type.label", (Object[])new Object[0]));
        JBLabel driverLbl = new JBLabel(DatabaseBundle.message((String)"data.source.editor.driver.label", (Object[])new Object[0]));
        Box box = new Box(0);
        Font small = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
        Arrays.asList(new JLabel[]{typeLbl, this.myPanelsSwitcher, driverLbl, this.myDriverLink}).forEach(c2 -> c2.setFont(small));
        box.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)DynamicJdbcUrlEditor.getVSpacing(), (int)0));
        box.add((Component)typeLbl);
        box.add(Box.createHorizontalStrut(5));
        box.add((Component)((Object)this.myPanelsSwitcher));
        box.add(Box.createHorizontalStrut(20));
        box.add((Component)driverLbl);
        box.add(Box.createHorizontalStrut(5));
        box.add((Component)((Object)this.myDriverLink));
        Box box2 = box;
        if (box2 == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(3);
        }
        return box2;
    }

    private JComponent getPanelSwitcher() {
        return this.myPanelsSwitcher;
    }

    @NotNull
    private UrlEditorModel createModelForDriver(@Nullable DatabaseDriver driver) {
        UrlEditorModel model = new UrlEditorModel(driver == null ? Collections.emptyList() : driver.getJDBCUrlParsers());
        model.addListener(this, this.myConfigurable);
        UrlEditorModel urlEditorModel = model;
        if (urlEditorModel == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(4);
        }
        return urlEditorModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(@Nullable Object arg) {
        if (arg == Boolean.FALSE) {
            return;
        }
        this.myUpdating = true;
        try {
            DatabaseAuthProvider.AuthWidget widget;
            if (!this.myUrlField.getText().equals(this.myModel.getUrl())) {
                this.myUrlField.setText(this.myModel.getUrl());
                this.myUrlField.setCaretPosition(0);
            }
            this.setCurrentTag(this.myModel.getActiveGroupId());
            UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
            if (panel2 != null) {
                panel2.getDataInterchange().putProperties((Consumer<PairConsumer<String, String>>)((Consumer)putter -> {
                    for (String param : this.myModel.getParameters()) {
                        putter.consume((Object)param, (Object)StringUtil.nullize((String)this.myModel.getParameter(param)));
                    }
                }));
            }
            if ((widget = this.myAuthPanel.getAuthWidget()) != null) {
                widget.updateFromUrl(this.myModel);
            }
            this.updateUrlFieldState();
            this.myChangedCallback.run();
        }
        finally {
            this.myUpdating = false;
        }
        this.inspect();
    }

    private void inspect() {
        if (this.myDriver == null || this.myInspectionsPane.isUpdating()) {
            return;
        }
        this.myInspectionsPane.clear();
        for (UrlEditorInspector inspector : this.getInspectors()) {
            inspector.runInspection(this.myDriver, this.myModel, this.myInspectionsPane);
        }
        UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        this.myInspectionsPane.updateVisibility(panel2 == null ? null : panel2.getDataInterchange());
    }

    @NotNull
    private Collection<UrlEditorInspector> getInspectors() {
        if (this.myInspectors == null) {
            this.myInspectors = UrlEditorInspector.inspectorsFor(this.myDriver);
        }
        Collection<UrlEditorInspector> collection = this.myInspectors;
        if (collection == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public void onActivity() {
        UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        if (panel2 != null) {
            panel2.getDataInterchange().fireUserDataChanged(DataInterchange.ACTIVITY);
        }
    }

    @NotNull
    public DatabaseAuthPanel getAuthPanel() {
        DatabaseAuthPanel databaseAuthPanel = this.myAuthPanel;
        if (databaseAuthPanel == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(6);
        }
        return databaseAuthPanel;
    }

    private static int getVSpacing() {
        return 12;
    }

    public boolean isUrlOnly() {
        return this.myModel.isUrlOnly();
    }

    public void requestUrlFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myUrlField, true));
    }

    public String getAnonymizedUrl() {
        JdbcUrlParser parser2;
        if (!(!this.myModel.isParserValid() || StringUtil.isEmpty((String)this.myModel.getParameter("user")) && StringUtil.isEmpty((String)this.myModel.getParameter("password")) || (parser2 = JdbcUrlParserUtil.stateful(this.myModel.getCurrentParser())) == null)) {
            parser2.setUrlText(this.getUrl());
            if (parser2.isValid()) {
                parser2.setParameter("user", "");
                parser2.setParameter("password", "");
                return parser2.getUrlText();
            }
        }
        return this.getUrl();
    }

    public String getUrl() {
        return this.myUrlField.getText();
    }

    @NotNull
    public String getIdentifier() {
        JdbcUrlParser parser2;
        StatelessJdbcUrlParser sparser = this.myModel.getMeaningfulParser();
        JdbcUrlParser jdbcUrlParser = parser2 = sparser == null ? null : sparser.createStateful();
        if (parser2 != null) {
            parser2.setUrlText(this.getUrl());
        }
        if (parser2 == null || !parser2.isValid()) {
            String string = this.getUrl();
            if (string == null) {
                DynamicJdbcUrlEditor.$$$reportNull$$$0(7);
            }
            return string;
        }
        EnumSet<StatelessJdbcUrlParser.LocationType> locations = sparser.getPossibleLocations();
        StringBuilder identifier = new StringBuilder();
        if (locations.contains((Object)StatelessJdbcUrlParser.LocationType.REMOTE)) {
            String databaseName = parser2.getParameter("database");
            String hostName = parser2.getParameter("host");
            if (!StringUtil.isEmpty((String)databaseName)) {
                identifier.append(new File(databaseName).getName());
            }
            if (!StringUtil.isEmpty((String)hostName)) {
                identifier.append("@").append(hostName);
            }
        } else if (locations.contains((Object)StatelessJdbcUrlParser.LocationType.FILE)) {
            String file = StringUtil.notNullize((String)parser2.getParameter("file"));
            identifier.append(new File(file).getName());
        } else if (locations.contains((Object)StatelessJdbcUrlParser.LocationType.DIRECTORY)) {
            String path = StringUtil.notNullize((String)parser2.getParameter("path"));
            identifier.append(new File(path).getName());
        } else {
            String parameter = parser2.getParameter("database");
            if (parameter == null) {
                parameter = parser2.getParameter("path");
            }
            if (parameter == null) {
                parameter = parser2.getParameter("file");
            }
            identifier.append(StringUtil.notNullize((String)parameter));
        }
        String string = identifier.toString();
        if (string == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String generateNameFromParameters() {
        String identifier = this.getIdentifier();
        if (this.myActualDriver == null || this.myActualDriver.isPredefined() && StringUtil.isNotEmpty((String)identifier)) {
            String string = identifier;
            if (string == null) {
                DynamicJdbcUrlEditor.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = this.myActualDriver.getName().replaceAll("Driver", "Data Source") + " - " + identifier;
        if (string == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(11);
        }
        return jComponent;
    }

    public void updateDriverLink() {
        List<SimpleClasspathElement> cp = ((LocalDataSource)this.myConfigurable.getDataSource()).getClasspathElements();
        boolean noJars = cp.isEmpty() || this.myActualDriver == null || cp != this.myActualDriver.getClasspathElements();
        String s1 = noJars ? null : "Custom Jars";
        String s2 = this.myActualDriver == null ? null : this.myActualDriver.getName();
        this.myDriverLink.setText(StringUtil.join(Arrays.asList(s1, s2), (String)" and "));
    }

    private void onDriverLinkClicked() {
        Collection drivers;
        Function driverProvider = (Function)this.myConfigurable.getController().getUserData(DataSourceConfigurable.DRIVER_VARIANTS_PROVIDER);
        Collection collection = drivers = driverProvider == null ? null : (Collection)driverProvider.fun((Object)this.myConfigurable.getTempDataSource());
        if (drivers == null || drivers.size() < 2) {
            this.myConfigurable.getController().navigateTo(this.myDriver, false);
            return;
        }
        DumbAwareAction goToDriver = new DumbAwareAction(DatabaseBundle.message((String)"data.source.editor.go.to.driver", (Object[])new Object[0]), null, AllIcons.General.Settings){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                DynamicJdbcUrlEditor.this.myConfigurable.getController().navigateTo(DynamicJdbcUrlEditor.this.myDriver, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$7", "actionPerformed"));
            }
        };
        List actions = JBIterable.of((Object)goToDriver).append((Object)Separator.getInstance()).append((Iterable)JBIterable.from((Iterable)drivers).filterMap(o -> (DatabaseDriver)this.myConfigurable.getController().getTempTargetOrTarget(o).get()).map(o -> new DumbAwareAction(o.getName(), null, o.getIcon(0), (DatabaseDriver)o){
            final /* synthetic */ DatabaseDriver val$o;
            {
                this.val$o = databaseDriver;
                super(arg0, arg1, arg2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                DynamicJdbcUrlEditor.this.myConfigurable.setDriver(this.val$o);
                DynamicJdbcUrlEditor.this.myDriverLink.fireStateChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$8", "actionPerformed"));
            }
        })).toList();
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("", (ActionGroup)new DefaultActionGroup(actions), DataManager.getInstance().getDataContext((Component)this.myPanel), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null);
        popup.showUnderneathOf((Component)((Object)this.myDriverLink));
    }

    private void panelPropertiesChanged(@Nullable UrlPropertiesPanel panel2) {
        if (!this.storeProperties(panel2)) {
            return;
        }
        this.myChangedCallback.run();
    }

    private boolean storeProperties(@Nullable UrlPropertiesPanel panel2) {
        if (panel2 != this.getPropertyPanel(this.myCurrentPropPanel) || panel2 == null) {
            return false;
        }
        this.myInterchangeProperties.clear();
        for (String prop : panel2.getDataInterchange().getPersistentProperties()) {
            String val = panel2.getDataInterchange().getProperty(prop);
            if (val == null) continue;
            this.myInterchangeProperties.put(prop, val);
        }
        return true;
    }

    public void saveSettings(@NotNull LocalDataSource dataSource2, boolean copyCredentials, boolean actual) {
        if (dataSource2 == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(12);
        }
        dataSource2.setDatabaseDriver(actual ? (DatabaseDriver)this.myConfigurable.getController().getTempTargetOrTarget(this.myDriver).get() : this.myDriver);
        dataSource2.setAdditionalJdbcProperties(this.myInterchangeProperties);
        this.myAuthPanel.save(dataSource2, copyCredentials);
        dataSource2.setUrl(this.getAnonymizedUrl());
        dataSource2.setConfiguredByUrl(this.isUrlOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(@NotNull LocalDataSource dataSource2, boolean resetCredentials) {
        if (dataSource2 == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(13);
        }
        this.myInterchangeProperties.clear();
        this.myInterchangeProperties.putAll(dataSource2.getAdditionalJdbcProperties());
        String url = StringUtil.notNullize((String)dataSource2.getUrl());
        this.myUpdating = true;
        try {
            this.myAuthPanel.reset(dataSource2, resetCredentials);
        }
        finally {
            this.myUpdating = false;
        }
        this.setDriver(dataSource2.getDatabaseDriver(), url, dataSource2.isConfiguredByUrl());
        this.updateDriverLink();
    }

    public void setUrl(@NotNull String url, boolean isUrlOnly) {
        if (url == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(14);
        }
        this.myModel.setUrl(url);
        this.myModel.setUrlOnly(isUrlOnly);
        this.myModel.commit(true);
    }

    @Nullable
    private UrlPropertiesPanel getPropertyPanel(int idx) {
        return idx >= 0 && idx < this.myUrlPropertiesPanels.size() ? this.myUrlPropertiesPanels.get(idx) : null;
    }

    private void setCurrentTag(int idx) {
        if (idx == this.myCurrentPropPanel) {
            return;
        }
        UrlPropertiesPanel curPanel = this.getPropertyPanel(idx);
        this.myCurrentPropPanel = idx;
        this.myConstructorPanel.removeAll();
        JComponent head = curPanel == null ? null : curPanel.getHeadComponent();
        JComponent tail = curPanel == null ? null : curPanel.getTailComponent();
        ArrayList<JComponent> panels = new ArrayList<JComponent>(5);
        if (head != null || tail != null) {
            if (head != null) {
                panels.add(head);
            }
            if (this.myAuthPanel.isNeeded()) {
                panels.add(this.myAuthPanel.getComponent());
            }
            if (tail != null) {
                panels.add(tail);
            }
            curPanel.setFieldsActive(!this.myEditUrl);
        } else {
            panels.add(this.myAuthPanel.getComponent());
        }
        GridLayoutManager layout = new GridLayoutManager(panels.size(), 6);
        this.myConstructorPanel.setLayout((LayoutManager)layout);
        for (int i2 = 0; i2 < panels.size(); ++i2) {
            ((JComponent)panels.get(i2)).setBorder((Border)JBUI.Borders.emptyTop((int)(i2 == 0 ? 0 : DynamicJdbcUrlEditor.getVSpacing())));
            this.myConstructorPanel.add((Component)panels.get(i2), UrlPropertiesPanel.createRowConstraints(i2));
        }
        this.myConstructorPanel.repaint();
        this.updatePanelSwitcher();
        this.storeProperties(this.getPropertyPanel(this.myCurrentPropPanel));
        this.myAuthPanel.getComponent().revalidate();
        this.myUrlField.getParent().revalidate();
    }

    private void setUrlFieldActive(boolean urlActive) {
        if (this.myEditUrl == urlActive) {
            return;
        }
        this.myEditUrl = urlActive;
        this.resetFieldsBackground();
    }

    private void resetFieldsBackground() {
        boolean ignore = this.isUrlOnly();
        this.myUrlField.setBackground(ParamEditorBase.getBackground(this.myEditUrl || ignore));
        UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        if (panel2 != null) {
            panel2.setFieldsActive(!this.myEditUrl || ignore);
        }
    }

    @NotNull
    private static TextAttributes getErrorAttributes(boolean insert) {
        return new TextAttributes(null, null, (Color)JBColor.RED, insert ? EffectType.BOXED : EffectType.WAVE_UNDERSCORE, 0);
    }

    private static TextAttributes getCurrentParamAttributes(@NotNull Color fg) {
        if (fg == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(15);
        }
        return new TextAttributes(null, null, fg, EffectType.LINE_UNDERSCORE, 0);
    }

    private void updateUrlFieldState() {
        UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        Editor editor = this.myUrlField.getEditor();
        if (panel2 != null) {
            if (editor != null) {
                TextAttributes errorAttributes = DynamicJdbcUrlEditor.getErrorAttributes(false);
                TextAttributes insertErrorAttributes = DynamicJdbcUrlEditor.getErrorAttributes(true);
                editor.getMarkupModel().removeAllHighlighters();
                for (TextRange range : this.myModel.getInvalidRanges()) {
                    int s = range.getStartOffset();
                    int e = range.getEndOffset();
                    editor.getMarkupModel().addRangeHighlighter(s, e, 100, s == e ? insertErrorAttributes : errorAttributes, HighlighterTargetArea.EXACT_RANGE);
                }
                String activeParam = panel2.getActiveParameter();
                TextAttributes currentParamAttributes = DynamicJdbcUrlEditor.getCurrentParamAttributes(this.myUrlField.getForeground());
                for (String param : this.myModel.getParameters()) {
                    TextRange range = this.myModel.getParameterRange(param);
                    if (range == null) continue;
                    editor.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 101, null, HighlighterTargetArea.EXACT_RANGE);
                    if (!param.equals(activeParam)) continue;
                    editor.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 101, currentParamAttributes, HighlighterTargetArea.EXACT_RANGE);
                }
            }
        } else if (editor != null) {
            editor.getMarkupModel().removeAllHighlighters();
        }
    }

    private void removeCredentialsFromActiveParser() {
        DatabaseAuthProvider.AuthWidget widget;
        UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        if (panel2 != null && this.myModel.isParserValid() && (widget = this.myAuthPanel.getAuthWidget()) != null) {
            widget.updateUrl(this.myModel);
        }
    }

    public void setDriver(@Nullable DatabaseDriver driver, @NotNull String url, boolean isUrlOnly) {
        if (url == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(16);
        }
        this.myInspectors = null;
        this.myDriver = driver;
        DatabaseDriver prevDriver = this.myActualDriver;
        DatabaseDriver databaseDriver = this.myActualDriver = this.myDriver == null ? null : (DatabaseDriver)this.myConfigurable.getController().getTempTargetOrTarget(this.myDriver).get();
        if (prevDriver == null || !((DatabaseDriverImpl)prevDriver).equalConfiguration((DatabaseDriverImpl)this.myActualDriver)) {
            UrlEditorModel newModel = this.createModelForDriver(this.myActualDriver);
            if (this.myModel.getUrl().equals(url)) {
                newModel.assign(this.myModel);
            } else {
                newModel.setUrl(url);
            }
            newModel.setUrlOnly(isUrlOnly);
            this.myModel = newModel;
            newModel.commit(false);
        } else {
            this.myModel.setUrl(url);
            this.myModel.setUrlOnly(isUrlOnly);
            this.myModel.commit(false);
        }
        this.createPanels();
        this.updateDriverLink();
        this.myConfigurable.getController().clearModifiedCache();
        this.myAuthPanel.validateAuthTypes(this.myConfigurable.getTempDataSource());
        this.stateChanged(true);
    }

    private void createPanels() {
        for (UrlPropertiesPanel panel2 : this.myUrlPropertiesPanels) {
            Disposer.dispose((Disposable)panel2);
        }
        this.myUrlPropertiesPanels.clear();
        Runnable focusCallback = this::updateUrlFieldState;
        for (int i2 = 0; i2 < this.myModel.getGroupsCount(); ++i2) {
            DataInterchange interchange = new DataInterchange(this.myConfigurable);
            for (Map.Entry<String, String> entry : this.myInterchangeProperties.entrySet()) {
                interchange.putProperty(entry.getKey(), entry.getValue());
            }
            final StatelessParametersHolder group = this.myModel.getGroup(i2);
            final UrlPropertiesPanel panel3 = new UrlPropertiesPanel(group, interchange, focusCallback);
            Disposer.register((Disposable)this.myConfigurable, (Disposable)panel3);
            panel3.getDataInterchange().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(@NotNull PropertyChangeEvent evt) {
                    if (evt == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    if (panel3 != DynamicJdbcUrlEditor.this.getPropertyPanel(DynamicJdbcUrlEditor.this.myCurrentPropPanel) || DynamicJdbcUrlEditor.this.myUpdating) {
                        return;
                    }
                    DynamicJdbcUrlEditor.this.myPersistentPropertyChanged = DynamicJdbcUrlEditor.this.myPersistentPropertyChanged | (panel3 == DynamicJdbcUrlEditor.this.getPropertyPanel(DynamicJdbcUrlEditor.this.myCurrentPropPanel) && panel3.getDataInterchange().getPersistentProperties().contains(evt.getPropertyName()));
                    if (group.getParameters().contains(evt.getPropertyName())) {
                        DynamicJdbcUrlEditor.this.myModel.setParameter(evt.getPropertyName(), StringUtil.notNullize((String)((String)ObjectUtils.tryCast((Object)evt.getNewValue(), String.class))));
                    }
                    DynamicJdbcUrlEditor.this.panelPropertiesChanged(panel3);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$9", "propertyChange"));
                }
            }, panel3);
            panel3.getDataInterchange().addUserDataListener(new DataInterchange.UserDataListener(){

                public void userDataChanged(@NotNull Key changed) {
                    if (changed == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    if (panel3 != DynamicJdbcUrlEditor.this.getPropertyPanel(DynamicJdbcUrlEditor.this.myCurrentPropPanel) || DynamicJdbcUrlEditor.this.myUpdating) {
                        return;
                    }
                    DynamicJdbcUrlEditor.this.inspect();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$10", "userDataChanged"));
                }
            }, panel3);
            panel3.getDataInterchange().addGroupedChangeListener(this.delayed(new DataInterchange.NestedChangeListener(){

                @Override
                public void nestedChange(int depth) {
                    if (DynamicJdbcUrlEditor.this.myUpdating || depth != 0) {
                        return;
                    }
                    if (DynamicJdbcUrlEditor.this.myPersistentPropertyChanged) {
                        DynamicJdbcUrlEditor.this.panelPropertiesChanged(DynamicJdbcUrlEditor.this.getPropertyPanel(DynamicJdbcUrlEditor.this.myCurrentPropPanel));
                        DynamicJdbcUrlEditor.this.myPersistentPropertyChanged = false;
                    }
                    if (DynamicJdbcUrlEditor.this.myModel.getState() != UrlEditorModelBase.State.VALID) {
                        DynamicJdbcUrlEditor.this.removeCredentialsFromActiveParser();
                    }
                    DynamicJdbcUrlEditor.this.myModel.commit(true);
                }
            }), panel3);
            this.myUrlPropertiesPanels.add(panel3);
        }
        this.updatePanelSwitcher();
        this.setUrlFieldActive(false);
        this.myCurrentPropPanel = -1;
    }

    private void updatePanelSwitcher() {
        int id = this.myModel.getActiveGroupId();
        this.myPanelsSwitcher.setText(id >= 0 && id < this.myModel.getGroupsCount() ? this.myModel.getGroupName(id) : "<none>");
        this.myUnderLabel.setVisible(!this.myModel.isUrlOnly());
    }

    @Nullable
    public DatabaseDriver getActualDriver() {
        return this.myActualDriver;
    }

    @Nullable
    public DatabaseDriver getDriver() {
        return this.myDriver;
    }

    @NotNull
    public UrlEditorModel getEditorModel() {
        UrlEditorModel urlEditorModel = this.myModel;
        if (urlEditorModel == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(17);
        }
        return urlEditorModel;
    }

    private javax.swing.event.DocumentListener delayed(final @NotNull javax.swing.event.DocumentListener l) {
        if (l == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(18);
        }
        return new javax.swing.event.DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (DynamicJdbcUrlEditor.this.myUpdating) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> l.insertUpdate(e));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (DynamicJdbcUrlEditor.this.myUpdating) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> l.removeUpdate(e));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (DynamicJdbcUrlEditor.this.myUpdating) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> l.changedUpdate(e));
            }
        };
    }

    private DataInterchange.NestedChangeListener delayed(final @NotNull DataInterchange.NestedChangeListener l) {
        if (l == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(19);
        }
        return new DataInterchange.NestedChangeListener(){

            @Override
            public void nestedChange(int depth) {
                if (DynamicJdbcUrlEditor.this.myUpdating || depth != 0) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> l.nestedChange(depth));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedCallback";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fg";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestConnectionPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorPreface";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModelForDriver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthPanel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifier";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNameFromParameters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentParamAttributes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setDriver";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "delayed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyLink
    extends SwingActionLink
    implements UserActivityProviderComponent {
        private final EventDispatcher<ChangeListener> myDispatcher = EventDispatcher.create(ChangeListener.class);

        MyLink(final Runnable callback) {
            super((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    callback.run();
                }
            });
        }

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyLink.$$$reportNull$$$0(0);
            }
            this.myDispatcher.addListener((EventListener)changeListener);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyLink.$$$reportNull$$$0(1);
            }
            this.myDispatcher.removeListener((EventListener)changeListener);
        }

        private void fireStateChanged() {
            ChangeEvent event = new ChangeEvent((Object)this);
            ((ChangeListener)this.myDispatcher.getMulticaster()).stateChanged(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "changeListener";
            objectArray2[1] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$MyLink";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyInspectionConsumer
    extends JPanel
    implements UrlEditorInspector.InspectionConsumer {
        private final List<Trinity<String, String, Pair<String, Consumer<DataInterchange>>[]>> myWarnings = new ArrayList<Trinity<String, String, Pair<String, Consumer<DataInterchange>>[]>>();
        private final JBLabel myLabel = new JBLabel();
        private final LinkLabel<?> myMore = LinkLabel.create((String)"More", () -> this.onMore());
        private final JComponent myFixesPanel = new Box(0);
        private boolean myUpdating = false;

        MyInspectionConsumer() {
            super(new BorderLayout(10, 0));
            Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
            this.myLabel.setFont(font);
            this.myMore.setFont(font);
            this.add((Component)this.myLabel, "West");
            this.add((Component)this.myFixesPanel, "East");
        }

        private void onMore() {
            StringBuilder sb = new StringBuilder();
            for (Trinity<String, String, Pair<String, Consumer<DataInterchange>>[]> warning : this.myWarnings) {
                sb.append((String)warning.second).append("\n\n");
            }
            Messages.showInfoMessage((String)sb.toString(), (String)"Warnings");
        }

        @Override
        public void warning(@NotNull String title, @Nullable String more, Pair<String, Consumer<DataInterchange>> ... fixes) {
            if (title == null) {
                MyInspectionConsumer.$$$reportNull$$$0(0);
            }
            if (fixes == null) {
                MyInspectionConsumer.$$$reportNull$$$0(1);
            }
            this.myWarnings.add((Trinity<String, String, Pair<String, Consumer<DataInterchange>>[]>)Trinity.create((Object)title, (Object)more, fixes));
        }

        public void clear() {
            this.myWarnings.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateVisibility(@Nullable DataInterchange active) {
            this.myUpdating = true;
            try {
                if (this.myWarnings.isEmpty()) {
                    this.setVisible(false);
                } else {
                    this.setVisible(true);
                    boolean hasMore = this.myWarnings.size() > 1;
                    for (Trinity<String, String, Pair<String, Consumer<DataInterchange>>[]> warning : this.myWarnings) {
                        hasMore |= warning.second != null;
                    }
                    Trinity<String, String, Pair<String, Consumer<DataInterchange>>[]> warning = this.myWarnings.get(0);
                    this.myLabel.setText("<html>" + StringUtil.escapeXmlEntities((String)((String)warning.first)) + "</html>");
                    this.myFixesPanel.removeAll();
                    if (hasMore) {
                        this.myFixesPanel.add((Component)this.myMore);
                    }
                    for (int i2 = 0; i2 < ((Pair[])warning.third).length; ++i2) {
                        Pair fix = ((Pair[])warning.third)[i2];
                        LinkLabel label = new LinkLabel((String)fix.first, null, (a, b2) -> {
                            if (active != null) {
                                ((Consumer)fix.second).consume((Object)active);
                            }
                        });
                        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)label);
                        this.myFixesPanel.add(Box.createHorizontalStrut(10));
                        this.myFixesPanel.add((Component)label);
                    }
                }
            }
            finally {
                this.myUpdating = false;
            }
        }

        public boolean isUpdating() {
            return this.myUpdating;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$MyInspectionConsumer";
            objectArray[2] = "warning";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

