/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.debugger;

import com.intellij.database.DataBus;
import com.intellij.database.DbmsExtension;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.debugger.SqlDebugController;
import com.intellij.database.debugger.SqlDebugFunKt;
import com.intellij.database.debugger.SqlDebugProfile;
import com.intellij.database.debugger.SqlDebugSessionRunner;
import com.intellij.database.debugger.SqlDebugSessionRunner$sam$com_intellij_openapi_Disposable$0;
import com.intellij.database.debugger.SqlDebuggerFacade;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.run.audit.DatabaseSessionLogger;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u000e2\u00020\u0001:\u0003\u000e\u000f\u0010J\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\rH&R \u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner;", "", "onFinish", "Lkotlin/Function0;", "", "getOnFinish", "()Lkotlin/jvm/functions/Function0;", "setOnFinish", "(Lkotlin/jvm/functions/Function0;)V", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "Companion", "Runner", "SqlDebugAvailability", "intellij.database.impl"})
public interface SqlDebugSessionRunner {
    public static final Companion Companion = com.intellij.database.debugger.SqlDebugSessionRunner$Companion.$$INSTANCE;

    @Nullable
    public Function0<Unit> getOnFinish();

    public void setOnFinish(@Nullable Function0<Unit> var1);

    @NotNull
    public Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment var1);

    @JvmStatic
    @NotNull
    public static SqlDebugAvailability checkDebuggerAvailability(@NotNull LocalDataSource localDataSource, @NotNull SqlDebuggerFacade facade, @NotNull PsiElement element2) {
        return Companion.checkDebuggerAvailability(localDataSource, facade, element2);
    }

    @JvmStatic
    @NotNull
    public static SqlDebugAvailability checkDebuggerAvailability(@Nullable DasDataSource dataSource2, @Nullable BasicSourceAware routine) {
        return Companion.checkDebuggerAvailability(dataSource2, routine);
    }

    @JvmStatic
    @Nullable
    public static SqlDebuggerFacade obtainDebuggerFacadeWhenApplicable(@NotNull LocalDataSource $this$obtainDebuggerFacadeWhenApplicable) {
        return Companion.obtainDebuggerFacadeWhenApplicable($this$obtainDebuggerFacadeWhenApplicable);
    }

    @JvmStatic
    public static void startDebugProcess(@NotNull DataRequest.OwnerEx transactionOwner, @NotNull DatabaseSession consoleDatabaseSession, boolean scriptIsMeaningful, @NotNull VirtualFile virtualFile, @Nullable RangeMarker rangeMarker, @Nullable SearchPath searchPath, @NotNull String consoleTitle, @NotNull Function1<? super ScriptModel<?>, ? extends DataRequest> requestFactory) {
        Companion.startDebugProcess(transactionOwner, consoleDatabaseSession, scriptIsMeaningful, virtualFile, rangeMarker, searchPath, consoleTitle, requestFactory);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner$SqlDebugAvailability;", "", "visible", "", "enabled", "(Ljava/lang/String;IZZ)V", "DEBUGGER_ABSENT", "DEBUGGER_INAPPLICABLE", "DEBUGGER_DISABLED", "DEBUGGER_CONSOLE_BUSY", "DEBUGGER_ENABLED", "intellij.database.impl"})
    public static final class SqlDebugAvailability
    extends Enum<SqlDebugAvailability> {
        public static final /* enum */ SqlDebugAvailability DEBUGGER_ABSENT;
        public static final /* enum */ SqlDebugAvailability DEBUGGER_INAPPLICABLE;
        public static final /* enum */ SqlDebugAvailability DEBUGGER_DISABLED;
        public static final /* enum */ SqlDebugAvailability DEBUGGER_CONSOLE_BUSY;
        public static final /* enum */ SqlDebugAvailability DEBUGGER_ENABLED;
        private static final /* synthetic */ SqlDebugAvailability[] $VALUES;
        @JvmField
        public final boolean visible;
        @JvmField
        public final boolean enabled;

        static {
            SqlDebugAvailability[] sqlDebugAvailabilityArray = new SqlDebugAvailability[5];
            SqlDebugAvailability[] sqlDebugAvailabilityArray2 = sqlDebugAvailabilityArray;
            sqlDebugAvailabilityArray[0] = DEBUGGER_ABSENT = new SqlDebugAvailability(false, false);
            sqlDebugAvailabilityArray[1] = DEBUGGER_INAPPLICABLE = new SqlDebugAvailability(true, false);
            sqlDebugAvailabilityArray[2] = DEBUGGER_DISABLED = new SqlDebugAvailability(true, false);
            sqlDebugAvailabilityArray[3] = DEBUGGER_CONSOLE_BUSY = new SqlDebugAvailability(true, false);
            sqlDebugAvailabilityArray[4] = DEBUGGER_ENABLED = new SqlDebugAvailability(true, true);
            $VALUES = sqlDebugAvailabilityArray;
        }

        private SqlDebugAvailability(boolean visible, boolean enabled) {
            this.visible = visible;
            this.enabled = enabled;
        }

        public static SqlDebugAvailability[] values() {
            return (SqlDebugAvailability[])$VALUES.clone();
        }

        public static SqlDebugAvailability valueOf(String string) {
            return Enum.valueOf(SqlDebugAvailability.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner$Runner;", "Lcom/intellij/database/debugger/SqlDebugSessionRunner;", "marker", "Lcom/intellij/openapi/editor/RangeMarker;", "transactionOwner", "Lcom/intellij/database/datagrid/DataRequest$OwnerEx;", "controller", "Lcom/intellij/database/debugger/SqlDebugController;", "consoleDatabaseSession", "Lcom/intellij/database/console/session/DatabaseSession;", "executingRequest", "Lcom/intellij/database/datagrid/DataRequest;", "(Lcom/intellij/openapi/editor/RangeMarker;Lcom/intellij/database/datagrid/DataRequest$OwnerEx;Lcom/intellij/database/debugger/SqlDebugController;Lcom/intellij/database/console/session/DatabaseSession;Lcom/intellij/database/datagrid/DataRequest;)V", "auditor", "Lcom/intellij/database/debugger/SqlDebugSessionRunner$Runner$MyAdapter;", "disposable", "Lcom/intellij/openapi/Disposable;", "onFinish", "Lkotlin/Function0;", "", "getOnFinish", "()Lkotlin/jvm/functions/Function0;", "setOnFinish", "(Lkotlin/jvm/functions/Function0;)V", "close", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "startTheRequestSequence", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "MyAdapter", "intellij.database.impl"})
    private static final class Runner
    implements SqlDebugSessionRunner {
        @Nullable
        private Function0<Unit> onFinish;
        private final Disposable disposable;
        private final MyAdapter auditor;
        private final DataRequest.OwnerEx transactionOwner;
        private final SqlDebugController controller;
        private final DatabaseSession consoleDatabaseSession;
        private final DataRequest executingRequest;

        @Override
        @Nullable
        public Function0<Unit> getOnFinish() {
            return this.onFinish;
        }

        @Override
        public void setOnFinish(@Nullable Function0<Unit> function0) {
            this.onFinish = function0;
        }

        @Override
        @NotNull
        public Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
            Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
            if (!this.consoleDatabaseSession.isIdle()) {
                Disposer.dispose((Disposable)this.disposable);
                if (this.getOnFinish() != null) {
                    Function0<Unit> function0 = this.getOnFinish();
                    if (function0 == null) {
                        Intrinsics.throwNpe();
                    }
                    function0.invoke();
                }
                return Promises.resolvedPromise(null);
            }
            XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)this.consoleDatabaseSession.getProject());
            XDebugProcessStarter xDebugProcessStarter = this.controller.getStarter();
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebugProcessStarter, (String)"controller.starter");
            XDebugProcessStarter debugProcessStarter = xDebugProcessStarter;
            XDebugSession xDebugSession = debuggerManager.startSession(environment, debugProcessStarter);
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debuggerManager.startSes\u2026ent, debugProcessStarter)");
            XDebugSession xDebugSession2 = xDebugSession;
            Disposer.register((Disposable)((Disposable)xDebugSession2.getConsoleView()), (Disposable)this.disposable);
            this.controller.getReady();
            ConsoleView consoleView = xDebugSession2.getConsoleView();
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleView, (String)"xDebugSession.consoleView");
            this.startTheRequestSequence(consoleView);
            return Promises.resolvedPromise((Object)xDebugSession2.getRunContentDescriptor());
        }

        private final void startTheRequestSequence(ConsoleView consoleView) {
            SqlDebugController.AuxiliaryRequest preparationRequest = this.controller.new SqlDebugController.AuxiliaryRequest(this.transactionOwner);
            if (this.executingRequest == null) {
                consoleView.print("Cannot find script to execute.", ConsoleViewContentType.LOG_ERROR_OUTPUT);
                this.close();
                return;
            }
            DataBus.Consuming consuming = this.transactionOwner.getMessageBus();
            Intrinsics.checkExpressionValueIsNotNull((Object)consuming, (String)"transactionOwner.messageBus");
            DataProducer dataProducer = consuming.getDataProducer();
            preparationRequest.getPromise().onSuccess((Consumer)new Consumer<Void>(this, dataProducer){
                final /* synthetic */ Runner this$0;
                final /* synthetic */ DataProducer $dataProducer;

                public final void accept(Void it2) {
                    this.$dataProducer.processRequest(Runner.access$getExecutingRequest$p(this.this$0));
                }
                {
                    this.this$0 = runner;
                    this.$dataProducer = dataProducer;
                }
            });
            preparationRequest.getPromise().onError((Consumer)new Consumer<Throwable>(this){
                final /* synthetic */ Runner this$0;

                public final void accept(@NotNull Throwable it2) {
                    Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                    Runner.access$close(this.this$0);
                }
                {
                    this.this$0 = runner;
                }
            });
            this.executingRequest.getPromise().onProcessed((Consumer)new Consumer<Void>(this){
                final /* synthetic */ Runner this$0;

                public final void accept(@Nullable Void it2) {
                    Runner.access$close(this.this$0);
                }
                {
                    this.this$0 = runner;
                }
            });
            dataProducer.processRequest(preparationRequest);
        }

        private final void close() {
            if (this.getOnFinish() != null) {
                Function0<Unit> function0 = this.getOnFinish();
                if (function0 == null) {
                    Intrinsics.throwNpe();
                }
                Object object = function0;
                if (function0 != null) {
                    Function0<Unit> function02 = object;
                    object = new SqlDebugSessionRunner$sam$com_intellij_openapi_Disposable$0(function02);
                }
                Disposer.dispose((Disposable)((Disposable)object));
            }
            this.controller.close();
        }

        public Runner(@Nullable RangeMarker marker, @NotNull DataRequest.OwnerEx transactionOwner, @NotNull SqlDebugController controller, @NotNull DatabaseSession consoleDatabaseSession, @Nullable DataRequest executingRequest) {
            Intrinsics.checkParameterIsNotNull((Object)transactionOwner, (String)"transactionOwner");
            Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
            Intrinsics.checkParameterIsNotNull((Object)consoleDatabaseSession, (String)"consoleDatabaseSession");
            this.transactionOwner = transactionOwner;
            this.controller = controller;
            this.consoleDatabaseSession = consoleDatabaseSession;
            this.executingRequest = executingRequest;
            this.disposable = new Disposable(marker){
                final /* synthetic */ RangeMarker $marker;

                public final void dispose() {
                    block0: {
                        RangeMarker rangeMarker = this.$marker;
                        if (rangeMarker == null) break block0;
                        rangeMarker.dispose();
                    }
                }
                {
                    this.$marker = rangeMarker;
                }
            };
            this.auditor = new MyAdapter();
            this.transactionOwner.getMessageBus().addAuditor(this.auditor);
            Disposer.register((Disposable)this.disposable, (Disposable)this.auditor);
        }

        public static final /* synthetic */ void access$close(Runner $this) {
            $this.close();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner$Runner$MyAdapter;", "Lcom/intellij/database/datagrid/DataAuditor$Adapter;", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/database/debugger/SqlDebugSessionRunner$Runner;)V", "afterStatement", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "beforeStatement", "dispose", "isApplicable", "", "intellij.database.impl"})
        private final class MyAdapter
        extends DataAuditor.Adapter
        implements Disposable {
            private final boolean isApplicable(DataRequest.Context context) {
                return context.request == Runner.this.executingRequest;
            }

            @Override
            public void beforeStatement(@NotNull DataRequest.Context context) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)context), (String)"context");
                if (this.isApplicable(context)) {
                    Runner.this.controller.debugBegin();
                }
            }

            @Override
            public void afterStatement(@NotNull DataRequest.Context context) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)context), (String)"context");
                if (this.isApplicable(context)) {
                    Runner.this.controller.debugEnd();
                }
            }

            public void dispose() {
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007JJ\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 JR\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0016\u0010!\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030#\u0012\u0004\u0012\u00020\u00180\"JT\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180$H\u0002J0\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010#2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001a2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\\\u0010)\u001a\u00020*2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010+\u001a\u00020,2\u0016\u0010!\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030#\u0012\u0004\u0012\u00020\u00180\"H\u0007J\u000e\u0010-\u001a\u0004\u0018\u00010\u0005*\u00020\tH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner$Companion;", "", "()V", "FACADE_EP", "Lcom/intellij/database/DbmsExtension;", "Lcom/intellij/database/debugger/SqlDebuggerFacade;", "checkDebuggerAvailability", "Lcom/intellij/database/debugger/SqlDebugSessionRunner$SqlDebugAvailability;", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "facade", "element", "Lcom/intellij/psi/PsiElement;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "routine", "Lcom/intellij/database/model/basic/BasicSourceAware;", "createRunner", "Lcom/intellij/database/debugger/SqlDebugSessionRunner;", "transactionOwner", "Lcom/intellij/database/datagrid/DataRequest$OwnerEx;", "consoleDatabaseSession", "Lcom/intellij/database/console/session/DatabaseSession;", "request", "Lcom/intellij/database/datagrid/DataRequest;", "scriptIsMeaningful", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "requestFactory", "Lkotlin/Function1;", "Lcom/intellij/database/script/ScriptModel;", "Lkotlin/Function0;", "obtainActualScriptModel", "project", "Lcom/intellij/openapi/project/Project;", "firstOnly", "startDebugProcess", "", "consoleTitle", "", "obtainDebuggerFacadeWhenApplicable", "intellij.database.impl"})
    public static final class Companion {
        private static final DbmsExtension<SqlDebuggerFacade> FACADE_EP;
        static final /* synthetic */ Companion $$INSTANCE;

        @JvmStatic
        @NotNull
        public final SqlDebugAvailability checkDebuggerAvailability(@NotNull LocalDataSource localDataSource, @NotNull SqlDebuggerFacade facade, @NotNull PsiElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)localDataSource, (String)"localDataSource");
            Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element2, SqlStatement.class);
            if (statement == null) {
                return SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
            }
            if (!facade.isApplicableToDebugStatement(statement)) {
                return SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
            }
            return facade.canDebug(localDataSource) ? SqlDebugAvailability.DEBUGGER_ENABLED : SqlDebugAvailability.DEBUGGER_DISABLED;
        }

        @JvmStatic
        @NotNull
        public final SqlDebugAvailability checkDebuggerAvailability(@Nullable DasDataSource dataSource2, @Nullable BasicSourceAware routine) {
            LocalDataSource localDataSource;
            Object object;
            LocalDataSource localDataSource2;
            DasDataSource dasDataSource = dataSource2;
            if (dasDataSource != null) {
                DasDataSource dasDataSource2 = dasDataSource;
                boolean bl = false;
                boolean bl2 = false;
                DasDataSource it2 = dasDataSource2;
                boolean bl3 = false;
                localDataSource2 = DbImplUtil.getMaybeLocalDataSource(it2);
            } else {
                localDataSource2 = null;
            }
            if ((object = (localDataSource = localDataSource2)) == null || (object = this.obtainDebuggerFacadeWhenApplicable((LocalDataSource)object)) == null) {
                return SqlDebugAvailability.DEBUGGER_ABSENT;
            }
            Object facade = object;
            if (routine == null) {
                return SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
            }
            if (!facade.isApplicableToDebugRoutine(routine)) {
                return SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
            }
            return facade.canDebug(localDataSource) ? SqlDebugAvailability.DEBUGGER_ENABLED : SqlDebugAvailability.DEBUGGER_DISABLED;
        }

        @JvmStatic
        @Nullable
        public final SqlDebuggerFacade obtainDebuggerFacadeWhenApplicable(@NotNull LocalDataSource $this$obtainDebuggerFacadeWhenApplicable) {
            Intrinsics.checkParameterIsNotNull((Object)$this$obtainDebuggerFacadeWhenApplicable, (String)"$this$obtainDebuggerFacadeWhenApplicable");
            if (!SqlDebugFunKt.sqlDebuggerIsEnabled()) {
                return null;
            }
            return (SqlDebuggerFacade)FACADE_EP.forDbms($this$obtainDebuggerFacadeWhenApplicable.getDbms());
        }

        @Nullable
        public final ScriptModel<?> obtainActualScriptModel(@NotNull Project project, @NotNull VirtualFile virtualFile, boolean firstOnly, @Nullable RangeMarker rangeMarker) {
            RangeMarker range;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            boolean bl = false;
            boolean bl2 = false;
            FileDocumentManager $this$apply = fileDocumentManager;
            boolean bl3 = false;
            Document document = $this$apply.getCachedDocument(virtualFile);
            if (document != null) {
                Document document2 = document;
                boolean bl4 = false;
                boolean bl5 = false;
                Document doc2 = document2;
                boolean bl6 = false;
                WriteAction.runAndWait((ThrowableRunnable)new ThrowableRunnable<E>(doc2, $this$apply){
                    final /* synthetic */ Document $doc;
                    final /* synthetic */ FileDocumentManager $this_apply$inlined;
                    {
                        this.$doc = document;
                        this.$this_apply$inlined = fileDocumentManager;
                    }

                    public final void run() {
                        this.$this_apply$inlined.saveDocument(this.$doc);
                    }
                });
            }
            ScriptModel scriptModel = SqlPsiFacade.getInstance((Project)project).createScriptModel(virtualFile, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)scriptModel, (String)"SqlPsiFacade.getInstance\u2026tModel(virtualFile, null)");
            ScriptModel sm = scriptModel;
            if (firstOnly) {
                object = rangeMarker;
                if (object == null || (object = UtilsKt.getRange((RangeMarker)object)) == null) {
                    JBIterable jBIterable = sm.statements();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"sm.statements()");
                    ScriptModel.StatementIt statementIt = (ScriptModel.StatementIt)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
                    object = statementIt != null ? statementIt.range() : null;
                }
            } else {
                RangeMarker rangeMarker2 = rangeMarker;
                if (rangeMarker2 == null || (rangeMarker2 = UtilsKt.getRange((RangeMarker)rangeMarker2)) == null) {
                    rangeMarker2 = object = sm.getTextRange();
                }
                if (rangeMarker2 == null) {
                    object = new TextRange(0, (int)virtualFile.getLength());
                }
            }
            if ((range = object) == null) {
                return null;
            }
            return sm.subModel((TextRange)range);
        }

        public static /* synthetic */ ScriptModel obtainActualScriptModel$default(Companion companion, Project project, VirtualFile virtualFile, boolean bl, RangeMarker rangeMarker, int n, Object object) {
            if ((n & 8) != 0) {
                rangeMarker = null;
            }
            return companion.obtainActualScriptModel(project, virtualFile, bl, rangeMarker);
        }

        @JvmStatic
        public final void startDebugProcess(@NotNull DataRequest.OwnerEx transactionOwner, @NotNull DatabaseSession consoleDatabaseSession, boolean scriptIsMeaningful, @NotNull VirtualFile virtualFile, @Nullable RangeMarker rangeMarker, @Nullable SearchPath searchPath, @NotNull String consoleTitle, @NotNull Function1<? super ScriptModel<?>, ? extends DataRequest> requestFactory) {
            Intrinsics.checkParameterIsNotNull((Object)transactionOwner, (String)"transactionOwner");
            Intrinsics.checkParameterIsNotNull((Object)consoleDatabaseSession, (String)"consoleDatabaseSession");
            Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkParameterIsNotNull((Object)consoleTitle, (String)"consoleTitle");
            Intrinsics.checkParameterIsNotNull(requestFactory, (String)"requestFactory");
            Project project = consoleDatabaseSession.getProject();
            LocalDataSource localDataSource = (LocalDataSource)consoleDatabaseSession.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDataSource, (String)"consoleDatabaseSession.target");
            LocalDataSource dataSource2 = localDataSource;
            SqlDebugSessionRunner runner = this.createRunner(transactionOwner, consoleDatabaseSession, scriptIsMeaningful, virtualFile, rangeMarker, searchPath, requestFactory);
            RunContentManager runContentManager = RunContentManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)runContentManager, (String)"RunContentManager.getInstance(project)");
            Set set = JBIterable.from((Iterable)runContentManager.getAllDescriptors()).map((Function)startDebugProcess.existingTitles.1.INSTANCE).toSet();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"JBIterable.from(RunConte\u2026Name }\n          .toSet()");
            Set existingTitles2 = set;
            String string = UniqueNameGenerator.generateUniqueName((String)consoleTitle, (String)"", (String)"", (String)" (", (String)")", (Condition)((Condition)new Condition<String>(existingTitles2){
                final /* synthetic */ Set $existingTitles;

                public final boolean value(String it2) {
                    return !this.$existingTitles.contains(it2);
                }
                {
                    this.$existingTitles = set;
                }
            }));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UniqueNameGenerator.gene\u2026{ it !in existingTitles }");
            String uniqueTitle2 = string;
            Executor debugExecutor = DefaultDebugExecutor.getDebugExecutorInstance();
            try {
                AsyncProgramRunner<RunnerSettings> asyncRunner2 = new AsyncProgramRunner<RunnerSettings>(runner){
                    final /* synthetic */ SqlDebugSessionRunner $runner;

                    @NotNull
                    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
                        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
                        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                        return this.$runner.execute(environment);
                    }

                    @NotNull
                    public String getRunnerId() {
                        return "sqlDebugSessionRunner";
                    }

                    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
                        Intrinsics.checkParameterIsNotNull((Object)executorId, (String)"executorId");
                        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
                        return false;
                    }
                    {
                        this.$runner = $captured_local_variable$0;
                    }
                };
                Executor executor = debugExecutor;
                Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"debugExecutor");
                ExecutionEnvironmentBuilder executionEnvironmentBuilder = new ExecutionEnvironmentBuilder(project, executor);
                Icon icon = dataSource2.getIcon();
                Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"dataSource.icon");
                ExecutionEnvironment environment = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)executionEnvironmentBuilder.runProfile((RunProfile)new SqlDebugProfile(consoleTitle, icon)).runner((ProgramRunner)asyncRunner2), null, (int)1, null);
                asyncRunner2.execute(environment);
            }
            catch (ExecutionException e) {
                Executor executor = debugExecutor;
                Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"debugExecutor");
                ExecutionUtil.handleExecutionError((Project)project, (String)executor.getToolWindowId(), (String)uniqueTitle2, (Throwable)e);
            }
        }

        @NotNull
        public final SqlDebugSessionRunner createRunner(@NotNull DataRequest.OwnerEx transactionOwner, @NotNull DatabaseSession consoleDatabaseSession, boolean scriptIsMeaningful, @NotNull VirtualFile virtualFile, @Nullable RangeMarker rangeMarker, @Nullable SearchPath searchPath, @NotNull Function1<? super ScriptModel<?>, ? extends DataRequest> requestFactory) {
            Intrinsics.checkParameterIsNotNull((Object)transactionOwner, (String)"transactionOwner");
            Intrinsics.checkParameterIsNotNull((Object)consoleDatabaseSession, (String)"consoleDatabaseSession");
            Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkParameterIsNotNull(requestFactory, (String)"requestFactory");
            return this.createRunner(transactionOwner, consoleDatabaseSession, scriptIsMeaningful, virtualFile, rangeMarker, searchPath, (Function0<? extends DataRequest>)((Function0)new Function0<DataRequest>(this, consoleDatabaseSession, virtualFile, rangeMarker, requestFactory){
                final /* synthetic */ Companion this$0;
                final /* synthetic */ DatabaseSession $consoleDatabaseSession;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ RangeMarker $rangeMarker;
                final /* synthetic */ Function1 $requestFactory;

                @Nullable
                public final DataRequest invoke() {
                    DataRequest dataRequest;
                    ScriptModel<?> scriptModel = this.this$0.obtainActualScriptModel(this.$consoleDatabaseSession.getProject(), this.$virtualFile, true, this.$rangeMarker);
                    if (scriptModel != null) {
                        ScriptModel<?> scriptModel2 = scriptModel;
                        boolean bl = false;
                        boolean bl2 = false;
                        ScriptModel<?> it2 = scriptModel2;
                        boolean bl3 = false;
                        dataRequest = (DataRequest)((Object)this.$requestFactory.invoke(it2));
                    } else {
                        dataRequest = null;
                    }
                    return dataRequest;
                }
                {
                    this.this$0 = companion;
                    this.$consoleDatabaseSession = databaseSession;
                    this.$virtualFile = virtualFile;
                    this.$rangeMarker = rangeMarker;
                    this.$requestFactory = function1;
                    super(0);
                }
            }));
        }

        @NotNull
        public final SqlDebugSessionRunner createRunner(@NotNull DataRequest.OwnerEx transactionOwner, @NotNull DatabaseSession consoleDatabaseSession, @NotNull DataRequest request, boolean scriptIsMeaningful, @Nullable VirtualFile virtualFile, @Nullable RangeMarker rangeMarker, @Nullable SearchPath searchPath) {
            Intrinsics.checkParameterIsNotNull((Object)transactionOwner, (String)"transactionOwner");
            Intrinsics.checkParameterIsNotNull((Object)consoleDatabaseSession, (String)"consoleDatabaseSession");
            Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
            return this.createRunner(transactionOwner, consoleDatabaseSession, scriptIsMeaningful, virtualFile, rangeMarker, searchPath, (Function0<? extends DataRequest>)((Function0)new Function0<DataRequest>(request){
                final /* synthetic */ DataRequest $request;

                @NotNull
                public final DataRequest invoke() {
                    return this.$request;
                }
                {
                    this.$request = dataRequest;
                    super(0);
                }
            }));
        }

        public static /* synthetic */ SqlDebugSessionRunner createRunner$default(Companion companion, DataRequest.OwnerEx ownerEx, DatabaseSession databaseSession, DataRequest dataRequest, boolean bl, VirtualFile virtualFile, RangeMarker rangeMarker, SearchPath searchPath, int n, Object object) {
            if ((n & 0x10) != 0) {
                virtualFile = null;
            }
            if ((n & 0x20) != 0) {
                rangeMarker = null;
            }
            if ((n & 0x40) != 0) {
                searchPath = null;
            }
            return companion.createRunner(ownerEx, databaseSession, dataRequest, bl, virtualFile, rangeMarker, searchPath);
        }

        private final SqlDebugSessionRunner createRunner(DataRequest.OwnerEx transactionOwner, DatabaseSession consoleDatabaseSession, boolean scriptIsMeaningful, VirtualFile virtualFile, RangeMarker rangeMarker, SearchPath searchPath, Function0<? extends DataRequest> requestFactory) {
            LocalDataSource localDataSource = (LocalDataSource)consoleDatabaseSession.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDataSource, (String)"consoleDatabaseSession.target");
            SqlDebuggerFacade facade = (SqlDebuggerFacade)FACADE_EP.forDbms(localDataSource.getDbms());
            SqlDebugController sqlDebugController = facade.createController(consoleDatabaseSession.getProject(), (LocalDataSource)consoleDatabaseSession.getTarget(), transactionOwner, scriptIsMeaningful, virtualFile, rangeMarker, searchPath);
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlDebugController, (String)"facade.createController(\u2026 rangeMarker, searchPath)");
            SqlDebugController controller = sqlDebugController;
            DataRequest executingRequest = (DataRequest)((Object)requestFactory.invoke());
            DatabaseSessionLogger.SILENT_REQUEST.set((UserDataHolder)executingRequest, (Object)true);
            return new Runner(rangeMarker, transactionOwner, controller, consoleDatabaseSession, executingRequest);
        }

        static /* synthetic */ SqlDebugSessionRunner createRunner$default(Companion companion, DataRequest.OwnerEx ownerEx, DatabaseSession databaseSession, boolean bl, VirtualFile virtualFile, RangeMarker rangeMarker, SearchPath searchPath, Function0 function0, int n, Object object) {
            if ((n & 8) != 0) {
                virtualFile = null;
            }
            if ((n & 0x10) != 0) {
                rangeMarker = null;
            }
            if ((n & 0x20) != 0) {
                searchPath = null;
            }
            return companion.createRunner(ownerEx, databaseSession, bl, virtualFile, rangeMarker, searchPath, (Function0<? extends DataRequest>)function0);
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            FACADE_EP = new DbmsExtension("com.intellij.database.debuggerFacade");
        }
    }
}

