/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.diff.DiffSupport;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TableDiffDividerDrawUtil {
    public static void paintPolygons(@NotNull Graphics2D gg, int width, @NotNull DiffSupport editor1, @NotNull DiffSupport editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            TableDiffDividerDrawUtil.$$$reportNull$$$0(0);
        }
        if (editor1 == null) {
            TableDiffDividerDrawUtil.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            TableDiffDividerDrawUtil.$$$reportNull$$$0(2);
        }
        if (paintable == null) {
            TableDiffDividerDrawUtil.$$$reportNull$$$0(3);
        }
        List<DividerPolygon> polygons = TableDiffDividerDrawUtil.createVisiblePolygons(editor1, editor2, paintable);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerPolygon polygon : polygons) {
            polygon.paint(gg, width);
        }
        config.restore();
    }

    @NotNull
    public static List<DividerPolygon> createVisiblePolygons(@NotNull DiffSupport editor1, @NotNull DiffSupport editor2, @NotNull DividerPaintable paintable) {
        if (editor1 == null) {
            TableDiffDividerDrawUtil.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            TableDiffDividerDrawUtil.$$$reportNull$$$0(5);
        }
        if (paintable == null) {
            TableDiffDividerDrawUtil.$$$reportNull$$$0(6);
        }
        final ArrayList<DividerPolygon> polygons = new ArrayList<DividerPolygon>();
        final Transformation[] transformations = new Transformation[]{TableDiffDividerDrawUtil.getTransformation(editor1), TableDiffDividerDrawUtil.getTransformation(editor2)};
        final LineRange leftInterval = TableDiffDividerDrawUtil.getVisibleInterval(editor1);
        final LineRange rightInterval = TableDiffDividerDrawUtil.getVisibleInterval(editor2);
        paintable.process(new DividerPaintable.Handler(){

            @Override
            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
                if (color == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (leftInterval.start > endLine1 && rightInterval.start > endLine2) {
                    return true;
                }
                if (leftInterval.end < startLine1 && rightInterval.end < startLine2) {
                    return false;
                }
                polygons.add(TableDiffDividerDrawUtil.createPolygon(transformations, startLine1, endLine1, startLine2, endLine2, color));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/database/diff/TableDiffDividerDrawUtil$1", "process"));
            }
        });
        ArrayList<DividerPolygon> arrayList = polygons;
        if (arrayList == null) {
            TableDiffDividerDrawUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static Transformation getTransformation(final @NotNull DiffSupport editor) {
        if (editor == null) {
            TableDiffDividerDrawUtil.$$$reportNull$$$0(8);
        }
        return new Transformation(){

            @Override
            public int transform(int line) {
                int yOffset = editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
                int headerOffset = editor.getHeaderOffset();
                return yOffset - editor.getScrollingModel().getVerticalScrollOffset() + headerOffset;
            }
        };
    }

    @NotNull
    private static DividerPolygon createPolygon(@NotNull Transformation[] transformations, int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
        if (color == null) {
            TableDiffDividerDrawUtil.$$$reportNull$$$0(9);
        }
        if (transformations == null) {
            TableDiffDividerDrawUtil.$$$reportNull$$$0(10);
        }
        int start1 = transformations[0].transform(startLine1);
        int end1 = transformations[0].transform(endLine1);
        int start2 = transformations[1].transform(startLine2);
        int end2 = transformations[1].transform(endLine2);
        return new DividerPolygon(start1, start2, end1, end2, color);
    }

    @NotNull
    private static LineRange getVisibleInterval(DiffSupport editor) {
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        LogicalPosition position1 = editor.xyToLogicalPosition(new Point(0, area.y));
        LogicalPosition position2 = editor.xyToLogicalPosition(new Point(0, area.y + area.height));
        return new LineRange(position1.line, position2.line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gg";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor1";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor2";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paintable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diff/TableDiffDividerDrawUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diff/TableDiffDividerDrawUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisiblePolygons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paintPolygons";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createVisiblePolygons";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTransformation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPolygon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Transformation {
        public int transform(int var1);
    }

    private static class DividerPolygon {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @NotNull
        private final Color myColor;

        DividerPolygon(int start1, int start2, int end1, int end2, @NotNull Color color) {
            if (color == null) {
                DividerPolygon.$$$reportNull$$$0(0);
            }
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myColor = color;
        }

        public void paint(Graphics2D g, int width) {
            int startY1 = this.myStart1;
            int endY1 = this.myEnd1;
            int startY2 = this.myStart2;
            int endY2 = this.myEnd2;
            if (endY1 - startY1 < 2) {
                endY1 = startY1 + 1;
            }
            if (endY2 - startY2 < 2) {
                endY2 = startY2 + 1;
            }
            DiffDrawUtil.drawCurveTrapezium((Graphics2D)g, (int)0, (int)width, (int)startY1, (int)endY1, (int)startY2, (int)endY2, (Color)this.myColor, null);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> " + this.myColor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/database/diff/TableDiffDividerDrawUtil$DividerPolygon", "<init>"));
        }
    }

    public static interface DividerPaintable {
        public void process(@NotNull Handler var1);

        public static abstract class Handler {
            public abstract boolean process(int var1, int var2, int var3, int var4, @NotNull Color var5);
        }
    }
}

