/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareExtractor;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlValuesExtractor
extends TranspositionAwareExtractor {
    public HtmlValuesExtractor(ObjectFormatter converter) {
        super(converter);
    }

    @NotNull
    public String getDataPrefix() {
        return "<table border=\"1\" style=\"border-collapse:collapse\">";
    }

    @NotNull
    public String getDataSuffix() {
        return "</table>";
    }

    @NotNull
    public String getLinePrefix() {
        return "<tr>";
    }

    @NotNull
    public String getLineSuffix() {
        return "</tr>";
    }

    @NotNull
    public String getValuePrefix() {
        return "<td>";
    }

    @NotNull
    public String getValueSuffix() {
        return "</td>";
    }

    @Override
    public String getColumnName(DataConsumer.Column column) {
        return "<th>" + column.name + "</th>";
    }

    @Override
    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull Dbms dbms, boolean forDisplay) {
        if (row == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(0);
        }
        if (column == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(1);
        }
        if (dbms == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(2);
        }
        return this.getValueAsString(row, column, dbms, forDisplay, true);
    }

    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull Dbms dbms, boolean forDisplay, boolean escape) {
        if (row == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(3);
        }
        if (column == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(4);
        }
        if (dbms == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(5);
        }
        String repr = super.getValueAsString(row, column, dbms, forDisplay);
        return escape ? HtmlValuesExtractor.escapeChars(repr) : repr;
    }

    @Nullable
    public static String escapeChars(@Nullable String s) {
        return s != null ? StringUtil.escapeXmlEntities((String)s.replaceAll("[\t\b\\f]", "")).replaceAll("\\r|\\n|\\r\\n", "<br/>") : null;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return "html";
    }

    @Override
    protected TranspositionAwareExtractor.TranspositionAwareExtraction startExtraction(CharOut out, Dbms dbms, List<DataConsumer.Column> allColumns, @NotNull ExtractionConfig config, boolean isTransposedMode, int ... selectedColumns) {
        if (config == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(6);
        }
        return new HtmlExtraction(out, dbms, config, allColumns, isTransposedMode, selectedColumns);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/extractors/HtmlValuesExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueAsString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "startExtraction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class HtmlExtraction
    extends TranspositionAwareExtractor.TranspositionAwareExtraction {
        private final boolean myIsTransposedMode;

        public HtmlExtraction(CharOut output, @NotNull Dbms dbms, ExtractionConfig config, List<DataConsumer.Column> allColumns, boolean isTransposedMode, int[] selectedColumnIndices) {
            if (config == null) {
                HtmlExtraction.$$$reportNull$$$0(0);
            }
            super(HtmlValuesExtractor.this, output, dbms, config, allColumns, selectedColumnIndices);
            this.myIsTransposedMode = isTransposedMode;
        }

        protected String getHeader() {
            return "<!DOCTYPE html>\n<html>\n<head>\n  <title></title>\n</head>\n<body>\n" + HtmlValuesExtractor.this.getDataPrefix() + "\n";
        }

        protected String getFooter() {
            return "\n</body>\n</html>";
        }

        @Override
        protected void doAppendData(List<DataConsumer.Row> rows) {
            TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
            boolean first2 = true;
            for (DataConsumer.Row row : rows) {
                if (!first2) {
                    this.myOutput.append(HtmlValuesExtractor.this.getLineSeparator());
                } else {
                    first2 = false;
                }
                this.myOutput.append(HtmlValuesExtractor.this.getLinePrefix());
                if (this.myIsTransposedMode) {
                    this.myOutput.append(HtmlValuesExtractor.this.getValuePrefix()).append(HtmlValuesExtractor.this.getValueLiteral(this.myDbms, this.getRowNumber(row), null, null)).append(HtmlValuesExtractor.this.getValueSuffix());
                }
                for (int selectedColumn : ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    DataConsumer.Column column = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column == null) continue;
                    String value2 = HtmlValuesExtractor.this.getValueLiteral(row, column, this.myDbms);
                    this.myOutput.append(HtmlValuesExtractor.this.getValuePrefix()).append(value2).append(HtmlValuesExtractor.this.getValueSuffix());
                }
                this.myOutput.append(HtmlValuesExtractor.this.getLineSuffix());
            }
        }

        @Override
        protected void doAppendHeader(boolean appendNewLine) {
            this.myOutput.append(this.getHeader());
            int[] selectedColumns = ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
            if (selectedColumns.length == 0) {
                return;
            }
            String columnName = this.myIsTransposedMode ? HtmlValuesExtractor.this.getColumnName(this.getRowNumbersColumn()) : "";
            this.myOutput.append(HtmlValuesExtractor.this.getLinePrefix()).append(columnName);
            TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
            for (int selectedColumn : selectedColumns) {
                DataConsumer.Column column = (DataConsumer.Column)columnsMap.get(selectedColumn);
                if (column == null) continue;
                this.myOutput.append(HtmlValuesExtractor.this.getColumnName(column));
            }
            this.myOutput.append(HtmlValuesExtractor.this.getLineSuffix());
            if (appendNewLine) {
                this.myOutput.append(HtmlValuesExtractor.this.getLineSeparator());
            }
        }

        @Override
        protected void doAppendFooter() {
            this.myOutput.append(HtmlValuesExtractor.this.getDataSuffix()).append(this.getFooter());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/extractors/HtmlValuesExtractor$HtmlExtraction", "<init>"));
        }
    }
}

