/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.RenameQueryGenerator;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DbRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiElement psiElement;
        if (dataContext == null) {
            DbRenameHandler.$$$reportNull$$$0(0);
        }
        return (psiElement = PsiElementRenameHandler.getElement((DataContext)dataContext)) instanceof DatabaseStructure.DbGroup || psiElement instanceof DbElement && !DbRenameHandler.isVetoedElement((DbElement)psiElement);
    }

    public static boolean isVetoedElement(@NotNull DbElement dbElement) {
        if (dbElement == null) {
            DbRenameHandler.$$$reportNull$$$0(1);
        }
        if (dbElement instanceof DbDataSource) {
            return false;
        }
        if (DataImporter.isBusy(dbElement)) {
            return true;
        }
        if (DbSqlUtil.isSqlElement(dbElement)) {
            return false;
        }
        BasicNamedElement element2 = (BasicNamedElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), BasicNamedElement.class);
        BasicModel model = element2 == null ? null : element2.getModel();
        return model == null || !RenameQueryGenerator.canRename(model, element2);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiElement element2;
        Object delegate;
        if (project == null) {
            DbRenameHandler.$$$reportNull$$$0(2);
        }
        Object object = delegate = (element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) instanceof DbElement ? ((DbElement)element2).getDelegate() : null;
        if (delegate instanceof BasicElement) {
            RefactoringActionHandlerFactory.getInstance().createRenameHandler().invoke(project, new PsiElement[]{element2}, dataContext);
        } else if (element2 instanceof DbDataSource) {
            String newName;
            String initialName = ((DbDataSource)element2).getName();
            String newText = Messages.showInputDialog((Project)project, (String)("Rename Data Source '" + initialName + "' to:"), (String)"Rename", (Icon)Messages.getQuestionIcon(), (String)initialName, null);
            int idx = newText == null ? -1 : newText.lastIndexOf("/");
            String groupName = idx < 0 ? null : newText.substring(0, idx);
            String string = newName = idx < 0 ? newText : newText.substring(idx + 1);
            if (StringUtil.isNotEmpty((String)newName)) {
                if (idx >= 0) {
                    ((AbstractDataSource)((DbDataSource)element2).getDelegate()).setGroupName(groupName);
                }
                ((DbDataSource)element2).setName(newName);
                DatabaseView.refreshViewAndSelect(project, Collections.singleton(element2));
            }
        } else if (element2 instanceof DatabaseStructure.DbGroup) {
            DatabaseStructure.DbGroup group = (DatabaseStructure.DbGroup)element2;
            String initialName = group.getName();
            String newName = Messages.showInputDialog((Project)project, (String)("Rename Group '" + initialName + "' to:"), (String)"Rename", (Icon)Messages.getQuestionIcon(), (String)initialName, null);
            if (StringUtil.isNotEmpty((String)newName)) {
                DatabaseStructure.renameGroup(project, group, newName);
            }
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            DbRenameHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            DbRenameHandler.$$$reportNull$$$0(4);
        }
        this.invoke(project, null, null, dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/DbRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isVetoedElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DatabaseVetoRenameCondition
    implements Condition<PsiElement> {
        public boolean value(PsiElement element2) {
            return element2 instanceof DbElement && DbRenameHandler.isVetoedElement((DbElement)element2);
        }
    }
}

