/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellRenderingUtils;
import com.intellij.database.run.ui.grid.GridRowHeader;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.run.ui.table.TableScrollPane;
import com.intellij.database.run.ui.table.TableSelectionModel;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class TableResultRowHeader
extends GridRowHeader {
    private final TableResultPanel myResultPanel;
    private final TableResultView myTable;
    private final ActionGroup myPopupActions;
    private final GridRowHeader.RowHeaderCellRenderer myRenderer;

    public TableResultRowHeader(@NotNull TableResultPanel resultPanel, @NotNull TableResultView view2, @NotNull ActionGroup popupActions) {
        if (resultPanel == null) {
            TableResultRowHeader.$$$reportNull$$$0(0);
        }
        if (view2 == null) {
            TableResultRowHeader.$$$reportNull$$$0(1);
        }
        if (popupActions == null) {
            TableResultRowHeader.$$$reportNull$$$0(2);
        }
        super((JTable)((Object)view2));
        this.myResultPanel = resultPanel;
        this.myTable = view2;
        this.myPopupActions = popupActions;
        this.myRenderer = new MyRowHeaderCellRenderer(this.createTransposedRenderer(), this.createRegularRenderer());
        GutterMouseListener mouseListener = new GutterMouseListener();
        this.addMouseMotionListener((MouseMotionListener)((Object)mouseListener));
        this.addMouseListener((MouseListener)((Object)mouseListener));
    }

    @NotNull
    protected RowHeaderCellComponentBase createRegularRenderer() {
        return new RowNumberRowHeaderCellComponent();
    }

    @NotNull
    protected RowHeaderCellComponentBase createTransposedRenderer() {
        return new ColumnInfoRowHeaderCellComponent();
    }

    @Override
    @NotNull
    public GridRowHeader.RowHeaderCellRenderer getCellRenderer() {
        GridRowHeader.RowHeaderCellRenderer rowHeaderCellRenderer = this.myRenderer;
        if (rowHeaderCellRenderer == null) {
            TableResultRowHeader.$$$reportNull$$$0(3);
        }
        return rowHeaderCellRenderer;
    }

    @Override
    @NotNull
    public JTable getTable() {
        TableResultView tableResultView = this.myTable;
        if (tableResultView == null) {
            TableResultRowHeader.$$$reportNull$$$0(4);
        }
        return tableResultView;
    }

    private boolean isTransposed() {
        return this.myTable.isTransposed();
    }

    public int rowForPoint(Point point) {
        return point != null ? this.myTable.rowAtPoint(point) : -1;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintCellsEffects(g);
    }

    @Override
    protected int calcPreferredWidthWithoutInsets() {
        if (this.isTransposed() || this.myTable.isEmpty()) {
            return super.calcPreferredWidthWithoutInsets();
        }
        int lastRowIdx = this.myTable.getModel().getRowCount() - 1;
        return ((RowNumberRowHeaderCellComponent)((Object)this.getCellRenderer().getRendererComponent(lastRowIdx, false))).getPreferredWidth();
    }

    private void paintCellsEffects(final Graphics g) {
        CellRenderingUtils.processVisibleRows((JTable)((Object)this.myTable), g, new CellRenderingUtils.RowProcessor(){

            @Override
            public boolean process(int row, int y) {
                TableResultRowHeader.this.paintCellEffects(g, row, new Rectangle(0, y, TableResultRowHeader.this.getWidth(), TableResultRowHeader.this.myTable.getRowHeight(row)));
                return true;
            }
        });
    }

    private void paintCellEffects(Graphics g, int row, Rectangle cellRect) {
        CellAttributes attributes2 = this.isTransposed() ? this.myResultPanel.getMarkupModel().getColumnHeaderAttributes(ViewIndex.forColumn(this.myResultPanel, row).toModel(this.myResultPanel), this.myResultPanel.getColorsScheme()) : this.myResultPanel.getMarkupModel().getRowHeaderAttributes(ViewIndex.forRow(this.myResultPanel, row).toModel(this.myResultPanel), this.myResultPanel.getColorsScheme());
        if (attributes2 != null) {
            CellRenderingUtils.paintCellEffect(g, cellRect, attributes2, DbUIUtil.softHighlightOf(attributes2.getEffectColor()));
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point point = event.getPoint();
        int viewRowIdx = this.rowForPoint(point);
        if (viewRowIdx < 0 || !this.isTransposed()) {
            return null;
        }
        ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this.myResultPanel, this.myTable.convertRowIndexToModel(viewRowIdx));
        DataConsumer.Column column = this.myResultPanel.getDataModel().getColumn(columnIdx);
        return this.myResultPanel.getColumnTooltipHtml(column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActions";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/table/TableResultRowHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/table/TableResultRowHeader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRowHeaderCellRenderer
    implements GridRowHeader.RowHeaderCellRenderer {
        final RowHeaderCellComponentBase myTransposed;
        final RowHeaderCellComponentBase myRegular;

        MyRowHeaderCellRenderer(RowHeaderCellComponentBase transposed, RowHeaderCellComponentBase regular) {
            this.myTransposed = transposed;
            this.myRegular = regular;
        }

        @Override
        public Component getRendererComponent(int row, boolean forDisplay) {
            RowHeaderCellComponentBase c2 = TableResultRowHeader.this.isTransposed() ? this.myTransposed : this.myRegular;
            int li = this.isLeftSide() ? 1 : 0;
            int ri = 1 - li;
            c2.setBorder(BorderFactory.createCompoundBorder((Border)new CustomLineBorder(TableResultRowHeader.this.myTable.getGridColor(), 0, ri, 0, li), (Border)JBUI.Borders.empty((int)0, (int)8)));
            c2.setRow(row, forDisplay);
            return c2;
        }

        private boolean isLeftSide() {
            TableScrollPane parent2 = (TableScrollPane)((Object)ComponentUtil.getParentOfType(TableScrollPane.class, (Component)((Object)TableResultRowHeader.this.myTable)));
            return parent2 == null || !parent2.isFlipped();
        }
    }

    protected class ColumnInfoRowHeaderCellComponent
    extends RowHeaderCellComponentBase {
        private final JLabel myNameLabel;
        private final JLabel mySortLabel;

        public ColumnInfoRowHeaderCellComponent() {
            this.myNameLabel = new JBLabel();
            this.mySortLabel = new JBLabel();
            this.setLayout(new BorderLayout());
            this.myNameLabel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)CellRenderingUtils.NAME_LABEL_ROW_INSETS));
            this.mySortLabel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)CellRenderingUtils.SORT_LABEL_ROW_INSETS));
            this.mySortLabel.setVerticalAlignment(0);
            this.add(this.myNameLabel, "Center");
            this.add(this.mySortLabel, "East");
        }

        @Override
        public void setRow(int viewRowIdx, boolean forDisplay) {
            DasColumn databaseColumn;
            super.setRow(viewRowIdx, forDisplay);
            assert (TableResultRowHeader.this.isTransposed());
            ModelIndex<DataConsumer.Column> modelColumnIdx = ViewIndex.forColumn(TableResultRowHeader.this.myResultPanel, viewRowIdx).toModel(TableResultRowHeader.this.myResultPanel);
            DataConsumer.Column column = TableResultRowHeader.this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getColumn(modelColumnIdx);
            if (column == null) {
                return;
            }
            Font font = TableResultRowHeader.this.myTable.getTableHeader().getFont();
            Color fg = TableResultRowHeader.this.myTable.getForeground();
            this.myNameLabel.setFont(font);
            this.mySortLabel.setFont(font);
            this.myNameLabel.setForeground(fg);
            this.mySortLabel.setForeground(fg);
            TableResultPanel.ColumnAttributes columnAttributes = TableResultRowHeader.this.myResultPanel.getColumnAttributes();
            DasColumn dasColumn = databaseColumn = forDisplay ? DataGridUtil.getDatabaseColumn((DataGrid)TableResultRowHeader.this.myResultPanel, column) : null;
            Icon icon = !forDisplay ? DbPresentation.getIcon(ObjectKind.COLUMN) : (databaseColumn == null ? null : DbPresentation.getIcon((DasObject)databaseColumn));
            this.myNameLabel.setIcon(icon);
            this.myNameLabel.setText(columnAttributes.getName(column));
            this.mySortLabel.setText("");
            this.mySortLabel.setIcon(null);
            if (TableResultRowHeader.this.myResultPanel.isSortViaOrderBy() && columnAttributes.getComparator(column) != null) {
                int sortOrder = columnAttributes.getSortOrder(column);
                this.mySortLabel.setIcon(TableResultView.getSortOrderIcon(sortOrder));
                this.mySortLabel.setText(TableResultView.getSortOrderText(sortOrder));
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.drawEffects(g, TableResultView.getLabelTextRect(this.myNameLabel));
        }

        protected void drawEffects(Graphics g, Rectangle r) {
        }
    }

    protected class RowNumberRowHeaderCellComponent
    extends RowHeaderCellComponentBase {
        protected RowNumberRowHeaderCellComponent() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintLineNumber(g);
        }

        public Dimension getPreferredSize() {
            int preferredWidth = this.getPreferredWidth();
            return new Dimension(preferredWidth, TableResultRowHeader.this.myTable.getRowHeight(this.getRow()));
        }

        private int getPreferredWidth() {
            Insets insets = this.getInsets();
            return this.preferredWidthOf(this.getRowNumberString()) + (insets.right + insets.left);
        }

        private void paintLineNumber(Graphics g) {
            Font fontBackup = g.getFont();
            g.setFont(TableResultRowHeader.this.myTable.getFont());
            Insets insets = this.getInsets();
            int middleX = insets.left + (this.getWidth() - insets.left - insets.right) / 2;
            String rowNum = this.getRowNumberString();
            int stringWidth = g.getFontMetrics().stringWidth(rowNum);
            int baseline = this.getBaseline();
            g.drawString(rowNum, middleX - stringWidth / 2, baseline);
            FontMetrics metrics = TableResultRowHeader.this.myTable.getFontMetrics(TableResultRowHeader.this.myTable.getFont());
            int height = metrics.getAscent() - metrics.getDescent();
            this.drawEffects(g, new Rectangle(middleX - stringWidth / 2, baseline - height, stringWidth, height));
            g.setFont(fontBackup);
        }

        @NotNull
        private String getRowNumberString() {
            String string = DataGridUtil.getRowName(TableResultRowHeader.this.myResultPanel, this.getRow());
            if (string == null) {
                RowNumberRowHeaderCellComponent.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void drawEffects(Graphics g, Rectangle r) {
        }

        private int getBaseline() {
            return TableResultRowHeader.this.myTable.getTextLineHeight() - TableResultRowHeader.this.myTable.getFontMetrics(TableResultRowHeader.this.myTable.getFont()).getDescent();
        }

        private int preferredWidthOf(String text2) {
            return TableResultRowHeader.this.myTable.getFontMetrics(TableResultRowHeader.this.myTable.getFont()).stringWidth(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/table/TableResultRowHeader$RowNumberRowHeaderCellComponent", "getRowNumberString"));
        }
    }

    protected abstract class RowHeaderCellComponentBase
    extends CellRendererPanel {
        private int myRow;

        protected RowHeaderCellComponentBase() {
        }

        public void setRow(int row, boolean forDisplay) {
            this.myRow = row;
        }

        public int getRow() {
            return this.myRow;
        }

        public boolean isShowing() {
            return true;
        }

        protected void paintComponent(Graphics g) {
            this.paintBackground(g);
        }

        public Color getBackground() {
            return TableResultRowHeader.this.myTable.isTransposed() ? TableResultRowHeader.this.myResultPanel.getColorModel().getColumnHeaderBackground(this.getColumnModelIndex()) : TableResultRowHeader.this.myResultPanel.getColorModel().getRowHeaderBackground(this.getRowModelIndex());
        }

        public Color getForeground() {
            return TableResultRowHeader.this.myTable.getForeground();
        }

        private void paintBackground(Graphics g) {
            Color backup = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(backup);
        }

        @NotNull
        private ModelIndex<DataConsumer.Row> getRowModelIndex() {
            ModelIndex<DataConsumer.Row> modelIndex = ModelIndex.forRow(TableResultRowHeader.this.myResultPanel, TableResultRowHeader.this.myResultPanel.getRawIndexConverter().row2Model().fun(this.myRow));
            if (modelIndex == null) {
                RowHeaderCellComponentBase.$$$reportNull$$$0(0);
            }
            return modelIndex;
        }

        @NotNull
        private ModelIndex<DataConsumer.Column> getColumnModelIndex() {
            ModelIndex<DataConsumer.Column> modelIndex = ModelIndex.forColumn(TableResultRowHeader.this.myResultPanel, TableResultRowHeader.this.myResultPanel.getRawIndexConverter().row2Model().fun(this.myRow));
            if (modelIndex == null) {
                RowHeaderCellComponentBase.$$$reportNull$$$0(1);
            }
            return modelIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/run/ui/table/TableResultRowHeader$RowHeaderCellComponentBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRowModelIndex";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnModelIndex";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class GutterMouseListener
    extends PopupHandler {
        private boolean mySelectWhileDraggingInExclusiveMode;
        private int myResizingRow = -1;
        private boolean myResizingColumn = false;

        private GutterMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() % 2 == 0) {
                this.packRow(e);
                this.toggleColumnSorting(e);
            }
            super.mouseClicked(e);
        }

        public void invokePopup(Component comp, int x, int y) {
            if (TableResultRowHeader.this.rowForPoint(new Point(x, y)) < 0) {
                return;
            }
            ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("EditorPopup", TableResultRowHeader.this.myPopupActions);
            menu.getComponent().show(comp, x, y);
        }

        public void mouseMoved(MouseEvent e) {
            if (this.shouldResizeColumn(e)) {
                TableResultRowHeader.this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (this.shouldResizeRow(e)) {
                TableResultRowHeader.this.setCursor(Cursor.getPredefinedCursor(9));
            } else {
                TableResultRowHeader.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        private boolean shouldResizeRow(MouseEvent e) {
            return this.getRowToResize(e) != -1;
        }

        private boolean shouldResizeColumn(MouseEvent e) {
            return TableResultRowHeader.this.myTable.isTransposed() && e.getX() >= TableResultRowHeader.this.getWidth() - 5 && e.getX() <= TableResultRowHeader.this.getWidth();
        }

        public void mousePressed(MouseEvent e) {
            if (this.shouldResizeColumn(e)) {
                this.myResizingColumn = true;
            } else {
                int rowToResize = this.getRowToResize(e);
                if (rowToResize != -1) {
                    this.myResizingRow = rowToResize;
                } else {
                    TableResultRowHeader.this.myResultPanel.getAutoscrollLocker().runWithLock(() -> this.processSelectionEvent(e, false));
                }
            }
            super.mousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.myResizingRow = -1;
            this.myResizingColumn = false;
            super.mouseReleased(e);
        }

        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                GutterMouseListener.$$$reportNull$$$0(0);
            }
            if (this.myResizingColumn) {
                TableResultRowHeader.this.updatePreferredSize(e.getX(), true);
                TableResultRowHeader.this.revalidate();
                TableResultRowHeader.this.repaint();
            } else if (this.myResizingRow != -1) {
                int newRowHeight;
                Rectangle cellRect = TableResultRowHeader.this.myTable.getCellRect(this.myResizingRow, 0, true);
                int oldRowHeight = TableResultRowHeader.this.myTable.getRowHeight(this.myResizingRow);
                if (oldRowHeight != (newRowHeight = Math.max(TableResultRowHeader.this.myTable.getRowHeight(), e.getY() - cellRect.y))) {
                    TableResultRowHeader.this.myTable.setRowHeight(this.myResizingRow, newRowHeight);
                }
            } else {
                this.processSelectionEvent(e, true);
            }
        }

        private int getRowToResize(MouseEvent e) {
            int rowAtPoint = TableResultRowHeader.this.rowForPoint(e.getPoint());
            if (rowAtPoint == -1) {
                return -1;
            }
            Rectangle cellRect = TableResultRowHeader.this.myTable.getCellRect(rowAtPoint, 0, true);
            int yInCellRect = e.getY() - cellRect.y;
            return yInCellRect < 4 ? (rowAtPoint == 0 ? -1 : rowAtPoint - 1) : (yInCellRect > cellRect.height - 4 ? rowAtPoint : -1);
        }

        private void processSelectionEvent(MouseEvent e, boolean isDragEvent) {
            int currentRow = TableResultRowHeader.this.rowForPoint(e.getPoint());
            if (currentRow == -1) {
                e.consume();
                return;
            }
            if (!TableResultRowHeader.this.myTable.hasFocus()) {
                IdeFocusManager.getInstance((Project)TableResultRowHeader.this.myResultPanel.getProject()).requestFocus((Component)((Object)TableResultRowHeader.this.myTable), true);
            }
            boolean selected = this.processSelectionEventInternal(e, isDragEvent, currentRow);
            TableResultRowHeader.this.myResultPanel.getHiddenColumnSelectionHolder().setWholeRowSelected(!TableResultRowHeader.this.isTransposed() && selected);
            e.consume();
        }

        private boolean processSelectionEventInternal(MouseEvent e, boolean isDragEvent, int currentRow) {
            boolean interval = DbUIUtil.isIntervalModifierSet(e);
            boolean exclusive = DbUIUtil.isExclusiveModifierSet(e);
            TableSelectionModel selectionModel = (TableSelectionModel)ObjectUtils.tryCast(SelectionModel.get(TableResultRowHeader.this.myResultPanel, TableResultRowHeader.this.myTable), TableSelectionModel.class);
            if (selectionModel == null) {
                return false;
            }
            if (interval) {
                int lead = TableResultRowHeader.this.myTable.getSelectionModel().getLeadSelectionIndex();
                if (exclusive) {
                    selectionModel.addRowSelectionInterval(currentRow, lead);
                    selectionModel.addColumnSelectionInterval(TableResultRowHeader.this.myTable.getColumnCount() - 1, 0);
                } else {
                    selectionModel.setRowSelectionInterval(currentRow, lead);
                    selectionModel.setColumnSelectionInterval(TableResultRowHeader.this.myTable.getColumnCount() - 1, 0);
                }
                return true;
            }
            if (exclusive) {
                if (!isDragEvent) {
                    boolean bl = this.mySelectWhileDraggingInExclusiveMode = !TableResultRowHeader.this.myTable.isRowSelected(currentRow) || TableResultRowHeader.this.myTable.getSelectedColumnCount() != TableResultRowHeader.this.myTable.getColumnCount();
                }
                if (this.mySelectWhileDraggingInExclusiveMode) {
                    selectionModel.addRowSelection(ModelIndexSet.forRows(TableResultRowHeader.this.myResultPanel, currentRow));
                    selectionModel.addColumnSelectionInterval(TableResultRowHeader.this.myTable.getColumnCount() - 1, 0);
                } else {
                    TableResultRowHeader.this.myTable.removeRowSelectionInterval(currentRow, currentRow);
                }
                return this.mySelectWhileDraggingInExclusiveMode;
            }
            int lead = isDragEvent ? TableResultRowHeader.this.myTable.getSelectionModel().getLeadSelectionIndex() : currentRow;
            selectionModel.setRowSelectionInterval(currentRow, lead);
            selectionModel.setColumnSelectionInterval(TableResultRowHeader.this.myTable.getColumnCount() - 1, 0);
            return true;
        }

        private void toggleColumnSorting(MouseEvent e) {
            if (!e.isConsumed() && TableResultRowHeader.this.isTransposed() && TableResultRowHeader.this.myResultPanel.isSortViaOrderBy()) {
                ViewIndex<DataConsumer.Column> viewIndex = ViewIndex.forColumn(TableResultRowHeader.this.myResultPanel, TableResultRowHeader.this.rowForPoint(e.getPoint()));
                TableResultRowHeader.this.myResultPanel.changeSortOrder(viewIndex.toModel(TableResultRowHeader.this.myResultPanel), null, false);
                e.consume();
            }
        }

        private void packRow(MouseEvent e) {
            int rowToResize = this.getRowToResize(e);
            if (e.isConsumed() || rowToResize == -1) {
                return;
            }
            int expandedHeight = this.getExpandedRowHeight(rowToResize);
            int newHeight = TableResultRowHeader.this.myTable.getRowHeight(rowToResize) >= expandedHeight ? TableResultRowHeader.this.myTable.getRowHeight() : expandedHeight;
            TableResultRowHeader.this.myTable.setRowHeight(rowToResize, newHeight);
        }

        private int getExpandedRowHeight(int row) {
            int expandedHeight = TableResultRowHeader.this.myTable.getRowHeight();
            for (int column = 0; column < TableResultRowHeader.this.myTable.getColumnCount(); ++column) {
                TableCellRenderer renderer = TableResultRowHeader.this.myTable.getCellRenderer(row, column);
                if (renderer == null) continue;
                Component c2 = TableResultRowHeader.this.myTable.prepareRenderer(renderer, row, column);
                expandedHeight = Math.max(expandedHeight, c2.getPreferredSize().height);
            }
            return expandedHeight;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/table/TableResultRowHeader$GutterMouseListener", "mouseDragged"));
        }
    }
}

