/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.ResultViewFactory;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactories;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.run.ui.table.TableScrollPane;
import com.intellij.database.run.ui.table.TableSelectionModel;
import com.intellij.database.util.DbUIUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBViewport;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class TableResultViewFactory
implements ResultViewFactory {
    public static final TableResultViewFactory TABLE_FACTORY = new TableResultViewFactory();

    @Override
    @NotNull
    public ResultView createResultView(final @NotNull TableResultPanel resultPanel) {
        if (resultPanel == null) {
            TableResultViewFactory.$$$reportNull$$$0(0);
        }
        final TableResultView table = new TableResultView(resultPanel, (GridCellEditorFactoryProvider)ObjectUtils.notNull((Object)resultPanel.getCellEditorFactoryProvider(), (Object)GridCellEditorFactories.getInstance()), resultPanel.getColumnHeaderActions(), resultPanel.getRowHeaderActions());
        table.getEmptyText().setText("");
        table.setSelectionMode(2);
        table.setCellSelectionEnabled(true);
        table.setAutoResizeMode(0);
        table.setBackground(resultPanel.getColorsScheme().getDefaultBackground());
        table.setShowGrid(true);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    int columnIndex;
                    int rowIndex = table.isTransposed() ? table.columnAtPoint(e.getPoint()) : table.rowAtPoint(e.getPoint());
                    int n = columnIndex = table.isTransposed() ? table.rowAtPoint(e.getPoint()) : table.columnAtPoint(e.getPoint());
                    if (rowIndex >= 0 && columnIndex >= 0 && !table.isCellSelected(rowIndex, columnIndex)) {
                        int modelRow = table.getRawIndexConverter().row2Model().fun(rowIndex);
                        int modelColumn = table.getRawIndexConverter().column2Model().fun(columnIndex);
                        SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = resultPanel.getSelectionModel();
                        selectionModel.setSelection(ModelIndexSet.forRows(resultPanel, modelRow), ModelIndexSet.forColumns(resultPanel, modelColumn));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/table/TableResultViewFactory$1", "mousePressed"));
            }
        });
        TableResultView tableResultView = table;
        if (tableResultView == null) {
            TableResultViewFactory.$$$reportNull$$$0(1);
        }
        return tableResultView;
    }

    @Override
    @NotNull
    public JComponent wrap(final @NotNull TableResultPanel grid, @NotNull ResultView resultView) {
        if (grid == null) {
            TableResultViewFactory.$$$reportNull$$$0(2);
        }
        if (resultView == null) {
            TableResultViewFactory.$$$reportNull$$$0(3);
        }
        final TableResultView table = (TableResultView)resultView;
        MyCornerToolsComponent cornerComponent = new MyCornerToolsComponent(grid.getProject()){

            @Override
            TableResultView getTable() {
                return table;
            }

            @Override
            TableResultPanel getGrid() {
                return grid;
            }
        };
        TableScrollPane scrollPane = new TableScrollPane(table, grid, (JComponent)((Object)cornerComponent), grid.getAutoscrollLocker()){

            protected void processMouseWheelEvent(MouseWheelEvent e) {
                if (EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled() && !MouseGestureManager.getInstance().hasTrackpad() && EditorUtil.isChangeFontSize((MouseWheelEvent)e)) {
                    int rotation = e.getWheelRotation();
                    if (rotation != 0) {
                        table.changeFontSize(-rotation, 1.0);
                    }
                    return;
                }
                super.processMouseWheelEvent(e);
            }

            public void paint(Graphics g) {
                table.startPaintingSession();
                try {
                    super.paint(g);
                }
                finally {
                    table.endPaintingSession();
                }
            }
        };
        table.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                grid.getHiddenColumnSelectionHolder().setWholeRowSelected(false);
                DataGridUtil.updateWidgets(grid);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/table/TableResultViewFactory$4", "valueChanged"));
            }
        });
        TableScrollPane tableScrollPane = scrollPane;
        if (tableScrollPane == null) {
            TableResultViewFactory.$$$reportNull$$$0(4);
        }
        return tableScrollPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/table/TableResultViewFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/table/TableResultViewFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createResultView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createResultView";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class MyCornerToolsComponent
    extends JBViewport {
        MyCornerToolsComponent(@NotNull Project project) {
            if (project == null) {
                MyCornerToolsComponent.$$$reportNull$$$0(0);
            }
            EditorHeaderComponent view2 = new EditorHeaderComponent(){

                public void uiSettingsChanged(@NotNull UISettings uiSettings) {
                    if (uiSettings == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiSettings", "com/intellij/database/run/ui/table/TableResultViewFactory$MyCornerToolsComponent$1", "uiSettingsChanged"));
                }
            };
            view2.setOpaque(false);
            this.add((Component)view2);
            DumbAwareAction action2 = DumbAwareAction.create(e -> {
                this.selectAll();
                if (!this.getTable().hasFocus()) {
                    IdeFocusManager.getInstance((Project)project).requestFocus((Component)((Object)this.getTable()), true);
                }
            });
            action2.getTemplatePresentation().setText("Select All");
            ActionButton button = new ActionButton((AnAction)action2, action2.getTemplatePresentation(), "", (Dimension)JBUI.emptySize());
            view2.add((Component)button, (Object)"Center");
            view2.setBorder((Border)new CustomLineBorder(null, 0, 0, 1, 1){

                protected Color getColor() {
                    return this.getTable().getGridColor();
                }
            });
        }

        abstract TableResultView getTable();

        abstract TableResultPanel getGrid();

        public Color getBackground() {
            return DbUIUtil.softHighlightOf(this.getTable().getBackground());
        }

        void selectAll() {
            boolean deselect;
            ListSelectionModel rowModel = this.getTable().getSelectionModel();
            int r0 = rowModel.getMinSelectionIndex();
            int r1 = rowModel.getMaxSelectionIndex();
            ListSelectionModel columnModel = this.getTable().getColumnModel().getSelectionModel();
            int c0 = columnModel.getMinSelectionIndex();
            int c1 = columnModel.getMaxSelectionIndex();
            boolean bl = deselect = r1 - r0 + 1 == this.getTable().getRowCount() && c1 - c0 + 1 == this.getTable().getColumnCount();
            if (deselect) {
                this.getTable().clearSelection();
            } else {
                this.getGrid().getAutoscrollLocker().runWithLock(() -> {
                    TableSelectionModel model = (TableSelectionModel)ObjectUtils.tryCast(SelectionModel.get(this.getGrid(), this.getTable()), TableSelectionModel.class);
                    if (model != null) {
                        model.setRowSelectionInterval(0, this.getTable().getRowCount());
                        model.setColumnSelectionInterval(0, this.getTable().getColumnCount());
                    }
                });
            }
            this.getGrid().getHiddenColumnSelectionHolder().setWholeRowSelected(!deselect);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/table/TableResultViewFactory$MyCornerToolsComponent", "<init>"));
        }
    }
}

