/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverListener;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DriverClasspathPanel
implements Disposable {
    @NotNull
    private final Project myProject;
    @Nullable
    private final LocalDataSource myDataSource;
    private final Configurable myConfigurable;
    @NotNull
    private DatabaseDriver myDriver;
    @NotNull
    private final DatabaseConfigEditor myController;
    private TableView<ClassPathItem> myArtifactList;
    private MyUserActivityPanel myArtifactsPanel;
    private Runnable onUpdate;
    private ListTableModel<ClassPathItem> myArtifactsModel;

    public DriverClasspathPanel(@NotNull Project project, @NotNull Configurable configurable, @NotNull DatabaseDriver driver, @Nullable LocalDataSource dataSource2, @NotNull DatabaseConfigEditor controller) {
        if (project == null) {
            DriverClasspathPanel.$$$reportNull$$$0(0);
        }
        if (configurable == null) {
            DriverClasspathPanel.$$$reportNull$$$0(1);
        }
        if (driver == null) {
            DriverClasspathPanel.$$$reportNull$$$0(2);
        }
        if (controller == null) {
            DriverClasspathPanel.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myConfigurable = configurable;
        this.myDriver = driver;
        this.myDataSource = dataSource2;
        this.myController = controller;
        DatabaseDriverManager.getInstance().addDriverListener(new DatabaseDriverListener.Adapter(){

            @Override
            public void driverUpdated(DatabaseDriver driver) {
                if (driver == DriverClasspathPanel.this.myDriver) {
                    DriverClasspathPanel.this.updateClasspath();
                    DriverClasspathPanel.this.providedChanged();
                    DriverClasspathPanel.this.fireUserActivity();
                }
            }
        }, this);
    }

    private void providedChanged() {
        int i2 = this.myArtifactsModel.indexOf((Object)this.getProvided());
        if (i2 == -1) {
            this.myArtifactsModel.fireTableDataChanged();
        } else {
            this.myArtifactsModel.fireTableRowsUpdated(i2, i2);
        }
    }

    public void dispose() {
    }

    private void fireUserActivity() {
        ((ChangeListener)this.myArtifactsPanel.myDispatcher.getMulticaster()).stateChanged(this.myArtifactsPanel.myEvent);
    }

    public void setDriver(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            DriverClasspathPanel.$$$reportNull$$$0(4);
        }
        this.myDriver = driver;
        this.updateClasspath();
        this.providedChanged();
    }

    public void setOnUpdate(Runnable onUpdate) {
        this.onUpdate = onUpdate;
    }

    public JComponent createComponent() {
        this.myArtifactsPanel = new MyUserActivityPanel();
        this.myArtifactsPanel.setLayout(new BorderLayout());
        this.myArtifactsModel = new ListTableModel((ColumnInfo[])ContainerUtil.ar((Object[])new 2[]{new ColumnInfo<ClassPathItem, ClassPathItem>(""){
            private final MyProvidedEditor myProvidedEditor;
            private final MyProvidedRenderer myProvidedRenderer;
            private final TableCellRenderer mySimpleRenderer;
            {
                this.myProvidedEditor = new MyProvidedEditor();
                this.myProvidedRenderer = new MyProvidedRenderer();
                this.mySimpleRenderer = new MySimpleRenderer();
            }

            @Nullable
            public ClassPathItem valueOf(ClassPathItem o) {
                return o;
            }

            public boolean isCellEditable(ClassPathItem item) {
                return this.isProvided(item);
            }

            private boolean isProvided(ClassPathItem item) {
                return item instanceof ProvidedItem;
            }

            @NotNull
            public TableCellRenderer getRenderer(ClassPathItem item) {
                TableCellRenderer tableCellRenderer = this.isProvided(item) ? this.myProvidedRenderer : this.mySimpleRenderer;
                if (tableCellRenderer == null) {
                    2.$$$reportNull$$$0(0);
                }
                return tableCellRenderer;
            }

            @Nullable
            public TableCellEditor getEditor(ClassPathItem item) {
                return this.isProvided(item) ? this.myProvidedEditor : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DriverClasspathPanel$2", "getRenderer"));
            }
        }}));
        this.myArtifactsModel.addTableModelListener(e -> this.onUpdateClasspath());
        this.myArtifactList = new TableView<ClassPathItem>(this.myArtifactsModel){

            public String getToolTipText(@NotNull MouseEvent event) {
                int row;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                ProvidedItem item = (row = this.rowAtPoint(event.getPoint())) == -1 ? null : (ProvidedItem)ObjectUtils.tryCast((Object)DriverClasspathPanel.this.myArtifactsModel.getItem(row), ProvidedItem.class);
                return item == null ? null : item.getToolTipText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/view/ui/DriverClasspathPanel$3", "getToolTipText"));
            }
        };
        this.myArtifactList.setTableHeader(null);
        this.myArtifactList.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DriverClasspathPanel.this.myArtifactList.repaint();
            }
        });
        this.myArtifactList.setShowGrid(false);
        this.myArtifactList.getEmptyText().setText("No driver files");
        this.myArtifactList.setVisibleRowCount(5);
        JPanel artifactsListPanel = ToolbarDecorator.createDecorator(this.myArtifactList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Boolean>(null, new Boolean[]{true, false}){

                    @NotNull
                    public String getTextFor(Boolean value2) {
                        return Boolean.TRUE.equals(value2) ? "Custom JARs..." : "Provided Driver";
                    }

                    public boolean hasSubstep(Boolean selectedValue) {
                        return Boolean.FALSE.equals(selectedValue);
                    }

                    public Icon getIconFor(Boolean value2) {
                        return Boolean.TRUE.equals(value2) ? AllIcons.FileTypes.Archive : AllIcons.Nodes.PpLib;
                    }

                    public PopupStep onChosen(Boolean selectedValue, boolean finalChoice) {
                        if (selectedValue == null) {
                            return FINAL_CHOICE;
                        }
                        if (!selectedValue.booleanValue()) {
                            return new ArtifactsPopupStep();
                        }
                        this.doFinalStep(() -> DriverClasspathPanel.this.addCustomDrivers());
                        return FINAL_CHOICE;
                    }
                });
                RelativePoint pref = button.getPreferredPopupPoint();
                if (pref != null) {
                    popup.show(pref);
                } else {
                    popup.showInBestPositionFor(button.getDataContext());
                }
            }
        }).disableUpDownActions().createPanel();
        DatabaseArtifactManager.getInstance().addListener((name, version) -> {
            ProvidedItem provided = this.getProvided();
            if (provided == null || name != null && (!Comparing.equal((String)name, (String)provided.getVersionDependentName()) || !Comparing.equal((String)version, (String)provided.version))) {
                return;
            }
            this.onUpdateClasspath();
            this.providedChanged();
        }, this);
        this.myArtifactsPanel.add((Component)new TitledSeparator("Driver files"), "North");
        this.myArtifactsPanel.add(artifactsListPanel);
        return this.myArtifactsPanel;
    }

    private void downloadImpl(final @NotNull String name, final @NotNull String version) {
        if (name == null) {
            DriverClasspathPanel.$$$reportNull$$$0(5);
        }
        if (version == null) {
            DriverClasspathPanel.$$$reportNull$$$0(6);
        }
        new Task.Backgroundable(this.myProject, "Downloading " + name, true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                DatabaseArtifactManager.DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
                try {
                    Consumer uiUpdate = version -> {
                        ProvidedItem provided = DriverClasspathPanel.this.getProvided();
                        if (provided != null) {
                            provided.update(provided.artifact, (String)version, provided.rolling, provided.legacy);
                        }
                        DriverClasspathPanel.this.providedChanged();
                        DriverClasspathPanel.this.onUpdateClasspath();
                        DriverClasspathPanel.this.fireUserActivity();
                    };
                    if (artifacts.isValid(name, version)) {
                        ApplicationManager.getApplication().invokeLater(() -> uiUpdate.consume((Object)version));
                    } else {
                        DatabaseArtifactManager.getInstance().downloadArtifact(name, version, (Consumer<? super DownloadableFileSetDescription>)((Consumer)o -> uiUpdate.consume((Object)o.getVersionString())));
                    }
                }
                catch (IOException e) {
                    ApplicationManager.getApplication().invokeLater(() -> DriverClasspathPanel.this.myController.showErrorNotification(DriverClasspathPanel.this.myConfigurable, (Object)this, e));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DriverClasspathPanel$6", "run"));
            }
        }.queue();
    }

    private void doChooseFiles(@NotNull Consumer<? super List<VirtualFile>> consumer2) {
        if (consumer2 == null) {
            DriverClasspathPanel.$$$reportNull$$$0(7);
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && file.isDirectory() || FileTypeRegistry.getInstance().isFileOfType(file, (FileType)ArchiveFileType.INSTANCE);
            }
        };
        descriptor.setTitle("Select Database Driver Files");
        File dir = new File(DatabaseDriverImpl.getDownloadPath());
        try {
            FileUtil.ensureExists((File)dir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        VirtualFile toSelect = VfsUtil.findFileByIoFile((File)dir, (boolean)true);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, (Component)this.myArtifactsPanel, (VirtualFile)toSelect, consumer2);
    }

    public void updateClasspath() {
        ArrayList<ClassPathItem> items = new ArrayList<ClassPathItem>();
        if (this.myDataSource != null) {
            if (this.myArtifactsModel.getRowCount() == 0) {
                for (SimpleClasspathElement cp : this.myDataSource.getOwnClasspath()) {
                    items.add(new SimpleItem(cp));
                }
            } else {
                items.addAll(this.myArtifactsModel.getItems());
            }
        } else {
            DatabaseDriver.ArtifactRef artifact = this.myDriver.getArtifact();
            if (artifact != null && artifact.isUsed()) {
                DatabaseArtifactManager.CompositeArtifact composite = DatabaseArtifactManager.getArtifacts().getCompositeArtifact(artifact.getName());
                List<SimpleClasspathElement> cp = ((DatabaseDriverImpl)this.myDriver).getArtifactClasspathElements();
                items.add(new ProvidedItem(composite.coupleWith(this.myDriver), artifact.getVersion(), artifact.isRolling(), cp));
            }
            for (SimpleClasspathElement element2 : this.myDriver.getAdditionalClasspathElements()) {
                items.add(new SimpleItem(element2));
            }
        }
        this.myArtifactsModel.setItems(items);
        this.onUpdateClasspath();
    }

    private void onUpdateClasspath() {
        if (this.onUpdate != null) {
            this.onUpdate.run();
        }
    }

    public List<SimpleClasspathElement> getClasspath() {
        TableModel artifactListModel = this.myArtifactList.getModel();
        ArrayList<SimpleClasspathElement> fileList = new ArrayList<SimpleClasspathElement>();
        for (int i2 = 0; i2 < artifactListModel.getRowCount(); ++i2) {
            SimpleItem item = (SimpleItem)ObjectUtils.tryCast((Object)artifactListModel.getValueAt(i2, 0), SimpleItem.class);
            if (item == null) continue;
            fileList.add(item.element);
        }
        return fileList;
    }

    public List<SimpleClasspathElement> getClasspathFull() {
        List<SimpleClasspathElement> classpath = this.getClasspath();
        ProvidedItem provided = this.getProvided();
        if (provided != null) {
            if (provided.version == null) {
                classpath.addAll(provided.legacy);
            } else {
                String name = provided.getVersionDependentName();
                classpath.addAll(DatabaseArtifactManager.getClasspathElements(name, provided.version));
            }
        }
        return classpath;
    }

    @Nullable
    public String getArtifactName() {
        ProvidedItem provided = this.getProvided();
        if (provided == null) {
            DatabaseDriver.ArtifactRef artifact = this.myDriver.getArtifact();
            return artifact == null ? null : artifact.getName();
        }
        return provided.getVersionDependentName();
    }

    @Nullable
    public String getArtifactVersion() {
        ProvidedItem provided = this.getProvided();
        if (provided != null) {
            return provided.version;
        }
        DatabaseDriver.ArtifactRef artifact = this.myDriver.getArtifact();
        return artifact == null ? null : artifact.getVersion();
    }

    public boolean isUseArtifact() {
        ProvidedItem provided = this.getProvided();
        return provided != null;
    }

    public boolean isRolling() {
        ProvidedItem provided = this.getProvided();
        if (provided != null) {
            return provided.rolling;
        }
        DatabaseDriver.ArtifactRef artifact = this.myDriver.getArtifact();
        return artifact != null && artifact.isRolling();
    }

    @Nullable
    private ProvidedItem getProvided() {
        return (ProvidedItem)JBIterable.from((Iterable)this.myArtifactList.getItems()).filter(ProvidedItem.class).first();
    }

    private void addCustomDrivers() {
        this.doChooseFiles((Consumer<? super List<VirtualFile>>)((Consumer)files -> {
            for (VirtualFile file : files) {
                for (SimpleClasspathElement cpe : SimpleClasspathElementFactory.createElements((String[])new String[]{file.getUrl()})) {
                    this.myArtifactsModel.addRow((Object)new SimpleItem(cpe));
                }
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/view/ui/DriverClasspathPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setDriver";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doChooseFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VersionsPopupStep
    extends BaseListPopupStep<DatabaseArtifactManager.ArtifactVersion> {
        VersionsPopupStep(@NotNull DatabaseArtifactManager.ArtifactWithDriver artifact) {
            if (artifact == null) {
                VersionsPopupStep.$$$reportNull$$$0(0);
            }
            super(null, artifact.getVersions());
        }

        @NotNull
        public String getTextFor(DatabaseArtifactManager.ArtifactVersion value2) {
            String string = value2.displayText();
            if (string == null) {
                VersionsPopupStep.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DriverClasspathPanel$VersionsPopupStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DriverClasspathPanel$VersionsPopupStep";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ArtifactsPopupStep
    extends BaseListPopupStep<DatabaseArtifactManager.CompositeArtifact> {
        private final DatabaseArtifactManager.CompositeArtifact myPredef;

        ArtifactsPopupStep() {
            super(null, (Object[])new DatabaseArtifactManager.CompositeArtifact[0]);
            this.getValues().addAll(DatabaseArtifactManager.getArtifacts().getCompositeArtifacts());
            this.getValues().sort((s1, s2) -> StringUtil.naturalCompare((String)s1.getName(), (String)s2.getName()));
            String predefined = DatabaseDriverManager.getInstance().getPredefinedArtifact(DriverClasspathPanel.this.myDriver.getId());
            DatabaseArtifactManager.CompositeArtifact compositeDriverArtifact = predefined == null ? null : DatabaseArtifactManager.getArtifacts().getCompositeArtifact(predefined);
            DatabaseArtifactManager.CompositeArtifact compositeArtifact = this.myPredef = compositeDriverArtifact == null ? null : compositeDriverArtifact.findSelfIn(this.getValues());
            if (this.myPredef != null) {
                this.getValues().remove(this.myPredef);
                this.getValues().add(0, this.myPredef);
            }
        }

        @Nullable
        public ListSeparator getSeparatorAbove(DatabaseArtifactManager.CompositeArtifact value2) {
            List values2 = this.getValues();
            return this.myPredef != null && values2.size() > 1 && Comparing.equal((Object)value2, values2.get(1)) ? new ListSeparator() : null;
        }

        public boolean hasSubstep(DatabaseArtifactManager.CompositeArtifact selectedValue) {
            return true;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        @NotNull
        public String getTextFor(DatabaseArtifactManager.CompositeArtifact value2) {
            String string = value2.getName();
            if (string == null) {
                ArtifactsPopupStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public PopupStep onChosen(DatabaseArtifactManager.CompositeArtifact artifact, boolean finalChoice) {
            if (artifact == null) {
                return FINAL_CHOICE;
            }
            return new VersionsPopupStep(artifact.coupleWith(DriverClasspathPanel.this.myDriver)){

                public PopupStep onChosen(DatabaseArtifactManager.ArtifactVersion v, boolean finalChoice) {
                    if (v == null) {
                        return FINAL_CHOICE;
                    }
                    boolean rolling = v.isLatest();
                    DriverClasspathPanel.this.fireUserActivity();
                    ProvidedItem provided = DriverClasspathPanel.this.getProvided();
                    String version = v.getExactVersion();
                    DatabaseArtifactManager.ArtifactWithDriver pair = v.getArtifact().coupleWith(DriverClasspathPanel.this.myDriver);
                    if (provided != null) {
                        provided.update(pair, version, rolling, null);
                    } else {
                        provided = new ProvidedItem(pair, version, rolling, null);
                        DriverClasspathPanel.this.myArtifactsModel.addRow((Object)provided);
                    }
                    if (version != null) {
                        DriverClasspathPanel.this.downloadImpl(provided.getVersionDependentName(), version);
                    }
                    return FINAL_CHOICE;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DriverClasspathPanel$ArtifactsPopupStep", "getTextFor"));
        }
    }

    private class MyProvidedRenderer
    implements TableCellRenderer {
        private final JComponent myComponent = new Box(0){

            @Override
            public void validate() {
                this.sendMouseMove(MyProvidedRenderer.this.myVersionLink);
                this.sendMouseMove(MyProvidedRenderer.this.myFixLink);
                this.sendMouseMove(MyProvidedRenderer.this.myLicenseLink);
                super.validate();
            }

            private void sendMouseMove(LinkLabel<?> link) {
                Point pos = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(pos, link);
                MouseEvent e = new MouseEvent((Component)link, 503, System.currentTimeMillis(), 0, pos.x, pos.y, 0, false);
                link.dispatchEvent((AWTEvent)e);
            }
        };
        private final SimpleColoredRenderer myColored = new SimpleColoredRenderer();
        private final LinkLabel<ProvidedItem> myVersionLink = new MyLinkLabel<ProvidedItem>("ver.");
        private final LinkLabel<ProvidedItem> myFixLink = new MyLinkLabel<ProvidedItem>("");
        private final LinkLabel<ProvidedItem> myLicenseLink = new MyLinkLabel<ProvidedItem>("Show License");
        private boolean mySelected;

        private MyProvidedRenderer() {
            this.myComponent.setOpaque(true);
            this.myComponent.add((Component)this.myColored);
            this.myComponent.add(Box.createHorizontalStrut(10));
            this.myComponent.add((Component)this.myVersionLink);
            this.myComponent.add(Box.createHorizontalGlue());
            this.myComponent.add((Component)this.myFixLink);
            this.myComponent.add(Box.createHorizontalStrut(20));
            this.myComponent.add((Component)this.myLicenseLink);
            this.myComponent.add(Box.createHorizontalStrut(10));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            this.mySelected = isSelected;
            this.myColored.clear();
            this.myColored.acquireState(table, isSelected, false, row, column);
            this.myColored.getCellState().updateRenderer(this.myComponent);
            ProvidedItem item = (ProvidedItem)ObjectUtils.tryCast((Object)value2, ProvidedItem.class);
            if (item != null) {
                this.myColored.append(item.artifact.composite().getName(), item.invalid ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.myColored.setIcon(PlatformIcons.LIBRARY_ICON);
                this.myVersionLink.setVisible(item.version != null);
                this.myVersionLink.setText("ver. " + item.version + (item.rolling ? " [latest]" : ""));
                this.myVersionLink.setListener(this::switchVersion, (Object)item);
                String actual = item.artifact.latestVersion();
                this.myFixLink.setVisible(item.artifact.latestVersion() != null && (item.invalid || item.needUpdate));
                this.myFixLink.setText((item.actualDownloaded ? "Switch to" : "Download") + " ver. " + actual);
                this.myFixLink.setListener(this::fixArtifact, (Object)item);
                this.myLicenseLink.setVisible(item.version != null);
                this.myLicenseLink.setListener(this::showLicense, (Object)item);
            }
            this.myColored.setMaximumSize(this.myColored.getPreferredSize());
            return this.myComponent;
        }

        private void switchVersion(LinkLabel label, final ProvidedItem item) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new VersionsPopupStep(item.artifact){

                public PopupStep onChosen(DatabaseArtifactManager.ArtifactVersion selectedValue, boolean finalChoice) {
                    if (selectedValue != null) {
                        boolean rolling = selectedValue.isLatest();
                        String version = selectedValue.getExactVersion();
                        item.update(selectedValue.getArtifact().coupleWith(DriverClasspathPanel.this.myDriver), version, rolling, null);
                        if (version != null) {
                            DriverClasspathPanel.this.downloadImpl(selectedValue.getExactName(), version);
                        }
                        DriverClasspathPanel.this.fireUserActivity();
                    }
                    return FINAL_CHOICE;
                }
            }).show(RelativePoint.getSouthWestOf((JComponent)label));
        }

        private void fixArtifact(LinkLabel label, ProvidedItem item) {
            String name;
            String version = item.rolling || item.version == null ? item.artifact.latestVersion() : item.version;
            String string = name = version == null ? null : item.artifact.composite().getNameAt(version);
            if (name != null) {
                DriverClasspathPanel.this.downloadImpl(name, version);
            }
        }

        private void showLicense(LinkLabel<ProvidedItem> label, ProvidedItem o) {
            JBIterable.from(o.version == null ? null : DatabaseArtifactManager.getClasspathElements(o.getVersionDependentName(), o.version)).flatMap(SimpleClasspathElement::getClassesRootUrls).filter(e -> StringUtil.endsWithIgnoreCase((String)e, (String)"-license.txt") || StringUtil.endsWithIgnoreCase((String)e, (String)"-agreement.txt") || StringUtil.endsWithIgnoreCase((String)e, (String)"/COPYING") || StringUtil.endsWithIgnoreCase((String)e, (String)"/LICENSE")).forEach(l -> BrowserUtil.browse((String)l, (Project)DriverClasspathPanel.this.myProject));
        }

        private class MyLinkLabel<T>
        extends LinkLabel<T> {
            MyLinkLabel(String text2) {
                super(text2, null);
            }

            protected Color getNormal() {
                return MyProvidedRenderer.this.mySelected ? UIUtil.getListForeground((boolean)true, (boolean)true) : super.getNormal();
            }

            protected Color getHover() {
                return MyProvidedRenderer.this.mySelected ? UIUtil.getListForeground((boolean)true, (boolean)true) : super.getHover();
            }
        }
    }

    private class MyProvidedEditor
    extends AbstractTableCellEditor {
        private final MyProvidedRenderer myDelegate;
        Object v;

        private MyProvidedEditor() {
            this.myDelegate = new MyProvidedRenderer();
            this.v = null;
        }

        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
            this.v = value2;
            return this.myDelegate.getTableCellRendererComponent(table, value2, isSelected, true, row, column);
        }

        public Object getCellEditorValue() {
            return this.v;
        }

        public void cancelCellEditing() {
            super.cancelCellEditing();
        }
    }

    private static class MySimpleRenderer
    implements TableCellRenderer {
        SimpleColoredRenderer myComponent = new SimpleColoredRenderer();

        private MySimpleRenderer() {
            this.myComponent.setTransparentIconBackground(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myComponent.clear();
            this.myComponent.acquireState(table, isSelected, false, row, column);
            this.myComponent.getCellState().updateRenderer((JComponent)this.myComponent);
            SimpleItem item = (SimpleItem)ObjectUtils.tryCast((Object)value2, SimpleItem.class);
            if (item != null) {
                SimpleTextAttributes style = item.file != null && item.file.exists() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES;
                this.myComponent.append(item.file != null ? item.file.getPath() : item.element.getPresentableName(), style);
                if (item.file != null) {
                    this.myComponent.setIcon(!item.file.exists() ? PlatformIcons.FILE_ICON : (item.file.isDirectory() ? PlatformIcons.FOLDER_ICON : FileTypeManager.getInstance().getFileTypeByExtension(FileUtilRt.getExtension((String)item.file.getName())).getIcon()));
                } else {
                    this.myComponent.setIcon(PlatformIcons.LIBRARY_ICON);
                }
            }
            return this.myComponent;
        }
    }

    private static class MyUserActivityPanel
    extends JPanel
    implements UserActivityProviderComponent {
        private final EventDispatcher<ChangeListener> myDispatcher = EventDispatcher.create(ChangeListener.class);
        private final ChangeEvent myEvent = new ChangeEvent(this);

        private MyUserActivityPanel() {
        }

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyUserActivityPanel.$$$reportNull$$$0(0);
            }
            this.myDispatcher.addListener((EventListener)changeListener);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyUserActivityPanel.$$$reportNull$$$0(1);
            }
            this.myDispatcher.removeListener((EventListener)changeListener);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "changeListener";
            objectArray2[1] = "com/intellij/database/view/ui/DriverClasspathPanel$MyUserActivityPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProvidedItem
    implements ClassPathItem {
        private DatabaseArtifactManager.ArtifactWithDriver artifact;
        private String version;
        private List<SimpleClasspathElement> legacy;
        private boolean rolling;
        boolean actualDownloaded;
        boolean invalid;
        boolean needUpdate;

        ProvidedItem(@NotNull DatabaseArtifactManager.ArtifactWithDriver artifact, @Nullable String version, boolean rolling, @Nullable List<SimpleClasspathElement> legacy) {
            if (artifact == null) {
                ProvidedItem.$$$reportNull$$$0(0);
            }
            this.update(artifact, version, rolling, legacy);
        }

        void update(@NotNull DatabaseArtifactManager.ArtifactWithDriver artifact, @Nullable String version, boolean rolling, @Nullable List<SimpleClasspathElement> legacy) {
            if (artifact == null) {
                ProvidedItem.$$$reportNull$$$0(1);
            }
            this.artifact = artifact;
            this.version = version;
            this.rolling = rolling;
            this.legacy = version == null ? legacy : null;
            String actual = artifact.latestVersion();
            String rawName = this.getVersionDependentName();
            this.invalid = !DatabaseDriverValidator.isDriverFilesValid(rawName, version, this.legacy);
            this.needUpdate = this.invalid || !DatabaseDriverValidator.isDriverFilesUpToDate(rawName, version, rolling, this.legacy);
            this.actualDownloaded = !this.needUpdate || DatabaseDriverValidator.isDriverFilesUpToDate(artifact.getName(), actual, rolling, this.legacy);
        }

        @NotNull
        String getVersionDependentName() {
            String string = this.version == null ? this.artifact.getName() : this.artifact.composite().getNameAt(this.version);
            if (string == null) {
                ProvidedItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String getToolTipText() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.artifact.getName());
            if (this.rolling) {
                builder.append(" [rolling releases]");
            }
            if (this.version == null) {
                if (ContainerUtil.isEmpty(this.legacy)) {
                    builder.append(" with no files");
                } else {
                    builder.append(" with old files:<br>");
                    for (SimpleClasspathElement element2 : this.legacy) {
                        for (String url2 : element2.getClassesRootUrls()) {
                            if (builder.length() != 0) {
                                builder.append("<br>");
                            }
                            builder.append(VfsUtilCore.urlToPath((String)url2));
                        }
                    }
                }
            } else {
                builder.append(" [ver. ").append(this.version).append("]:<br>");
                DatabaseArtifactManager.getClasspathElements(this.getVersionDependentName(), this.version).stream().flatMap(o -> o.getClassesRootUrls().stream()).forEach(url -> {
                    if (builder.length() != 0) {
                        builder.append("<br>");
                    }
                    builder.append(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url)));
                });
            }
            return builder.toString();
        }

        public String toString() {
            return this.artifact.getName() + ":" + this.version + (this.rolling ? "[Latest]" : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DriverClasspathPanel$ProvidedItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DriverClasspathPanel$ProvidedItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersionDependentName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SimpleItem
    implements ClassPathItem {
        @NotNull
        SimpleClasspathElement element;
        @Nullable
        File file;

        SimpleItem(@NotNull SimpleClasspathElement element2) {
            if (element2 == null) {
                SimpleItem.$$$reportNull$$$0(0);
            }
            this.element = element2;
            String url = (String)ContainerUtil.getFirstItem((List)element2.getClassesRootUrls());
            if (url != null) {
                this.file = new File(PathUtil.toPresentableUrl((String)url));
            }
        }

        public String toString() {
            String url = (String)ContainerUtil.getFirstItem((List)this.element.getClassesRootUrls());
            return url == null ? "" : PathUtil.toPresentableUrl((String)url);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/ui/DriverClasspathPanel$SimpleItem", "<init>"));
        }
    }

    private static interface ClassPathItem {
    }
}

