/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.SqlInsertHandlers;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlParameterNamesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private final Set<String> EMPTY_STRING_SET = new HashSet<String>();

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        SqlLanguageDialectEx dialect;
        String separator;
        if (parameters == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((separator = SqlParameterNamesCompletionProvider.getSeparator(dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)parameters.getOriginalFile()))) == null) {
            return;
        }
        PsiElement position = parameters.getPosition();
        int offset = position.getTextRange().getStartOffset();
        SqlExpressionList params = (SqlExpressionList)PsiTreeUtil.getParentOfType((PsiElement)position, SqlExpressionList.class);
        SqlFunctionCallExpressionImpl foo = (SqlFunctionCallExpressionImpl)((Object)ObjectUtils.tryCast((Object)(params == null ? null : params.getParent()), SqlFunctionCallExpressionImpl.class));
        if (foo == null) {
            return;
        }
        SqlExpression slot = (SqlExpression)((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)params).expand(e -> e == params)).filter(SqlExpression.class).filter(e -> e.getTextRange().contains(offset)).first();
        if (slot == null || slot instanceof SqlNamedParameterValueExpression) {
            return;
        }
        PsiElement nonEmpty = (PsiElement)JBIterable.generate((Object)position, PsiTreeUtil::prevVisibleLeaf).skip(1).skipWhile(e -> e instanceof PsiComment || e instanceof PsiWhiteSpace).first();
        if (nonEmpty != null && slot.getTextRange().contains(nonEmpty.getTextRange().getStartOffset())) {
            return;
        }
        SqlExpressionList list = foo.getParameterList();
        Set<String> existingParams = this.getExistingParamNames(separator, list);
        LinkedHashMap entries = new LinkedHashMap();
        SqlFunctionCallExpressionImpl.processParameters(foo.getNameElement(), (Processor<PsiElement>)((Processor)p2 -> {
            DasObject object = (DasObject)ObjectUtils.tryCast((Object)p2, DasObject.class);
            if (object == null) {
                return true;
            }
            String objectName = object.getName();
            if (StringUtil.isEmpty((String)objectName) || existingParams.contains(objectName)) {
                return true;
            }
            entries.put(objectName, object);
            return true;
        }), position);
        for (Map.Entry entry : entries.entrySet()) {
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)((String)entry.getKey())).appendTailText(" " + separator, true).withIcon(DbPresentation.getIcon(ObjectKind.ARGUMENT)).withInsertHandler((ctx, item) -> {
                if (!SqlParameterNamesCompletionProvider.avoidQuoting((DasObject)entry.getValue(), (String)entry.getKey(), dialect)) {
                    SqlInsertHandlers.QUOT_INSERT_HANDLER.handleInsert(ctx, item);
                }
                String suffix = " " + separator + " ";
                ctx.getDocument().insertString(ctx.getTailOffset(), (CharSequence)suffix);
                ctx.getEditor().getCaretModel().moveCaretRelatively(suffix.length(), 0, false, false, false);
            }), (double)(parameters.getInvocationCount() <= 1 ? 0.0 : 150.0)));
        }
    }

    @NotNull
    private Set<String> getExistingParamNames(@NotNull String separator, @Nullable SqlExpressionList list) {
        if (separator == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(3);
        }
        if (list == null) {
            Set<String> set = this.EMPTY_STRING_SET;
            if (set == null) {
                SqlParameterNamesCompletionProvider.$$$reportNull$$$0(4);
            }
            return set;
        }
        List expressionList = list.getExpressionList();
        HashSet<String> result = new HashSet<String>(expressionList.size());
        for (SqlExpression expression : expressionList) {
            String name;
            if (!(expression instanceof SqlNamedParameterValueExpression) || (name = expression.getName()) == null) continue;
            if (name.contains(separator)) {
                name = name.split(separator)[0].trim();
            }
            result.add(name);
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static boolean avoidQuoting(@NotNull DasObject object, @NotNull String name, @NotNull SqlLanguageDialectEx dialect) {
        if (object == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(6);
        }
        if (name == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(7);
        }
        if (dialect == null) {
            SqlParameterNamesCompletionProvider.$$$reportNull$$$0(8);
        }
        if (object instanceof PsiElement && SqlCompletionUtil.hasPlainIdentifier((PsiElement)object)) {
            return true;
        }
        if (!dialect.getDbms().isMicrosoft()) {
            return false;
        }
        if (StringUtil.isEmpty((String)name) || name.charAt(0) != '@') {
            return false;
        }
        NamingService namingService = NamingServices.getNamingService(SqlImplUtil.getDbms(object));
        return namingService.isPlain(name.substring(1), true);
    }

    @Nullable
    private static String getSeparator(SqlLanguageDialectEx dialect) {
        if (dialect.getDbms().isTransactSql()) {
            return "=";
        }
        if (dialect.getDbms().isPostgres()) {
            return ":=";
        }
        if (dialect.getDbms().isOracle()) {
            return "=>";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/providers/SqlParameterNamesCompletionProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/providers/SqlParameterNamesCompletionProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingParamNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExistingParamNames";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "avoidQuoting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

