/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.SqlFormattingModelBuilder;
import com.intellij.sql.formatter.SqlLineIndentProviderKt;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlRootBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/formatter/SqlLineIndentProvider;", "Lcom/intellij/psi/codeStyle/lineIndent/LineIndentProvider;", "()V", "getLineIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "", "isSuitableFor", "", "intellij.database.sql.impl"})
public final class SqlLineIndentProvider
implements LineIndentProvider {
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        Document document2 = document;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document2);
        PsiFile psiFile = documentManager.getPsiFile(document2);
        if (!(psiFile instanceof SqlFile)) {
            psiFile = null;
        }
        SqlFile sqlFile = (SqlFile)psiFile;
        if (sqlFile == null) {
            return "";
        }
        SqlFile file = sqlFile;
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings((PsiFile)((PsiFile)file));
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCodeStyleSettings, (String)"SqlCodeStyles.getSqlSettings(file)");
        SqlCodeStyleSettings settings = sqlCodeStyleSettings;
        if (settings.DISABLE_FORMATTING) {
            return LineIndentProvider.DO_NOT_ADJUST;
        }
        int length = document2.getTextLength();
        int n = 0;
        IntRange intRange = new IntRange(n, length);
        n = 0;
        TextRange interestingTextRange = new TextRange(SqlUtilFun.fitInto(offset - 1, intRange), SqlUtilFun.fitInto(offset + 1, new IntRange(n, length)));
        FormattingModel formattingModel = SqlFormattingModelBuilder.makeModel((PsiElement)file, FormattingMode.ADJUST_INDENT_ON_ENTER, document2, interestingTextRange, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)formattingModel, (String)"SqlFormattingModelBuilde\u2026terestingTextRange, null)");
        FormattingModel model = formattingModel;
        Block block = model.getRootBlock();
        if (!(block instanceof SqlRootBlock)) {
            block = null;
        }
        SqlRootBlock sqlRootBlock = (SqlRootBlock)block;
        if (sqlRootBlock == null) {
            return LineIndentProvider.DO_NOT_ADJUST;
        }
        SqlRootBlock rootBlock = sqlRootBlock;
        AdjacentBlocks enclosedBlocks = SqlLineIndentProviderKt.access$adjustEnclosingBlocks(SqlLineIndentProviderKt.access$findEnclosingBlocks(rootBlock, offset));
        SqlBlock parentBlock = enclosedBlocks.getParent();
        if (parentBlock == null) {
            return LineIndentProvider.DO_NOT_ADJUST;
        }
        if (enclosedBlocks.getSame() && enclosedBlocks.getBlock1() instanceof SqlLeafBlock) {
            return SqlLineIndentProviderKt.access$getLineIndentInsideLeaf(enclosedBlocks);
        }
        String indent = parentBlock.getNewLineIndent(enclosedBlocks);
        String string = indent;
        if (string == null) {
            string = LineIndentProvider.DO_NOT_ADJUST;
        }
        return string;
    }

    public boolean isSuitableFor(@Nullable Language language) {
        return language instanceof SqlLanguageDialect;
    }
}

