/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.configuration;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlFile;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlNoDataSourceInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "SqlNoDataSourceInspection";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SqlNoDataSourceInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlNoDataSourceInspection.$$$reportNull$$$0(1);
        }
        if (!isOnTheFly || !(file instanceof SqlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        if (topLevelFile.getVirtualFile() instanceof LightVirtualFile) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!DbPsiFacade.getInstance((Project)manager.getProject()).getDataSources().isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        boolean injectedFile = topLevelFile != file;
        MyQuickFix setupFix = new MyQuickFix();
        LocalQuickFix[] quickFixes = new LocalQuickFix[]{setupFix};
        AnAction action2 = ActionManager.getInstance().getAction("ShowIntentionActions");
        String messageTail = injectedFile ? " Disable this inspection via problem menu (" + KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2) + ")." : "";
        String message2 = "No data sources are configured to run this SQL and provide advanced code assistance." + messageTail;
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)file, message2, true, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        return new ProblemDescriptor[]{descriptor};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/configuration/SqlNoDataSourceInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyQuickFix
    extends IntentionAndQuickFixAction {
        private MyQuickFix() {
        }

        @NotNull
        public String getName() {
            return "Configure data source";
        }

        @NotNull
        public String getFamilyName() {
            return "Configure data source";
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            DataSourceManagerDialog.showDialog(project, null, null);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/configuration/SqlNoDataSourceInspection$MyQuickFix", "applyFix"));
        }
    }
}

