/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlLimitClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import gnu.trove.TIntArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlPreviewDmlAction
extends SqlBaseElementAtCaretIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        SqlDmlInstruction instruction2;
        if (project == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(1);
        }
        if ((instruction2 = this.getInstruction(element2)) == null) {
            return;
        }
        String statement = this.getPreviewStatement(instruction2);
        if (statement == null) {
            return;
        }
        SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)element2.getContainingFile(), SqlFile.class);
        if (file == null) {
            return;
        }
        JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file.getViewProvider().getVirtualFile());
        if (console != null) {
            this.perform(editor, statement, (PsiElement)instruction2, console);
        } else {
            this.chooseAndPerform(project, editor, (PsiElement)instruction2, statement);
        }
    }

    @Nullable
    protected abstract String getPreviewStatement(SqlDmlInstruction var1);

    @Nullable
    protected abstract SqlDmlInstruction getInstruction(@NotNull PsiElement var1);

    protected void chooseAndPerform(@NotNull Project project, Editor editor, @NotNull PsiElement element2, @NotNull String statement) {
        PsiFile file;
        List<PersistenceConsoleProvider.Runner> runners;
        if (project == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(3);
        }
        if (statement == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(4);
        }
        if ((runners = DatabaseRunners.getRunners(DbImplUtil.getDataSourcesForExec(file = element2.getContainingFile(), false, true), project, null, this.getFamilyName(), (Consumer<? super DatabaseSession>)((Consumer)session2 -> {
            JdbcConsole console = JdbcConsoleProvider.attachConsole(project, session2, file.getViewProvider().getVirtualFile());
            if (console == null) {
                return;
            }
            this.perform(editor, statement, element2, console);
        }))).isEmpty()) {
            return;
        }
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(runners, editor, null);
    }

    protected void perform(Editor editor, @NotNull String statement, @NotNull PsiElement element2, @NotNull JdbcConsole console) {
        if (statement == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(5);
        }
        if (element2 == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(6);
        }
        if (console == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(7);
        }
        Document document = console.getDocument();
        RangeMarker marker = document.createRangeMarker(element2.getTextRange());
        MyRequest request = new MyRequest((DataRequest.Owner)console, statement, editor, marker);
        request.getPromise().onProcessed(__ -> marker.dispose());
        console.getMessageBus().getDataProducer().processRequest(request);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(9);
        }
        return this.getInstruction(element2) != null;
    }

    @NotNull
    private static List<String> getColumnNames(@NotNull Project project, SqlTableType type, SqlLanguageDialectEx dialect, SqlExpression extra) {
        if (project == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(10);
        }
        SqlTableType extraType = extra == null ? null : (SqlTableType)ObjectUtils.tryCast((Object)extra.getSqlType(), SqlTableType.class);
        SqlTableType all = extraType == null ? null : type.join(extraType);
        DatabaseDialectEx dbDialect = dialect.getDatabaseDialect();
        List<String> list = all == null ? DbSqlUtil.getUnambiguousColumnNames(project, dbDialect, type, (PairFunction<? super SqlTableType, ? super Integer, Boolean>)((PairFunction)(a, b2) -> false)) : DbSqlUtil.getUnambiguousColumnNames(project, dbDialect, type, all, (PairFunction<? super SqlTableType, ? super Integer, Boolean>)((PairFunction)(a, b2) -> false));
        if (list == null) {
            SqlPreviewDmlAction.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static void appendNewValue(StringBuilder res, int listStart, List<SqlSetAssignment> assignments, TIntArrayList indices, int idx, NamingService ns) {
        for (int k = 0; k < indices.size(); ++k) {
            SqlElement value2;
            if (indices.get(k) != idx || (value2 = assignments.get(k).getRValue()) == null) continue;
            SqlPreviewDmlAction.leadingComma(res, listStart);
            res.append(value2.getText()).append(" ").append(ns.enquoteName("new " + assignments.get(k).getLValue().getText()));
        }
    }

    private static void leadingComma(StringBuilder res, int listStart) {
        if (res.length() != listStart) {
            res.append(", ");
        }
    }

    private static int findIdx(SqlElement value2, SqlTableType type) {
        ResolveResult[] resolved;
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)value2, SqlReferenceExpression.class);
        for (ResolveResult result : resolved = ref == null ? ResolveResult.EMPTY_ARRAY : ref.multiResolve(false)) {
            int e = type.getColumnCount();
            for (int i2 = 0; i2 < e; ++i2) {
                if (result.getElement() != type.getColumnElement(i2)) continue;
                return i2;
            }
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlPreviewDmlAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlPreviewDmlAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndPerform";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNames";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Delete
    extends SqlPreviewDmlAction {
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("preview.delete", new Object[0]);
            if (string == null) {
                Delete.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        protected String getPreviewStatement(SqlDmlInstruction instruction2) {
            return Delete.getStatement(instruction2);
        }

        @Override
        @Nullable
        protected SqlDmlInstruction getInstruction(@NotNull PsiElement element2) {
            if (element2 == null) {
                Delete.$$$reportNull$$$0(1);
            }
            return Delete.getDeleteInstruction(element2);
        }

        @Nullable
        private static SqlDmlInstruction getDeleteInstruction(@NotNull PsiElement element2) {
            if (element2 == null) {
                Delete.$$$reportNull$$$0(2);
            }
            return (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlDeleteStatement.class), SqlDmlInstruction.class);
        }

        @Nullable
        private static String getStatement(@NotNull SqlDmlInstruction del) {
            SqlLimitClause limit;
            SqlWhereClause where;
            SqlExpression expression;
            if (del == null) {
                Delete.$$$reportNull$$$0(3);
            }
            if ((expression = del.getTargetExpression()) == null) {
                return null;
            }
            StringBuilder res = new StringBuilder();
            SqlTableType type = del.getTargetType();
            SqlFromClause from = (SqlFromClause)PsiTreeUtil.getChildOfType((PsiElement)del, SqlFromClause.class);
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)del);
            SqlExpression extra = from == null ? null : from.getFromExpression();
            List names = SqlPreviewDmlAction.getColumnNames(del.getProject(), type, dialect, extra);
            SqlWithClause cte = (SqlWithClause)PsiTreeUtil.getChildOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)del, SqlStatement.class), SqlWithClause.class);
            if (cte != null) {
                res.append(cte.getText()).append(" ");
            }
            res.append("select ");
            if (names.isEmpty()) {
                res.append("*");
            } else {
                StringUtil.join((Collection)names, (String)", ", (StringBuilder)res);
            }
            res.append(" from ");
            int listStart = res.length();
            if (!Delete.isInFrom(expression, from)) {
                res.append(expression.getText());
            }
            if (extra != null) {
                SqlPreviewDmlAction.leadingComma(res, listStart);
                res.append(extra.getText());
            }
            if ((where = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)del, SqlWhereClause.class)) != null) {
                res.append(" ").append(where.getText());
            }
            if ((limit = (SqlLimitClause)PsiTreeUtil.getChildOfType((PsiElement)del, SqlLimitClause.class)) != null) {
                res.append(" ").append(limit.getText());
            }
            return res.toString();
        }

        private static boolean isInFrom(SqlExpression expression, SqlFromClause from) {
            PsiElement immediate;
            PsiElement resolved;
            if (PsiTreeUtil.isAncestor((PsiElement)from, (PsiElement)expression, (boolean)false)) {
                return true;
            }
            ResolveResult rr = expression instanceof SqlReferenceExpression ? ((SqlReferenceExpression)expression).resolveSingle() : null;
            PsiElement psiElement = resolved = rr == null ? null : rr.getElement();
            if (resolved == null) {
                return false;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)from, (PsiElement)resolved, (boolean)true)) {
                return true;
            }
            return rr instanceof SqlResolveResult && (immediate = ((SqlResolveResult)rr).getImmediateTarget()) != null && PsiTreeUtil.isAncestor((PsiElement)from, (PsiElement)immediate, (boolean)true);
        }

        @Nullable
        public static String getStatement(@NotNull PsiElement element2) {
            SqlDmlInstruction instruction2;
            if (element2 == null) {
                Delete.$$$reportNull$$$0(4);
            }
            return (instruction2 = Delete.getDeleteInstruction(element2)) == null ? null : Delete.getStatement(instruction2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/intentions/SqlPreviewDmlAction$Delete";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "del";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/intentions/SqlPreviewDmlAction$Delete";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstruction";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDeleteInstruction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Update
    extends SqlPreviewDmlAction {
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("preview.update", new Object[0]);
            if (string == null) {
                Update.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        protected String getPreviewStatement(SqlDmlInstruction instruction2) {
            return Update.getStatement(instruction2);
        }

        @Override
        @Nullable
        protected SqlDmlInstruction getInstruction(@NotNull PsiElement element2) {
            if (element2 == null) {
                Update.$$$reportNull$$$0(1);
            }
            return Update.getUpdateInstruction(element2);
        }

        @Nullable
        private static SqlDmlInstruction getUpdateInstruction(@NotNull PsiElement element2) {
            if (element2 == null) {
                Update.$$$reportNull$$$0(2);
            }
            return (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlUpdateStatement.class), SqlDmlInstruction.class);
        }

        @Nullable
        private static String getStatement(@NotNull SqlDmlInstruction upd) {
            SqlWhereClause where;
            SqlExpression expression;
            if (upd == null) {
                Update.$$$reportNull$$$0(3);
            }
            if ((expression = upd.getTargetExpression()) == null) {
                return null;
            }
            StringBuilder res = new StringBuilder();
            SqlTableType type = upd.getTargetType();
            SqlFromClause from = (SqlFromClause)PsiTreeUtil.getChildOfType((PsiElement)upd, SqlFromClause.class);
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)upd);
            NamingService namingService = NamingServices.getNamingService(SqlImplUtil.getDbms((PsiElement)upd));
            SqlExpression extra = from == null ? null : from.getFromExpression();
            List names = SqlPreviewDmlAction.getColumnNames(upd.getProject(), type, dialect, extra);
            SqlSetClause set = (SqlSetClause)PsiTreeUtil.getChildOfType((PsiElement)upd, SqlSetClause.class);
            List assignments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)set, SqlSetAssignment.class);
            TIntArrayList indices = new TIntArrayList();
            for (SqlSetAssignment assignment : assignments) {
                indices.add(SqlPreviewDmlAction.findIdx(assignment.getLValue(), type));
            }
            SqlWithClause cte = (SqlWithClause)PsiTreeUtil.getChildOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)upd, SqlStatement.class), SqlWithClause.class);
            if (cte != null) {
                res.append(cte.getText()).append(" ");
            }
            res.append("select ");
            int listStart = res.length();
            for (int i2 = 0; i2 < names.size(); ++i2) {
                SqlPreviewDmlAction.leadingComma(res, listStart);
                res.append((String)names.get(i2));
                SqlPreviewDmlAction.appendNewValue(res, listStart, assignments, indices, i2, namingService);
            }
            SqlPreviewDmlAction.appendNewValue(res, listStart, assignments, indices, -1, namingService);
            if (names.isEmpty()) {
                SqlPreviewDmlAction.leadingComma(res, listStart);
                res.append("*");
            }
            res.append(" from ");
            listStart = res.length();
            if (!Update.isInFrom(expression, from)) {
                res.append(expression.getText());
            }
            if (extra != null) {
                SqlPreviewDmlAction.leadingComma(res, listStart);
                res.append(extra.getText());
            }
            if ((where = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)upd, SqlWhereClause.class)) != null) {
                res.append(" ").append(where.getText());
            }
            return res.toString();
        }

        private static boolean isInFrom(SqlExpression expression, SqlFromClause from) {
            PsiElement immediate;
            PsiElement resolved;
            ResolveResult rr = expression instanceof SqlReferenceExpression ? ((SqlReferenceExpression)expression).resolveSingle() : null;
            PsiElement psiElement = resolved = rr == null ? null : rr.getElement();
            if (resolved == null) {
                return false;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)from, (PsiElement)resolved, (boolean)true)) {
                return true;
            }
            return rr instanceof SqlResolveResult && (immediate = ((SqlResolveResult)rr).getImmediateTarget()) != null && PsiTreeUtil.isAncestor((PsiElement)from, (PsiElement)immediate, (boolean)true);
        }

        @Nullable
        public static String getStatement(@NotNull PsiElement element2) {
            SqlDmlInstruction instruction2;
            if (element2 == null) {
                Update.$$$reportNull$$$0(4);
            }
            return (instruction2 = Update.getUpdateInstruction(element2)) == null ? null : Update.getStatement(instruction2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/intentions/SqlPreviewDmlAction$Update";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "upd";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/intentions/SqlPreviewDmlAction$Update";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstruction";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getUpdateInstruction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyRequest
    extends DataRequest.QueryRequest
    implements DataRequest.CoupledWithEditor {
        private final Editor myEditor;
        private final RangeMarker myMarker;

        MyRequest(@NotNull DataRequest.Owner owner, @NotNull String query, @NotNull Editor editor, @NotNull RangeMarker marker) {
            if (owner == null) {
                MyRequest.$$$reportNull$$$0(0);
            }
            if (query == null) {
                MyRequest.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                MyRequest.$$$reportNull$$$0(2);
            }
            if (marker == null) {
                MyRequest.$$$reportNull$$$0(3);
            }
            super(owner, query, DataRequest.newConstraints(), null);
            this.myEditor = editor;
            this.myMarker = marker;
        }

        @Override
        @Nullable
        public Editor getEditor() {
            return this.myEditor;
        }

        @Override
        @Nullable
        public TextRange getRange() {
            return this.myMarker.isValid() ? TextRange.create((int)this.myMarker.getStartOffset(), (int)this.myMarker.getEndOffset()) : null;
        }

        @Override
        @Nullable
        public DataRequest.CoupledWithEditor.ErrorNavigator onError(@Nullable String message2, @Nullable Throwable th) {
            return null;
        }

        @Override
        @NotNull
        public DataRequest getRequest() {
            MyRequest myRequest = this;
            if (myRequest == null) {
                MyRequest.$$$reportNull$$$0(4);
            }
            return myRequest;
        }

        @Override
        public void onWarning(@Nullable String message2, @Nullable Runnable suppressAction, @NotNull JdbcEngine.ExecutionConcession concession) {
            if (concession == null) {
                MyRequest.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "marker";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/intentions/SqlPreviewDmlAction$MyRequest";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "concession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/intentions/SqlPreviewDmlAction$MyRequest";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "onWarning";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

