/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SqlSplitStringLiteralIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("quickfix.name.split.string.literal", new Object[0]);
        if (string == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        SqlStringTokenElement string;
        if (project == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(2);
        }
        if ((string = SqlSplitStringLiteralIntention.currentStringToken(element2)) == null) {
            return false;
        }
        return SqlSplitStringLiteralIntention.getContentRange(string).contains(editor.getCaretModel().getOffset());
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        SqlStringTokenElement string;
        if (project == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(4);
        }
        if ((string = SqlSplitStringLiteralIntention.currentStringToken(element2)) != null) {
            CommandProcessor.getInstance().executeCommand(project, () -> SqlSplitStringLiteralIntention.splitLiteral(string, project, editor, element2), null, (Object)editor.getDocument());
        }
    }

    @NotNull
    private static TextRange getContentRange(SqlStringTokenElement string) {
        PsiElement element2 = Objects.requireNonNull(SqlStringLiteralManipulator.getStringElement((PsiElement)string));
        TextRange textRange = SqlStringLiteralManipulator.getStringContentRange(element2).shiftRight(element2.getTextRange().getStartOffset());
        if (textRange == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static SqlStringTokenElement currentStringToken(PsiElement element2) {
        SqlStringTokenElement type = (SqlStringTokenElement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStringTokenElement.class, (boolean)false);
        return PsiUtilCore.getElementType((PsiElement)type) != SqlTokens.SQL_IDENT_DELIMITED ? type : null;
    }

    private static int getConcatExpr(@NotNull DdlBuilder builder, @NotNull String a, @NotNull String b2) {
        int res;
        Dbms id;
        if (builder == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(6);
        }
        if (a == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(7);
        }
        if (b2 == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(8);
        }
        if ((id = builder.getDialect().getDbms()).isMysql()) {
            builder.keyword("CONCAT").symbol("(").literal(a).symbol(",").space();
            res = builder.length();
            builder.symbol(",").space().literal(b2).symbol(")");
        } else {
            String op = id.isTransactSql() ? "+" : "||";
            builder.literal(a).space().symbol(op).space();
            res = builder.length();
            builder.space().symbol(op).space().literal(b2);
        }
        return res;
    }

    @NotNull
    private static TextRange findLiteralRange(@NotNull SqlStringTokenElement string) {
        if (string == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(9);
        }
        if (string.getParent() instanceof SqlStringLiteralExpression) {
            TextRange textRange = string.getParent().getTextRange();
            if (textRange == null) {
                SqlSplitStringLiteralIntention.$$$reportNull$$$0(10);
            }
            return textRange;
        }
        if (string.getElementType() == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            Object prev = PsiTreeUtil.prevLeaf((PsiElement)string);
            Object next = PsiTreeUtil.nextLeaf((PsiElement)string);
            if (PsiUtilCore.getElementType((PsiElement)prev) != SqlTokens.SQL_CUSTOM_LQUOTE) {
                prev = string;
            }
            if (PsiUtilCore.getElementType((PsiElement)next) != SqlTokens.SQL_CUSTOM_RQUOTE) {
                next = string;
            }
            TextRange textRange = TextRange.create((int)prev.getTextRange().getStartOffset(), (int)next.getTextRange().getEndOffset());
            if (textRange == null) {
                SqlSplitStringLiteralIntention.$$$reportNull$$$0(11);
            }
            return textRange;
        }
        TextRange textRange = string.getTextRange();
        if (textRange == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    private static void splitLiteral(SqlStringTokenElement string, Project project, Editor editor, PsiElement element2) {
        TextRange outerRange = SqlSplitStringLiteralIntention.findLiteralRange(string);
        TextRange innerRange = SqlSplitStringLiteralIntention.getContentRange(string).shiftLeft(outerRange.getStartOffset());
        int splitPosition = SqlSplitStringLiteralIntention.findSplitPosition(string, outerRange, editor);
        if (splitPosition != -1) {
            WriteCommandAction.runWriteCommandAction((Project)project, (String)"Split string literal", (String)"Split string literal", () -> {
                String text2 = editor.getDocument().getText(outerRange);
                String bquote = text2.substring(0, innerRange.getStartOffset());
                String equote = text2.substring(innerRange.getEndOffset(), outerRange.getLength());
                SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe((PsiElement)string);
                DdlBuilder builder = new DdlBuilder(new StringBuilder(string.getTextLength() + 20)).configureBuilder(project, sqlDialect).withDialect(sqlDialect.getDatabaseDialect());
                int cur = SqlSplitStringLiteralIntention.getConcatExpr(builder, text2.substring(0, splitPosition) + equote, bquote + text2.substring(splitPosition));
                editor.getDocument().replaceString(outerRange.getStartOffset(), outerRange.getEndOffset(), (CharSequence)builder.getStatement());
                editor.getCaretModel().moveToOffset(cur += outerRange.getStartOffset());
            }, (PsiFile[])new PsiFile[]{element2.getContainingFile()});
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
        }
    }

    private static int findSplitPosition(SqlStringTokenElement string, TextRange literalRange, Editor editor) {
        PsiElement parent2 = string.getParent();
        int caret = editor.getCaretModel().getOffset();
        if (parent2 instanceof SqlStringLiteralExpression) {
            return SqlSplitStringLiteralIntention.findSplitPosition((SqlStringLiteralExpression)parent2, caret);
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)editor.getProject());
        SqlStringLiteralExpression literal = (SqlStringLiteralExpression)PsiTreeUtil.findChildOfType((PsiElement)facade.createExpressionFragment((Language)SqlImplUtil.getSqlDialectSafe((PsiElement)string), null, null, editor.getDocument().getText(literalRange)), SqlStringLiteralExpression.class);
        if (literal == null) {
            return -1;
        }
        return SqlSplitStringLiteralIntention.findSplitPosition(literal, caret - literalRange.getStartOffset());
    }

    private static int findSplitPosition(SqlStringLiteralExpression literal, int caret) {
        StringBuilder dummy;
        int innerCaretOffset;
        TextRange innerRange = SqlStringLiteralManipulator.getStringContentRange((PsiElement)literal);
        if (!innerRange.contains(innerCaretOffset = caret - literal.getTextRange().getStartOffset())) {
            return -1;
        }
        LiteralTextEscaper esc = literal.createLiteralTextEscaper();
        if (!esc.decode(innerRange, dummy = new StringBuilder(literal.getTextLength()))) {
            return -1;
        }
        int pos = SqlSplitStringLiteralIntention.findDecodedSplitPosition(esc, innerRange, innerCaretOffset, 0, dummy.length());
        return pos == -1 ? -1 : esc.getOffsetInHost(pos, innerRange);
    }

    private static int findDecodedSplitPosition(LiteralTextEscaper<?> esc, TextRange innerRange, int h, int s, int e) {
        if (esc.getOffsetInHost(s, innerRange) == h) {
            return s;
        }
        if (esc.getOffsetInHost(e, innerRange) == h) {
            return e;
        }
        int i2 = ObjectUtils.binarySearch((int)s, (int)e, m -> Integer.compare(esc.getOffsetInHost(m, innerRange), h));
        if (i2 < 0) {
            i2 = -i2 - 1;
        }
        return i2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlSplitStringLiteralIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlSplitStringLiteralIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRange";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findLiteralRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConcatExpr";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findLiteralRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

