/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.support;

import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPairedBraceMatcher
extends PairedBraceMatcherAdapter {
    public static final BracePair[] PAIRS = new BracePair[]{new BracePair((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, true), new BracePair((IElementType)SqlTokens.SQL_LEFT_BRACE, (IElementType)SqlTokens.SQL_RIGHT_BRACE, false), new BracePair((IElementType)SqlTokens.SQL_LEFT_BRACKET, (IElementType)SqlTokens.SQL_RIGHT_BRACKET, false), new BracePair((IElementType)SqlTokens.SQL_LEFT_ANGLES, (IElementType)SqlTokens.SQL_RIGHT_ANGLES, false), new BracePair((IElementType)SqlTokens.SQL_CUSTOM_LQUOTE, (IElementType)SqlTokens.SQL_CUSTOM_RQUOTE, false), new BracePair((IElementType)SqlTokens.SQL_CUSTOM_PARAM_LQUOTE, (IElementType)SqlTokens.SQL_CUSTOM_PARAM_RQUOTE, false)};

    public SqlPairedBraceMatcher() {
        super((PairedBraceMatcher)new MyPairedBraceMatcher(), (Language)SqlLanguage.INSTANCE);
    }

    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        BracePair pair = this.findPair(true, iterator, fileText, fileType);
        if (pair == null) {
            return false;
        }
        if (pair.getRightBraceType() != SqlCommonKeywords.SQL_END) {
            return true;
        }
        boolean result = true;
        int count2 = 0;
        while (true) {
            iterator.retreat();
            ++count2;
            if (iterator.atEnd()) break;
            IElementType tokenType = iterator.getTokenType();
            if (SqlTokens.WS_OR_COMMENTS.contains(tokenType)) continue;
            if (tokenType != SqlCommonKeywords.SQL_END) break;
            result = false;
        }
        while (count2-- > 0) {
            iterator.advance();
        }
        return result;
    }

    private static class MyPairedBraceMatcher
    implements PairedBraceMatcher {
        private MyPairedBraceMatcher() {
        }

        @NotNull
        public BracePair[] getPairs() {
            if (PAIRS == null) {
                MyPairedBraceMatcher.$$$reportNull$$$0(0);
            }
            return PAIRS;
        }

        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType type) {
            if (lbraceType == null) {
                MyPairedBraceMatcher.$$$reportNull$$$0(1);
            }
            return SqlTokens.WS_OR_COMMENTS.contains(type) || type == SqlTokens.SQL_SEMICOLON || type == SqlTokens.SQL_COMMA || type == SqlTokens.SQL_RIGHT_PAREN || type == SqlTokens.SQL_RIGHT_BRACKET || type == SqlTokens.SQL_RIGHT_BRACE || null == type;
        }

        public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
            return openingBraceOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/support/SqlPairedBraceMatcher$MyPairedBraceMatcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lbraceType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPairs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/support/SqlPairedBraceMatcher$MyPairedBraceMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isPairedBracesAllowedBeforeType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

