/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;

public class SqlTriggerStub
extends SqlNamedElementStub<SqlCreateTriggerStatement> {
    protected final StringRef myTableName;
    protected final StringRef myTriggerProcText;
    private SqlReferenceExpression myTargetReference;
    private SqlExpression myTriggerProcedure;

    public SqlTriggerStub(StubElement parent2, @NotNull IStubElementType<SqlTriggerStub, SqlCreateTriggerStatement> elementType, StringRef name, StringRef tableName, StringRef triggerProcText) {
        if (elementType == null) {
            SqlTriggerStub.$$$reportNull$$$0(0);
        }
        super(parent2, elementType, name);
        this.myTableName = tableName;
        this.myTriggerProcText = triggerProcText;
    }

    public String getTableName() {
        return this.myTableName == null ? null : this.myTableName.getString();
    }

    public String getTriggerProcText() {
        return this.myTriggerProcText == null ? null : this.myTriggerProcText.getString();
    }

    public SqlReferenceExpression getTableReference() {
        if (this.myTargetReference == null) {
            String targetName = this.getTableName();
            if (targetName == null) {
                return null;
            }
            this.myTargetReference = this.createReference(SqlCompositeElementTypes.SQL_TABLE_REFERENCE, targetName);
        }
        return this.myTargetReference;
    }

    public SqlExpression getTriggerProcedure() {
        if (this.myTriggerProcedure == null && this.myTriggerProcText != null) {
            String exprText = this.getTriggerProcText();
            if (exprText == null) {
                return null;
            }
            SqlCreateTriggerStatement psi = (SqlCreateTriggerStatement)this.getPsi();
            this.myTriggerProcedure = SqlPsiElementFactory.createExpressionFromText(exprText, SqlImplUtil.getSqlDialectSafe((PsiElement)psi), (PsiElement)psi);
        }
        return this.myTriggerProcedure;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/psi/stubs/SqlTriggerStub", "<init>"));
    }
}

