/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine;

import com.intellij.DynamicBundle;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.facet.AppEngineFacetType;
import com.jetbrains.appengine.facet.AppEngineSettingsPanel;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.appengine.util.AppEngineUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;

public class AppEngineConfigurable
implements Configurable,
NonDefaultProjectConfigurable {
    private JCheckBox myEnableGoogleAppEngineCheckBox;
    private final AppEngineSettingsPanel mySettingsPanel;
    private JPanel myMainPanel;
    private JPanel myAppEngineConfigurationPlaceholder;
    private final Module myModule;

    public AppEngineConfigurable(Module module) {
        this.myModule = module;
        this.$$$setupUI$$$();
        this.mySettingsPanel = new AppEngineSettingsPanel();
        this.myAppEngineConfigurationPlaceholder.add((Component)this.mySettingsPanel, "Center");
        this.myEnableGoogleAppEngineCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppEngineConfigurable.this.updateSettingsPanelEnabled();
            }
        });
        this.updateSettingsPanelEnabled();
    }

    private void updateSettingsPanelEnabled() {
        UIUtil.setEnabled((Component)this.mySettingsPanel, (boolean)this.myEnableGoogleAppEngineCheckBox.isSelected(), (boolean)true);
    }

    @Nls
    public String getDisplayName() {
        return AppEngineBundle.message((String)"configurable.AppEngineFacet.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.google_app_engine";
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (this.myEnableGoogleAppEngineCheckBox.isSelected() != AppEngineFacet.isPresent((Module)this.myModule)) {
            return true;
        }
        if (this.myEnableGoogleAppEngineCheckBox.isSelected()) {
            return this.mySettingsPanel.isModified((AppEngineFacetConfiguration)AppEngineFacet.getInstance((Module)this.myModule).getConfiguration());
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        AppEngineFacetConfiguration configuration = null;
        if (this.myEnableGoogleAppEngineCheckBox.isSelected() && !AppEngineFacet.isPresent((Module)this.myModule)) {
            configuration = AppEngineFacetType.getDefaultConfiguration((Project)this.myModule.getProject());
            this.mySettingsPanel.apply(configuration);
            AppEngineFacetType.createAppEngineFacet((Module)this.myModule, (AppEngineFacetConfiguration)configuration);
        } else if (!this.myEnableGoogleAppEngineCheckBox.isSelected() && AppEngineFacet.isPresent((Module)this.myModule)) {
            ModifiableFacetModel model = FacetManager.getInstance((Module)this.myModule).createModifiableModel();
            model.removeFacet((Facet)AppEngineFacet.getInstance((Module)this.myModule));
            ApplicationManager.getApplication().runWriteAction(() -> model.commit());
        } else {
            AppEngineFacet facet = AppEngineFacet.getInstance((Module)this.myModule);
            if (facet != null) {
                configuration = (AppEngineFacetConfiguration)facet.getConfiguration();
                this.mySettingsPanel.apply(configuration);
            }
        }
        if (this.myEnableGoogleAppEngineCheckBox.isSelected()) {
            assert (configuration != null);
            String sdkFolder = configuration.getSdkFolder();
            String projectRoot = configuration.getProjectRoot();
            if (!StringUtil.isEmpty((String)sdkFolder)) {
                WriteAction.run(() -> AppEngineUtil.initAppEngineModuleLibrary((Module)this.myModule, null, (String)sdkFolder, (String)projectRoot));
            }
        } else {
            WriteAction.run(() -> AppEngineUtil.detachAppEngineModuleLibrary((Module)this.myModule));
        }
    }

    public void reset() {
        if (this.myModule == null) {
            this.myEnableGoogleAppEngineCheckBox.setSelected(false);
            this.myEnableGoogleAppEngineCheckBox.setEnabled(false);
        } else {
            this.myEnableGoogleAppEngineCheckBox.setEnabled(true);
            AppEngineFacet instance = AppEngineFacet.getInstance((Module)this.myModule);
            if (instance != null) {
                this.myEnableGoogleAppEngineCheckBox.setSelected(true);
                this.mySettingsPanel.reset((AppEngineFacetConfiguration)instance.getConfiguration());
            } else {
                this.myEnableGoogleAppEngineCheckBox.setSelected(false);
            }
            this.updateSettingsPanelEnabled();
        }
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnableGoogleAppEngineCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/AppEngineBundle", AppEngineConfigurable.class).getString("python.app.engine.enable.support"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAppEngineConfigurationPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

