/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HtmlLabelsHolder {
    private static final Key<CachedValue<HtmlLabelsHolder>> htmlLabelsHolderKey = Key.create((String)"html labels holder");
    private final Set<String> myForValuesOfLabels = new HashSet<String>();
    private static final UserDataCache<CachedValue<HtmlLabelsHolder>, XmlFile, Object> CACHE = new UserDataCache<CachedValue<HtmlLabelsHolder>, XmlFile, Object>(){

        protected CachedValue<HtmlLabelsHolder> compute(XmlFile file, Object p) {
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
                HtmlLabelsHolder holder = new HtmlLabelsHolder();
                Language language = file.getViewProvider().getBaseLanguage();
                PsiFile psiFile = file.getViewProvider().getPsi(language);
                if (psiFile != null) {
                    psiFile.accept((PsiElementVisitor)new LabelGatheringRecursiveVisitor(holder));
                    return new CachedValueProvider.Result((Object)holder, new Object[]{file});
                }
                return null;
            }, false);
        }
    };

    public static HtmlLabelsHolder getInstance(XmlFile file) {
        return (HtmlLabelsHolder)((CachedValue)CACHE.get(htmlLabelsHolderKey, (UserDataHolder)file, null)).getValue();
    }

    private void registerForValue(@NotNull String forValue) {
        if (forValue == null) {
            HtmlLabelsHolder.$$$reportNull$$$0(0);
        }
        this.myForValuesOfLabels.add(forValue);
    }

    public boolean hasForValue(@NotNull String forValue) {
        if (forValue == null) {
            HtmlLabelsHolder.$$$reportNull$$$0(1);
        }
        return this.myForValuesOfLabels.contains(forValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "forValue";
        objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlLabelsHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerForValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasForValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LabelGatheringRecursiveVisitor
    extends XmlRecursiveElementVisitor {
        private final HtmlLabelsHolder myHolder;

        private LabelGatheringRecursiveVisitor(HtmlLabelsHolder holder) {
            super(true);
            this.myHolder = holder;
        }

        public void visitXmlTag(XmlTag tag) {
            super.visitXmlTag(tag);
            if ("label".equals(StringUtil.toLowerCase((String)tag.getName()))) {
                for (XmlAttribute attribute : tag.getAttributes()) {
                    String id;
                    if (!"for".equals(StringUtil.toLowerCase((String)attribute.getLocalName())) || (id = attribute.getValue()) == null) continue;
                    this.myHolder.registerForValue(id);
                }
            }
        }
    }
}

