/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.completion.ml.common.LocationFeaturesUtil;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0011\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0082\u0010J\b\u0010\u000f\u001a\u00020\u0005H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/completion/ml/common/CommonElementLocationFeatures;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "delegate", "lookupElement", "getName", "intellij.statsCollector"})
public final class CommonElementLocationFeatures
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "common";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)contextFeatures, (String)"contextFeatures");
        boolean bl = false;
        Map result = new LinkedHashMap();
        PsiElement completionElement = this.delegate(element).getPsiElement();
        PsiElement psiElement = completionElement;
        if (psiElement == null || (psiElement = psiElement.getLanguage()) == null || !psiElement.isKindOf("ruby")) {
            CompletionParameters completionParameters = location.getCompletionParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)completionParameters, (String)"location.completionParameters");
            Integer linesDiff2 = LocationFeaturesUtil.INSTANCE.linesDiff(completionParameters, completionElement);
            if (linesDiff2 != null) {
                result.put("lines_diff", MLFeatureValue.Companion.float(linesDiff2.intValue()));
            }
        }
        return result;
    }

    private final LookupElement delegate(LookupElement lookupElement) {
        LookupElement lookupElement2;
        while ((lookupElement2 = lookupElement) instanceof LookupElementDecorator) {
            Intrinsics.checkExpressionValueIsNotNull((Object)((LookupElementDecorator)lookupElement).getDelegate(), (String)"lookupElement.delegate");
        }
        return lookupElement;
    }
}

