/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElementVisitor;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Component;
import org.angular2.inspections.Angular2SourceEntityListValidator;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;

public class AngularInvalidEntryComponentInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AngularInvalidEntryComponentInspection.$$$reportNull$$$0(0);
        }
        return new JSElementVisitor(){

            public void visitES6Decorator(ES6Decorator decorator) {
                if (Angular2DecoratorUtil.isAngularEntityDecorator(decorator, "NgModule", "Component")) {
                    Angular2SourceEntityListValidator.ValidationResults<ProblemType> results = new Angular2SourceEntityListValidator.ValidationResults<ProblemType>();
                    new EntryComponentsValidator().validate(decorator, results);
                    if ("NgModule".equals(decorator.getDecoratorName())) {
                        new BootstrapValidator().validate(decorator, results);
                    }
                    results.registerProblems(ProblemType.INVALID_ENTRY_COMPONENT, holder);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/angular2/inspections/AngularInvalidEntryComponentInspection", "buildVisitor"));
    }

    private static class BootstrapValidator
    extends Angular2SourceEntityListValidator<Angular2Component, ProblemType> {
        protected BootstrapValidator() {
            super(Angular2Component.class, "bootstrap");
        }

        @Override
        protected void processNonEntityClass(@NotNull JSClass aClass) {
            if (aClass == null) {
                BootstrapValidator.$$$reportNull$$$0(0);
            }
            this.registerProblem(ProblemType.INVALID_ENTRY_COMPONENT, Angular2Bundle.message("angular.inspection.decorator.not-a-component", aClass.getName()), new LocalQuickFix[0]);
        }

        @Override
        protected void processAnyElement(JSElement node) {
            this.registerProblem(ProblemType.INVALID_ENTRY_COMPONENT, Angular2Bundle.message("angular.inspection.decorator.not-array-of-class-types", new Object[0]), new LocalQuickFix[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/angular2/inspections/AngularInvalidEntryComponentInspection$BootstrapValidator", "processNonEntityClass"));
        }
    }

    private static class EntryComponentsValidator
    extends Angular2SourceEntityListValidator<Angular2Component, ProblemType> {
        protected EntryComponentsValidator() {
            super(Angular2Component.class, "entryComponents");
        }

        @Override
        protected void processNonEntityClass(@NotNull JSClass aClass) {
            if (aClass == null) {
                EntryComponentsValidator.$$$reportNull$$$0(0);
            }
            this.registerProblem(ProblemType.INVALID_ENTRY_COMPONENT, Angular2Bundle.message("angular.inspection.decorator.not-a-component", aClass.getName()), new LocalQuickFix[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/angular2/inspections/AngularInvalidEntryComponentInspection$EntryComponentsValidator", "processNonEntityClass"));
        }
    }

    private static enum ProblemType {
        INVALID_ENTRY_COMPONENT;

    }
}

