/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.Queue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.angular2.codeInsight.Angular2DeclarationsScope;
import org.angular2.entities.Angular2Declaration;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.Angular2Module;
import org.angular2.entities.source.Angular2SourceDeclaration;
import org.angular2.inspections.actions.AddNgModuleDeclarationAction;
import org.angular2.inspections.actions.Angular2ActionFactory;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddNgModuleDeclarationQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String myDeclarationName;
    @NotNull
    private final SmartPsiElementPointer<ES6Decorator> myDeclarationDecorator;
    @Nullable
    private final String myModuleName;

    public static void add(@NotNull PsiElement context, @NotNull Angular2Declaration declaration, @NotNull List<LocalQuickFix> fixes) {
        if (context == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(0);
        }
        if (declaration == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(1);
        }
        if (fixes == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(2);
        }
        if (declaration instanceof Angular2SourceDeclaration && ((Angular2SourceDeclaration)declaration).getTypeScriptClass().getName() != null) {
            fixes.add((LocalQuickFix)new AddNgModuleDeclarationQuickFix(context, (Angular2SourceDeclaration)declaration));
        }
    }

    private AddNgModuleDeclarationQuickFix(@NotNull PsiElement context, @NotNull Angular2SourceDeclaration declaration) {
        if (context == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(3);
        }
        if (declaration == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(4);
        }
        super(context);
        this.myDeclarationName = Objects.requireNonNull(declaration.getTypeScriptClass().getName());
        this.myDeclarationDecorator = SmartPointerManager.createPointer((PsiElement)declaration.getDecorator());
        List<Angular2Module> candidates = AddNgModuleDeclarationQuickFix.getCandidates(context);
        this.myModuleName = candidates.size() == 1 ? candidates.get(0).getName() : null;
    }

    @NotNull
    public String getText() {
        String string = Angular2Bundle.message(this.myModuleName == null ? "angular.quickfix.ngmodule.declare.name.choice" : "angular.quickfix.ngmodule.declare.name", this.myDeclarationName, this.myModuleName);
        if (string == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = Angular2Bundle.message("angular.quickfix.ngmodule.declare.family", new Object[0]);
        if (string == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(7);
        }
        if (file == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(10);
        }
        if (this.myDeclarationDecorator.getElement() == null) {
            return;
        }
        AddNgModuleDeclarationAction action = Angular2ActionFactory.createAddNgModuleDeclarationAction(editor, startElement, this.myDeclarationDecorator, this.myDeclarationName, this.getText(), false);
        List<JSElement> candidates = action.getCandidates();
        if (candidates.size() == 1 || editor != null) {
            action.execute();
        }
    }

    @NotNull
    public static List<Angular2Module> getCandidates(@NotNull PsiElement context) {
        if (context == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(11);
        }
        Queue processingQueue = new Queue(20);
        Angular2DeclarationsScope scope = new Angular2DeclarationsScope(context);
        Angular2Module contextModule = scope.getModule();
        if (contextModule == null || !scope.isInSource(contextModule)) {
            List<Angular2Module> list = Collections.emptyList();
            if (list == null) {
                AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(12);
            }
            return list;
        }
        processingQueue.addLast((Object)contextModule);
        HashSet<Angular2Module> processed = new HashSet<Angular2Module>();
        ArrayList<Angular2Module> result = new ArrayList<Angular2Module>();
        while (!processingQueue.isEmpty()) {
            Angular2Module module = (Angular2Module)processingQueue.pullFirst();
            if (!processed.add(module) || !scope.isInSource(module)) continue;
            result.add(module);
            module.getImports().forEach(arg_0 -> ((Queue)processingQueue).addLast(arg_0));
            for (Angular2Entity entity : module.getExports()) {
                if (!(entity instanceof Angular2Module)) continue;
                processingQueue.addLast((Object)((Angular2Module)entity));
            }
        }
        ArrayList<Angular2Module> arrayList = result;
        if (arrayList == null) {
            AddNgModuleDeclarationQuickFix.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/quickfixes/AddNgModuleDeclarationQuickFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/quickfixes/AddNgModuleDeclarationQuickFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCandidates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

