/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.FileResolverByContentKt;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;
import org.jetbrains.wip.WipScript;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a(\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u0018"}, d2={"possibleWrapperLengths", "", "", "[Ljava/lang/Integer;", "checkLength", "", "script", "Lorg/jetbrains/debugger/Script;", "fileLength", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "checkLineCount", "scriptLineCount", "fileLineCount", "url", "Lcom/intellij/util/Url;", "countLinesAndChars", "Lkotlin/Pair;", "isFileMatchingContent", "sourceContent", "", "project", "Lcom/intellij/openapi/project/Project;", "isFileMatchingScript", "intellij.javascript.debugger"})
public final class JSCachingFileFinderKt {
    private static final Integer[] possibleWrapperLengths = new Integer[]{0, 66, 65, 67, 63, 222};

    /*
     * WARNING - void declaration
     */
    public static final boolean isFileMatchingScript(@NotNull VirtualFile file2, @NotNull Script script) {
        void fileCount;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        if (file2.isDirectory()) {
            return false;
        }
        if (script.getLine() != 0) {
            return true;
        }
        int scriptLineCount = script.getEndLine();
        Pair<Integer, Integer> pair = JSCachingFileFinderKt.countLinesAndChars(file2);
        int n = ((Number)pair.component1()).intValue();
        int newLineCount = ((Number)pair.component2()).intValue();
        if (!JSCachingFileFinderKt.checkLineCount(scriptLineCount, newLineCount, file2, script.getUrl())) {
            return false;
        }
        return JSCachingFileFinderKt.checkLength(script, (int)fileCount, file2);
    }

    public static final boolean isFileMatchingContent(@NotNull VirtualFile file2, @NotNull String sourceContent, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)sourceContent, (String)"sourceContent");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (file2.isDirectory()) {
            return false;
        }
        return FileResolverByContentKt.selectMostSimilarFile((Collection)new SmartList((Object)file2), sourceContent, project) != null;
    }

    private static final boolean checkLineCount(int scriptLineCount, int fileLineCount, VirtualFile file2, Url url) {
        if (scriptLineCount < fileLineCount || scriptLineCount > fileLineCount + 2) {
            JavaScriptDebugProcessKt.getLOG().debug("Incorrect file " + file2.getCanonicalPath() + " found by url " + url + ": " + "script line count = " + scriptLineCount + ", " + "file line count = " + fileLineCount);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Pair<Integer, Integer> countLinesAndChars(VirtualFile file2) {
        int fileCount = 0;
        int newLineCount = 0;
        Closeable closeable = new BufferedReader(new InputStreamReader(file2.getInputStream(), file2.getCharset()));
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl2 = false;
            int c = reader.read();
            while (c != -1) {
                int n = fileCount;
                fileCount = n + 1;
                if (c == 10) {
                    n = newLineCount;
                    newLineCount = n + 1;
                }
                c = reader.read();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return new Pair((Object)fileCount, (Object)newLineCount);
    }

    private static final boolean checkLength(Script script, int fileLength, VirtualFile file2) {
        if (script.getUrl().isInLocalFileSystem()) {
            return true;
        }
        int sourceParam = ("\n//# sourceURL=" + script.getUrl()).length();
        if (script instanceof WipScript && !ArraysKt.contains((Object[])possibleWrapperLengths, (Object)(((WipScript)script).getLength() - fileLength)) && (!((WipScript)script).getHasSourceURL() || ((WipScript)script).getLength() - sourceParam != fileLength && ((WipScript)script).getLength() - sourceParam + 1 != fileLength)) {
            JavaScriptDebugProcessKt.getLOG().debug("Incorrect file " + file2.getCanonicalPath() + " found by url " + script.getUrl() + ": script.length = " + ((WipScript)script).getLength() + ", " + "file.length = " + file2.getLength());
            return false;
        }
        return true;
    }
}

