/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.console.ConsoleExecutionEditor;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.ActionsBundle;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.javascript.debugger.console.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.intellij.javascript.debugger.console.WebConsole;
import com.intellij.javascript.debugger.console.WebConsoleFilterForm;
import com.intellij.javascript.debugger.console.WebConsoleHistoryView;
import com.intellij.javascript.debugger.console.WebConsoleSearchSession;
import com.intellij.javascript.debugger.console.WebConsoleView;
import com.intellij.javascript.debugger.console.WebConsoleViewSettings;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.Url;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.OperationNotSupportedException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 \u00ac\u00012\u00020\u00012\u00020\u00022\u00020\u0003:(\u00ab\u0001\u00ac\u0001\u00ad\u0001\u00ae\u0001\u00af\u0001\u00b0\u0001\u00b1\u0001\u00b2\u0001\u00b3\u0001\u00b4\u0001\u00b5\u0001\u00b6\u0001\u00b7\u0001\u00b8\u0001\u00b9\u0001\u00ba\u0001\u00bb\u0001\u00bc\u0001\u00bd\u0001\u00be\u0001B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\n2\n\u0010(\u001a\u00060)R\u00020\u0000H\u0002J\u0010\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,H\u0016J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J \u00103\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00104\u001a\u0002022\u0006\u00105\u001a\u000206H\u0004J\b\u00107\u001a\u00020&H\u0016J\u0012\u00108\u001a\u00020&2\b\u00109\u001a\u0004\u0018\u00010:H\u0016J\b\u0010;\u001a\u000206H\u0016J\b\u0010<\u001a\u00020&H\u0002J\b\u0010=\u001a\u00020&H\u0016J\u0018\u0010>\u001a\u00020&2\u0006\u0010?\u001a\u00020.2\u0006\u0010@\u001a\u00020\u0001H\u0002J\u0013\u0010A\u001a\b\u0012\u0004\u0012\u00020C0BH\u0016\u00a2\u0006\u0002\u0010DJ\b\u0010E\u001a\u00020&H\u0016J\u0006\u0010F\u001a\u00020&J#\u0010G\u001a\b\u0012\u0004\u0012\u0002060H2\u0006\u0010I\u001a\u00020.2\u0006\u0010J\u001a\u000206H\u0000\u00a2\u0006\u0002\bKJ\b\u0010L\u001a\u00020&H\u0002J\b\u0010M\u001a\u00020NH\u0002J\b\u0010O\u001a\u00020PH\u0016J\b\u0010Q\u001a\u000202H\u0016J\b\u0010R\u001a\u00020\nH\u0016J\b\u0010S\u001a\u000202H\u0016J\b\u0010T\u001a\u00020UH\u0016J4\u0010V\u001a\u00020W2\n\b\u0002\u0010X\u001a\u0004\u0018\u00010\u000f2\u0016\b\u0002\u0010Y\u001a\u0010\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020&\u0018\u00010Z2\b\b\u0002\u0010[\u001a\u000206J\b\u0010\\\u001a\u00020]H\u0016J\b\u0010^\u001a\u0004\u0018\u00010\u0018J\b\u0010_\u001a\u000202H\u0016J\b\u0010`\u001a\u00020aH\u0016J\u0010\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0016J\b\u0010f\u001a\u00020PH\u0016J\b\u0010g\u001a\u00020hH\u0016J\n\u0010i\u001a\u0004\u0018\u00010.H\u0016J\r\u0010j\u001a\u00070k\u00a2\u0006\u0002\blH\u0016J\b\u0010m\u001a\u00020.H\u0016J\b\u0010n\u001a\u00020oH\u0016J\b\u0010p\u001a\u000206H\u0016J\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bqJ\b\u0010r\u001a\u00020&H\u0016J\b\u0010s\u001a\u000206H\u0016J\b\u0010t\u001a\u000206H\u0016J\b\u0010u\u001a\u000206H\u0016J\u0010\u0010v\u001a\u00020&2\u0006\u0010w\u001a\u00020\u000fH\u0016J\u0016\u0010x\u001a\u00020.2\u0006\u0010y\u001a\u0002062\u0006\u0010z\u001a\u000206J\u0018\u0010{\u001a\u00020&2\u0006\u0010I\u001a\u00020.2\u0006\u0010|\u001a\u00020kH\u0016J \u0010{\u001a\u00020&2\u0006\u0010I\u001a\u00020.2\u0006\u0010|\u001a\u00020k2\b\u0010}\u001a\u0004\u0018\u00010.J\u001c\u0010~\u001a\u00020&2\u0006\u0010\u007f\u001a\u00020.2\n\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0016J\u001b\u0010\u0082\u0001\u001a\u00020&2\u0006\u0010\u007f\u001a\u00020.2\n\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u0001J\u0013\u0010\u0083\u0001\u001a\u00020&2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0002J\u0018\u0010\u0086\u0001\u001a\u00020.2\u0007\u00101\u001a\u00030\u0087\u00012\u0006\u0010/\u001a\u000200J\u0012\u0010\u0088\u0001\u001a\u00020&2\u0007\u0010\u0089\u0001\u001a\u00020\nH\u0016J\t\u0010\u008a\u0001\u001a\u00020&H\u0002J\u000f\u0010\u008b\u0001\u001a\u00020&H\u0000\u00a2\u0006\u0003\b\u008c\u0001J\u000f\u0010\u008d\u0001\u001a\u00020&H\u0000\u00a2\u0006\u0003\b\u008e\u0001J\u000f\u0010\u008f\u0001\u001a\u00020&H\u0000\u00a2\u0006\u0003\b\u0090\u0001J\u0012\u0010\u0091\u0001\u001a\u00020&2\u0007\u0010\u0092\u0001\u001a\u000206H\u0016J\u000f\u0010\u0093\u0001\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0094\u0001\u001a\u00020&2\u0007\u0010\u0095\u0001\u001a\u000206H\u0016J\u0012\u0010\u0096\u0001\u001a\u00020&2\t\u0010\u0097\u0001\u001a\u0004\u0018\u00010\u0018J\u0012\u0010\u0098\u0001\u001a\u00020&2\u0007\u0010\u0099\u0001\u001a\u00020.H\u0016J\u0012\u0010\u009a\u0001\u001a\u00020&2\u0007\u0010\u009b\u0001\u001a\u00020.H\u0016J\u0012\u0010\u009c\u0001\u001a\u00020&2\u0007\u0010\u009d\u0001\u001a\u00020aH\u0016J\u0012\u0010\u009e\u0001\u001a\u00020&2\u0007\u0010\u009f\u0001\u001a\u000206H\u0016J\u0014\u0010\u00a0\u0001\u001a\u00020&2\t\u0010\u00a1\u0001\u001a\u0004\u0018\u00010.H\u0016J\u0012\u0010\u00a2\u0001\u001a\u00020&2\u0007\u0010\u00a3\u0001\u001a\u00020kH\u0016J\u0013\u0010\u00a4\u0001\u001a\u00020&2\b\u0010?\u001a\u0004\u0018\u00010.H\u0016J\t\u0010\u00a5\u0001\u001a\u00020&H\u0002J&\u0010\u00a6\u0001\u001a\u00020&2\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u00012\u0006\u0010|\u001a\u00020k2\u000b\b\u0002\u0010\u00a9\u0001\u001a\u0004\u0018\u00010.J\u0007\u0010\u00aa\u0001\u001a\u00020&R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00bf\u0001"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView;", "Ljavax/swing/JPanel;", "Lcom/intellij/execution/console/LanguageConsoleView;", "Lcom/intellij/javascript/debugger/console/WebConsole;", "helper", "Lcom/intellij/execution/console/LanguageConsoleImpl$Helper;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/execution/console/LanguageConsoleImpl$Helper;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "DEFAULT_FLUSH_DELAY", "", "consoleExecutionEditor", "Lcom/intellij/execution/console/ConsoleExecutionEditor;", "currentRequests", "Lgnu/trove/THashSet;", "Ljava/lang/Runnable;", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "deferredTasks", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "domPresentationProvider", "Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "executionPanel", "headerComponent", "Ljava/awt/Component;", "getHelper", "()Lcom/intellij/execution/console/LanguageConsoleImpl$Helper;", "historyView", "Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;", "searchSession", "Lcom/intellij/javascript/debugger/console/WebConsoleSearchSession;", "settings", "Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;", "getSettings$intellij_javascript_debugger", "()Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;", "swingAlarm", "Lcom/intellij/util/Alarm;", "addFlushRequest", "", "delay", "request", "Lcom/intellij/javascript/debugger/console/WebConsoleView$FlushRequest;", "addMessageFilter", "filter", "Lcom/intellij/execution/filters/Filter;", "addTextRangeToHistory", "", "textRange", "Lcom/intellij/openapi/util/TextRange;", "inputEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "addToHistoryInner", "editor", "erase", "", "allowHeavyFilters", "attachToProcess", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "canPause", "cancelAllFlushRequests", "clear", "createAndShowPopup", "title", "jPanel", "createConsoleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "dispose", "endTrace", "findText", "Lorg/jetbrains/concurrency/AsyncPromise;", "text", "caseSensitive", "findText$intellij_javascript_debugger", "flushDeferred", "getBorderColor", "Ljava/awt/Color;", "getComponent", "Ljavax/swing/JComponent;", "getConsoleEditor", "getContentSize", "getCurrentEditor", "getEditorDocument", "Lcom/intellij/openapi/editor/Document;", "getEvaluationCallback", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator$XEvaluationCallback;", "successHandler", "errorHandler", "Lkotlin/Function1;", "xmlView", "getFile", "Lcom/intellij/psi/PsiFile;", "getHeaderComponent", "getHistoryViewer", "getLanguage", "Lcom/intellij/lang/Language;", "getMessageBuilder", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "vm", "Lorg/jetbrains/debugger/Vm;", "getPreferredFocusableComponent", "getProject", "Lcom/intellij/openapi/project/Project;", "getPrompt", "getPromptAttributes", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "Lorg/jetbrains/annotations/NotNull;", "getTitle", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasDeferredOutput", "historyView$intellij_javascript_debugger", "increaseLastMessageRepeatCount", "isConsoleEditorEnabled", "isEditable", "isOutputPaused", "performWhenNoDeferredOutput", "runnable", "prepareExecuteAction", "addToHistory", "clearInput", "print", "contentType", "style", "printHyperlink", "hyperlinkText", "info", "Lcom/intellij/execution/filters/HyperlinkInfo;", "printMessageHyperlink", "printToken", "tokenInfo", "Lcom/intellij/javascript/debugger/console/WebConsoleView$TokenInfo;", "printWithHighlighting", "Lcom/intellij/openapi/editor/Editor;", "scrollTo", "offset", "scrollToEnd", "searchSessionStopped", "searchSessionStopped$intellij_javascript_debugger", "selectNextFindResult", "selectNextFindResult$intellij_javascript_debugger", "selectPrevFindResult", "selectPrevFindResult$intellij_javascript_debugger", "setConsoleEditorEnabled", "consoleEditorEnabled", "setDOMViewHandler", "setEditable", "editable", "setHeaderComponent", "header", "setHelpId", "helpId", "setInputText", "inputText", "setLanguage", "language", "setOutputPaused", "value", "setPrompt", "prompt", "setPromptAttributes", "textAttributes", "setTitle", "showFiltersPopup", "startMessage", "type", "Lcom/intellij/javascript/debugger/console/WebConsoleView$MessageType;", "source", "startTrace", "ClearAllAction", "Companion", "DOMNode", "DOMPresentationProvider", "DeferredToken", "FilterAction", "FlushRequest", "HyperLink", "IconHolder", "LinkType", "MessageBuilder", "MessageType", "Node", "PrintRunnable", "ScrollToTheEndToolbarAction", "SearchAction", "SoftWrapsAction", "TokenInfo", "TreeRoot", "Variable", "intellij.javascript.debugger"})
public final class WebConsoleView
extends JPanel
implements LanguageConsoleView,
WebConsole {
    private final int DEFAULT_FLUSH_DELAY;
    private final ConsoleExecutionEditor consoleExecutionEditor;
    private final JPanel executionPanel;
    @NotNull
    private final WebConsoleViewSettings settings;
    private final WebConsoleHistoryView historyView;
    private final Alarm swingAlarm;
    private final THashSet<Runnable> currentRequests;
    private final ConcurrentLinkedQueue<Runnable> deferredTasks;
    private Component headerComponent;
    private WebConsoleSearchSession searchSession;
    private DOMPresentationProvider domPresentationProvider;
    @NotNull
    private final LanguageConsoleImpl.Helper helper;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    private static final String INDENT = "  ";
    @NotNull
    private static final UrlFilter urlFilter;
    public static final Companion Companion;

    @NotNull
    public final WebConsoleViewSettings getSettings$intellij_javascript_debugger() {
        return this.settings;
    }

    private final Color getBorderColor() {
        return UIUtil.isUnderDarcula() ? new Color(58, 58, 58) : new Color(240, 240, 240);
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    public void clear() {
        this.deferredTasks.clear();
        this.cancelAllFlushRequests();
        this.swingAlarm.addRequest(new Runnable(this){
            final /* synthetic */ WebConsoleView this$0;

            public final void run() {
                WebConsoleView.access$getHistoryView$p(this.this$0).clear();
            }
            {
                this.this$0 = webConsoleView;
            }
        }, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancelAllFlushRequests() {
        THashSet<Runnable> tHashSet = this.currentRequests;
        boolean bl = false;
        int n = 0;
        synchronized (tHashSet) {
            boolean bl2 = false;
            this.currentRequests.clear();
            n = this.swingAlarm.cancelAllRequests();
        }
    }

    public void scrollTo(int offset) {
        throw (Throwable)new UnsupportedOperationException();
    }

    public void attachToProcess(@Nullable ProcessHandler processHandler) {
        throw (Throwable)new UnsupportedOperationException();
    }

    public void setOutputPaused(boolean value) {
        throw (Throwable)new UnsupportedOperationException();
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return this.deferredTasks.size() > 0;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
    }

    public void setHelpId(@NotNull String helpId) {
        Intrinsics.checkParameterIsNotNull((Object)helpId, (String)"helpId");
        throw (Throwable)new UnsupportedOperationException();
    }

    public void addMessageFilter(@NotNull Filter filter) {
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        throw (Throwable)new UnsupportedOperationException();
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)hyperlinkText, (String)"hyperlinkText");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
        HyperLink token = new HyperLink(hyperlinkText, consoleViewContentType, info, LinkType.SOURCE);
        this.printToken(token);
    }

    public final void printMessageHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)hyperlinkText, (String)"hyperlinkText");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
        HyperLink token = new HyperLink(hyperlinkText, consoleViewContentType, info, LinkType.MESSAGE);
        this.printToken(token);
    }

    public int getContentSize() {
        return 1;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        SoftWrapsAction switchSoftWrapsAction = new SoftWrapsAction();
        SearchAction searchAction = new SearchAction();
        searchAction.registerCustomShortcutSet(this.getComponent(), (Disposable)this);
        ScrollToTheEndToolbarAction scrollAction = new ScrollToTheEndToolbarAction(this.historyView);
        return new AnAction[]{(AnAction)scrollAction, (AnAction)new ClearAllAction(this), (AnAction)new FilterAction()};
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        EditorEx editorEx = this.consoleExecutionEditor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"consoleExecutionEditor.editor");
        JComponent jComponent = editorEx.getContentComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"consoleExecutionEditor.editor.contentComponent");
        return jComponent;
    }

    public boolean canPause() {
        return false;
    }

    public void allowHeavyFilters() {
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public final WebConsoleHistoryView historyView$intellij_javascript_debugger() {
        return this.historyView;
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        this.print(text, contentType, null);
    }

    public final void print(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable String style) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        if (Intrinsics.areEqual((Object)text, (Object)"\u200c")) {
            WebConsoleView.startMessage$default(this, MessageType.EVAL_OUT, contentType, null, 4, null);
        } else {
            this.printToken(new TokenInfo(text, contentType, null, style, false, 20, null));
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.helper.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"helper.project");
        return project;
    }

    @NotNull
    public String getTitle() {
        String string = this.helper.getTitle();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"helper.title");
        return string;
    }

    public void setTitle(@Nullable String title) {
        this.helper.setTitle(title);
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.helper.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"helper.file");
        return psiFile;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.consoleExecutionEditor.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"consoleExecutionEditor.virtualFile");
        return virtualFile;
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = this.consoleExecutionEditor.getCurrentEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"consoleExecutionEditor.currentEditor");
        return editorEx;
    }

    @NotNull
    public EditorEx getConsoleEditor() {
        EditorEx editorEx = this.consoleExecutionEditor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"consoleExecutionEditor.editor");
        return editorEx;
    }

    @NotNull
    public Document getEditorDocument() {
        Document document = this.consoleExecutionEditor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"consoleExecutionEditor.document");
        return document;
    }

    @NotNull
    public EditorEx getHistoryViewer() {
        throw (Throwable)new OperationNotSupportedException();
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getFile().getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"file.language");
        return language;
    }

    public void setLanguage(@NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        this.helper.setLanguage(language);
        this.helper.getFileSafe();
    }

    @Nullable
    public String getPrompt() {
        return this.consoleExecutionEditor.getPrompt();
    }

    @NotNull
    public ConsoleViewContentType getPromptAttributes() {
        ConsoleViewContentType consoleViewContentType = this.consoleExecutionEditor.getPromptAttributes();
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"consoleExecutionEditor.promptAttributes");
        return consoleViewContentType;
    }

    public void setPromptAttributes(@NotNull ConsoleViewContentType textAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)textAttributes, (String)"textAttributes");
        this.consoleExecutionEditor.setPromptAttributes(textAttributes);
    }

    public void setPrompt(@Nullable String prompt) {
        this.consoleExecutionEditor.setPrompt(prompt);
    }

    public void setEditable(boolean editable) {
        this.consoleExecutionEditor.setEditable(editable);
    }

    public boolean isEditable() {
        return this.consoleExecutionEditor.isEditable();
    }

    public void setInputText(@NotNull String inputText) {
        Intrinsics.checkParameterIsNotNull((Object)inputText, (String)"inputText");
        DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(this, inputText){
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ String $inputText;

            public final void run() {
                WebConsoleView.access$getConsoleExecutionEditor$p(this.this$0).getDocument().setText((CharSequence)StringUtil.convertLineSeparators((String)this.$inputText));
            }
            {
                this.this$0 = webConsoleView;
                this.$inputText = string;
            }
        });
    }

    public void setConsoleEditorEnabled(boolean consoleEditorEnabled) {
        if (this.isConsoleEditorEnabled() == consoleEditorEnabled) {
            return;
        }
        if (consoleEditorEnabled) {
            FileEditorManager.getInstance((Project)this.helper.project).closeFile(this.helper.virtualFile);
        }
        this.executionPanel.setVisible(consoleEditorEnabled);
    }

    public boolean isConsoleEditorEnabled() {
        return this.executionPanel.isVisible();
    }

    @NotNull
    public final String prepareExecuteAction(boolean addToHistory, boolean clearInput) {
        EditorEx editor = this.getCurrentEditor();
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)documentEx, (String)"editor.document");
        DocumentEx document = documentEx;
        String string = document.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.text");
        String text = string;
        TextRange range = new TextRange(0, document.getTextLength());
        if (!clearInput) {
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
        if (addToHistory) {
            this.addToHistoryInner(range, editor, clearInput);
        } else if (clearInput) {
            this.setInputText("");
        }
        return text;
    }

    @NotNull
    protected final String addToHistoryInner(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean erase) {
        Intrinsics.checkParameterIsNotNull((Object)textRange, (String)"textRange");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        ApplicationManager.getApplication().assertIsDispatchThread();
        String result2 = this.addTextRangeToHistory(textRange, editor);
        if (erase) {
            DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(editor, textRange){
                final /* synthetic */ EditorEx $editor;
                final /* synthetic */ TextRange $textRange;

                public final void run() {
                    this.$editor.getDocument().deleteString(this.$textRange.getStartOffset(), this.$textRange.getEndOffset());
                }
                {
                    this.$editor = editorEx;
                    this.$textRange = textRange;
                }
            });
        }
        this.scrollToEnd();
        return result2;
    }

    private final void scrollToEnd() {
        this.swingAlarm.addRequest(new Runnable(this){
            final /* synthetic */ WebConsoleView this$0;

            public final void run() {
                WebConsoleView.access$getHistoryView$p(this.this$0).scrollToEnd();
            }
            {
                this.this$0 = webConsoleView;
            }
        }, 0);
    }

    @NotNull
    public final String printWithHighlighting(@NotNull Editor inputEditor, @NotNull TextRange textRange) {
        Intrinsics.checkParameterIsNotNull((Object)inputEditor, (String)"inputEditor");
        Intrinsics.checkParameterIsNotNull((Object)textRange, (String)"textRange");
        String text = null;
        EditorHighlighter highlighter = null;
        if (inputEditor instanceof EditorWindow) {
            PsiFile psiFile = ((EditorWindow)inputEditor).getInjectedFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"inputEditor.injectedFile");
            PsiFile file2 = psiFile;
            VirtualFile virtualFile = file2.getVirtualFile();
            EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
            EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((VirtualFile)virtualFile, (EditorColorsScheme)editorColorsManager.getGlobalScheme(), (Project)this.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)editorHighlighter, (String)"HighlighterFactory.creat\u2026().globalScheme, project)");
            highlighter = editorHighlighter;
            String fullText = InjectedLanguageUtil.getUnescapedText((PsiFile)file2, null, null);
            highlighter.setText((CharSequence)fullText);
            String string = textRange.substring(fullText);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"textRange.substring(fullText)");
            text = string;
        } else {
            String string = inputEditor.getDocument().getText(textRange);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inputEditor.document.getText(textRange)");
            text = string;
            EditorHighlighter editorHighlighter = ((EditorEx)inputEditor).getHighlighter();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorHighlighter, (String)"(inputEditor as EditorEx).highlighter");
            highlighter = editorHighlighter;
        }
        SyntaxHighlighter syntax = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.USER_INPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.USER_INPUT");
        WebConsoleView.startMessage$default(this, MessageType.EVAL_IN, consoleViewContentType, null, 4, null);
        if (syntax != null) {
            ConsoleViewUtil.printWithHighlighting((ConsoleView)((ConsoleView)this), (String)text, (SyntaxHighlighter)syntax);
        } else {
            ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.USER_INPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"ConsoleViewContentType.USER_INPUT");
            this.print(text, consoleViewContentType2);
        }
        return text;
    }

    @NotNull
    public final String addTextRangeToHistory(@NotNull TextRange textRange, @NotNull EditorEx inputEditor) {
        Intrinsics.checkParameterIsNotNull((Object)textRange, (String)"textRange");
        Intrinsics.checkParameterIsNotNull((Object)inputEditor, (String)"inputEditor");
        return this.printWithHighlighting((Editor)inputEditor, textRange);
    }

    @Override
    public void increaseLastMessageRepeatCount() {
        this.deferredTasks.add(new Runnable(this){
            final /* synthetic */ WebConsoleView this$0;

            public final void run() {
                WebConsoleView.access$getHistoryView$p(this.this$0).increaseLastMessageRepeatCount();
            }
            {
                this.this$0 = webConsoleView;
            }
        });
        this.addFlushRequest(this.DEFAULT_FLUSH_DELAY, new FlushRequest());
    }

    @Override
    @NotNull
    public ConsoleMessageBuilder getMessageBuilder(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        return new MessageBuilder(this.debugProcess, vm);
    }

    private final void printToken(TokenInfo tokenInfo) {
        this.deferredTasks.add(new PrintRunnable(tokenInfo));
        boolean shouldFlushNow = tokenInfo.getContentType() == ConsoleViewContentType.USER_INPUT;
        int delay = shouldFlushNow ? 0 : this.DEFAULT_FLUSH_DELAY;
        this.addFlushRequest(delay, new FlushRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addFlushRequest(int delay, FlushRequest request) {
        THashSet<Runnable> tHashSet = this.currentRequests;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (tHashSet) {
            boolean bl3 = false;
            if (!this.swingAlarm.isDisposed() && this.currentRequests.add((Object)request)) {
                this.swingAlarm.addRequest((Runnable)request, delay);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void flushDeferred() {
        boolean bl = false;
        List tasks = new ArrayList();
        Runnable task = null;
        do {
            task = this.deferredTasks.poll();
            while (task instanceof PrintRunnable && this.deferredTasks.peek() instanceof PrintRunnable) {
                Runnable runnable = this.deferredTasks.poll();
                if (runnable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.console.WebConsoleView.PrintRunnable");
                }
                ((PrintRunnable)task).appendTokens(((PrintRunnable)runnable).getTokens());
            }
            if (task == null) continue;
            tasks.add(task);
        } while (task != null);
        this.historyView.runInBatch((Function0<Unit>)((Function0)new Function0<Unit>(tasks){
            final /* synthetic */ List $tasks;

            public final void invoke() {
                Iterable $this$forEach$iv = this.$tasks;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Runnable it = (Runnable)element$iv;
                    boolean bl = false;
                    it.run();
                }
            }
            {
                this.$tasks = list;
                super(0);
            }
        }));
    }

    public void dispose() {
        FileEditorManager editorManager;
        this.swingAlarm.cancelAllRequests();
        this.deferredTasks.clear();
        this.remove(this.historyView.getComponent());
        Project project = this.helper.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"helper.project");
        if (project.isOpen() && (editorManager = FileEditorManager.getInstance((Project)this.helper.project)).isFileOpen(this.helper.virtualFile)) {
            editorManager.closeFile(this.helper.virtualFile);
        }
    }

    private final void showFiltersPopup() {
        WebConsoleFilterForm filterForm = new WebConsoleFilterForm();
        filterForm.reset(this.settings);
        filterForm.addListener(new WebConsoleFilterForm.FilterListener(this, filterForm){
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ WebConsoleFilterForm $filterForm;

            public void filtersChanged() {
                WebConsoleView.access$getHistoryView$p(this.this$0).updateFromFilterSettingsUI(this.$filterForm);
            }

            public void filtersResetRequested() {
                WebConsoleView.access$getHistoryView$p(this.this$0).resetAllFilters();
                this.$filterForm.reset(this.this$0.getSettings$intellij_javascript_debugger());
            }
            {
                this.this$0 = $outer;
                this.$filterForm = $captured_local_variable$1;
            }
        });
        String string = JSDebuggerBundle.message("js.console.filter.title", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSDebuggerBundle.message\u2026js.console.filter.title\")");
        JPanel jPanel = filterForm.getMainPanel();
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"filterForm.mainPanel");
        this.createAndShowPopup(string, jPanel);
    }

    private final void createAndShowPopup(String title, JPanel jPanel) {
        Rectangle visibleRect = this.getComponent().getVisibleRect();
        Point topLeft = new Point(this.getComponent().getLocationOnScreen().x + visibleRect.x, this.getComponent().getLocationOnScreen().y + visibleRect.y);
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)jPanel, null).setProject(this.getProject()).setTitle(title).setMovable(true).setRequestFocus(true).createPopup().show(RelativePoint.fromScreen((Point)topLeft));
    }

    public final void setDOMViewHandler(@NotNull DOMPresentationProvider domPresentationProvider) {
        Intrinsics.checkParameterIsNotNull((Object)domPresentationProvider, (String)"domPresentationProvider");
        this.domPresentationProvider = domPresentationProvider;
        this.historyView.setDomPresentationProvider$intellij_javascript_debugger(domPresentationProvider);
    }

    @NotNull
    public final XDebuggerEvaluator.XEvaluationCallback getEvaluationCallback(@Nullable Runnable successHandler2, @Nullable Function1<? super String, Unit> errorHandler, boolean xmlView) {
        return new XDebuggerEvaluator.XEvaluationCallback(this, errorHandler, successHandler2, xmlView){
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ Function1 $errorHandler;
            final /* synthetic */ Runnable $successHandler;
            final /* synthetic */ boolean $xmlView;

            public void errorOccurred(@NotNull String errorMessage) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                    Function1 function1 = this.$errorHandler;
                    if (function1 == null) break block0;
                    Unit cfr_ignored_0 = (Unit)function1.invoke((Object)errorMessage);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void evaluated(@NotNull XValue result2) {
                block9: {
                    Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
                    Runnable runnable = this.$successHandler;
                    if (runnable != null) {
                        runnable.run();
                    }
                    if (!(result2 instanceof VariableView)) break block9;
                    Value value = ((VariableView)result2).getValue();
                    if (value != null) {
                        void contentType;
                        Value value2 = value;
                        boolean bl = false;
                        boolean bl2 = false;
                        Value value3 = value2;
                        boolean bl3 = false;
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(JavaScriptDebuggerConsoleExecuteActionHandler.Companion.getValueKey(value3));
                        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.g\u2026ndler.getValueKey(value))");
                        objectRef.element = consoleViewContentType;
                        TokenInfo tokenInfo = null;
                        if (value3.getType() == ValueType.NODE && WebConsoleView.access$getDomPresentationProvider$p(this.this$0) != null && this.$xmlView) {
                            DOMPresentationProvider dOMPresentationProvider = WebConsoleView.access$getDomPresentationProvider$p(this.this$0);
                            if (dOMPresentationProvider == null) {
                                Intrinsics.throwNpe();
                            }
                            Promise<ItemPresentation> promise2 = dOMPresentationProvider.getNodePresentation(value3);
                            tokenInfo = new DeferredToken((Promise<TokenInfo>)(promise2 != null ? promise2.then((Function)new Function<T, SUB_RESULT>((Ref.ObjectRef)contentType, this, result2){
                                final /* synthetic */ Ref.ObjectRef $contentType;
                                final /* synthetic */ getEvaluationCallback.1 this$0;
                                final /* synthetic */ XValue $result$inlined;
                                {
                                    this.$contentType = objectRef;
                                    this.this$0 = var2_2;
                                    this.$result$inlined = xValue;
                                }

                                @Nullable
                                public final DOMNode fun(@Nullable ItemPresentation itemPresentation) {
                                    DOMNode dOMNode;
                                    ItemPresentation itemPresentation2 = itemPresentation;
                                    if (itemPresentation2 != null) {
                                        ItemPresentation itemPresentation3 = itemPresentation2;
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        ItemPresentation it = itemPresentation3;
                                        boolean bl3 = false;
                                        DOMPresentationProvider dOMPresentationProvider = WebConsoleView.access$getDomPresentationProvider$p(this.this$0.this$0);
                                        if (dOMPresentationProvider == null) {
                                            Intrinsics.throwNpe();
                                        }
                                        dOMNode = DOMNode.Companion.createDOMNode(itemPresentation, dOMPresentationProvider, (ConsoleViewContentType)this.$contentType.element);
                                    } else {
                                        dOMNode = null;
                                    }
                                    return dOMNode;
                                }
                            }) : null), new TreeRoot(((VariableView)result2).getVariableName(), (ConsoleViewContentType)contentType.element, (VariableView)result2, this.this$0, null, 16, null));
                        } else if (value3 instanceof ObjectValue) {
                            tokenInfo = new TreeRoot(((VariableView)result2).getVariableName(), (ConsoleViewContentType)contentType.element, (VariableView)result2, this.this$0, null, 16, null);
                        } else {
                            String text;
                            String string = value3.getValueString();
                            if (string == null) {
                                string = text = "undefined";
                            }
                            if (Intrinsics.areEqual((Object)text, (Object)"undefined")) {
                                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.getConsoleViewType(ConsolePrinter.Companion.getCONSOLE_INFO_KEY());
                                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"ConsoleViewContentType.g\u2026Printer.CONSOLE_INFO_KEY)");
                                contentType.element = consoleViewContentType2;
                            }
                            tokenInfo = new TokenInfo(text, (ConsoleViewContentType)contentType.element, null, null, false, 28, null);
                        }
                        WebConsoleView.access$printToken(this.this$0, tokenInfo);
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$errorHandler = $captured_local_variable$1;
                this.$successHandler = $captured_local_variable$2;
                this.$xmlView = $captured_local_variable$3;
            }
        };
    }

    public static /* synthetic */ XDebuggerEvaluator.XEvaluationCallback getEvaluationCallback$default(WebConsoleView webConsoleView, Runnable runnable, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            runnable = null;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return webConsoleView.getEvaluationCallback(runnable, (Function1<? super String, Unit>)function1, bl);
    }

    @Nullable
    public final Component getHeaderComponent() {
        return this.headerComponent;
    }

    public final void setHeaderComponent(@Nullable Component header) {
        if (this.headerComponent != null) {
            this.remove(this.headerComponent);
        }
        if (header != null) {
            this.add(header, "North");
        }
        this.revalidate();
        this.repaint();
        this.headerComponent = header;
    }

    public final void selectPrevFindResult$intellij_javascript_debugger() {
        this.swingAlarm.addRequest(new Runnable(this){
            final /* synthetic */ WebConsoleView this$0;

            public final void run() {
                WebConsoleView.access$getHistoryView$p(this.this$0).selectPrevFindItem();
            }
            {
                this.this$0 = webConsoleView;
            }
        }, 0);
    }

    public final void selectNextFindResult$intellij_javascript_debugger() {
        this.swingAlarm.addRequest(new Runnable(this){
            final /* synthetic */ WebConsoleView this$0;

            public final void run() {
                WebConsoleView.access$getHistoryView$p(this.this$0).selectNextFindItem();
            }
            {
                this.this$0 = webConsoleView;
            }
        }, 0);
    }

    @NotNull
    public final AsyncPromise<Boolean> findText$intellij_javascript_debugger(@NotNull String text, boolean caseSensitive) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        AsyncPromise result2 = new AsyncPromise();
        this.swingAlarm.addRequest(new Runnable(this, text, caseSensitive, result2){
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ boolean $caseSensitive;
            final /* synthetic */ AsyncPromise $result;

            public final void run() {
                WebConsoleView.access$getHistoryView$p(this.this$0).findText(this.$text, this.$caseSensitive, (AsyncPromise<Boolean>)this.$result);
            }
            {
                this.this$0 = webConsoleView;
                this.$text = string;
                this.$caseSensitive = bl;
                this.$result = asyncPromise;
            }
        }, 0);
        return result2;
    }

    public final void searchSessionStopped$intellij_javascript_debugger() {
        this.searchSession = null;
    }

    public final void startMessage(@NotNull MessageType type, @NotNull ConsoleViewContentType contentType, @Nullable String source) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        this.deferredTasks.add(new Runnable(this, contentType, source, type){
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ ConsoleViewContentType $contentType;
            final /* synthetic */ String $source;
            final /* synthetic */ MessageType $type;

            public final void run() {
                String string;
                StringBuilder stringBuilder;
                String level;
                block5: {
                    block4: {
                        ConsoleViewContentType consoleViewContentType;
                        level = "level-" + (Intrinsics.areEqual((Object)(consoleViewContentType = this.$contentType), (Object)ConsoleViewContentType.LOG_ERROR_OUTPUT) || Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.ERROR_OUTPUT) ? "error" : (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.LOG_WARNING_OUTPUT) ? "warning" : (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.LOG_INFO_OUTPUT) ? "info" : (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.LOG_DEBUG_OUTPUT) ? "debug" : "log"))));
                        stringBuilder = new StringBuilder().append("source-");
                        string = this.$source;
                        if (string == null) break block4;
                        String string2 = string;
                        StringBuilder stringBuilder2 = stringBuilder;
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.toLowerCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                        String string5 = string4;
                        stringBuilder = stringBuilder2;
                        string = string5;
                        if (string != null) break block5;
                    }
                    string = "default";
                }
                String src = stringBuilder.append((Object)string).toString();
                WebConsoleView.access$getHistoryView$p(this.this$0).startMessage(this.$type, level, src);
            }
            {
                this.this$0 = webConsoleView;
                this.$contentType = consoleViewContentType;
                this.$source = string;
                this.$type = messageType;
            }
        });
    }

    public static /* synthetic */ void startMessage$default(WebConsoleView webConsoleView, MessageType messageType, ConsoleViewContentType consoleViewContentType, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        webConsoleView.startMessage(messageType, consoleViewContentType, string);
    }

    public final void startTrace() {
        this.deferredTasks.add(new Runnable(this){
            final /* synthetic */ WebConsoleView this$0;

            public final void run() {
                WebConsoleView.access$getHistoryView$p(this.this$0).startTrace();
            }
            {
                this.this$0 = webConsoleView;
            }
        });
    }

    public final void endTrace() {
        this.deferredTasks.add(new Runnable(this){
            final /* synthetic */ WebConsoleView this$0;

            public final void run() {
                WebConsoleView.access$getHistoryView$p(this.this$0).endTrace();
            }
            {
                this.this$0 = webConsoleView;
            }
        });
    }

    @NotNull
    public final LanguageConsoleImpl.Helper getHelper() {
        return this.helper;
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public WebConsoleView(@NotNull LanguageConsoleImpl.Helper helper2, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)helper2, (String)"helper");
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        super(new BorderLayout());
        this.helper = helper2;
        this.debugProcess = debugProcess;
        this.DEFAULT_FLUSH_DELAY = SystemProperties.getIntProperty((String)"console.flush.delay.ms", (int)200);
        this.consoleExecutionEditor = new ConsoleExecutionEditor(this.helper);
        this.executionPanel = new JPanel(new BorderLayout());
        this.settings = new WebConsoleViewSettings();
        Project project = this.helper.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"helper.project");
        this.historyView = new WebConsoleHistoryView(project, this.settings);
        this.swingAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.currentRequests = new THashSet();
        this.deferredTasks = new ConcurrentLinkedQueue();
        this.helper.setupEditor(this.consoleExecutionEditor.getEditor());
        this.consoleExecutionEditor.initComponent();
        this.consoleExecutionEditor.setPrompt((String)null);
        EditorEx editorEx = this.consoleExecutionEditor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"consoleExecutionEditor.editor");
        editorEx.getGutter().closeAllAnnotations();
        this.add(this.historyView.getComponent(), "Center");
        this.add((Component)this.executionPanel, "South");
        this.executionPanel.add(this.consoleExecutionEditor.getComponent());
        Icon icon = AllIcons.Debugger.PromptInput;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Debugger.PromptInput");
        EditorEx editorEx2 = this.consoleExecutionEditor.getCurrentEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx2, (String)"consoleExecutionEditor.currentEditor");
        EditorColorsScheme editorColorsScheme = editorEx2.getColorsScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"consoleExecutionEditor.currentEditor.colorsScheme");
        final IconHolder iconHolder = new IconHolder(icon, editorColorsScheme);
        this.executionPanel.add((Component)iconHolder, "West");
        this.executionPanel.setBorder((Border)new CustomLineBorder(this.getBorderColor(), 1, 0, 0, 0));
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme2 = editorColorsManager.getGlobalScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme2, (String)"EditorColorsManager.getInstance().globalScheme");
        this.setBackground(editorColorsScheme2.getDefaultBackground());
        this.getProject().getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public final void globalSchemeChange(@Nullable EditorColorsScheme newScheme) {
                EditorColorsScheme editorColorsScheme = newScheme;
                if (editorColorsScheme == null) {
                    EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
                    editorColorsScheme = editorColorsManager.getGlobalScheme();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"newScheme ?: EditorColor\u2026etInstance().globalScheme");
                EditorColorsScheme scheme = editorColorsScheme;
                this.setBackground(scheme.getDefaultBackground());
                iconHolder.updateScheme(scheme);
                executionPanel.setBorder((Border)new CustomLineBorder(this.getBorderColor(), 1, 0, 0, 0));
            }
        });
        this.historyView.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(@Nullable KeyEvent event) {
                if (this.isConsoleEditorEnabled()) {
                    KeyEvent keyEvent = event;
                    if (keyEvent == null) {
                        Intrinsics.throwNpe();
                    }
                    if (UIUtil.isReallyTypedEvent((KeyEvent)keyEvent)) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(this){
                            final /* synthetic */ 2 this$0;

                            public final void run() {
                                IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
                                EditorEx editorEx = WebConsoleView.access$getConsoleExecutionEditor$p(this.this$0.this).getEditor();
                                Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"consoleExecutionEditor.editor");
                                ideFocusManager.requestFocus((Component)editorEx.getContentComponent(), true);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        consoleExecutionEditor.getEditor().processKeyTyped(event);
                    }
                }
            }
        });
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.consoleExecutionEditor));
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.historyView);
    }

    static {
        Companion = new Companion(null);
        urlFilter = new UrlFilter();
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getDeferredTasks$p(WebConsoleView $this) {
        return $this.deferredTasks;
    }

    public static final /* synthetic */ DOMPresentationProvider access$getDomPresentationProvider$p(WebConsoleView $this) {
        return $this.domPresentationProvider;
    }

    public static final /* synthetic */ void access$setDomPresentationProvider$p(WebConsoleView $this, DOMPresentationProvider dOMPresentationProvider) {
        $this.domPresentationProvider = dOMPresentationProvider;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\b\u0010\r\u001a\u00020\nH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$PrintRunnable;", "Ljava/lang/Runnable;", "token", "Lcom/intellij/javascript/debugger/console/WebConsoleView$TokenInfo;", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;Lcom/intellij/javascript/debugger/console/WebConsoleView$TokenInfo;)V", "tokens", "", "getTokens", "()Ljava/util/List;", "appendTokens", "", "t", "", "run", "intellij.javascript.debugger"})
    private final class PrintRunnable
    implements Runnable {
        @NotNull
        private final List<TokenInfo> tokens;

        @NotNull
        public final List<TokenInfo> getTokens() {
            return this.tokens;
        }

        @Override
        public void run() {
            WebConsoleView.this.historyView.flush(this.tokens);
        }

        public final void appendTokens(@NotNull List<? extends TokenInfo> t) {
            Intrinsics.checkParameterIsNotNull(t, (String)"t");
            this.tokens.addAll((Collection<TokenInfo>)t);
        }

        public PrintRunnable(TokenInfo token) {
            Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
            this.tokens = CollectionsKt.mutableListOf((Object[])new TokenInfo[]{token});
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$FilterAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/Toggleable;", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.javascript.debugger"})
    public final class FilterAction
    extends DumbAwareAction
    implements Toggleable {
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)WebConsoleView.this.getSettings$intellij_javascript_debugger().areFiltersApplied());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            WebConsoleView.this.showFiltersPopup();
        }

        public FilterAction() {
            super(JSDebuggerBundle.message("js.console.filter.popup", new Object[0]), null, AllIcons.General.Filter);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$SearchAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.javascript.debugger"})
    public final class SearchAction
    extends AnAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (WebConsoleView.this.searchSession == null) {
                WebConsoleView.this.searchSession = new WebConsoleSearchSession(WebConsoleView.this, WebConsoleView.this.getProject());
            }
        }

        public SearchAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Find");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$ClearAllAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "consoleView", "Lcom/intellij/javascript/debugger/console/WebConsoleView;", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.javascript.debugger"})
    public static final class ClearAllAction
    extends DumbAwareAction {
        private final WebConsoleView consoleView;

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(this.consoleView.getContentSize() > 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            this.consoleView.clear();
        }

        public ClearAllAction(@NotNull WebConsoleView consoleView) {
            Intrinsics.checkParameterIsNotNull((Object)consoleView, (String)"consoleView");
            super(ExecutionBundle.message((String)"clear.all.from.console.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"clear.all.from.console.action.description", (Object[])new Object[0]), AllIcons.Actions.GC);
            this.consoleView = consoleView;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$SoftWrapsAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.javascript.debugger"})
    public final class SoftWrapsAction
    extends ToggleAction {
        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return WebConsoleView.this.historyView.getUseSoftWraps();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (WebConsoleView.this.historyView.getUseSoftWraps() != state) {
                WebConsoleView.this.historyView.setUseSoftWraps(state);
            }
            EditorEx editorEx = WebConsoleView.this.consoleExecutionEditor.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"consoleExecutionEditor.editor");
            EditorSettings editorSettings = editorEx.getSettings();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorSettings, (String)"consoleExecutionEditor.editor.settings");
            if (editorSettings.isUseSoftWraps() != state) {
                EditorEx editorEx2 = WebConsoleView.this.consoleExecutionEditor.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editorEx2, (String)"consoleExecutionEditor.editor");
                EditorSettings editorSettings2 = editorEx2.getSettings();
                Intrinsics.checkExpressionValueIsNotNull((Object)editorSettings2, (String)"consoleExecutionEditor.editor.settings");
                editorSettings2.setUseSoftWraps(state);
            }
        }

        public SoftWrapsAction() {
            ActionUtil.copyFrom((AnAction)((AnAction)this), (String)"EditorToggleUseSoftWraps");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$ScrollToTheEndToolbarAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "historyView", "Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;", "(Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.javascript.debugger"})
    public static final class ScrollToTheEndToolbarAction
    extends ToggleAction
    implements DumbAware {
        private final WebConsoleHistoryView historyView;

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return this.historyView.isStickToEnd();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            this.historyView.setStickToEnd(state);
        }

        public ScrollToTheEndToolbarAction(@NotNull WebConsoleHistoryView historyView) {
            Intrinsics.checkParameterIsNotNull((Object)historyView, (String)"historyView");
            this.historyView = historyView;
            String message = ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]);
            Presentation presentation = this.getTemplatePresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
            presentation.setDescription(message);
            Presentation presentation2 = this.getTemplatePresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"templatePresentation");
            presentation2.setText(message);
            this.getTemplatePresentation().setIcon(AllIcons.RunConfigurations.Scroll_down);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0004J\u0013\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$FlushRequest;", "Ljava/lang/Runnable;", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;)V", "doRun", "", "equals", "", "other", "", "hashCode", "", "run", "intellij.javascript.debugger"})
    private final class FlushRequest
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.doRun();
            THashSet tHashSet = WebConsoleView.this.currentRequests;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (tHashSet) {
                boolean bl3 = false;
                bl2 = WebConsoleView.this.currentRequests.remove((Object)this);
            }
        }

        protected final void doRun() {
            WebConsoleView.this.flushDeferred();
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other != null && Intrinsics.areEqual(this.getClass(), other.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\b\u0010\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$TokenInfo;", "", "text", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "coloredText", "Lcom/intellij/ui/SimpleColoredText;", "userStyle", "cached", "", "(Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleViewContentType;Lcom/intellij/ui/SimpleColoredText;Ljava/lang/String;Z)V", "getCached", "()Z", "getColoredText", "()Lcom/intellij/ui/SimpleColoredText;", "getContentType", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "getUserStyle", "intellij.javascript.debugger"})
    public static class TokenInfo {
        @NotNull
        private String text;
        @NotNull
        private final ConsoleViewContentType contentType;
        @Nullable
        private final SimpleColoredText coloredText;
        @Nullable
        private final String userStyle;
        private final boolean cached;

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void setText(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.text = string;
        }

        @NotNull
        public final ConsoleViewContentType getContentType() {
            return this.contentType;
        }

        @Nullable
        public final SimpleColoredText getColoredText() {
            return this.coloredText;
        }

        @Nullable
        public final String getUserStyle() {
            return this.userStyle;
        }

        public final boolean getCached() {
            return this.cached;
        }

        public TokenInfo(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable SimpleColoredText coloredText, @Nullable String userStyle, boolean cached) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            this.text = text;
            this.contentType = contentType;
            this.coloredText = coloredText;
            this.userStyle = userStyle;
            this.cached = cached;
        }

        public /* synthetic */ TokenInfo(String string, ConsoleViewContentType consoleViewContentType, SimpleColoredText simpleColoredText, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                simpleColoredText = null;
            }
            if ((n & 8) != 0) {
                string2 = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(string, consoleViewContentType, simpleColoredText, string2, bl);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u0001R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$DeferredToken;", "Lcom/intellij/javascript/debugger/console/WebConsoleView$TokenInfo;", "promise", "Lorg/jetbrains/concurrency/Promise;", "default", "(Lorg/jetbrains/concurrency/Promise;Lcom/intellij/javascript/debugger/console/WebConsoleView$TokenInfo;)V", "getDefault", "()Lcom/intellij/javascript/debugger/console/WebConsoleView$TokenInfo;", "getPromise", "()Lorg/jetbrains/concurrency/Promise;", "get", "intellij.javascript.debugger"})
    public static final class DeferredToken
    extends TokenInfo {
        @Nullable
        private final Promise<TokenInfo> promise;
        @NotNull
        private final TokenInfo default;

        @NotNull
        public final TokenInfo get() {
            Object object;
            try {
                Object object2 = this.promise;
                if (object2 == null || (object2 = (TokenInfo)object2.blockingGet(300, TimeUnit.MILLISECONDS)) == null) {
                    object2 = this.default;
                }
                object = object2;
            }
            catch (TimeoutException e) {
                object = this.default;
            }
            return object;
        }

        @Nullable
        public final Promise<TokenInfo> getPromise() {
            return this.promise;
        }

        @NotNull
        public final TokenInfo getDefault() {
            return this.default;
        }

        public DeferredToken(@Nullable Promise<TokenInfo> promise2, @NotNull TokenInfo tokenInfo) {
            Intrinsics.checkParameterIsNotNull((Object)tokenInfo, (String)"default");
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
            super("", consoleViewContentType, null, null, false, 28, null);
            this.promise = promise2;
            this.default = tokenInfo;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b \u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH&J\b\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$Node;", "Lcom/intellij/javascript/debugger/console/WebConsoleView$TokenInfo;", "text", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "coloredText", "Lcom/intellij/ui/SimpleColoredText;", "(Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleViewContentType;Lcom/intellij/ui/SimpleColoredText;)V", "getIcon", "Ljavax/swing/Icon;", "hasIcon", "", "intellij.javascript.debugger"})
    public static abstract class Node
    extends TokenInfo {
        @Nullable
        public abstract Icon getIcon();

        public abstract boolean hasIcon();

        public Node(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable SimpleColoredText coloredText) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            super(text, contentType, coloredText, null, true, 8, null);
        }

        public /* synthetic */ Node(String string, ConsoleViewContentType consoleViewContentType, SimpleColoredText simpleColoredText, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                simpleColoredText = null;
            }
            this(string, consoleViewContentType, simpleColoredText);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u000eJ\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$TreeRoot;", "Lcom/intellij/javascript/debugger/console/WebConsoleView$Node;", "text", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "variableView", "Lorg/jetbrains/debugger/VariableView;", "console", "Lcom/intellij/javascript/debugger/console/WebConsoleView;", "coloredText", "Lcom/intellij/ui/SimpleColoredText;", "(Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleViewContentType;Lorg/jetbrains/debugger/VariableView;Lcom/intellij/javascript/debugger/console/WebConsoleView;Lcom/intellij/ui/SimpleColoredText;)V", "rootNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "getRootNode", "()Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "rootNode$delegate", "Lkotlin/Lazy;", "getIcon", "Ljavax/swing/Icon;", "getRoot", "hasIcon", "", "intellij.javascript.debugger"})
    public static final class TreeRoot
    extends Node {
        @NotNull
        private final Lazy rootNode$delegate;
        private final VariableView variableView;

        @Override
        @Nullable
        public Icon getIcon() {
            return null;
        }

        @Override
        public boolean hasIcon() {
            return false;
        }

        @NotNull
        public final XDebuggerTreeNode getRootNode() {
            Lazy lazy = this.rootNode$delegate;
            TreeRoot treeRoot = this;
            Object var3_3 = null;
            boolean bl = false;
            return (XDebuggerTreeNode)lazy.getValue();
        }

        @NotNull
        public final XDebuggerTreeNode getRoot() {
            return this.getRootNode();
        }

        public TreeRoot(@NotNull String text, @NotNull ConsoleViewContentType contentType, @NotNull VariableView variableView, @NotNull WebConsoleView console, @Nullable SimpleColoredText coloredText) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)variableView, (String)"variableView");
            Intrinsics.checkParameterIsNotNull((Object)console, (String)"console");
            super(text, contentType, coloredText);
            this.variableView = variableView;
            this.rootNode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XValueNodeImpl>(this, console){
                final /* synthetic */ TreeRoot this$0;
                final /* synthetic */ WebConsoleView $console;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final XValueNodeImpl invoke() {
                    void var2_2;
                    Project project = this.$console.getProject();
                    XDebuggerEditorsProvider xDebuggerEditorsProvider = this.$console.getDebugProcess().getEditorsProvider();
                    XDebugSession xDebugSession = this.$console.getDebugProcess().getSession();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"console.debugProcess.session");
                    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"com/intellij/javascript/debugger/console/WebConsoleView$TreeRoot$rootNode$2$HeadlessDebuggerTree", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "project", "Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "pos", "Lcom/intellij/xdebugger/XSourcePosition;", "popupActionGroupId", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;Lcom/intellij/xdebugger/XSourcePosition;Ljava/lang/String;)V", "intellij.javascript.debugger"})
                    public final class HeadlessDebuggerTree
                    extends XDebuggerTree {
                        public HeadlessDebuggerTree(@NotNull Project project, @NotNull XDebuggerEditorsProvider provider, @Nullable XSourcePosition pos, @NotNull String popupActionGroupId) {
                            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
                            Intrinsics.checkParameterIsNotNull((Object)popupActionGroupId, (String)"popupActionGroupId");
                            super(project, provider, pos, popupActionGroupId, null);
                            this.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

                                public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                                    Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
                                }
                            });
                        }
                    }
                    HeadlessDebuggerTree tree = new HeadlessDebuggerTree(project, xDebuggerEditorsProvider, xDebugSession.getCurrentPosition(), "XDebugger.Inspect.Tree.Popup");
                    XDebuggerTree xDebuggerTree = tree;
                    Value value = TreeRoot.access$getVariableView$p(this.this$0).getValue();
                    if (value == null) {
                        Intrinsics.throwNpe();
                    }
                    XValueNodeImpl root = new XValueNodeImpl(xDebuggerTree, null, value.getValueString(), (XValue)TreeRoot.access$getVariableView$p(this.this$0));
                    tree.setRoot((XDebuggerTreeNode)root, false);
                    tree.setSelectionRow(0);
                    tree.expandNodesOnLoad((Condition)new Condition<TreeNode>(root){
                        final /* synthetic */ XValueNodeImpl $root;

                        public final boolean value(TreeNode node) {
                            return node == this.$root;
                        }
                        {
                            this.$root = xValueNodeImpl;
                        }
                    });
                    Disposer.register((Disposable)((Disposable)this.$console), (Disposable)((Disposable)tree));
                    return var2_2;
                }
                {
                    this.this$0 = treeRoot;
                    this.$console = webConsoleView;
                    super(0);
                }
            }));
        }

        public /* synthetic */ TreeRoot(String string, ConsoleViewContentType consoleViewContentType, VariableView variableView, WebConsoleView webConsoleView, SimpleColoredText simpleColoredText, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                simpleColoredText = null;
            }
            this(string, consoleViewContentType, variableView, webConsoleView, simpleColoredText);
        }

        public static final /* synthetic */ VariableView access$getVariableView$p(TreeRoot $this) {
            return $this.variableView;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u0012J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMNode;", "Lcom/intellij/javascript/debugger/console/WebConsoleView$Node;", "text", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "node", "Lcom/intellij/navigation/ItemPresentation;", "provider", "Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "coloredText", "Lcom/intellij/ui/SimpleColoredText;", "(Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleViewContentType;Lcom/intellij/navigation/ItemPresentation;Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;Lcom/intellij/ui/SimpleColoredText;)V", "getNode", "()Lcom/intellij/navigation/ItemPresentation;", "getProvider", "()Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "getChildren", "", "getIcon", "Ljavax/swing/Icon;", "hasChildren", "", "hasIcon", "Companion", "intellij.javascript.debugger"})
    public static final class DOMNode
    extends Node {
        @NotNull
        private final ItemPresentation node;
        @NotNull
        private final DOMPresentationProvider provider;
        public static final Companion Companion = new Companion(null);

        @Override
        public boolean hasIcon() {
            boolean $i$f$runReadAction = false;
            return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ DOMNode this$0;
                {
                    this.this$0 = dOMNode;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)Boolean.valueOf(this.this$0.getNode().getIcon(true) != null);
                }
            });
        }

        @Override
        @Nullable
        public Icon getIcon() {
            boolean $i$f$runReadAction = false;
            return (Icon)ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ DOMNode this$0;
                {
                    this.this$0 = dOMNode;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.this$0.getNode().getIcon(true);
                }
            });
        }

        public final boolean hasChildren() {
            boolean $i$f$runReadAction = false;
            return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ DOMNode this$0;
                {
                    this.this$0 = dOMNode;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)Boolean.valueOf(this.this$0.getProvider().hasChildren(this.this$0.getNode()));
                }
            });
        }

        @NotNull
        public final List<DOMNode> getChildren() {
            boolean $i$f$runReadAction = false;
            return (List)ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ DOMNode this$0;
                {
                    this.this$0 = dOMNode;
                }

                /*
                 * WARNING - void declaration
                 */
                public final T compute() {
                    void $this$mapTo$iv$iv;
                    boolean bl = false;
                    Iterable $this$map$iv = this.this$0.getProvider().getChildren(this.this$0.getNode());
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ItemPresentation itemPresentation = (ItemPresentation)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        DOMNode dOMNode = DOMNode.Companion.createDOMNode((ItemPresentation)it, this.this$0.getProvider(), this.this$0.getContentType());
                        collection.add(dOMNode);
                    }
                    return (T)((List)destination$iv$iv);
                }
            });
        }

        @NotNull
        public final ItemPresentation getNode() {
            return this.node;
        }

        @NotNull
        public final DOMPresentationProvider getProvider() {
            return this.provider;
        }

        public DOMNode(@NotNull String text, @NotNull ConsoleViewContentType contentType, @NotNull ItemPresentation node, @NotNull DOMPresentationProvider provider, @Nullable SimpleColoredText coloredText) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            super(text, contentType, coloredText);
            this.node = node;
            this.provider = provider;
        }

        public /* synthetic */ DOMNode(String string, ConsoleViewContentType consoleViewContentType, ItemPresentation itemPresentation, DOMPresentationProvider dOMPresentationProvider, SimpleColoredText simpleColoredText, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                simpleColoredText = null;
            }
            this(string, consoleViewContentType, itemPresentation, dOMPresentationProvider, simpleColoredText);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMNode$Companion;", "", "()V", "createDOMNode", "Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMNode;", "item", "Lcom/intellij/navigation/ItemPresentation;", "provider", "Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "intellij.javascript.debugger"})
        public static final class Companion {
            @NotNull
            public final DOMNode createDOMNode(@NotNull ItemPresentation item, @NotNull DOMPresentationProvider provider, @NotNull ConsoleViewContentType contentType) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
                Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
                boolean $i$f$runReadAction = false;
                return (DOMNode)ApplicationManager.getApplication().runReadAction(new Computable<T>(item, contentType, provider){
                    final /* synthetic */ ItemPresentation $item$inlined;
                    final /* synthetic */ ConsoleViewContentType $contentType$inlined;
                    final /* synthetic */ DOMPresentationProvider $provider$inlined;
                    {
                        this.$item$inlined = itemPresentation;
                        this.$contentType$inlined = consoleViewContentType;
                        this.$provider$inlined = dOMPresentationProvider;
                    }

                    public final T compute() {
                        String string;
                        boolean bl = false;
                        String string2 = this.$item$inlined.getPresentableText();
                        if (string2 == null) {
                            string2 = "";
                        }
                        SimpleColoredText coloredText = new SimpleColoredText(string2, SimpleTextAttributes.fromTextAttributes((TextAttributes)this.$contentType$inlined.getAttributes()));
                        if (this.$item$inlined.getLocationString() != null) {
                            coloredText.append(" " + this.$item$inlined.getLocationString(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        }
                        if ((string = this.$item$inlined.getPresentableText()) == null) {
                            string = "";
                        }
                        return (T)new DOMNode(string, this.$contentType$inlined, this.$item$inlined, this.$provider$inlined, coloredText);
                    }
                });
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$Variable;", "Lcom/intellij/javascript/debugger/console/WebConsoleView$Node;", "text", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "variable", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "coloredText", "Lcom/intellij/ui/SimpleColoredText;", "(Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleViewContentType;Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;Lcom/intellij/ui/SimpleColoredText;)V", "getVariable", "()Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "getIcon", "Ljavax/swing/Icon;", "hasIcon", "", "intellij.javascript.debugger"})
    public static final class Variable
    extends Node {
        @NotNull
        private final XDebuggerTreeNode variable;

        @Override
        public boolean hasIcon() {
            boolean $i$f$runReadAction = false;
            return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ Variable this$0;
                {
                    this.this$0 = variable;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)Boolean.valueOf(this.this$0.getVariable().getIcon() != null);
                }
            });
        }

        @Override
        @Nullable
        public Icon getIcon() {
            boolean $i$f$runReadAction = false;
            return (Icon)ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ Variable this$0;
                {
                    this.this$0 = variable;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.this$0.getVariable().getIcon();
                }
            });
        }

        @NotNull
        public final XDebuggerTreeNode getVariable() {
            return this.variable;
        }

        public Variable(@NotNull String text, @NotNull ConsoleViewContentType contentType, @NotNull XDebuggerTreeNode variable, @Nullable SimpleColoredText coloredText) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
            super(text, contentType, coloredText);
            this.variable = variable;
        }

        public /* synthetic */ Variable(String string, ConsoleViewContentType consoleViewContentType, XDebuggerTreeNode xDebuggerTreeNode, SimpleColoredText simpleColoredText, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                simpleColoredText = null;
            }
            this(string, consoleViewContentType, xDebuggerTreeNode, simpleColoredText);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$HyperLink;", "Lcom/intellij/javascript/debugger/console/WebConsoleView$TokenInfo;", "text", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "hyperlink", "Lcom/intellij/execution/filters/HyperlinkInfo;", "linkType", "Lcom/intellij/javascript/debugger/console/WebConsoleView$LinkType;", "(Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleViewContentType;Lcom/intellij/execution/filters/HyperlinkInfo;Lcom/intellij/javascript/debugger/console/WebConsoleView$LinkType;)V", "getHyperlink", "()Lcom/intellij/execution/filters/HyperlinkInfo;", "getLinkType", "()Lcom/intellij/javascript/debugger/console/WebConsoleView$LinkType;", "intellij.javascript.debugger"})
    public static final class HyperLink
    extends TokenInfo {
        @Nullable
        private final HyperlinkInfo hyperlink;
        @NotNull
        private final LinkType linkType;

        @Nullable
        public final HyperlinkInfo getHyperlink() {
            return this.hyperlink;
        }

        @NotNull
        public final LinkType getLinkType() {
            return this.linkType;
        }

        public HyperLink(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable HyperlinkInfo hyperlink, @NotNull LinkType linkType) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)((Object)linkType), (String)"linkType");
            super(text, contentType, null, null, true, 12, null);
            this.hyperlink = hyperlink;
            this.linkType = linkType;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$LinkType;", "", "(Ljava/lang/String;I)V", "BROWSER", "SOURCE", "MESSAGE", "intellij.javascript.debugger"})
    public static final class LinkType
    extends Enum<LinkType> {
        public static final /* enum */ LinkType BROWSER;
        public static final /* enum */ LinkType SOURCE;
        public static final /* enum */ LinkType MESSAGE;
        private static final /* synthetic */ LinkType[] $VALUES;

        static {
            LinkType[] linkTypeArray = new LinkType[3];
            LinkType[] linkTypeArray2 = linkTypeArray;
            linkTypeArray[0] = BROWSER = new LinkType();
            linkTypeArray[1] = SOURCE = new LinkType();
            linkTypeArray[2] = MESSAGE = new LinkType();
            $VALUES = linkTypeArray;
        }

        public static LinkType[] values() {
            return (LinkType[])$VALUES.clone();
        }

        public static LinkType valueOf(String string) {
            return Enum.valueOf(LinkType.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0004H&J\u001a\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004H&J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004H&\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "", "getChildren", "", "Lcom/intellij/navigation/ItemPresentation;", "node", "getNodePresentation", "Lorg/jetbrains/concurrency/Promise;", "v", "Lorg/jetbrains/debugger/values/Value;", "hasChildren", "", "hideHighlight", "", "highlight", "intellij.javascript.debugger"})
    public static interface DOMPresentationProvider {
        @Nullable
        public Promise<ItemPresentation> getNodePresentation(@NotNull Value var1);

        public boolean hasChildren(@NotNull ItemPresentation var1);

        @NotNull
        public List<ItemPresentation> getChildren(@NotNull ItemPresentation var1);

        public void highlight(@NotNull ItemPresentation var1);

        public void hideHighlight(@NotNull ItemPresentation var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$MessageType;", "", "(Ljava/lang/String;I)V", "EVAL_IN", "EVAL_OUT", "LOG", "intellij.javascript.debugger"})
    public static final class MessageType
    extends Enum<MessageType> {
        public static final /* enum */ MessageType EVAL_IN;
        public static final /* enum */ MessageType EVAL_OUT;
        public static final /* enum */ MessageType LOG;
        private static final /* synthetic */ MessageType[] $VALUES;

        static {
            MessageType[] messageTypeArray = new MessageType[3];
            MessageType[] messageTypeArray2 = messageTypeArray;
            messageTypeArray[0] = EVAL_IN = new MessageType();
            messageTypeArray[1] = EVAL_OUT = new MessageType();
            messageTypeArray[2] = LOG = new MessageType();
            $VALUES = messageTypeArray;
        }

        public static MessageType[] values() {
            return (MessageType[])$VALUES.clone();
        }

        public static MessageType valueOf(String string) {
            return Enum.valueOf(MessageType.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0015\u0010\u0018\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$IconHolder;", "Ljavax/swing/JComponent;", "icon", "Ljavax/swing/Icon;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "(Ljavax/swing/Icon;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "getIcon", "()Ljavax/swing/Icon;", "scaledIcon", "getScheme", "()Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "setScheme", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "getFontMetrics", "Ljava/awt/FontMetrics;", "getLineHeight", "", "getPreferredSize", "Ljava/awt/Dimension;", "paint", "", "g", "Ljava/awt/Graphics;", "scaleIcon", "Lorg/jetbrains/annotations/NotNull;", "colorsScheme", "updateScheme", "intellij.javascript.debugger"})
    public static final class IconHolder
    extends JComponent {
        private Icon scaledIcon;
        @NotNull
        private final Icon icon;
        @NotNull
        private EditorColorsScheme scheme;

        public final void updateScheme(@NotNull EditorColorsScheme colorsScheme) {
            Intrinsics.checkParameterIsNotNull((Object)colorsScheme, (String)"colorsScheme");
            this.scheme = colorsScheme;
            this.scaledIcon = this.scaleIcon(colorsScheme);
        }

        private final Icon scaleIcon(EditorColorsScheme colorsScheme) {
            Icon icon = IconUtil.scaleByFont((Icon)this.icon, (Component)this, (float)colorsScheme.getConsoleFontSize());
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"IconUtil.scaleByFont(ico\u2026onsoleFontSize.toFloat())");
            return icon;
        }

        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
            Rectangle clip = g.getClipBounds();
            g.setColor(this.scheme.getDefaultBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            this.scaledIcon.paintIcon(null, g, 0, this.getLineHeight() / 2 - this.scaledIcon.getIconHeight() / 2);
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            return new Dimension(this.scaledIcon.getIconWidth(), this.getLineHeight());
        }

        public final int getLineHeight() {
            FontMetrics fontMetrics = this.getFontMetrics();
            return (int)((float)fontMetrics.getHeight() * this.scheme.getConsoleLineSpacing());
        }

        @NotNull
        public final FontMetrics getFontMetrics() {
            Font font = this.scheme.getFont(EditorFontType.CONSOLE_PLAIN);
            Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"scheme.getFont(EditorFontType.CONSOLE_PLAIN)");
            Font schemeFont = font;
            FontMetrics fontMetrics = this.getFontMetrics(schemeFont);
            Intrinsics.checkExpressionValueIsNotNull((Object)fontMetrics, (String)"this.getFontMetrics(schemeFont)");
            return fontMetrics;
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        @NotNull
        public final EditorColorsScheme getScheme() {
            return this.scheme;
        }

        public final void setScheme(@NotNull EditorColorsScheme editorColorsScheme) {
            Intrinsics.checkParameterIsNotNull((Object)editorColorsScheme, (String)"<set-?>");
            this.scheme = editorColorsScheme;
        }

        public IconHolder(@NotNull Icon icon, @NotNull EditorColorsScheme scheme) {
            Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
            Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
            this.icon = icon;
            this.scheme = scheme;
            this.scaledIcon = this.scaleIcon(this.scheme);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J<\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J\"\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0016J*\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0002J*\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0002JJ\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0004\u0012\u00020\n0\u001f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\"\u001a\u00020\bH\u0016J\u0006\u0010#\u001a\u00020\bJ,\u0010$\u001a\u00020\n2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\fH\u0002J\b\u0010+\u001a\u00020\bH\u0016J\u0018\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u0010H\u0016J\u0010\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\u001aH\u0016J*\u00101\u001a\u00020\b2\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u0010H\u0016J\b\u00106\u001a\u00020\bH\u0016J\u001a\u00107\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u001a\u0010:\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010;\u001a\u0004\u0018\u00010\nH\u0016J\u0006\u0010<\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$MessageBuilder;", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "messageVm", "Lorg/jetbrains/debugger/Vm;", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lorg/jetbrains/debugger/Vm;)V", "addHyperLink", "", "url", "", "suggestedLine", "", "suggestedColumn", "functionName", "resolveToScript", "", "scriptId", "addMessageLink", "append", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "style", "applyAnsiFilter", "it", "Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "applyUrlFilter", "textChunk", "chunkContentType", "createLinkInfo", "Lkotlin/Pair;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "doPrintIndent", "endMessage", "endTrace", "getLinkText", "parsedUrl", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "rawUrl", "line", "groupEnd", "groupStart", "groupName", "collapsed", "print", "consolePrinter", "printAndStoreValueToInspect", "value", "Lorg/jetbrains/debugger/values/Value;", "expression", "xmlView", "printIndent", "printStackTrace", "stackTrace", "Lorg/jetbrains/wip/protocol/runtime/StackTraceValue;", "startMessage", "source", "startTrace", "intellij.javascript.debugger"})
    public final class MessageBuilder
    extends ConsoleMessageBuilder {
        private final Vm messageVm;

        @Override
        public void startMessage(@NotNull ConsoleViewContentType contentType, @Nullable String source) {
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            this.getTasks().add(new Consumer<ConsolePrinter>(this, contentType, source){
                final /* synthetic */ MessageBuilder this$0;
                final /* synthetic */ ConsoleViewContentType $contentType;
                final /* synthetic */ String $source;

                public final void consume(ConsolePrinter it) {
                    this.this$0.WebConsoleView.this.startMessage(MessageType.LOG, this.$contentType, this.$source);
                }
                {
                    this.this$0 = messageBuilder;
                    this.$contentType = consoleViewContentType;
                    this.$source = string;
                }
            });
        }

        @Override
        public void endMessage() {
        }

        @Override
        public void printIndent() {
            this.getTasks().add(new Consumer<ConsolePrinter>(this){
                final /* synthetic */ MessageBuilder this$0;

                public final void consume(ConsolePrinter it) {
                    ConsolePrinter consolePrinter = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)consolePrinter, (String)"it");
                    MessageBuilder.access$doPrintIndent(this.this$0, consolePrinter);
                }
                {
                    this.this$0 = messageBuilder;
                }
            });
        }

        private final void doPrintIndent(ConsolePrinter it) {
            int l = it.getIndentLevel$intellij_javascript_debugger();
            while (l-- > 0) {
                ConsoleView consoleView = it.getConsoleView$intellij_javascript_debugger();
                if (consoleView == null) {
                    Intrinsics.throwNpe();
                }
                consoleView.print(WebConsoleView.INDENT, ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        }

        @Override
        public void groupStart(@NotNull String groupName, boolean collapsed) {
            Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
            this.getTasks().add(new Consumer<ConsolePrinter>(this, groupName, collapsed){
                final /* synthetic */ MessageBuilder this$0;
                final /* synthetic */ String $groupName;
                final /* synthetic */ boolean $collapsed;

                public final void consume(ConsolePrinter it) {
                    WebConsoleView.access$getDeferredTasks$p(this.this$0.WebConsoleView.this).add(new Runnable(this){
                        final /* synthetic */ groupStart.1 this$0;

                        public final void run() {
                            WebConsoleView.access$getHistoryView$p(this.this$0.this$0.WebConsoleView.this).startGroup(this.this$0.$groupName, this.this$0.$collapsed);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = messageBuilder;
                    this.$groupName = string;
                    this.$collapsed = bl;
                }
            });
        }

        @Override
        public void groupEnd() {
            this.getTasks().add(new Consumer<ConsolePrinter>(this){
                final /* synthetic */ MessageBuilder this$0;

                public final void consume(ConsolePrinter it) {
                    WebConsoleView.access$getDeferredTasks$p(this.this$0.WebConsoleView.this).add(new Runnable(this){
                        final /* synthetic */ groupEnd.1 this$0;

                        public final void run() {
                            WebConsoleView.access$getHistoryView$p(this.this$0.this$0.WebConsoleView.this).endGroup();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = messageBuilder;
                }
            });
        }

        @Override
        public void append(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable String style) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            this.getTasks().add(new Consumer<ConsolePrinter>(this, text, contentType, style){
                final /* synthetic */ MessageBuilder this$0;
                final /* synthetic */ String $text;
                final /* synthetic */ ConsoleViewContentType $contentType;
                final /* synthetic */ String $style;

                public final void consume(ConsolePrinter it) {
                    ConsolePrinter consolePrinter = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)consolePrinter, (String)"it");
                    MessageBuilder.access$applyAnsiFilter(this.this$0, this.$text, consolePrinter, this.$contentType, this.$style);
                }
                {
                    this.this$0 = messageBuilder;
                    this.$text = string;
                    this.$contentType = consoleViewContentType;
                    this.$style = string2;
                }
            });
        }

        private final void applyAnsiFilter(String text, ConsolePrinter it, ConsoleViewContentType contentType, String style) {
            AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
            decoder.escapeText(text, ProcessOutputTypes.STDOUT, new AnsiEscapeDecoder.ColoredTextAcceptor(this, contentType, it, style){
                final /* synthetic */ MessageBuilder this$0;
                final /* synthetic */ ConsoleViewContentType $contentType;
                final /* synthetic */ ConsolePrinter $it;
                final /* synthetic */ String $style;

                public final void coloredTextAvailable(@NotNull String textChunk, @NotNull Key<Object> attributes) {
                    Intrinsics.checkParameterIsNotNull((Object)textChunk, (String)"textChunk");
                    Intrinsics.checkParameterIsNotNull(attributes, (String)"attributes");
                    ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(attributes);
                    Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.g\u2026nsoleViewType(attributes)");
                    ConsoleViewContentType ansiChunkContentType = consoleViewContentType;
                    ConsoleViewContentType finalContentType = Intrinsics.areEqual((Object)this.$contentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT) ^ true && Intrinsics.areEqual((Object)ansiChunkContentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT) ? this.$contentType : ansiChunkContentType;
                    MessageBuilder.access$applyUrlFilter(this.this$0, textChunk, this.$it, finalContentType, this.$style);
                }
                {
                    this.this$0 = messageBuilder;
                    this.$contentType = consoleViewContentType;
                    this.$it = consolePrinter;
                    this.$style = string;
                }
            });
        }

        private final void applyUrlFilter(String textChunk, ConsolePrinter it, ConsoleViewContentType chunkContentType, String style) {
            boolean bl;
            int n;
            Object object;
            int curOffset = 0;
            ConsoleView consoleView = it.getConsoleView$intellij_javascript_debugger();
            if (consoleView == null) {
                Intrinsics.throwNpe();
            }
            if (consoleView == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.console.WebConsoleView");
            }
            WebConsoleView webConsoleView = (WebConsoleView)consoleView;
            Filter.Result result2 = Companion.getUrlFilter().applyFilter(textChunk, textChunk.length());
            if (result2 != null) {
                object = result2;
                n = 0;
                bl = false;
                Filter.Result result3 = object;
                boolean bl2 = false;
                Filter.Result result4 = result3;
                Intrinsics.checkExpressionValueIsNotNull((Object)result4, (String)"result");
                for (Filter.ResultItem resultItem : result4.getResultItems()) {
                    String linkText;
                    boolean bl3;
                    int start = resultItem.getHighlightStartOffset();
                    int end = resultItem.getHighlightEndOffset();
                    if (start < 0 || end < start || end > textChunk.length()) continue;
                    if (curOffset < start) {
                        String string;
                        String string2 = textChunk;
                        int n2 = curOffset;
                        WebConsoleView webConsoleView2 = webConsoleView;
                        bl3 = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n2, start), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        webConsoleView2.print(string, chunkContentType, style);
                    }
                    String string = textChunk;
                    bl3 = false;
                    String string4 = string;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(start, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    if (resultItem.getHyperlinkInfo() != null) {
                        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                        HyperlinkInfo hyperlinkInfo = resultItem.getHyperlinkInfo();
                        if (hyperlinkInfo == null) {
                            Intrinsics.throwNpe();
                        }
                        HyperLink tokenInfo = new HyperLink(linkText, consoleViewContentType, hyperlinkInfo, LinkType.BROWSER);
                        webConsoleView.printToken(tokenInfo);
                    } else {
                        webConsoleView.print(linkText, chunkContentType, style);
                    }
                    curOffset = end;
                }
            }
            if (curOffset < textChunk.length()) {
                object = textChunk;
                n = curOffset;
                WebConsoleView webConsoleView3 = webConsoleView;
                bl = false;
                Object object2 = object;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string = ((String)object2).substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                String string5 = string;
                webConsoleView3.print(string5, chunkContentType, style);
            }
        }

        @Override
        public void printStackTrace(@NotNull ConsoleViewContentType contentType, @Nullable StackTraceValue stackTrace) {
            StackTraceValue currentStackTrace;
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            if (stackTrace == null) {
                return;
            }
            if (stackTrace.callFrames().isEmpty() || Intrinsics.areEqual((Object)"undefined", (Object)((CallFrameValue)CollectionsKt.first((List)stackTrace.callFrames())).url())) {
                return;
            }
            printStackTrace.1 $fun$frameName$1 = printStackTrace.1.INSTANCE;
            int max = -1;
            for (currentStackTrace = stackTrace; currentStackTrace != null; currentStackTrace = currentStackTrace.getParent()) {
                max = Math.max(max, currentStackTrace.callFrames().stream().mapToInt(printStackTrace.2.INSTANCE).max().orElse(0));
            }
            this.startTrace();
            for (currentStackTrace = stackTrace; currentStackTrace != null; currentStackTrace = currentStackTrace.getParent()) {
                if (Intrinsics.areEqual((Object)currentStackTrace, (Object)stackTrace) ^ true) {
                    String string = JSDebuggerBundle.message("js.frame.async", currentStackTrace.getDescription());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSDebuggerBundle.message\u2026ntStackTrace.description)");
                    ConsoleMessageBuilder.append$default(this, string, contentType, null, 4, null);
                    this.newLine();
                }
                for (CallFrameValue frame : currentStackTrace.callFrames()) {
                    String functionName = $fun$frameName$1.invoke(frame);
                    ConsoleMessageBuilder.append$default(this, functionName, contentType, null, 4, null);
                    String string = StringUtil.repeatSymbol((char)' ', (int)(max - functionName.length()));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.repeatSymbol(\u2026ax - functionName.length)");
                    ConsoleMessageBuilder.append$default(this, string, null, null, 6, null);
                    ConsoleMessageBuilder.append$default(this, "\t", contentType, null, 4, null);
                    this.addHyperLink(frame.url(), frame.getLineNumber(), frame.getColumnNumber(), frame.functionName(), true, frame.scriptId());
                    this.newLine();
                }
            }
            this.endTrace();
        }

        public final void startTrace() {
            this.getTasks().add(new Consumer<ConsolePrinter>(this){
                final /* synthetic */ MessageBuilder this$0;

                public final void consume(ConsolePrinter it) {
                    this.this$0.WebConsoleView.this.startTrace();
                }
                {
                    this.this$0 = messageBuilder;
                }
            });
        }

        public final void endTrace() {
            this.getTasks().add(new Consumer<ConsolePrinter>(this){
                final /* synthetic */ MessageBuilder this$0;

                public final void consume(ConsolePrinter it) {
                    this.this$0.WebConsoleView.this.endTrace();
                }
                {
                    this.this$0 = messageBuilder;
                }
            });
        }

        @Override
        public void printAndStoreValueToInspect(@NotNull Value value, @Nullable String expression, @NotNull ConsoleViewContentType contentType, boolean xmlView) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            this.getTasks().add(new Consumer<ConsolePrinter>(this, value, xmlView, expression){
                final /* synthetic */ MessageBuilder this$0;
                final /* synthetic */ Value $value;
                final /* synthetic */ boolean $xmlView;
                final /* synthetic */ String $expression;

                public final void consume(ConsolePrinter it) {
                    String string;
                    if (this.$value instanceof ObjectValue) {
                        string = VariableViewKt.getObjectValueDescription((ObjectValue)((ObjectValue)this.$value));
                    } else {
                        string = this.$value.getValueString();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                    }
                    String valueString = string;
                    XDebuggerEvaluator.XEvaluationCallback xEvaluationCallback = WebConsoleView.getEvaluationCallback$default(this.this$0.WebConsoleView.this, null, null, this.$xmlView, 3, null);
                    String string2 = this.$expression;
                    if (string2 == null) {
                        string2 = valueString;
                    }
                    xEvaluationCallback.evaluated((XValue)VariableViewKt.VariableView((org.jetbrains.debugger.Variable)((org.jetbrains.debugger.Variable)new VariableImpl(string2, this.$value)), (VariableContext)new VariableContext(this){
                        final /* synthetic */ printAndStoreValueToInspect.1 this$0;

                        @NotNull
                        public EvaluateContext getEvaluateContext() {
                            EvaluateContext evaluateContext = MessageBuilder.access$getMessageVm$p(this.this$0.this$0).getEvaluateContext();
                            if (evaluateContext == null) {
                                throw (Throwable)new IllegalStateException("global evaluation context is null, vm " + MessageBuilder.access$getMessageVm$p(this.this$0.this$0) + ", vm class " + MessageBuilder.access$getMessageVm$p(this.this$0.this$0).getClass().getName());
                            }
                            return evaluateContext;
                        }

                        public boolean watchableAsEvaluationExpression() {
                            return false;
                        }

                        @NotNull
                        public DebuggerViewSupport getViewSupport() {
                            return (DebuggerViewSupport)this.this$0.this$0.getDebugProcess().getDebuggerViewSupport();
                        }

                        @Nullable
                        public Vm getVm() {
                            return MessageBuilder.access$getMessageVm$p(this.this$0.this$0);
                        }
                        {
                            this.this$0 = $outer;
                        }

                        @NotNull
                        public Promise<MemberFilter> getMemberFilter() {
                            return VariableContext.DefaultImpls.getMemberFilter((VariableContext)this);
                        }

                        @Nullable
                        public VariableContext getParent() {
                            return VariableContext.DefaultImpls.getParent((VariableContext)this);
                        }

                        @Nullable
                        public Scope getScope() {
                            return VariableContext.DefaultImpls.getScope((VariableContext)this);
                        }

                        @Nullable
                        public String getVariableName() {
                            return VariableContext.DefaultImpls.getVariableName((VariableContext)this);
                        }
                    }));
                }
                {
                    this.this$0 = messageBuilder;
                    this.$value = value;
                    this.$xmlView = bl;
                    this.$expression = string;
                }
            });
        }

        @Override
        public void addMessageLink(@NotNull String url, int suggestedLine, int suggestedColumn, @Nullable String functionName, boolean resolveToScript, @Nullable String scriptId) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            this.getTasks().add(new Consumer<ConsolePrinter>(this, url, suggestedLine, suggestedColumn, functionName, resolveToScript, scriptId){
                final /* synthetic */ MessageBuilder this$0;
                final /* synthetic */ String $url;
                final /* synthetic */ int $suggestedLine;
                final /* synthetic */ int $suggestedColumn;
                final /* synthetic */ String $functionName;
                final /* synthetic */ boolean $resolveToScript;
                final /* synthetic */ String $scriptId;

                /*
                 * WARNING - void declaration
                 */
                public final void consume(ConsolePrinter it) {
                    void hyperlinkInfo;
                    Pair pair = MessageBuilder.access$createLinkInfo(this.this$0, this.$url, this.$suggestedLine, this.$suggestedColumn, this.$functionName, this.$resolveToScript, this.$scriptId);
                    HyperlinkInfo hyperlinkInfo2 = (HyperlinkInfo)pair.component1();
                    String linkText = (String)pair.component2();
                    ConsoleView consoleView = it.getConsoleView$intellij_javascript_debugger();
                    if (consoleView == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.console.WebConsoleView");
                    }
                    ((WebConsoleView)consoleView).printMessageHyperlink(linkText, (HyperlinkInfo)hyperlinkInfo);
                }
                {
                    this.this$0 = messageBuilder;
                    this.$url = string;
                    this.$suggestedLine = n;
                    this.$suggestedColumn = n2;
                    this.$functionName = string2;
                    this.$resolveToScript = bl;
                    this.$scriptId = string3;
                }
            });
        }

        @Override
        public void addHyperLink(@NotNull String url, int suggestedLine, int suggestedColumn, @Nullable String functionName, boolean resolveToScript, @Nullable String scriptId) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            this.getTasks().add(new Consumer<ConsolePrinter>(this, url, suggestedLine, suggestedColumn, functionName, resolveToScript, scriptId){
                final /* synthetic */ MessageBuilder this$0;
                final /* synthetic */ String $url;
                final /* synthetic */ int $suggestedLine;
                final /* synthetic */ int $suggestedColumn;
                final /* synthetic */ String $functionName;
                final /* synthetic */ boolean $resolveToScript;
                final /* synthetic */ String $scriptId;

                /*
                 * WARNING - void declaration
                 */
                public final void consume(ConsolePrinter it) {
                    void hyperlinkInfo;
                    Pair pair = MessageBuilder.access$createLinkInfo(this.this$0, this.$url, this.$suggestedLine, this.$suggestedColumn, this.$functionName, this.$resolveToScript, this.$scriptId);
                    HyperlinkInfo hyperlinkInfo2 = (HyperlinkInfo)pair.component1();
                    String linkText = (String)pair.component2();
                    ConsoleView consoleView = it.getConsoleView$intellij_javascript_debugger();
                    if (consoleView == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.console.WebConsoleView");
                    }
                    ((WebConsoleView)consoleView).printHyperlink(linkText, (HyperlinkInfo)hyperlinkInfo);
                }
                {
                    this.this$0 = messageBuilder;
                    this.$url = string;
                    this.$suggestedLine = n;
                    this.$suggestedColumn = n2;
                    this.$functionName = string2;
                    this.$resolveToScript = bl;
                    this.$scriptId = string3;
                }
            });
        }

        private final Pair<HyperlinkInfo, String> createLinkInfo(String url, int suggestedLine, int suggestedColumn, String functionName, boolean resolveToScript, String scriptId) {
            int line = suggestedLine;
            int column = suggestedColumn;
            SourceInfo sourceInfo = resolveToScript ? this.getDebugProcess().getSourceInfo(this.messageVm, scriptId, url, functionName, line, column) : null;
            VirtualFile file2 = null;
            Url parsedUrl = null;
            HyperlinkInfo hyperlinkInfo = null;
            if (sourceInfo == null) {
                parsedUrl = ScriptDebuggerUrls.parse((String)url, (boolean)true);
                VirtualFile virtualFile = file2 = parsedUrl == null ? null : JavaScriptDebugProcess.findFile$default(this.getDebugProcess(), parsedUrl, false, null, 6, null);
                if (virtualFile != null) {
                    VirtualFile virtualFile2 = virtualFile;
                    boolean bl = false;
                    boolean bl2 = false;
                    VirtualFile it = virtualFile2;
                    boolean bl3 = false;
                    PsiNavigationSupport psiNavigationSupport = PsiNavigationSupport.getInstance();
                    XDebugSession xDebugSession = this.getDebugProcess().getSession();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
                    Navigatable navigatable = psiNavigationSupport.createNavigatable(xDebugSession.getProject(), file2, 0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)navigatable, (String)"PsiNavigationSupport.get\u2026session.project, file, 0)");
                    Navigatable navigatable2 = navigatable;
                    hyperlinkInfo = new HyperlinkInfo(navigatable2){
                        final /* synthetic */ Navigatable $navigatable;

                        public final void navigate(Project it) {
                            this.$navigatable.navigate(true);
                        }
                        {
                            this.$navigatable = navigatable;
                        }
                    };
                }
            } else {
                file2 = sourceInfo.getFile();
                line = sourceInfo.getLine();
                column = sourceInfo.getColumn();
                parsedUrl = null;
                XDebugSession xDebugSession = this.getDebugProcess().getSession();
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
                Project project = xDebugSession.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
                hyperlinkInfo = (HyperlinkInfo)new OpenFileHyperlinkInfo(sourceInfo.createNavigatable(project));
            }
            String linkText = this.getLinkText(parsedUrl, file2, url, line);
            return new Pair((Object)hyperlinkInfo, (Object)linkText);
        }

        private final String getLinkText(Url parsedUrl, VirtualFile file2, String rawUrl, int line) {
            Object object;
            Object object2 = file2;
            if (object2 == null || (object2 = object2.getName()) == null) {
                Url url = parsedUrl;
                object2 = url != null && (url = url.trimParameters()) != null ? url.toDecodedForm() : (object = null);
            }
            if (object2 == null) {
                object = rawUrl;
            }
            Object name = object;
            String string = StringUtil.shortenPathWithEllipsis((String)name, (int)25, (boolean)true);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.shortenPathWithEllipsis(name, 25, true)");
            name = string;
            return line < 0 ? name : (String)name + ':' + (line + 1);
        }

        @Override
        public void print(@NotNull ConsolePrinter consolePrinter) {
            Intrinsics.checkParameterIsNotNull((Object)consolePrinter, (String)"consolePrinter");
            Iterable $this$forEach$iv = this.getTasks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Consumer it = (Consumer)element$iv;
                boolean bl = false;
                it.consume((Object)consolePrinter);
            }
        }

        public MessageBuilder(@NotNull JavaScriptDebugProcess<?> debugProcess, Vm messageVm) {
            Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
            Intrinsics.checkParameterIsNotNull((Object)messageVm, (String)"messageVm");
            super((ConsoleView)WebConsoleView.this, debugProcess);
            this.messageVm = messageVm;
        }

        public static final /* synthetic */ void access$doPrintIndent(MessageBuilder $this, ConsolePrinter it) {
            $this.doPrintIndent(it);
        }

        public static final /* synthetic */ void access$applyAnsiFilter(MessageBuilder $this, String text, ConsolePrinter it, ConsoleViewContentType contentType, String style) {
            $this.applyAnsiFilter(text, it, contentType, style);
        }

        public static final /* synthetic */ void access$applyUrlFilter(MessageBuilder $this, String textChunk, ConsolePrinter it, ConsoleViewContentType chunkContentType, String style) {
            $this.applyUrlFilter(textChunk, it, chunkContentType, style);
        }

        public static final /* synthetic */ Vm access$getMessageVm$p(MessageBuilder $this) {
            return $this.messageVm;
        }

        public static final /* synthetic */ Pair access$createLinkInfo(MessageBuilder $this, String url, int suggestedLine, int suggestedColumn, String functionName, boolean resolveToScript, String scriptId) {
            return $this.createLinkInfo(url, suggestedLine, suggestedColumn, functionName, resolveToScript, scriptId);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$Companion;", "", "()V", "INDENT", "", "urlFilter", "Lcom/intellij/execution/filters/UrlFilter;", "getUrlFilter", "()Lcom/intellij/execution/filters/UrlFilter;", "intellij.javascript.debugger"})
    public static final class Companion {
        @NotNull
        public final UrlFilter getUrlFilter() {
            return urlFilter;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

