/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip.org.jetbrains.wip;

import com.intellij.javascript.debugger.JSCachingFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebugSession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipStyleSheet;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.css.CSSKt;
import org.jetbrains.wip.protocol.css.CSSStyleSheetHeaderValue;
import org.jetbrains.wip.protocol.css.StyleSheetAddedEventData;
import org.jetbrains.wip.protocol.css.StyleSheetChangedEventData;
import org.jetbrains.wip.protocol.css.StyleSheetRemovedEventData;
import org.jetbrains.wip.protocol.dom.DOMKt;
import org.jetbrains.wip.protocol.page.FrameDetachedEventData;
import org.jetbrains.wip.protocol.page.FrameNavigatedEventData;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/wip/org/jetbrains/wip/WipCssManager;", "", "process", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "idToStyleSheet", "", "", "Lorg/jetbrains/wip/WipStyleSheet;", "getIdToStyleSheet", "()Ljava/util/Map;", "clear", "", "enable", "handleEvent", "event", "setCssSourceMap", "sheet", "Companion", "intellij.javascript.debugger"})
public final class WipCssManager {
    @NotNull
    private final Map<String, WipStyleSheet> idToStyleSheet;
    private final JavaScriptDebugProcess<?> process;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final Map<String, WipStyleSheet> getIdToStyleSheet() {
        return this.idToStyleSheet;
    }

    public final void enable() {
        block1: {
            Vm vm = this.process.getVm();
            if (!(vm instanceof WipVm)) {
                vm = null;
            }
            WipVm wipVm = (WipVm)vm;
            if (wipVm == null) break block1;
            WipVm wipVm2 = wipVm;
            boolean bl = false;
            boolean bl2 = false;
            WipVm vm2 = wipVm2;
            boolean bl3 = false;
            vm2.getCommandProcessor().send((Request)DOMKt.Enable());
            vm2.getCommandProcessor().send((Request)CSSKt.Enable());
            vm2.getCommandProcessor().getEventMap().addMulti(new EventType[]{(EventType)StyleSheetAddedEventData.TYPE, (EventType)StyleSheetRemovedEventData.TYPE, (EventType)FrameDetachedEventData.TYPE, (EventType)FrameNavigatedEventData.TYPE, (EventType)StyleSheetChangedEventData.TYPE}, (Function1)new Function1<Object, Unit>(this){
                final /* synthetic */ WipCssManager this$0;
                {
                    this.this$0 = wipCssManager;
                    super(1);
                }

                public final void invoke(@NotNull Object it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    WipCssManager.access$handleEvent(this.this$0, it);
                }
            });
        }
    }

    private final void handleEvent(Object event) {
        block9: {
            block7: {
                CSSStyleSheetHeaderValue styleSheetInfo;
                block8: {
                    if (!(event instanceof StyleSheetAddedEventData)) break block7;
                    styleSheetInfo = ((StyleSheetAddedEventData)event).header();
                    if (!StringUtil.isEmpty((String)styleSheetInfo.sourceURL())) break block8;
                    LOG.warn("CSS " + styleSheetInfo.styleSheetId() + " has empty source URL, sourcemap URL " + styleSheetInfo.getSourceMapURL());
                    break block9;
                }
                Url parsed = Urls.parseEncoded((String)styleSheetInfo.sourceURL());
                if (parsed == null) break block9;
                WipStyleSheet styleSheet = new WipStyleSheet(parsed, styleSheetInfo);
                this.idToStyleSheet.put(styleSheetInfo.styleSheetId(), styleSheet);
                this.setCssSourceMap(styleSheet);
                break block9;
            }
            if (event instanceof StyleSheetRemovedEventData) {
                String styleSheetId = ((StyleSheetRemovedEventData)event).styleSheetId();
                this.idToStyleSheet.remove(styleSheetId);
            } else if (!(event instanceof StyleSheetChangedEventData)) {
                String string;
                if (event instanceof FrameDetachedEventData) {
                    string = ((FrameDetachedEventData)event).frameId();
                } else {
                    Object object = event;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.protocol.page.FrameNavigatedEventData");
                    }
                    string = ((FrameNavigatedEventData)object).frame().id();
                }
                String frameId = string;
                Object styleSheet = this.idToStyleSheet;
                boolean bl = false;
                Iterator<Map.Entry<String, WipStyleSheet>> iterator = styleSheet.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, WipStyleSheet> entry;
                    Map.Entry<String, WipStyleSheet> entry2 = entry = iterator.next();
                    boolean bl2 = false;
                    styleSheet = entry2.getKey();
                    entry2 = entry;
                    bl2 = false;
                    WipStyleSheet stylesheet = entry2.getValue();
                    if (!Intrinsics.areEqual((Object)stylesheet.getDescriptor().frameId(), (Object)frameId)) continue;
                    iterator.remove();
                }
            }
        }
    }

    public final void clear() {
        this.idToStyleSheet.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCssSourceMap(WipStyleSheet sheet) {
        block2: {
            String string = sheet.getDescriptor().getSourceMapURL();
            if (string == null) break block2;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String sourceMapUrl = string2;
            boolean bl3 = false;
            Url parsedUrl = SourceMapLoaderKt.canonicalizeUrl(sourceMapUrl, sheet.getUrl());
            SourceMap sourceMap = SourceMapLoaderKt.findSourceMap(parsedUrl, this.process);
            if (sourceMap != null) {
                SourceMap sourceMap2 = sourceMap;
                boolean bl4 = false;
                boolean bl5 = false;
                SourceMap sourceMap3 = sourceMap2;
                boolean bl6 = false;
                sheet.setSourceMap(sourceMap3);
                int n = 0;
                int n2 = sourceMap3.getSources().length;
                while (n < n2) {
                    void i;
                    JSCachingFileFinder jSCachingFileFinder = this.process.getFinder();
                    Url url = sourceMap3.getSources()[i];
                    XDebugSession xDebugSession = this.process.getSession();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"process.session");
                    Project project = xDebugSession.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"process.session.project");
                    JSCachingFileFinder.findFile$default(jSCachingFileFinder, url, project, false, sourceMap3.getSourceContent((int)i), null, 16, null);
                    ++i;
                }
            }
        }
    }

    public WipCssManager(@NotNull JavaScriptDebugProcess<?> process) {
        Intrinsics.checkParameterIsNotNull(process, (String)"process");
        this.process = process;
        this.idToStyleSheet = new HashMap();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(WipCssManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(WipCssManager::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$handleEvent(WipCssManager $this, Object event) {
        $this.handleEvent(event);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/wip/org/jetbrains/wip/WipCssManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.javascript.debugger"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

