/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;

public class RemoveTableColumnFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<GherkinTable> myTable;
    private final int myColumnIndex;

    public RemoveTableColumnFix(@NotNull GherkinTable table, int columnIndex) {
        if (table == null) {
            RemoveTableColumnFix.$$$reportNull$$$0(0);
        }
        this.myTable = SmartPointerManager.createPointer((PsiElement)table);
        this.myColumnIndex = columnIndex;
    }

    @NotNull
    public String getName() {
        return "Remove unused column";
    }

    @NotNull
    public String getFamilyName() {
        return "RemoveTableColumnFix";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        GherkinTable table;
        if (project == null) {
            RemoveTableColumnFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            RemoveTableColumnFix.$$$reportNull$$$0(2);
        }
        if ((table = (GherkinTable)this.myTable.getElement()) == null) {
            return;
        }
        GherkinTableRow headerRow = table.getHeaderRow();
        if (headerRow != null) {
            headerRow.deleteCell(this.myColumnIndex);
        }
        for (GherkinTableRow row : table.getDataRows()) {
            row.deleteCell(this.myColumnIndex);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/RemoveTableColumnFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

