/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.testFramework.ApplicationRule;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.FixtureRuleKt;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.ProjectRule;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.PathKt;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/ProjectRule;", "Lcom/intellij/testFramework/ApplicationRule;", "projectDescriptor", "Lcom/intellij/testFramework/LightProjectDescriptor;", "(Lcom/intellij/testFramework/LightProjectDescriptor;)V", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "()Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/ex/ProjectEx;", "getProject", "()Lcom/intellij/openapi/project/ex/ProjectEx;", "getProjectDescriptor", "()Lcom/intellij/testFramework/LightProjectDescriptor;", "projectIfOpened", "getProjectIfOpened", "after", "", "Companion", "intellij.platform.testFramework"})
public final class ProjectRule
extends ApplicationRule {
    @NotNull
    private final LightProjectDescriptor projectDescriptor;
    private static ProjectEx sharedProject;
    private static final AtomicBoolean projectOpened;
    public static final Companion Companion;

    public void after() {
        block4: {
            if (!projectOpened.compareAndSet(true, false)) break block4;
            if (sharedProject != null) {
                ProjectEx projectEx = sharedProject;
                if (projectEx == null) {
                    Intrinsics.throwNpe();
                }
                UndoManager undoManager = UndoManager.getInstance((Project)((Project)projectEx));
                if (undoManager == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
                }
                UndoManagerImpl undoManager2 = (UndoManagerImpl)undoManager;
                ApplicationManager.getApplication().invokeAndWait(new Runnable(undoManager2){
                    final /* synthetic */ UndoManagerImpl $undoManager;

                    public final void run() {
                        this.$undoManager.dropHistoryInTests();
                        this.$undoManager.flushCurrentCommandMerger();
                    }
                    {
                        this.$undoManager = undoManagerImpl;
                    }
                });
            }
            ProjectEx projectEx = sharedProject;
            if (projectEx != null) {
                ProjectEx projectEx2 = projectEx;
                boolean bl = false;
                boolean bl2 = false;
                ProjectEx it = projectEx2;
                boolean bl3 = false;
                EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)new Function0<Unit>(it){
                    final /* synthetic */ ProjectEx $it;

                    public final void invoke() {
                        ProjectManager projectManager = ProjectManager.getInstance();
                        if (projectManager == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.project.impl.ProjectManagerImpl");
                        }
                        ((ProjectManagerImpl)projectManager).forceCloseProject((Project)this.$it, false);
                    }
                    {
                        this.$it = projectEx;
                        super(0);
                    }
                }));
            }
        }
    }

    @Nullable
    public final ProjectEx getProjectIfOpened() {
        return projectOpened.get() ? sharedProject : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ProjectEx getProject() {
        ProjectEx result = sharedProject;
        if (result == null) {
            TestApplicationManager testApplicationManager = TestApplicationManager.Companion.getInstance();
            boolean bl = false;
            boolean bl2 = false;
            synchronized (testApplicationManager) {
                boolean bl3 = false;
                result = sharedProject;
                if (result == null) {
                    sharedProject = result = ProjectRule.Companion.createLightProject();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        if (projectOpened.compareAndSet(false, true)) {
            EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ProjectRule this$0;

                public final void invoke() {
                    ProjectManagerEx.getInstanceEx().openTestProject((Project)this.this$0.getProject());
                }
                {
                    this.this$0 = projectRule;
                    super(0);
                }
            }));
        }
        ProjectEx projectEx = result;
        if (projectEx == null) {
            Intrinsics.throwNpe();
        }
        return projectEx;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Module getModule() {
        void result;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = FixtureRuleKt.access$getSharedModule$p();
        if ((Module)result.element == null) {
            EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)new Function0<Unit>(this, (Ref.ObjectRef)result){
                final /* synthetic */ ProjectRule this$0;
                final /* synthetic */ Ref.ObjectRef $result;

                public final void invoke() {
                    this.this$0.getProjectDescriptor().setUpProject((Project)this.this$0.getProject(), new LightProjectDescriptor.SetupHandler(this){
                        final /* synthetic */ module.1 this$0;

                        public void moduleCreated(@NotNull Module module2) {
                            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
                            this.this$0.$result.element = module2;
                            FixtureRuleKt.access$setSharedModule$p(module2);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    });
                }
                {
                    this.this$0 = projectRule;
                    this.$result = objectRef;
                    super(0);
                }
            }));
        }
        Module module2 = (Module)result.element;
        if (module2 == null) {
            Intrinsics.throwNpe();
        }
        return module2;
    }

    @NotNull
    public final LightProjectDescriptor getProjectDescriptor() {
        return this.projectDescriptor;
    }

    public ProjectRule(@NotNull LightProjectDescriptor projectDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)projectDescriptor, (String)"projectDescriptor");
        this.projectDescriptor = projectDescriptor;
    }

    public /* synthetic */ ProjectRule(LightProjectDescriptor lightProjectDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            lightProjectDescriptor = new LightProjectDescriptor();
        }
        this(lightProjectDescriptor);
    }

    public ProjectRule() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        projectOpened = new AtomicBoolean();
    }

    @JvmStatic
    public static final void checkThatNoOpenProjects() {
        Companion.checkThatNoOpenProjects();
    }

    @JvmStatic
    @NotNull
    public static final String getCreationPlace(@NotNull Project project2) {
        return Companion.getCreationPlace(project2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\u0006H\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/testFramework/ProjectRule$Companion;", "", "()V", "projectOpened", "Ljava/util/concurrent/atomic/AtomicBoolean;", "sharedProject", "Lcom/intellij/openapi/project/ex/ProjectEx;", "checkThatNoOpenProjects", "", "createLightProject", "disposeProject", "getCreationPlace", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.testFramework"})
    public static final class Companion {
        @JvmStatic
        public final void checkThatNoOpenProjects() {
            Project[] openProjects = ProjectUtil.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)openProjects, (String)"openProjects");
            Project[] projectArray = openProjects;
            boolean bl = false;
            if (projectArray.length == 0) {
                return;
            }
            ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
            List errors = (List)new SmartList();
            List tasks = (List)new SmartList();
            for (Project project2 : openProjects) {
                StringBuilder stringBuilder = new StringBuilder().append("Test project is not disposed: ").append(project2).append(";\n created in: ");
                Project project3 = project2;
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                errors.add(new IllegalStateException(stringBuilder.append(this.getCreationPlace(project3)).toString()));
                tasks.add(new ThrowableRunnable<Throwable>(projectManager, project2){
                    final /* synthetic */ ProjectManagerEx $projectManager;
                    final /* synthetic */ Project $project;

                    public final void run() {
                        this.$projectManager.forceCloseProject(this.$project);
                    }
                    {
                        this.$projectManager = projectManagerEx;
                        this.$project = project2;
                    }
                });
            }
            new RunAll(tasks).run(errors);
        }

        @JvmStatic
        @NotNull
        public final String getCreationPlace(@NotNull Project project2) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            try {
                string = project2.isDisposed() ? "" : project2.getBasePath();
            }
            catch (Exception e) {
                string = " (" + e + " while getting base dir)";
            }
            String base = string;
            String place = project2 instanceof ProjectImpl ? ((ProjectImpl)project2).getCreationTrace() : null;
            StringBuilder stringBuilder = new StringBuilder().append(project2).append(' ');
            String string2 = place;
            if (string2 == null) {
                string2 = "";
            }
            return stringBuilder.append(string2).append(base).toString();
        }

        private final ProjectEx createLightProject() {
            PersistentFS persistentFS = PersistentFS.getInstance();
            if (persistentFS == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl");
            }
            ((PersistentFSImpl)persistentFS).cleanPersistedContents();
            Path projectFile = TemporaryDirectory.Companion.generateTemporaryPath("light_temp_shared_project.ipr");
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            new Throwable(PathKt.getSystemIndependentPath((Path)projectFile), null).printStackTrace(new PrintStream(buffer));
            Project project2 = HeavyPlatformTestCase.createProject(projectFile);
            if (project2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.project.ex.ProjectEx");
            }
            ProjectEx project3 = (ProjectEx)project2;
            PlatformTestUtil.registerProjectCleanup(new Runnable(projectFile){
                final /* synthetic */ Path $projectFile;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    try {
                        com.intellij.testFramework.ProjectRule$Companion.access$disposeProject(ProjectRule.Companion);
                    }
                    finally {
                        Files.deleteIfExists(this.$projectFile);
                    }
                }
                {
                    this.$projectFile = path;
                }
            });
            return project3;
        }

        private final void disposeProject() {
            ProjectEx projectEx = sharedProject;
            if (projectEx == null) {
                return;
            }
            ProjectEx project2 = projectEx;
            sharedProject = null;
            FixtureRuleKt.access$setSharedModule$p(null);
            ProjectManagerEx.getInstanceEx().forceCloseProject((Project)project2);
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$disposeProject(Companion $this) {
            $this.disposeProject();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

