/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.appengine.inspection.AppEngineInspection;
import com.jetbrains.appengine.inspection.GqlQueryVisitor;
import com.jetbrains.appengine.lang.gql.psi.GqlCompare;
import com.jetbrains.appengine.lang.gql.psi.GqlOrder;
import com.jetbrains.appengine.lang.gql.psi.GqlProperty;
import com.jetbrains.appengine.lang.gql.psi.GqlQuery;
import com.jetbrains.appengine.ui.AppEngineBundle;
import org.jetbrains.annotations.NotNull;

public class RestrictedQueryInspection
extends AppEngineInspection {
    @Override
    @NotNull
    public String getShortName() {
        return "Query_restricted";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RestrictedQueryInspection.$$$reportNull$$$0(0);
        }
        return new GqlQueryRestrictionChecker(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/appengine/inspection/RestrictedQueryInspection", "buildVisitor"));
    }

    private static class GqlQueryRestrictionChecker
    extends GqlQueryVisitor {
        private final ProblemsHolder myHolder;
        private String myInequalityProperty;

        private GqlQueryRestrictionChecker(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitWhereProperty(GqlProperty prop) {
            this.checkInequalityOneProperty(prop);
        }

        private void checkInequalityOneProperty(GqlProperty prop) {
            PsiElement parent = prop.getParent();
            if (!(parent instanceof GqlCompare)) {
                return;
            }
            GqlCompare compare = (GqlCompare)parent;
            if (!compare.isEqual()) {
                if (this.myInequalityProperty != null && !this.myInequalityProperty.equals(prop.getPropertyName())) {
                    String msg = AppEngineBundle.message("query-error.many-inequality-props", this.myInequalityProperty);
                    this.myHolder.registerProblem((PsiElement)prop, msg, new LocalQuickFix[0]);
                } else {
                    this.myInequalityProperty = prop.getPropertyName();
                }
            }
        }

        @Override
        public void visitQuery(GqlQuery query) {
            this.checkFirstOrderInequality(query);
        }

        private void checkFirstOrderInequality(GqlQuery query) {
            GqlOrder order = query.getOrderBy();
            if (order == null) {
                return;
            }
            String inequalityProperty = null;
            for (GqlCompare cond : query.getConditions()) {
                if (cond.isEqual()) continue;
                inequalityProperty = cond.getProperty();
                break;
            }
            if (inequalityProperty != null && !inequalityProperty.equals(order.getFirstProperty())) {
                String msg = AppEngineBundle.message("query-error.sort-inequality-first", inequalityProperty);
                this.myHolder.registerProblem((PsiElement)order, msg, new LocalQuickFix[0]);
            }
        }
    }
}

