/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.lang.gql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.appengine.lang.gql.psi.GqlOrder;
import com.jetbrains.appengine.lang.gql.psi.GqlProperty;
import com.jetbrains.appengine.lang.gql.psi.SortOrder;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlAscDescImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlElementImpl;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GqlOrderImpl
extends GqlElementImpl
implements GqlOrder {
    public GqlOrderImpl(@NotNull ASTNode astNode) {
        if (astNode == null) {
            GqlOrderImpl.$$$reportNull$$$0(0);
        }
        super(astNode);
    }

    @Override
    public List<Pair<String, SortOrder>> getProperties() {
        ArrayList<Pair<String, SortOrder>> result = new ArrayList<Pair<String, SortOrder>>();
        GqlProperty[] orderProperties = this.getPropertiesChildren();
        if (orderProperties != null) {
            for (GqlProperty orderProperty : orderProperties) {
                String name = orderProperty.getPropertyName();
                if (StringUtil.isEmpty((String)name)) continue;
                SortOrder sortOrder = GqlOrderImpl.getSortOrder(orderProperty);
                result.add((Pair<String, SortOrder>)Pair.create((Object)name, (Object)((Object)sortOrder)));
            }
        }
        return result;
    }

    private static SortOrder getSortOrder(GqlProperty property) {
        GqlAscDescImpl ascDesc = (GqlAscDescImpl)PsiTreeUtil.getChildOfType((PsiElement)property, GqlAscDescImpl.class);
        if (ascDesc != null) {
            return ascDesc.getSortOrder();
        }
        return SortOrder.ASC;
    }

    private GqlProperty[] getPropertiesChildren() {
        return (GqlProperty[])PsiTreeUtil.getChildrenOfType((PsiElement)this, GqlProperty.class);
    }

    @Override
    public String getFirstProperty() {
        GqlProperty prop;
        GqlProperty[] props = this.getPropertiesChildren();
        if (props != null && props.length > 0 && (prop = props[0]) != null) {
            return prop.getPropertyName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/jetbrains/appengine/lang/gql/psi/impl/GqlOrderImpl", "<init>"));
    }
}

