/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.codeInsight;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.django.DjangoNames;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.model.applications.DjangoAppConfigClassUtil;
import com.jetbrains.django.templateFSLoader.DjangoTemplateFSLoaderPre8;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.blockEvaluator.PyBlockEvaluator;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoSettingsPy {
    private static final DjangoSettingsCache NO_SETTINGS = new DjangoSettingsCache(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, null, null, Collections.emptyList(), null);
    private static final Key<CachedValue<DjangoSettingsCache>> DJANGO_SETTINGS_CACHE_KEY = Key.create((String)"DjangoSettingsPy.DjangoSettingsCache");

    private DjangoSettingsPy() {
    }

    public static Collection<PyCustomMember> getSettingsMembers(Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length != 1) {
            return Collections.emptyList();
        }
        PyFile settingsFile = DjangoSettingsPy.getSettingsFile(modules[0]);
        if (settingsFile == null) {
            return Collections.emptyList();
        }
        ArrayList members = Lists.newArrayList();
        DjangoSettingsPy.collectAllMembers(settingsFile, members, Sets.newHashSet());
        return members;
    }

    @Nullable
    public static PyFile getSettingsFile(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        VirtualFile settingsFile = DjangoUtil.getSettingsFile(module);
        if (settingsFile != null) {
            return DjangoSettingsPy.asPyFile(module.getProject(), settingsFile);
        }
        return DjangoSettingsPy.findSettingsFile(module);
    }

    @Nullable
    public static PyFile findSettingsFile(@Nullable Module module) {
        VirtualFile[] contentRoots;
        if (module == null) {
            return null;
        }
        DjangoFacet facet = DjangoFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        String settings = ((DjangoFacetConfiguration)facet.getConfiguration()).getSettingsFilePath();
        VirtualFile projectRootFolderFile = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile();
        if (projectRootFolderFile == null) {
            return null;
        }
        VirtualFile settingsVFile = projectRootFolderFile.findChild(settings);
        if (settingsVFile != null) {
            return DjangoSettingsPy.asPyFile(module.getProject(), settingsVFile);
        }
        for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            settingsVFile = contentRoot.findFileByRelativePath(settings);
            if (settingsVFile == null) continue;
            return DjangoSettingsPy.asPyFile(module.getProject(), settingsVFile);
        }
        return null;
    }

    @Nullable
    private static PyFile asPyFile(@NotNull Project project, @NotNull VirtualFile settingsVFile) {
        PsiFile settingsFile;
        if (project == null) {
            DjangoSettingsPy.$$$reportNull$$$0(0);
        }
        if (settingsVFile == null) {
            DjangoSettingsPy.$$$reportNull$$$0(1);
        }
        if (!settingsVFile.isValid()) {
            return null;
        }
        if (settingsVFile.isDirectory()) {
            VirtualFile initFile = settingsVFile.findChild("__init__.py");
            if (initFile == null || !initFile.isValid()) {
                return null;
            }
            PsiFile settingsFile2 = PsiManager.getInstance((Project)project).findFile(initFile);
            if (settingsFile2 instanceof PyFile) {
                return (PyFile)settingsFile2;
            }
        }
        if ((settingsFile = PsiManager.getInstance((Project)project).findFile(settingsVFile)) instanceof PyFile) {
            return (PyFile)settingsFile;
        }
        return null;
    }

    @Nullable
    public static PsiElement resolveSettingsMember(@NotNull PsiElement element, @NotNull String name, @NotNull PyResolveContext resolveContext) {
        if (element == null) {
            DjangoSettingsPy.$$$reportNull$$$0(2);
        }
        if (name == null) {
            DjangoSettingsPy.$$$reportNull$$$0(3);
        }
        if (resolveContext == null) {
            DjangoSettingsPy.$$$reportNull$$$0(4);
        }
        Project project = element.getProject();
        Collection<PyCustomMember> settings = DjangoSettingsPy.getSettingsMembers(project);
        for (PyCustomMember setting : settings) {
            if (!setting.getName().equals(name)) continue;
            return setting.resolve(element, resolveContext);
        }
        return null;
    }

    @NotNull
    public static List<String> getInstalledApps(@Nullable Module module) {
        if (module == null) {
            List list = DjangoSettingsPy.getCachedData(null).myInstalledApps;
            if (list == null) {
                DjangoSettingsPy.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String app : DjangoSettingsPy.getCachedData(module).myInstalledApps) {
            if (app == null) continue;
            String realName = DjangoAppConfigClassUtil.getApplicationNameByConfigClassName(module, app);
            result.add(realName != null ? realName : app);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            DjangoSettingsPy.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getMiddleware(@Nullable Module module) {
        List list = DjangoSettingsPy.getCachedData(module).myMiddleware;
        if (list == null) {
            DjangoSettingsPy.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static DjangoSettingsCache getCachedData(@Nullable Module module) {
        PyFile file2 = DjangoSettingsPy.getSettingsFile(module);
        if (file2 == null) {
            return NO_SETTINGS;
        }
        CachedValue<DjangoSettingsCache> data = (CachedValue<DjangoSettingsCache>)file2.getUserData(DJANGO_SETTINGS_CACHE_KEY);
        if (data == null) {
            data = DjangoSettingsPy.buildCachedData(file2);
            file2.putUserData(DJANGO_SETTINGS_CACHE_KEY, data);
        }
        return (DjangoSettingsCache)data.getValue();
    }

    private static CachedValue<DjangoSettingsCache> buildCachedData(PyFile settingsFile) {
        return CachedValuesManager.getManager((Project)settingsFile.getProject()).createCachedValue(() -> {
            PyBlockEvaluator evaluator = new PyBlockEvaluator();
            evaluator.trackDeclarations("STATICFILES_DIRS");
            evaluator.trackDeclarations("TEMPLATES");
            evaluator.trackDeclarations("TEMPLATE_LOADERS");
            evaluator.evaluate(settingsFile);
            ArrayList<String> oldTemplateDirs = new ArrayList<String>(DjangoTemplateFSLoaderPre8.getFolders(settingsFile));
            List declarations = evaluator.getDeclarations("TEMPLATES").stream().filter(o -> o instanceof PyDictLiteralExpression).map(o -> (PyDictLiteralExpression)o).collect(Collectors.toList());
            PsiQuery<PyExpression> oldSyntaxTemplateLoaders = new PsiQuery<PyExpression>(evaluator.getDeclarations("TEMPLATE_LOADERS"));
            PsiQuery<PySequenceExpression> newSyntaxTemplateLoaders = new PsiQuery<PyFile>(settingsFile).descendants(PyKeyValueExpression.class).filter(o -> "loaders".equals(PyEvaluator.evaluate(o.getKey(), String.class))).descendants(PySequenceExpression.class);
            PsiQuery<PyStringLiteralExpression> loadersQuery = PsiQuery.createFromQueries(Arrays.asList(oldSyntaxTemplateLoaders, newSyntaxTemplateLoaders));
            PsiQuery<PyStringLiteralExpression> innerLoadersQuery = loadersQuery.descendants(new PsiQuery.PsiFilter<PyStringLiteralExpression>(PyStringLiteralExpression.class));
            Set templateLoaders = loadersQuery.addElements(innerLoadersQuery).asStream().map(o -> PyEvaluator.evaluate(o, String.class)).collect(Collectors.toSet());
            DjangoSettingsCache cache2 = new DjangoSettingsCache(evaluator.getValueAsStringList("INSTALLED_APPS"), StreamEx.of((Object[])DjangoNames.MIDDLEWARE_SETTING).flatMap(s -> evaluator.getValueAsStringList((String)s).stream()).toList(), new ArrayList(templateLoaders), oldTemplateDirs, evaluator.getDeclarations("STATICFILES_DIRS"), evaluator.getValueAsString("ROOT_URLCONF"), evaluator.getValueAsString("MEDIA_URL"), evaluator.getValueAsString("TEST_RUNNER"), evaluator.getValueAsString("STATIC_ROOT"), declarations, evaluator.getValueAsString("MEDIA_ROOT"));
            return new CachedValueProvider.Result((Object)cache2, evaluator.getVisitedFiles().toArray());
        }, false);
    }

    @NotNull
    public static List<PyExpression> getStaticfilesDirs(@NotNull Module module) {
        if (module == null) {
            DjangoSettingsPy.$$$reportNull$$$0(8);
        }
        List dirs2 = DjangoSettingsPy.getCachedData(module).myStaticfilesDirs;
        PyUtil.verboseOnly(() -> dirs2.forEach(PyPsiUtils::assertValid));
        List list = dirs2;
        if (list == null) {
            DjangoSettingsPy.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static List<String> getOldTemplateDirs(@NotNull Module module) {
        if (module == null) {
            DjangoSettingsPy.$$$reportNull$$$0(10);
        }
        List list = DjangoSettingsPy.getCachedData(module).myOldTemplateDirs;
        if (list == null) {
            DjangoSettingsPy.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static List<String> getTemplateLoaders(Module module) {
        List list = DjangoSettingsPy.getCachedData(module).myTemplateLoaders;
        if (list == null) {
            DjangoSettingsPy.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public static Collection<PyDictLiteralExpression> getTemplateDicts(@NotNull Module module) {
        if (module == null) {
            DjangoSettingsPy.$$$reportNull$$$0(13);
        }
        Collection collection = DjangoSettingsPy.getCachedData(module).myTemplateDicts;
        if (collection == null) {
            DjangoSettingsPy.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Nullable
    public static String getRootUrlconf(Module module) {
        return DjangoSettingsPy.getCachedData(module).myRootUrlconf;
    }

    @Nullable
    public static String getMediaUrl(Module module) {
        return DjangoSettingsPy.getCachedData(module).myMediaUrl;
    }

    @Nullable
    public static String getTestRunner(Module module) {
        return DjangoSettingsPy.getCachedData(module).myTestRunner;
    }

    @Nullable
    public static String getStaticRoot(Module module) {
        return DjangoSettingsPy.getCachedData(module).myStaticRoot;
    }

    @Nullable
    public static String getMediaRoot(Module module) {
        return DjangoSettingsPy.getCachedData(module).myMediaRoot;
    }

    private static void collectAllMembers(PyFile settingsFile, List<PyCustomMember> result, Set<PyFile> processedFiles) {
        if (processedFiles.contains(settingsFile)) {
            return;
        }
        processedFiles.add(settingsFile);
        for (PyTargetExpression expression : settingsFile.getTopLevelAttributes()) {
            String name = expression.getName();
            if (name == null) continue;
            result.add(new PyCustomMember(name, expression));
        }
        List<PyFromImportStatement> imports = settingsFile.getFromImports();
        for (PyFromImportStatement element : imports) {
            PsiElement resolved;
            PyReferenceExpression expression = element.getImportSource();
            if (expression == null || !((resolved = expression.getReference().resolve()) instanceof PyFile)) continue;
            DjangoSettingsPy.collectAllMembers((PyFile)resolved, result, processedFiles);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsVFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/codeInsight/DjangoSettingsPy";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/codeInsight/DjangoSettingsPy";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledApps";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMiddleware";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticfilesDirs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldTemplateDirs";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateLoaders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "asPyFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveSettingsMember";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStaticfilesDirs";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOldTemplateDirs";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateDicts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DjangoSettingsCache {
        private final List<String> myInstalledApps;
        private final List<String> myMiddleware;
        private final List<String> myTemplateLoaders;
        private final List<String> myOldTemplateDirs;
        private final Collection<PyDictLiteralExpression> myTemplateDicts;
        private final List<PyExpression> myStaticfilesDirs;
        private final String myRootUrlconf;
        private final String myMediaUrl;
        private final String myTestRunner;
        private final String myStaticRoot;
        private final String myMediaRoot;

        private DjangoSettingsCache(List<String> apps, List<String> middleware, List<String> templateLoaders, List<String> oldTemplateDirs, List<PyExpression> staticfilesDirs, String rootUrlconf, String mediaUrl, String testRunner, String staticRoot, Collection<PyDictLiteralExpression> templateDicts, String mediaRoot) {
            this.myInstalledApps = apps;
            this.myMiddleware = middleware;
            this.myTemplateDicts = templateDicts;
            this.myTemplateLoaders = templateLoaders;
            this.myOldTemplateDirs = oldTemplateDirs;
            this.myStaticfilesDirs = staticfilesDirs;
            this.myRootUrlconf = rootUrlconf;
            this.myMediaUrl = mediaUrl;
            this.myTestRunner = testRunner;
            this.myStaticRoot = staticRoot;
            this.myMediaRoot = mediaRoot;
        }
    }
}

