/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.structureView;

import com.google.common.collect.Lists;
import com.intellij.formatting.Block;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.psi.PsiElement;
import com.jetbrains.django.lang.template.formatter.DjangoTagBlock;
import com.jetbrains.django.lang.template.formatter.MutableBlockWrapper;
import com.jetbrains.django.lang.template.structureView.DjangoXmlRootTreeElement;
import com.jetbrains.django.lang.template.structureView.StructureViewBlockWrapper;
import com.jetbrains.django.lang.template.structureView.TreeElementBlock;
import java.util.ArrayList;
import java.util.List;

public class DjangoStructureViewUtil {
    public static Block convertFromTreeViewToBlocks(PsiTreeElementBase<PsiElement> root) {
        return new TreeElementBlock(root);
    }

    public static StructureViewTreeElement convertFromBlockTreeToTreeView(DjangoXmlRootTreeElement root, Block block) {
        List<StructureViewTreeElement> res = DjangoStructureViewUtil.convertFromBlockTreeToTreeView(Lists.newArrayList((Object[])new Block[]{block}));
        if (res.size() == 1) {
            return res.get(0);
        }
        return DjangoStructureViewUtil.createBlockWrapper(root, res);
    }

    public static List<StructureViewTreeElement> convertFromBlockTreeToTreeView(List<? extends Block> blocks) {
        ArrayList result = Lists.newArrayList();
        for (Block block : blocks) {
            DjangoStructureViewUtil.convertFromBlockTreeToTreeView(result, block);
        }
        return result;
    }

    public static List<StructureViewTreeElement> convertFromBlockTreeToTreeView(Block block) {
        ArrayList result = Lists.newArrayList();
        DjangoStructureViewUtil.convertFromBlockTreeToTreeView(result, block);
        if (result.size() == 1 && result.get(0) instanceof StructureViewBlockWrapper) {
            return Lists.newArrayList((Object[])((StructureViewBlockWrapper)result.get(0)).getChildren());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void convertFromBlockTreeToTreeView(List<? super StructureViewTreeElement> result, Block b) {
        if (b instanceof TreeElementBlock) {
            List<StructureViewTreeElement> children2 = DjangoStructureViewUtil.convertFromBlockTreeToTreeView(b.getSubBlocks());
            result.add(DjangoStructureViewUtil.createBlockWrapper(((TreeElementBlock)b).getTreeElement(), children2));
            return;
        } else if (b instanceof MutableBlockWrapper && ((MutableBlockWrapper)b).getOriginalBlock() instanceof TreeElementBlock) {
            List<StructureViewTreeElement> children3 = DjangoStructureViewUtil.convertFromBlockTreeToTreeView(b.getSubBlocks());
            Block originalBlock = ((MutableBlockWrapper)b).getOriginalBlock();
            if (!(originalBlock instanceof TreeElementBlock)) throw new IllegalStateException("this should not happen");
            result.add(DjangoStructureViewUtil.createBlockWrapper(((TreeElementBlock)originalBlock).getTreeElement(), children3));
            return;
        } else if (b instanceof DjangoTagBlock) {
            TreeElementBlock treeElementBlock;
            List<StructureViewTreeElement> children4 = DjangoStructureViewUtil.convertFromBlockTreeToTreeView(b.getSubBlocks());
            Block openTag = ((DjangoTagBlock)b).getOpenTag();
            if (openTag instanceof TreeElementBlock) {
                treeElementBlock = (TreeElementBlock)openTag;
            } else {
                if (!(openTag instanceof MutableBlockWrapper)) throw new IllegalStateException("unexpected block:" + openTag.getClass());
                treeElementBlock = (TreeElementBlock)((MutableBlockWrapper)openTag).getOriginalBlock();
            }
            result.add(DjangoStructureViewUtil.createBlockWrapper(treeElementBlock.getTreeElement(), children4));
            return;
        } else {
            result.addAll(DjangoStructureViewUtil.convertFromBlockTreeToTreeView(b.getSubBlocks()));
        }
    }

    private static StructureViewBlockWrapper createBlockWrapper(PsiTreeElementBase treeElement, List<StructureViewTreeElement> children2) {
        return new StructureViewBlockWrapper((StructureViewTreeElement)treeElement, children2);
    }
}

