/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.manage;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

final class ProcessHandlerWaiter
extends ProcessAdapter {
    @NotNull
    private final CountDownLatch myLatch;
    @NotNull
    private final ProcessHandler myHandler;
    private volatile int myResultCode;

    private ProcessHandlerWaiter(@NotNull ProcessHandler handler) {
        if (handler == null) {
            ProcessHandlerWaiter.$$$reportNull$$$0(0);
        }
        this.myLatch = new CountDownLatch(1);
        this.myHandler = handler;
    }

    @NotNull
    static ProcessHandlerWaiter create(@NotNull ProcessHandler handler) {
        if (handler == null) {
            ProcessHandlerWaiter.$$$reportNull$$$0(1);
        }
        ProcessHandlerWaiter waiter = new ProcessHandlerWaiter(handler);
        handler.addProcessListener((ProcessListener)waiter);
        ProcessHandlerWaiter processHandlerWaiter = waiter;
        if (processHandlerWaiter == null) {
            ProcessHandlerWaiter.$$$reportNull$$$0(2);
        }
        return processHandlerWaiter;
    }

    int waitForExit(int secondsToWait) throws InterruptedException, TimeoutException {
        assert (secondsToWait > 0) : "Should be positive";
        if (!this.myLatch.await(secondsToWait, TimeUnit.SECONDS)) {
            this.myHandler.destroyProcess();
            throw new TimeoutException();
        }
        return this.myResultCode;
    }

    public void processTerminated(@NotNull ProcessEvent event2) {
        if (event2 == null) {
            ProcessHandlerWaiter.$$$reportNull$$$0(3);
        }
        super.processTerminated(event2);
        this.myResultCode = event2.getExitCode();
        this.myLatch.countDown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/manage/ProcessHandlerWaiter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/manage/ProcessHandlerWaiter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processTerminated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class TimeoutException
    extends Exception {
        private TimeoutException() {
            super("Timeout elapsed while waiting for process to complete");
        }
    }
}

