/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.stubs.manager;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.io.StringRef;
import com.jetbrains.django.codeInsight.DjangoTypeProvider;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.stubs.manager.DjangoManagerIndex;
import com.jetbrains.django.model.stubs.manager.DjangoManagerStub;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStubType;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public final class DjangoManagerStubType
extends CustomTargetExpressionStubType<DjangoManagerStub> {
    private static final Collection<String> MODEL_FIELDS = Collections2.transform(DjangoTypeProvider.FIELD_INSTANCE_TYPES.keySet(), (Function)new MyFieldShortNamesObtainer());

    @Override
    @Nullable
    public DjangoManagerStub createStub(PyTargetExpression psi) {
        if (!DjangoFacet.isInProject(psi)) {
            return null;
        }
        PyClass possibleModel = psi.getContainingClass();
        if (possibleModel == null) {
            return null;
        }
        boolean hasFields = false;
        String calleeName = null;
        for (PyTargetExpression modelAttribute : possibleModel.getClassAttributes()) {
            PyExpression callee;
            PyCallExpression modelAttributeValue = PyUtil.as(modelAttribute.findAssignedValue(), PyCallExpression.class);
            if (modelAttributeValue == null || (callee = modelAttributeValue.getCallee()) == null) continue;
            if (MODEL_FIELDS.contains(callee.getName())) {
                if (modelAttribute.equals(psi)) {
                    return null;
                }
                hasFields = true;
                continue;
            }
            if (!modelAttribute.equals(psi)) continue;
            calleeName = callee.getName();
        }
        if (!hasFields || calleeName == null) {
            return null;
        }
        return new DjangoManagerStub(StringRef.fromString(calleeName));
    }

    @Override
    @Nullable
    public DjangoManagerStub deserializeStub(StubInputStream stream) throws IOException {
        return new DjangoManagerStub(stream.readName());
    }

    @Override
    public void indexStub(PyTargetExpressionStub stub, IndexSink sink) {
        DjangoManagerStub customStub = stub.getCustomStub(DjangoManagerStub.class);
        if (customStub != null) {
            sink.occurrence(DjangoManagerIndex.KEY, (Object)customStub.getManagerNameRef().getString());
        }
    }

    private static class MyFieldShortNamesObtainer
    implements Function<String, String> {
        private MyFieldShortNamesObtainer() {
        }

        public String apply(String input) {
            return QualifiedName.fromDottedString((String)input).getLastComponent();
        }
    }
}

