/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.google.common.collect.Lists;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralFileReferenceSet;
import com.jetbrains.python.psi.WeakFileReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoDirectoryReferenceSet
extends PyStringLiteralFileReferenceSet {
    public DjangoDirectoryReferenceSet(String str, PyStringLiteralExpression element, int startInElement, @Nullable PsiReferenceProvider provider, boolean isCaseSensitive) {
        super(str, element, startInElement, provider, isCaseSensitive, false, (FileType[])null);
    }

    protected String getNewAbsolutePath(PsiFileSystemItem root, String relativePath) {
        if (root != null && root.getVirtualFile() != null) {
            return VirtualFileUtil.getAbsolutePath(root.getVirtualFile(), relativePath).replace(File.separatorChar, DjangoDirectoryReferenceSet.getUsedSeparatorChar(this.getPathString()));
        }
        return super.getNewAbsolutePath(root, relativePath);
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        ArrayList contexts = Lists.newArrayList();
        contexts.addAll(super.computeDefaultContexts());
        if (!this.isAbsolutePathReference()) {
            contexts.addAll(DjangoDirectoryReferenceSet.getModuleRoots(this.getElement()));
        }
        ArrayList arrayList = contexts;
        if (arrayList == null) {
            DjangoDirectoryReferenceSet.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public static List<PsiFileSystemItem> getModuleRoots(@NotNull PsiElement element) {
        PsiDirectory djangoRootDirectory;
        DjangoModelApi modelApi;
        if (element == null) {
            DjangoDirectoryReferenceSet.$$$reportNull$$$0(1);
        }
        ArrayList contexts = Lists.newArrayList();
        Project project = element.getProject();
        contexts.add(PsiManager.getInstance((Project)project).findDirectory(project.getBaseDir()));
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null && (modelApi = DjangoModelApi.create(module).getSuccessOrNull()) != null && (djangoRootDirectory = element.getManager().findDirectory(modelApi.getDjangoProjectRoot())) != null) {
            contexts.add(djangoRootDirectory);
        }
        return contexts;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return DIRECTORY_FILTER;
    }

    public static char getUsedSeparatorChar(String pathString) {
        if (pathString.contains("\\")) {
            return '\\';
        }
        if (pathString.contains("/")) {
            return '/';
        }
        return File.separatorChar;
    }

    public FileReference createFileReference(TextRange range, int index, String text2) {
        return new WeakFileReference(this, range, index, text2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/ref/DjangoDirectoryReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/ref/DjangoDirectoryReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModuleRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

