/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceWrapper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.Consumer;
import com.jetbrains.django.lang.template.ref.DjangoTemplateFileReferenceSet;
import com.jetbrains.django.ref.CreateViewQuickFix;
import com.jetbrains.django.ref.DjangoViewItemReference;
import com.jetbrains.django.ref.ViewParameters;
import com.jetbrains.django.ui.CreateTemplateDialog;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.ui.DjangoTemplateFileFactory;
import com.jetbrains.django.util.DjangoStringUtil;
import com.jetbrains.python.inspections.PyUnresolvedReferenceQuickFixProvider;
import com.jetbrains.python.templateLanguages.ConfigureTemplateDirectoriesAction;
import com.jetbrains.python.templateLanguages.PyTemplateFileReferenceSet;
import org.jetbrains.annotations.NotNull;

public class DjangoReferenceQuickFixProvider
implements PyUnresolvedReferenceQuickFixProvider {
    @Override
    public void registerQuickFixes(PsiReference reference, Consumer<LocalQuickFix> fixConsumer) {
        FileReferenceSet fileReferenceSet;
        int count;
        if (reference instanceof DjangoViewItemReference) {
            DjangoReferenceQuickFixProvider.suggestFix(ViewParameters.fromElement(reference.getElement()), fixConsumer);
        }
        PsiElement element = reference.getElement();
        FileReference fileReference = null;
        if (reference instanceof FileReference) {
            fileReference = (FileReference)reference;
        } else if (reference instanceof PsiReferenceWrapper && ((PsiReferenceWrapper)reference).isInstance(FileReference.class)) {
            fileReference = (FileReference)((PsiReferenceWrapper)reference).cast(FileReference.class);
        }
        if (fileReference != null && (fileReference.getFileReferenceSet() instanceof DjangoTemplateFileReferenceSet || fileReference.getFileReferenceSet() instanceof PyTemplateFileReferenceSet) && (count = (fileReferenceSet = fileReference.getFileReferenceSet()).getAllReferences().length) != 0 && fileReference.getIndex() == count - 1) {
            fixConsumer.consume((Object)new CreateTemplateIntentionAction(DjangoStringUtil.getStringValue(element)));
            fixConsumer.consume((Object)new ConfigureTemplateDirectoriesAction());
        }
    }

    private static void suggestFix(ViewParameters viewMethodReference, Consumer<LocalQuickFix> fixConsumer) {
        if (viewMethodReference.getViewsFile() != null) {
            fixConsumer.consume((Object)new CreateViewQuickFix(viewMethodReference));
        }
    }

    public static class CreateTemplateIntentionAction
    implements LocalQuickFix {
        private final String myTemplateName;

        private CreateTemplateIntentionAction(String templateName) {
            this.myTemplateName = templateName;
        }

        @NotNull
        public String getName() {
            String string = DjangoBundle.message("django.create.template.with.name", this.myTemplateName);
            if (string == null) {
                CreateTemplateIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = DjangoBundle.message("django.templates.create.no.capitalization", new Object[0]);
            if (string == null) {
                CreateTemplateIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                CreateTemplateIntentionAction.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                CreateTemplateIntentionAction.$$$reportNull$$$0(3);
            }
            CreateTemplateDialog d = new CreateTemplateDialog(project, descriptor2.getPsiElement());
            d.setShowCreateTemplateCheckBox(false);
            d.setTemplateName(this.myTemplateName);
            d.setTemplateNameEditable(false);
            d.show();
            if (d.getExitCode() != 0) {
                return;
            }
            DjangoTemplateFileFactory templateFileFactory = d.getTemplateFileFactory();
            if (d.isCreateTemplate() && !templateFileFactory.isValid(d.getTemplateName())) {
                Messages.showErrorDialog((String)DjangoBundle.message("template-name-error", new Object[0]), (String)"");
                return;
            }
            try {
                CreateTemplateIntentionAction.create(project, templateFileFactory, PsiManager.getInstance((Project)project).findDirectory(d.getSelectedTemplateRoot()), d.getTemplateName());
            }
            catch (Exception ex) {
                CreateTemplateIntentionAction.showError(ex.getMessage());
            }
        }

        private static void showError(String msg) {
            Messages.showErrorDialog((String)msg, (String)"");
        }

        public static void create(Project project, DjangoTemplateFileFactory templateFileFactory, PsiDirectory templateFolder, String templateName) {
            CommandProcessor.getInstance().executeCommand(project, () -> {
                PsiFile file2 = templateFileFactory.createTemplate(templateFolder, templateName);
                if (file2 != null) {
                    file2.navigate(true);
                }
            }, DjangoBundle.message("django.templates.create.no.capitalization", new Object[0]), (Object)templateName, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/django/ref/DjangoReferenceQuickFixProvider$CreateTemplateIntentionAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/django/ref/DjangoReferenceQuickFixProvider$CreateTemplateIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

