/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.mako.MakoElementTypes;
import com.jetbrains.mako.MakoLanguage;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MakoFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private final Language myTemplateDataLanguage = this.calcTemplateDataLanguage();
    private final Set<Language> myLanguages = ImmutableSet.of((Object)this.getBaseLanguage(), (Object)this.getTemplateDataLanguage());

    public MakoFileViewProvider(PsiManager manager, VirtualFile virtualFile2, boolean physical) {
        super(manager, virtualFile2, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        MakoLanguage makoLanguage = MakoLanguage.INSTANCE;
        if (makoLanguage == null) {
            MakoFileViewProvider.$$$reportNull$$$0(0);
        }
        return makoLanguage;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            MakoFileViewProvider.$$$reportNull$$$0(1);
        }
        return language;
    }

    private Language calcTemplateDataLanguage() {
        FileType type;
        VirtualFile originalFile;
        VirtualFile file2 = this.getVirtualFile();
        if (file2 instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)file2).getOriginalFile()) != null) {
            file2 = originalFile;
        }
        if (StdFileTypes.XML == (type = file2.getFileType())) {
            return XMLLanguage.INSTANCE;
        }
        if (StdFileTypes.JS == type) {
            FileTypeManager.getInstance();
            Language javaScript = Language.findLanguageByID((String)"JavaScript");
            if (javaScript != null) {
                return javaScript;
            }
        }
        return HTMLLanguage.INSTANCE;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            MakoFileViewProvider.$$$reportNull$$$0(2);
        }
        return new MakoFileViewProvider((PsiManager)this.getManager(), virtualFile2, false);
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = this.myLanguages;
        if (set == null) {
            MakoFileViewProvider.$$$reportNull$$$0(3);
        }
        return set;
    }

    protected PsiFile createFile(@NotNull Language lang) {
        ParserDefinition def;
        if (lang == null) {
            MakoFileViewProvider.$$$reportNull$$$0(4);
        }
        if ((def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) != null) {
            if (lang == this.getTemplateDataLanguage()) {
                PsiFileImpl file2 = (PsiFileImpl)def.createFile((FileViewProvider)this);
                file2.setContentElementType((IElementType)MakoElementTypes.TEMPLATE_DATA);
                return file2;
            }
            if (lang == MakoLanguage.INSTANCE) {
                return def.createFile((FileViewProvider)this);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/mako/MakoFileViewProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/mako/MakoFileViewProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

