/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.mako.MakoElementTypes;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.psi.impl.MakoCodeBlock;
import com.jetbrains.mako.psi.impl.MakoSubstitution;
import com.jetbrains.mako.psi.impl.MakoTag;
import com.jetbrains.mako.psi.impl.MakoTagBlockImpl;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyParameterList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakoBlock
extends TemplateLanguageBlock {
    protected MakoBlock(ASTNode node, Wrap wrap, Alignment alignment, CodeStyleSettings settings, @NotNull TemplateLanguageBlockFactory blockFactory, @Nullable List<DataLanguageBlockWrapper> foreignChildren) {
        if (blockFactory == null) {
            MakoBlock.$$$reportNull$$$0(0);
        }
        super(node, wrap, alignment, blockFactory, settings, foreignChildren);
    }

    protected IElementType getTemplateTextElementType() {
        return MakoTokenTypes.TEMPLATE_CHARACTERS;
    }

    @Nullable
    public Indent getIndent() {
        BlockWithParent parentBlock = this.getParent();
        IElementType type = this.myNode.getElementType();
        PsiElement psi = this.myNode.getPsi();
        ASTNode treeParent = this.myNode.getTreeParent();
        if (PsiTreeUtil.getParentOfType((PsiElement)psi, MakoTagBlockImpl.class) != null && psi != null && PsiTreeUtil.getParentOfType((PsiElement)psi, PyParameterList.class) != null) {
            return Indent.getNormalIndent();
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)psi, MakoCodeBlock.class) != null) {
            if (type == MakoTokenTypes.MAKO_TAG_END || type == MakoTokenTypes.MAKO_TAG_START) {
                return Indent.getNoneIndent();
            }
            if (psi instanceof PyIfPart || psi instanceof PyElsePart) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent((boolean)true);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)psi, MakoSubstitution.class) != null) {
            return Indent.getNoneIndent();
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)psi, MakoTag.class, (boolean)false) != null || MakoBlock.inCloseTag(this.myNode)) {
            return Indent.getNoneIndent();
        }
        if (type == MakoElementTypes.CONTROL_BLOCK && treeParent != null && treeParent.getElementType() == MakoElementTypes.TEXT && parentBlock instanceof DataLanguageBlockWrapper) {
            return Indent.getNormalIndent();
        }
        if (treeParent != null && treeParent.getElementType() == MakoElementTypes.TEXT) {
            return Indent.getNoneIndent();
        }
        if (parentBlock instanceof DataLanguageBlockWrapper) {
            if (type == MakoTokenTypes.CONTROL_STRUCTURE || type == MakoTokenTypes.CONTROL_STRUCTURE_END) {
                return Indent.getNoneIndent();
            }
            DataLanguageBlockWrapper dataBlock = (DataLanguageBlockWrapper)parentBlock;
            Block original = dataBlock.getOriginal();
            if (original instanceof SyntheticBlock && parentBlock.getParent() instanceof DataLanguageBlockWrapper && (original = ((DataLanguageBlockWrapper)parentBlock.getParent()).getOriginal()) instanceof SyntheticBlock) {
                return ((SyntheticBlock)original).getChildIndent();
            }
            List blocks = this.getSubBlocks();
            for (Block block : blocks) {
                if (block.getIndent() != Indent.getNormalIndent()) continue;
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (type == MakoElementTypes.MAKO_STATEMENT_LIST || type instanceof PyElementType) {
            List blocks = this.getSubBlocks();
            for (Block block : blocks) {
                if (block.getIndent() != Indent.getNormalIndent()) continue;
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent((boolean)true);
        }
        return Indent.getNoneIndent();
    }

    private static boolean inCloseTag(ASTNode node) {
        while (node != null) {
            if (node.getElementType() == MakoElementTypes.CLOSE_TAG) {
                return true;
            }
            node = node.getTreeParent();
        }
        return false;
    }

    protected boolean shouldBuildBlockFor(ASTNode node) {
        boolean shoud = super.shouldBuildBlockFor(node);
        if (shoud && PsiTreeUtil.getParentOfType((PsiElement)node.getPsi(), MakoCodeBlock.class) != null) {
            if (node.getPsi() instanceof PyIfPart || node.getPsi() instanceof PyElsePart) {
                return true;
            }
            return node.getTreeParent().getElementType() == MakoElementTypes.PYTHON_TAG;
        }
        return shoud;
    }

    @Nullable
    protected Indent getChildIndent() {
        PsiElement psi = this.myNode.getPsi();
        if (psi == null || psi instanceof PsiFile) {
            return Indent.getNoneIndent();
        }
        return Indent.getNormalIndent((boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockFactory", "com/jetbrains/mako/formatter/MakoBlock", "<init>"));
    }
}

