/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.ref;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.mako.psi.impl.MakoFile;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.references.PyImportReference;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MakoModuleReference
extends PyImportReference {
    public MakoModuleReference(PyReferenceExpressionImpl element, PyResolveContext context) {
        super(element, context);
    }

    @Override
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @Override
    public Object @NotNull [] getVariants() {
        ArrayList result = Lists.newArrayList();
        PsiDirectory dir = this.myElement.getContainingFile().getOriginalFile().getContainingDirectory();
        PyExpression qualifier = this.myElement.getQualifier();
        if (qualifier == null) {
            for (PsiFileSystemItem pfsi : MakoModuleReference.getSubmodulesList(dir)) {
                LookupElement lookupElement = MakoModuleReference.buildFileLookupElement((PsiElement)this.myElement, pfsi);
                if (lookupElement == null) continue;
                result.add(lookupElement);
            }
        } else {
            List<PsiElement> modules = ResolveImportUtil.resolveModule(QualifiedName.fromDottedString((String)qualifier.getText()), this.myElement.getContainingFile(), false, 0);
            for (PsiElement file2 : modules) {
                if (!(file2 instanceof PsiDirectory)) continue;
                for (PsiFileSystemItem pfsi : MakoModuleReference.getSubmodulesList((PsiDirectory)file2)) {
                    LookupElement lookupElement = MakoModuleReference.buildFileLookupElement((PsiElement)this.myElement, pfsi);
                    if (lookupElement == null) continue;
                    result.add(lookupElement);
                }
            }
        }
        Object[] superVariants = super.getVariants();
        for (Object variant : superVariants) {
            if (!(variant instanceof LookupElementBuilder)) continue;
            result.add(variant);
        }
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            MakoModuleReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @Override
    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        List<PsiElement> modules = ResolveImportUtil.resolveModule(QualifiedName.fromDottedString((String)this.myElement.getText()), this.myElement.getContainingFile(), false, 0);
        ArrayList<PsiElementResolveResult> result = new ArrayList<PsiElementResolveResult>();
        for (PsiElement file2 : modules) {
            if (!(file2 instanceof PsiFile)) continue;
            result.add(new PsiElementResolveResult(file2));
        }
        ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            MakoModuleReference.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    @NotNull
    public static List<PsiFileSystemItem> getSubmodulesList(PsiDirectory directory2) {
        ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
        if (directory2 != null) {
            for (PsiFile f : directory2.getFiles()) {
                String filename = f.getName();
                if (!(f instanceof PyFile) || filename.equals("__init__.py") || f instanceof MakoFile) continue;
                result.add((PsiFileSystemItem)f);
            }
            Collections.addAll(result, directory2.getSubdirectories());
        }
        ArrayList<PsiFileSystemItem> arrayList = result;
        if (arrayList == null) {
            MakoModuleReference.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static LookupElement buildFileLookupElement(PsiElement location, PsiFileSystemItem pfsi) {
        if (pfsi == location.getContainingFile().getOriginalFile()) {
            return null;
        }
        String s = pfsi.getName();
        int pos = s.lastIndexOf(46);
        if (pos > 0) {
            s = s.substring(0, pos);
        }
        if (!PyNames.isIdentifier(s)) {
            return null;
        }
        PsiDirectory d = (PsiDirectory)pfsi.getParent();
        if (d == null) {
            return null;
        }
        String path = d.getVirtualFile().getPath();
        return LookupElementBuilder.createWithSmartPointer((String)s, (PsiElement)pfsi).withTypeText(FileUtil.toSystemDependentName((String)path)).withPresentableText(s).withIcon(pfsi.getIcon(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/mako/ref/MakoModuleReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubmodulesList";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

