/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.validation;

import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.mako.MakoFileType;
import com.jetbrains.mako.MakoLanguage;
import com.jetbrains.mako.psi.impl.MakoFile;
import com.jetbrains.mako.validation.MakoAnnotator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MakoAnnotatingVisitor
implements Annotator,
HighlightRangeExtension {
    private static final Logger LOGGER = Logger.getInstance((String)MakoAnnotatingVisitor.class.getName());
    private final List<MakoAnnotator> myAnnotators = new ArrayList<MakoAnnotator>();

    public MakoAnnotatingVisitor() {
        for (Class<? extends MakoAnnotator> cls : ((MakoLanguage)MakoFileType.INSTANCE.getLanguage()).getAnnotators()) {
            MakoAnnotator annotator;
            try {
                annotator = cls.newInstance();
            }
            catch (InstantiationException e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            this.myAnnotators.add(annotator);
        }
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            MakoAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            MakoAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        for (MakoAnnotator annotator : this.myAnnotators) {
            annotator.annotateElement(psiElement, holder);
        }
    }

    public boolean isForceHighlightParents(@NotNull PsiFile file2) {
        if (file2 == null) {
            MakoAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        return file2 instanceof MakoFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/mako/validation/MakoAnnotatingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isForceHighlightParents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

