/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyramid.annotator;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.jetbrains.pyramid.project.PyramidUtils;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.PyElementListCellRenderer;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyramidTemplateLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            PyramidTemplateLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            PyramidTemplateLineMarkerProvider.$$$reportNull$$$0(1);
        }
        PyramidTemplateLineMarkerProvider.collectLineMarkersForElement(result, element);
    }

    private static void collectLineMarkersForElement(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement element) {
        RelatedItemLineMarkerInfo<XmlFile> info;
        if (element instanceof XmlFile && PyramidUtils.isPyramidProject(element) && (info = PyramidTemplateLineMarkerProvider.createLineMarker((XmlFile)element)) != null) {
            result.add(info);
        }
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<XmlFile> createLineMarker(XmlFile file2) {
        Set<PyStringLiteralExpression> result = PyramidTemplateLineMarkerProvider.getRenderers((PsiFile)file2);
        if (!result.isEmpty()) {
            String msg = "Select view";
            return new RelatedItemLineMarkerInfo((PsiElement)file2, file2.getTextRange(), PythonFileType.INSTANCE.getIcon(), 11, (Function)new ConstantFunction((Object)msg), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler<XmlFile>(result, msg){

                protected ListCellRenderer createListCellRenderer() {
                    return new PyElementListCellRenderer(){

                        @Override
                        public String getElementText(PsiElement element) {
                            String name = PyramidTemplateLineMarkerProvider.getReferenceViewName(element);
                            return name != null ? name : super.getElementText(element);
                        }
                    };
                }
            }, GutterIconRenderer.Alignment.RIGHT, (Collection)GotoRelatedItem.createItems(result, (String)"Views"));
        }
        return null;
    }

    public static Set<PyStringLiteralExpression> getRenderers(final PsiFile file2) {
        PsiFile[] files;
        final HashSet result = Sets.newHashSet();
        Project project = file2.getProject();
        for (PsiFile viewsFile : files = FilenameIndex.getFilesByName((Project)project, (String)"views.py", (GlobalSearchScope)ProjectScope.getProjectScope((Project)project))) {
            if (!(viewsFile instanceof PyFile)) continue;
            PyRecursiveElementVisitor visitor2 = new PyRecursiveElementVisitor(){

                @Override
                public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
                    String value2 = node.getStringValue();
                    if (value2.endsWith(file2.getName())) {
                        result.add(node);
                    }
                }
            };
            viewsFile.accept((PsiElementVisitor)visitor2);
        }
        return result;
    }

    private static String getReferenceViewName(PsiElement usage) {
        PyFunction func;
        PsiFile file2 = usage.getContainingFile();
        String name = file2.getName();
        PsiDirectory directory2 = file2.getParent();
        if (directory2 != null) {
            name = directory2.getName() + File.separator + name;
        }
        if ((func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)usage, PyFunction.class)) != null) {
            name = func.getName() + " in " + name;
        }
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/pyramid/annotator/PyramidTemplateLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

