/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PyGotoSuperHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        PsiElement element;
        PyClass pyClass;
        if (project == null) {
            PyGotoSuperHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            PyGotoSuperHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            PyGotoSuperHandler.$$$reportNull$$$0(2);
        }
        if ((pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)(element = file2.findElementAt(editor2.getCaretModel().getOffset())), PyClass.class)) != null) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class});
            if (function != null) {
                PyGotoSuperHandler.gotoSuperFunctions(editor2, function, pyClass);
            } else {
                PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class, (boolean)false, (Class[])new Class[]{PyClass.class});
                if (assignment != null && assignment.getTargets()[0] instanceof PyTargetExpression) {
                    PyGotoSuperHandler.gotoSuperClassAttributes(editor2, (PyTargetExpression)assignment.getTargets()[0], pyClass);
                } else {
                    TypeEvalContext context = TypeEvalContext.codeAnalysis(project, file2);
                    PyGotoSuperHandler.navigateOrChoose(editor2, pyClass.getAncestorClasses(context), "Choose superclass");
                }
            }
        }
    }

    private static void gotoSuperFunctions(Editor editor2, PyFunction function, PyClass pyClass) {
        Collection<PyFunction> superFunctions = PyGotoSuperHandler.getAllSuperMethodsByName(function, pyClass);
        PyGotoSuperHandler.navigateOrChoose(editor2, superFunctions, CodeInsightBundle.message((String)"goto.super.method.chooser.title", (Object[])new Object[0]));
    }

    private static void gotoSuperClassAttributes(Editor editor2, PyTargetExpression attr, PyClass pyClass) {
        Collection<PyTargetExpression> attrs = PyGotoSuperHandler.getAllSuperAttributesByName(attr, pyClass);
        PyGotoSuperHandler.navigateOrChoose(editor2, attrs, "Choose superclass attribute");
    }

    private static void navigateOrChoose(Editor editor2, Collection<? extends NavigatablePsiElement> superElements, String title) {
        if (!superElements.isEmpty()) {
            NavigatablePsiElement[] superElementArray = superElements.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY);
            if (superElementArray.length == 1) {
                superElementArray[0].navigate(true);
            } else {
                NavigationUtil.getPsiElementPopup((PsiElement[])superElementArray, (String)title).showInBestPositionFor(editor2);
            }
        }
    }

    private static Collection<PyTargetExpression> getAllSuperAttributesByName(@NotNull PyTargetExpression classAttr, PyClass pyClass) {
        String name;
        if (classAttr == null) {
            PyGotoSuperHandler.$$$reportNull$$$0(3);
        }
        if ((name = classAttr.getName()) == null) {
            return Collections.emptyList();
        }
        ArrayList<PyTargetExpression> result = new ArrayList<PyTargetExpression>();
        for (PyClass aClass : pyClass.getAncestorClasses(null)) {
            PyTargetExpression superAttr = aClass.findClassAttribute(name, false, null);
            if (superAttr == null) continue;
            result.add(superAttr);
        }
        return result;
    }

    private static Collection<PyFunction> getAllSuperMethodsByName(@NotNull PyFunction method, PyClass pyClass) {
        String name;
        if (method == null) {
            PyGotoSuperHandler.$$$reportNull$$$0(4);
        }
        if ((name = method.getName()) == null) {
            return Collections.emptyList();
        }
        ArrayList<PyFunction> result = new ArrayList<PyFunction>();
        for (PyClass aClass : pyClass.getAncestorClasses(null)) {
            PyFunction byName = aClass.findMethodByName(name, false, null);
            if (byName == null) continue;
            result.add(byName);
        }
        return result;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classAttr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/PyGotoSuperHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllSuperAttributesByName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllSuperMethodsByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

