/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.InstructionBuilder;
import com.jetbrains.python.codeInsight.controlflow.PyTypeAssertionEvaluator;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssertStatement;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionComponent;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyComprehensionIfComponent;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWhilePart;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Triple;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyControlFlowBuilder
extends PyRecursiveElementVisitor {
    @NotNull
    private static final Set<String> EXCEPTION_SUPPRESSORS = ImmutableSet.of((Object)"suppress", (Object)"assertRaises", (Object)"assertRaisesRegex");
    private final ControlFlowBuilder myBuilder = new ControlFlowBuilder();

    public ControlFlow buildControlFlow(@NotNull ScopeOwner owner) {
        if (owner == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(0);
        }
        return this.myBuilder.build((PsiElementVisitor)this, (PsiElement)owner);
    }

    @NotNull
    protected ControlFlowBuilder getBuilder() {
        ControlFlowBuilder controlFlowBuilder = this.myBuilder;
        if (controlFlowBuilder == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(1);
        }
        return controlFlowBuilder;
    }

    @Override
    public void visitPyFunction(PyFunction node) {
        this.myBuilder.startNode((PsiElement)node);
        this.visitParameterListExpressions(node.getParameterList());
        this.visitDecorators(node.getDecoratorList());
        PyAnnotation annotation = node.getAnnotation();
        if (annotation != null) {
            annotation.accept(this);
        }
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNode((Instruction)instruction);
        this.myBuilder.checkPending((Instruction)instruction);
    }

    @Override
    public void visitPyDecoratorList(PyDecoratorList node) {
    }

    private void visitDecorators(PyDecoratorList list) {
        if (list != null) {
            for (PyDecorator decorator : list.getDecorators()) {
                decorator.accept(this);
            }
        }
    }

    private void visitParameterListExpressions(PyParameterList parameterList) {
        ParamHelper.walkDownParamArray(parameterList.getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                PyAnnotation annotation;
                PyExpression defaultValue = param.getDefaultValue();
                if (defaultValue != null) {
                    defaultValue.accept(PyControlFlowBuilder.this);
                }
                if ((annotation = param.getAnnotation()) != null) {
                    annotation.accept(PyControlFlowBuilder.this);
                }
            }
        });
    }

    @Override
    public void visitPyClass(PyClass node) {
        this.myBuilder.startNode((PsiElement)node);
        for (PyExpression element : node.getSuperClassExpressions()) {
            element.accept(this);
        }
        this.visitDecorators(node.getDecoratorList());
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNode((Instruction)instruction);
        this.myBuilder.checkPending((Instruction)instruction);
    }

    @Override
    public void visitPyStatement(PyStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        super.visitPyStatement(node);
    }

    @Override
    public void visitPyElement(PyElement node) {
        if (node instanceof PsiNamedElement && !(node instanceof PyKeywordArgument)) {
            this.myBuilder.startNode((PsiElement)node);
            this.myBuilder.addNode((Instruction)ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getName(), ReadWriteInstruction.ACCESS.WRITE));
        }
        super.visitPyElement(node);
    }

    @Override
    public void visitPyCallExpression(PyCallExpression node) {
        PyExpression callee = node.getCallee();
        String repr = PyUtil.getReadableRepr((PsiElement)callee, true);
        if (callee != null && ("sys.exit".equals(repr) || "self.fail".equals(repr))) {
            callee.accept(this);
            for (PyExpression expression : node.getArguments()) {
                expression.accept(this);
            }
            this.abruptFlow((PsiElement)node);
        } else {
            super.visitPyCallExpression(node);
        }
        if (node.isCalleeText("assertIsInstance")) {
            PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator();
            node.accept(assertionEvaluator);
            InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
        }
    }

    @Override
    public void visitPySubscriptionExpression(PySubscriptionExpression node) {
        this.myBuilder.startNode((PsiElement)node);
        node.getOperand().accept(this);
        PyExpression expression = node.getIndexExpression();
        if (expression != null) {
            expression.accept(this);
        }
    }

    @Override
    public void visitPyReferenceExpression(PyReferenceExpression node) {
        PyExpression qualifier = node.getQualifier();
        if (qualifier != null) {
            qualifier.accept(this);
            return;
        }
        if (PyImportStatementNavigator.getImportStatementByElement((PsiElement)node) != null) {
            return;
        }
        ReadWriteInstruction.ACCESS access = PyAugAssignmentStatementNavigator.getStatementByTarget((PsiElement)node) != null ? ReadWriteInstruction.ACCESS.READWRITE : ReadWriteInstruction.ACCESS.READ;
        ReadWriteInstruction readWriteInstruction = ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getName(), access);
        this.myBuilder.addNode((Instruction)readWriteInstruction);
        this.myBuilder.checkPending((Instruction)readWriteInstruction);
    }

    @Override
    public void visitPyBoolLiteralExpression(PyBoolLiteralExpression node) {
        ReadWriteInstruction readWriteInstruction = ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getText(), ReadWriteInstruction.ACCESS.READ);
        this.myBuilder.addNode((Instruction)readWriteInstruction);
        this.myBuilder.checkPending((Instruction)readWriteInstruction);
    }

    @Override
    public void visitPyNoneLiteralExpression(PyNoneLiteralExpression node) {
        ReadWriteInstruction readWriteInstruction = ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getText(), ReadWriteInstruction.ACCESS.READ);
        this.myBuilder.addNode((Instruction)readWriteInstruction);
        this.myBuilder.checkPending((Instruction)readWriteInstruction);
    }

    @Override
    public void visitPyTypeDeclarationStatement(PyTypeDeclarationStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        PyAnnotation annotation = node.getAnnotation();
        if (annotation != null) {
            annotation.accept(this);
        }
        node.getTarget().accept(this);
    }

    @Override
    public void visitPyAssignmentStatement(PyAssignmentStatement node) {
        PyAnnotation annotation;
        this.myBuilder.startNode((PsiElement)node);
        PyExpression value2 = node.getAssignedValue();
        if (value2 != null) {
            value2.accept(this);
        }
        if ((annotation = node.getAnnotation()) != null) {
            annotation.accept(this);
        }
        for (PyExpression expression : node.getRawTargets()) {
            expression.accept(this);
        }
    }

    @Override
    public void visitPyDelStatement(PyDelStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        for (PyExpression target : node.getTargets()) {
            if (target instanceof PyReferenceExpression) {
                PyReferenceExpression expr = (PyReferenceExpression)target;
                this.myBuilder.addNode((Instruction)ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)target, expr.getName(), ReadWriteInstruction.ACCESS.DELETE));
                PyExpression qualifier = expr.getQualifier();
                if (qualifier == null) continue;
                qualifier.accept(this);
                continue;
            }
            target.accept(this);
        }
    }

    @Override
    public void visitPyAugAssignmentStatement(PyAugAssignmentStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        PyExpression value2 = node.getValue();
        if (value2 != null) {
            value2.accept(this);
        }
        node.getTarget().accept(this);
    }

    @Override
    public void visitPyTargetExpression(PyTargetExpression node) {
        PyExpression qualifier;
        QualifiedName qName = node.asQualifiedName();
        if (qName != null) {
            ReadWriteInstruction instruction = ReadWriteInstruction.newInstruction(this.myBuilder, node, qName.toString(), ReadWriteInstruction.ACCESS.WRITE);
            this.myBuilder.addNode((Instruction)instruction);
            this.myBuilder.checkPending((Instruction)instruction);
        }
        if ((qualifier = node.getQualifier()) != null) {
            qualifier.accept(this);
        }
    }

    @Override
    public void visitPyNamedParameter(PyNamedParameter node) {
        PyExpression defaultValue = node.getDefaultValue();
        if (defaultValue != null) {
            defaultValue.accept(this);
        }
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNode((Instruction)instruction);
        this.myBuilder.checkPending((Instruction)instruction);
    }

    @Override
    public void visitPyImportStatement(PyImportStatement node) {
        this.visitPyImportStatementBase(node);
    }

    @Override
    public void visitPyFromImportStatement(PyFromImportStatement node) {
        this.visitPyImportStatementBase(node);
        PyStarImportElement starImportElement = node.getStarImportElement();
        if (starImportElement != null) {
            starImportElement.accept(this);
        }
    }

    @Override
    public void visitPyStarImportElement(PyStarImportElement node) {
        this.myBuilder.startNode((PsiElement)node);
    }

    private void visitPyImportStatementBase(PyImportStatementBase node) {
        this.myBuilder.startNode((PsiElement)node);
        for (PyImportElement importElement : node.getImportElements()) {
            ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, importElement, importElement.getVisibleName());
            this.myBuilder.addNode((Instruction)instruction);
            this.myBuilder.checkPending((Instruction)instruction);
        }
    }

    @NotNull
    private List<Pair<PsiElement, Instruction>> getPrevInstructions(@Nullable PyElement condition) {
        ArrayList result = ContainerUtil.newArrayList((Object[])new Pair[]{Pair.create((Object)condition, (Object)this.myBuilder.prevInstruction)});
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)pendingScope, (boolean)false)) {
                result.add(Pair.create((Object)pendingScope, (Object)instruction));
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    public void visitPyConditionalExpression(PyConditionalExpression node) {
        this.myBuilder.startNode((PsiElement)node);
        PyExpression condition = node.getCondition();
        PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator();
        if (condition != null) {
            condition.accept(this);
            condition.accept(assertionEvaluator);
        }
        Instruction branchingPoint = this.myBuilder.prevInstruction;
        PyExpression truePart = node.getTruePart();
        PyExpression falsePart = node.getFalsePart();
        if (truePart != null) {
            InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
            truePart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        if (falsePart != null) {
            this.myBuilder.prevInstruction = branchingPoint;
            falsePart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
    }

    @Override
    public void visitPyIfStatement(PyIfStatement node) {
        PyElsePart elseBranch;
        this.myBuilder.startNode((PsiElement)node);
        PyExpression lastCondition = null;
        List lastBranchingPoints = Collections.emptyList();
        ArrayList<Object> conditionResults = new ArrayList<Object>();
        PyIfPart firstIfPart = node.getIfPart();
        for (PyIfPart part : StreamEx.of((Object)firstIfPart).append((Object[])node.getElifParts())) {
            if (part != firstIfPart) {
                if (!ContainerUtil.exists(conditionResults, Boolean.TRUE::equals)) {
                    lastBranchingPoints.forEach(pair -> this.myBuilder.addPendingEdge((PsiElement)pair.getFirst(), (Instruction)pair.getSecond()));
                }
                this.myBuilder.prevInstruction = null;
                this.myBuilder.startConditionalNode((PsiElement)part, (PsiElement)lastCondition, false);
            }
            Triple<PyExpression, List<Pair<PsiElement, Instruction>>, Boolean> currentPartResults = this.visitPyIfPart(part, node);
            lastCondition = (PyExpression)currentPartResults.getFirst();
            lastBranchingPoints = (List)currentPartResults.getSecond();
            conditionResults.add(currentPartResults.getThird());
        }
        PyTypeAssertionEvaluator negativeAssertionEvaluator = new PyTypeAssertionEvaluator(false);
        PyExpression firstIfPartCondition = firstIfPart.getCondition();
        if (firstIfPartCondition != null) {
            firstIfPartCondition.accept(negativeAssertionEvaluator);
        }
        if ((elseBranch = node.getElsePart()) != null) {
            if (!ContainerUtil.exists(conditionResults, Boolean.TRUE::equals)) {
                lastBranchingPoints.forEach(pair -> this.myBuilder.addPendingEdge((PsiElement)pair.getFirst(), (Instruction)pair.getSecond()));
            }
            this.myBuilder.prevInstruction = null;
            PyStatementList statements = elseBranch.getStatementList();
            this.myBuilder.startConditionalNode((PsiElement)statements, (PsiElement)lastCondition, false);
            InstructionBuilder.addAssertInstructions(this.myBuilder, negativeAssertionEvaluator);
            statements.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        } else if (ContainerUtil.getLastItem(conditionResults) != Boolean.TRUE) {
            this.myBuilder.prevInstruction = null;
            Instruction instruction = (Instruction)ContainerUtil.getFirstItem(InstructionBuilder.addAssertInstructions(this.myBuilder, negativeAssertionEvaluator));
            if (instruction != null) {
                lastBranchingPoints.forEach(p -> this.myBuilder.addEdge((Instruction)p.getSecond(), instruction));
            } else {
                lastBranchingPoints.forEach(pair -> this.myBuilder.addPendingEdge((PsiElement)pair.getFirst(), (Instruction)pair.getSecond()));
            }
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
    }

    @NotNull
    private Triple<PyExpression, List<Pair<PsiElement, Instruction>>, Boolean> visitPyIfPart(@NotNull PyIfPart part, @NotNull PyIfStatement node) {
        if (part == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(3);
        }
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(4);
        }
        PyExpression condition = part.getCondition();
        PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator();
        Boolean conditionResult = PyEvaluator.evaluateAsBooleanNoResolve(condition);
        if (condition != null) {
            condition.accept(this);
            condition.accept(assertionEvaluator);
        }
        List<Pair<PsiElement, Instruction>> branchingPoints = this.getPrevInstructions(condition);
        if (conditionResult != Boolean.FALSE) {
            branchingPoints.forEach(pair -> this.myBuilder.addPendingEdge((PsiElement)pair.getFirst(), (Instruction)pair.getSecond()));
        }
        this.myBuilder.prevInstruction = null;
        this.visitPyIfPartStatements(part, assertionEvaluator, node);
        return new Triple((Object)condition, branchingPoints, (Object)conditionResult);
    }

    private void visitPyIfPartStatements(@NotNull PyIfPart part, @NotNull PyTypeAssertionEvaluator assertionEvaluator, @NotNull PyIfStatement node) {
        if (part == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(5);
        }
        if (assertionEvaluator == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(6);
        }
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(7);
        }
        PyStatementList statements = part.getStatementList();
        this.myBuilder.startConditionalNode((PsiElement)statements, (PsiElement)part.getCondition(), true);
        InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
        statements.accept(this);
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)statements, (PsiElement)pendingScope, (boolean)false)) {
                this.myBuilder.addPendingEdge((PsiElement)node, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
    }

    @Override
    public void visitPyBinaryExpression(PyBinaryExpression node) {
        PyElementType operator = node.getOperator();
        if (operator == PyTokenTypes.AND_KEYWORD || operator == PyTokenTypes.OR_KEYWORD) {
            PyExpression right;
            this.myBuilder.startNode((PsiElement)node);
            PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator(operator == PyTokenTypes.AND_KEYWORD);
            PyExpression left = node.getLeftExpression();
            if (left != null) {
                left.accept(this);
                left.accept(assertionEvaluator);
                this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
            }
            if ((right = node.getRightExpression()) != null) {
                InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
                right.accept(this);
                this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
            }
        } else {
            super.visitPyBinaryExpression(node);
        }
    }

    @Override
    public void visitPyWhileStatement(PyWhileStatement node) {
        Instruction instruction = this.myBuilder.startNode((PsiElement)node);
        PyWhilePart whilePart = node.getWhilePart();
        PyExpression condition = whilePart.getCondition();
        boolean isStaticallyTrue = false;
        if (condition != null) {
            condition.accept(this);
            isStaticallyTrue = PyControlFlowBuilder.loopHasAtLeastOneIteration(node);
        }
        Instruction head = this.myBuilder.prevInstruction;
        PyElsePart elsePart = node.getElsePart();
        if (elsePart == null && !isStaticallyTrue) {
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        PyStatementList list = whilePart.getStatementList();
        this.myBuilder.startConditionalNode((PsiElement)list, (PsiElement)condition, true);
        list.accept(this);
        if (this.myBuilder.prevInstruction != null) {
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, instruction);
        }
        this.myBuilder.checkPending(instruction);
        if (elsePart != null) {
            this.myBuilder.prevInstruction = !isStaticallyTrue ? head : null;
            elsePart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyForStatement(PyForStatement node) {
        Instruction body;
        this.myBuilder.startNode((PsiElement)node);
        PyForPart forPart = node.getForPart();
        PyExpression source2 = forPart.getSource();
        if (source2 != null) {
            source2.accept(this);
        }
        Instruction head = this.myBuilder.prevInstruction;
        PyElsePart elsePart = node.getElsePart();
        if (elsePart == null && !PyControlFlowBuilder.loopHasAtLeastOneIteration(node)) {
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        PyStatementList list = forPart.getStatementList();
        PyExpression target = forPart.getTarget();
        if (target != null) {
            body = this.myBuilder.startNode((PsiElement)target);
            target.accept(this);
        } else {
            body = this.myBuilder.startNode((PsiElement)list);
        }
        list.accept(this);
        if (this.myBuilder.prevInstruction != null) {
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, body);
            this.myBuilder.addPendingEdge((PsiElement)list, this.myBuilder.prevInstruction);
        }
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)list, (PsiElement)pendingScope, (boolean)false)) {
                this.myBuilder.addEdge(instruction, body);
                this.myBuilder.addPendingEdge((PsiElement)list, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        this.myBuilder.prevInstruction = head;
        if (elsePart != null) {
            elsePart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        this.myBuilder.flowAbrupted();
    }

    private static boolean loopHasAtLeastOneIteration(@NotNull PyLoopStatement loopStatement) {
        if (loopStatement == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(8);
        }
        PyExpression expression = loopStatement instanceof PyForStatement ? ((PyForStatement)loopStatement).getForPart().getSource() : (loopStatement instanceof PyWhileStatement ? ((PyWhileStatement)loopStatement).getWhilePart().getCondition() : null);
        return PyEvaluator.evaluateAsBooleanNoResolve(expression, false);
    }

    @Override
    public void visitPyBreakStatement(PyBreakStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        PyLoopStatement loop = node.getLoopStatement();
        if (loop != null) {
            this.myBuilder.addPendingEdge((PsiElement)loop, this.myBuilder.prevInstruction);
        } else {
            this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyContinueStatement(PyContinueStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        PyLoopStatement loop = node.getLoopStatement();
        if (loop != null) {
            Instruction instruction = this.myBuilder.findInstructionByElement((PsiElement)loop);
            if (instruction != null) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, instruction);
            } else {
                this.myBuilder.addPendingEdge(null, null);
            }
            if (PyControlFlowBuilder.loopHasAtLeastOneIteration(loop)) {
                this.myBuilder.addPendingEdge((PsiElement)loop, this.myBuilder.prevInstruction);
            }
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyYieldExpression(PyYieldExpression node) {
        this.myBuilder.startNode((PsiElement)node);
        PyExpression expression = node.getExpression();
        if (expression != null) {
            expression.accept(this);
        }
    }

    @Override
    public void visitPyRaiseStatement(PyRaiseStatement node) {
        PyExpression[] expressions;
        this.myBuilder.startNode((PsiElement)node);
        for (PyExpression expression : expressions = node.getExpressions()) {
            expression.accept(this);
        }
        this.myBuilder.processPending((pendingScope, instruction) -> {
            PsiElement pendingElement = instruction.getElement();
            if (pendingElement != null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)pendingElement, (boolean)false)) {
                this.myBuilder.addEdge(null, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyReturnStatement(PyReturnStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        PyExpression expression = node.getExpression();
        if (expression != null) {
            expression.accept(this);
        }
        this.abruptFlow((PsiElement)node);
    }

    @Override
    public void visitPyTryExceptStatement(PyTryExceptStatement node) {
        Instruction finallyFailInstruction;
        this.myBuilder.startNode((PsiElement)node);
        PyTryPart tryPart = node.getTryPart();
        this.myBuilder.startNode((PsiElement)tryPart);
        tryPart.accept(this);
        PyElsePart elsePart = node.getElsePart();
        if (elsePart != null) {
            this.myBuilder.startNode((PsiElement)elsePart);
            elsePart.accept(this);
        }
        this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        ArrayList<Instruction> exceptInstructions = new ArrayList<Instruction>();
        ArrayList pendingBackup = new ArrayList();
        for (PyExceptPart exceptPart : node.getExceptParts()) {
            pendingBackup.addAll(this.myBuilder.pending);
            this.myBuilder.pending = new ArrayList();
            this.myBuilder.flowAbrupted();
            Instruction exceptInstruction = this.myBuilder.startNode((PsiElement)exceptPart);
            exceptPart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
            exceptInstructions.add(exceptInstruction);
        }
        for (Pair pair : pendingBackup) {
            this.myBuilder.addPendingEdge((PsiElement)pair.first, (Instruction)pair.second);
        }
        ArrayList pendingNormalExits = new ArrayList();
        PyFinallyPart finallyPart = node.getFinallyPart();
        if (finallyPart != null) {
            this.myBuilder.processPending((pendingScope, instruction) -> {
                PsiElement pendingElement = instruction.getElement();
                if (pendingElement != null) {
                    boolean isPending;
                    boolean bl = isPending = PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)pendingElement, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)finallyPart, (PsiElement)pendingElement, (boolean)false);
                    if (isPending && pendingScope != null) {
                        pendingNormalExits.add(Pair.createNonNull((Object)pendingScope, (Object)instruction));
                    } else {
                        this.myBuilder.addPendingEdge(pendingScope, instruction);
                    }
                }
            });
        }
        if (finallyPart != null) {
            this.myBuilder.flowAbrupted();
            finallyFailInstruction = this.myBuilder.startNode((PsiElement)finallyPart);
            finallyPart.accept(this);
            this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
            this.myBuilder.flowAbrupted();
        } else {
            finallyFailInstruction = null;
        }
        for (Instruction instruction2 : this.myBuilder.instructions) {
            PsiElement e = instruction2.getElement();
            if (e == null || !PyControlFlowBuilder.canRaiseExceptions(instruction2)) continue;
            if (PsiTreeUtil.getParentOfType((PsiElement)e, PyTryPart.class, (boolean)false) == tryPart) {
                for (Instruction inst : exceptInstructions) {
                    this.myBuilder.addEdge(instruction2, inst);
                }
                if (finallyPart != null) {
                    this.myBuilder.addEdge(instruction2, finallyFailInstruction);
                }
            }
            if (finallyPart == null) continue;
            for (PyExceptPart exceptPart : node.getExceptParts()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)exceptPart, (PsiElement)e, (boolean)false)) continue;
                this.myBuilder.addEdge(instruction2, finallyFailInstruction);
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)elsePart, (PsiElement)e, (boolean)false)) continue;
            this.myBuilder.addEdge(instruction2, finallyFailInstruction);
        }
        if (finallyPart != null) {
            Instruction finallyInstruction;
            this.myBuilder.processPending((pendingScope, instruction) -> {
                PsiElement e = instruction.getElement();
                if (e != null) {
                    if (PsiTreeUtil.isAncestor((PsiElement)finallyPart, (PsiElement)e, (boolean)false)) {
                        this.myBuilder.addPendingEdge(null, instruction);
                    } else if (pendingScope == null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)e, (boolean)false)) {
                        this.myBuilder.addEdge(instruction, finallyFailInstruction);
                    } else {
                        this.myBuilder.addPendingEdge(pendingScope, instruction);
                    }
                }
            });
            if (!pendingNormalExits.isEmpty()) {
                pendingBackup = new ArrayList(this.myBuilder.pending);
                this.myBuilder.pending = new ArrayList();
                this.myBuilder.flowAbrupted();
                Instruction finallySuccessInstruction = this.myBuilder.startNode((PsiElement)finallyPart);
                finallyPart.accept(this);
                for (Pair pair : pendingBackup) {
                    this.myBuilder.addPendingEdge((PsiElement)pair.first, (Instruction)pair.second);
                }
                finallyInstruction = finallySuccessInstruction;
            } else {
                finallyInstruction = finallyFailInstruction;
            }
            for (Pair pendingScopeAndInstruction : pendingNormalExits) {
                PsiElement pendingScope2 = (PsiElement)pendingScopeAndInstruction.first;
                Instruction instruction3 = (Instruction)pendingScopeAndInstruction.second;
                this.myBuilder.addEdge(instruction3, finallyInstruction);
                if (!PsiTreeUtil.isAncestor((PsiElement)pendingScope2, (PsiElement)node, (boolean)true)) continue;
                this.myBuilder.addPendingEdge(pendingScope2, this.myBuilder.prevInstruction);
            }
        }
    }

    @Override
    public void visitPyComprehensionElement(PyComprehensionElement node) {
        PyExpression prevCondition = null;
        this.myBuilder.startNode((PsiElement)node);
        ArrayList<Instruction> iterators = new ArrayList<Instruction>();
        for (PyComprehensionComponent component : node.getComponents()) {
            PyExpression condition;
            PyComprehensionComponent c;
            if (component instanceof PyComprehensionForComponent) {
                c = (PyComprehensionForComponent)component;
                PyExpression iteratedList = c.getIteratedList();
                PyExpression iteratorVariable = c.getIteratorVariable();
                if (prevCondition != null) {
                    this.myBuilder.startConditionalNode((PsiElement)iteratedList, prevCondition, true);
                    prevCondition = null;
                } else {
                    this.myBuilder.startNode((PsiElement)iteratedList);
                }
                iteratedList.accept(this);
                for (Instruction i : iterators) {
                    this.myBuilder.addEdge(this.myBuilder.prevInstruction, i);
                }
                this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
                Instruction iterator = this.myBuilder.startNode((PsiElement)iteratorVariable);
                iteratorVariable.accept(this);
                iterators.add(iterator);
                continue;
            }
            if (!(component instanceof PyComprehensionIfComponent) || (condition = (c = (PyComprehensionIfComponent)component).getTest()) == null) continue;
            if (prevCondition != null) {
                this.myBuilder.startConditionalNode((PsiElement)condition, prevCondition, true);
            } else {
                this.myBuilder.startNode((PsiElement)condition);
            }
            PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator();
            condition.accept(this);
            condition.accept(assertionEvaluator);
            InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
            prevCondition = condition;
            for (Instruction i : iterators) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, i);
            }
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        PyExpression result = node.getResultExpression();
        if (result != null) {
            if (prevCondition != null) {
                this.myBuilder.startConditionalNode((PsiElement)result, prevCondition, true);
            } else {
                this.myBuilder.startNode((PsiElement)result);
            }
            result.accept(this);
            for (Instruction i : iterators) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, i);
            }
        }
    }

    @Override
    public void visitPyAssertStatement(PyAssertStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        super.visitPyAssertStatement(node);
        PyExpression[] args2 = node.getArguments();
        if (args2.length >= 1 && !PyEvaluator.evaluateAsBooleanNoResolve(args2[0], true)) {
            this.abruptFlow((PsiElement)node);
            return;
        }
        PyTypeAssertionEvaluator evaluator = new PyTypeAssertionEvaluator();
        node.acceptChildren(evaluator);
        InstructionBuilder.addAssertInstructions(this.myBuilder, evaluator);
    }

    @Override
    public void visitPyLambdaExpression(PyLambdaExpression node) {
        this.myBuilder.startNode((PsiElement)node);
        this.visitParameterListExpressions(node.getParameterList());
    }

    @Override
    public void visitPyWithStatement(PyWithStatement node) {
        super.visitPyWithStatement(node);
        boolean suppressor = StreamEx.of((Object[])node.getWithItems()).map(PyWithItem::getExpression).select(PyCallExpression.class).map(PyCallExpression::getCallee).select(PyReferenceExpression.class).anyMatch(it -> EXCEPTION_SUPPRESSORS.contains(it.getReferencedName()));
        this.myBuilder.processPending((pendingScope, instruction) -> {
            PsiElement element = instruction.getElement();
            if (element != null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)element, (boolean)true) && (suppressor && PyControlFlowBuilder.canRaiseExceptions(instruction) || PsiTreeUtil.getParentOfType((PsiElement)element, PyRaiseStatement.class) != null)) {
                this.myBuilder.addPendingEdge((PsiElement)node, instruction);
            }
            this.myBuilder.addPendingEdge(pendingScope, instruction);
        });
    }

    @Override
    public void visitPyAssignmentExpression(PyAssignmentExpression node) {
        PyTargetExpression target;
        PyExpression assignedValue = node.getAssignedValue();
        if (assignedValue != null) {
            assignedValue.accept(this);
        }
        if ((target = node.getTarget()) != null) {
            target.accept(this);
        }
    }

    private void abruptFlow(PsiElement node) {
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)pendingScope, (boolean)false)) {
                this.myBuilder.addPendingEdge(null, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        this.myBuilder.flowAbrupted();
    }

    private static boolean canRaiseExceptions(Instruction instruction) {
        if (instruction instanceof ReadWriteInstruction) {
            return true;
        }
        return !PsiTreeUtil.instanceOf((Object)instruction.getElement(), (Class[])new Class[]{PyStatementList.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/controlflow/PyControlFlowBuilder";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertionEvaluator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/controlflow/PyControlFlowBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildControlFlow";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitPyIfPart";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitPyIfPartStatements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loopHasAtLeastOneIteration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

