/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker.debugger;

import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PyDebugSessionFactory;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyDockerDebugSessionFactoryBase
extends PyDebugSessionFactory {
    protected static final String ALL_HOST_INTERFACES_IP = "0.0.0.0";
    private static final int LOWEST_RANDOM_DEBUGGER_PORT = 50000;
    private static final int RANDOM_DEBUGGER_PORTS_RANGE = 10000;
    @NotNull
    private final Random myRandom = new Random(System.currentTimeMillis());

    protected static boolean appliesTo(@NotNull Sdk sdk, @NotNull CredentialsType instance) {
        if (sdk == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(0);
        }
        if (instance == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(1);
        }
        if (sdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData) {
            RemoteSdkAdditionalData remoteSdkAdditionalData = (RemoteSdkAdditionalData)sdk.getSdkAdditionalData();
            return remoteSdkAdditionalData.getRemoteConnectionType() == instance;
        }
        return false;
    }

    @Override
    @NotNull
    public final XDebugSession createSession(@NotNull PythonCommandLineState pyState, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        Sdk sdk;
        if (pyState == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(3);
        }
        if ((sdk = pyState.getSdk()) == null) {
            throw new ExecutionException("Python SDK does not exist");
        }
        PyRemoteSdkAdditionalData remoteSdkAdditionalData = (PyRemoteSdkAdditionalData)sdk.getSdkAdditionalData();
        if (remoteSdkAdditionalData == null) {
            throw new ExecutionException("Python SDK is invalid");
        }
        final String serverHost = DockerUtil.getDockerHost((RemoteSdkAdditionalData)remoteSdkAdditionalData);
        final int serverPort = this.generateDebuggerPort();
        final ExecutionResult result = this.executeDebuggingScript(pyState, remoteSdkAdditionalData, environment, serverPort);
        final Project project = environment.getProject();
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).startSession(environment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                PyDebugProcess pyDebugProcess = PyDockerDebugSessionFactoryBase.this.createDebugProcess(session, result, serverHost, serverPort);
                PyDebugRunner.createConsoleCommunicationAndSetupActions(project, result, pyDebugProcess, session);
                PyDebugProcess pyDebugProcess2 = pyDebugProcess;
                if (pyDebugProcess2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pyDebugProcess2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/docker/debugger/PyDockerDebugSessionFactoryBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/docker/debugger/PyDockerDebugSessionFactoryBase$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        if (xDebugSession == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(4);
        }
        return xDebugSession;
    }

    private int generateDebuggerPort() {
        return 50000 + this.myRandom.nextInt(10000);
    }

    @NotNull
    protected abstract PyDebugProcess createDebugProcess(@NotNull XDebugSession var1, @NotNull ExecutionResult var2, @NotNull String var3, int var4);

    protected final CommandLinePatcher @NotNull [] createCommandLinePatchers(Project project, PythonCommandLineState state2, RunProfile profile, int serverLocalPort) {
        CommandLinePatcher[] commandLinePatcherArray = new CommandLinePatcher[]{this.createDebugServerPatcher(project, state2, serverLocalPort, profile), PyDebugRunner.createRunConfigPatcher((RunProfileState)state2, profile)};
        if (commandLinePatcherArray == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(5);
        }
        return commandLinePatcherArray;
    }

    @NotNull
    private CommandLinePatcher createDebugServerPatcher(final @NotNull Project project, final @NotNull PythonCommandLineState pyState, final int serverLocalPort, final RunProfile profile) {
        if (project == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(6);
        }
        if (pyState == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(7);
        }
        return new CommandLinePatcher(){

            @Override
            public void patchCommandLine(GeneralCommandLine commandLine) {
                ParametersList parametersList = commandLine.getParametersList();
                @NotNull ParamsGroup debugParams = parametersList.getParamsGroup("Debugger");
                assert (debugParams != null);
                boolean isModule = PyDebugRunner.patchExeParams(parametersList);
                PyDockerDebugSessionFactoryBase.this.fillDebugParameters(project, debugParams, serverLocalPort, pyState, commandLine, profile, isModule);
                @NotNull ParamsGroup exeParams = parametersList.getParamsGroup("Exe Options");
                PythonSdkFlavor flavor = pyState.getSdkFlavor();
                if (flavor != null) {
                    assert (exeParams != null);
                    for (String option : flavor.getExtraDebugOptions()) {
                        exeParams.addParameter(option);
                    }
                }
            }
        };
    }

    private void fillDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams, int serverLocalPort, @NotNull PythonCommandLineState pyState, @NotNull GeneralCommandLine cmd, @Nullable RunProfile runProfile, boolean isModule) {
        if (project == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(8);
        }
        if (debugParams == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(9);
        }
        if (pyState == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(10);
        }
        if (cmd == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(11);
        }
        PythonHelper.DEBUGGER.addToGroup(debugParams, cmd);
        if (isModule) {
            debugParams.addParameter("--module");
        }
        if (pyState.isMultiprocessDebug()) {
            debugParams.addParameter("--multiprocess");
        }
        PyDebugRunner.configureCommonDebugParameters(project, debugParams);
        PyDebugRunner.configureDebugEnvironment(project, cmd.getEnvironment(), runProfile);
        PyDockerDebugSessionFactoryBase.configureDebugConnectionParameters(debugParams, serverLocalPort);
        this.configureExtraDebugParameters(project, serverLocalPort, cmd);
    }

    @NotNull
    protected abstract ExecutionResult executeDebuggingScript(@NotNull PythonCommandLineState var1, @NotNull PyRemoteSdkAdditionalData var2, @NotNull ExecutionEnvironment var3, int var4) throws ExecutionException;

    protected abstract void configureExtraDebugParameters(@NotNull Project var1, int var2, @NotNull GeneralCommandLine var3);

    public static void configureDebugConnectionParameters(@NotNull ParamsGroup debugParams, int serverLocalPort) {
        String[] debuggerArgs;
        if (debugParams == null) {
            PyDockerDebugSessionFactoryBase.$$$reportNull$$$0(12);
        }
        for (String s : debuggerArgs = new String[]{"--port", String.valueOf(serverLocalPort), "--file"}) {
            debugParams.addParameter(s);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/docker/debugger/PyDockerDebugSessionFactoryBase";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugParams";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/docker/debugger/PyDockerDebugSessionFactoryBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSession";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLinePatchers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appliesTo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSession";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDebugServerPatcher";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillDebugParameters";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "configureDebugConnectionParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

