/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyPsiPep8NamingInspection;
import com.jetbrains.python.inspections.quickfix.PyRenameElementQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPep8NamingInspection
extends PyPsiPep8NamingInspection {
    @Nullable
    public JComponent createOptionsPanel() {
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add((Component)new CheckBox(PyBundle.message("ignore.overridden.functions", new Object[0]), (InspectionProfileEntry)this, "ignoreOverriddenFunctions"), "North");
        OnePixelSplitter splitter = new OnePixelSplitter(false);
        splitter.setFirstComponent(new ListEditForm("Excluded base classes", this.ignoredBaseClasses).getContentPanel());
        splitter.setSecondComponent(new ListEditForm("Ignored errors", this.ignoredErrors).getContentPanel());
        rootPanel.add((Component)splitter, "Center");
        return rootPanel;
    }

    @Override
    protected void addFunctionQuickFixes(ProblemsHolder holder, PyClass containingClass, ASTNode nameNode, List<LocalQuickFix> quickFixes, TypeEvalContext typeEvalContext) {
        if (holder != null && holder.isOnTheFly()) {
            quickFixes.add((LocalQuickFix)new PyRenameElementQuickFix(nameNode.getPsi()));
        }
        if (containingClass != null) {
            quickFixes.add(new IgnoreBaseClassQuickFix(containingClass, typeEvalContext));
        }
    }

    @Override
    protected LocalQuickFix[] createRenameAndIngoreErrorQuickFixes(@Nullable PsiElement node, String errorCode) {
        return new LocalQuickFix[]{new PyRenameElementQuickFix(node), new PyPsiPep8NamingInspection.IgnoreErrorFix(errorCode)};
    }

    private static class IgnoreBaseClassQuickFix
    implements LocalQuickFix {
        private final List<String> myBaseClassNames;

        IgnoreBaseClassQuickFix(@NotNull PyClass baseClass, @NotNull TypeEvalContext context) {
            if (baseClass == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(0);
            }
            if (context == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(1);
            }
            this.myBaseClassNames = new ArrayList<String>();
            ContainerUtil.addIfNotNull(this.getBaseClassNames(), (Object)baseClass.getQualifiedName());
            for (PyClass ancestor : baseClass.getAncestorClasses(context)) {
                ContainerUtil.addIfNotNull(this.getBaseClassNames(), (Object)ancestor.getQualifiedName());
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = PyBundle.message("INSP.pep8.ignore.method.names.for.descendants.of.class", new Object[0]);
            if (string == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(4);
            }
            DataManager.getInstance().getDataContextFromFocus().doWhenDone(dataContext -> JBPopupFactory.getInstance().createPopupChooserBuilder(this.getBaseClassNames()).setTitle(PyBundle.message("INSP.pep8.ignore.base.class", new Object[0])).setItemChosenCallback(selectedValue -> InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, it -> {
                PyPep8NamingInspection inspection = (PyPep8NamingInspection)it.getUnwrappedTool(PyPep8NamingInspection.class.getSimpleName(), descriptor2.getPsiElement());
                ContainerUtil.addIfNotNull((Collection)inspection.ignoredBaseClasses, (Object)selectedValue);
            })).setNamerForFiltering(o -> o).createPopup().showInBestPositionFor(dataContext));
        }

        public List<String> getBaseClassNames() {
            return this.myBaseClassNames;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreBaseClassQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreBaseClassQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

