/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommandLineInspectionProgressReporter;
import com.intellij.codeInspection.CommandLineInspectionProjectConfigurator;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.facet.PythonFacetType;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PythonPluginCommandLineInspectionProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    public boolean isApplicable(@NotNull Path projectPath, @NotNull CommandLineInspectionProgressReporter logger) {
        List<Sdk> sdks;
        if (projectPath == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(1);
        }
        if (!(sdks = PythonSdkUtil.getAllSdks()).isEmpty()) {
            return false;
        }
        try {
            boolean hasAnyPythonFiles = Files.walk(projectPath, new FileVisitOption[0]).anyMatch(f -> f.toString().endsWith(".py"));
            if (!hasAnyPythonFiles) {
                logger.reportMessage(3, "Skipping Python interpreter autodetection because the project doesn't contain any Python files");
            }
            return hasAnyPythonFiles;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void configureEnvironment(@NotNull Path projectPath, @NotNull CommandLineInspectionProgressReporter logger) {
        if (projectPath == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(2);
        }
        if (logger == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(3);
        }
        logger.reportMessage(3, "Python environment configuration...");
        List<Sdk> sdks = PythonSdkUtil.getAllSdks();
        logger.reportMessage(3, "Python interpreters detected:");
        for (Sdk sdk : sdks) {
            logger.reportMessage(3, sdk.getHomePath());
        }
        if (sdks.isEmpty()) {
            List<Sdk> detectedSdks = PySdkExtKt.findAllPythonSdks(projectPath);
            if (detectedSdks.size() > 0) {
                for (Sdk sdk2 : detectedSdks) {
                    logger.reportMessage(3, sdk2.getHomePath());
                }
                Sdk sdk = detectedSdks.get(0);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    logger.reportMessage(1, "Settings up interpreter " + sdk.getName());
                    ProjectJdkTable.getInstance().addJdk(sdk);
                });
                PythonSdkUpdater.update(sdk, null, null, null);
            } else {
                logger.reportMessage(1, "ERROR: Can't find Python interpreter");
            }
        }
    }

    public void configureProject(@NotNull Project project, @NotNull AnalysisScope scope, @NotNull CommandLineInspectionProgressReporter logger) {
        List<Sdk> sdks;
        if (project == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(5);
        }
        if (logger == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(6);
        }
        if (!(sdks = PythonSdkUtil.getAllSdks()).isEmpty()) {
            PythonFacetType facetType = PythonFacetType.getInstance();
            for (VirtualFile f : scope.getFiles()) {
                Module m;
                if (!FileTypeRegistry.getInstance().isFileOfType(f, (FileType)PythonFileType.INSTANCE) || (m = ModuleUtilCore.findModuleForFile((VirtualFile)f, (Project)project)) == null || FacetManager.getInstance((Module)m).getFacetByType(facetType.getId()) != null) continue;
                ApplicationManager.getApplication().runWriteAction(() -> FacetManager.getInstance((Module)m).addFacet((FacetType)facetType, facetType.getPresentableName(), null));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PythonPluginCommandLineInspectionProjectConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "configureEnvironment";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

